/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.MassGap;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.NeutralLossCombination;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.biology.ions.RelatedIon;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class IonFactory {
    private static IonFactory instance = null;
    private static ArrayList<NeutralLoss> defaultNeutralLosses = null;
    private HashMap<String, NeutralLossCombination[]> neutralLossesCombinationsCache = new HashMap();
    private static final double nh3 = Atom.N.getMonoisotopicMass() + 3.0 * Atom.H.getMonoisotopicMass();
    private static final double co = Atom.C.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    private static final double nMinusO = Atom.N.getMonoisotopicMass() - Atom.O.getMonoisotopicMass();
    private static final double co2 = Atom.C.getMonoisotopicMass() + 2.0 * Atom.O.getMonoisotopicMass();
    private static final double h2 = 2.0 * Atom.H.getMonoisotopicMass();
    private static final double h2o = 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    private static final double ho = Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();

    private IonFactory() {
    }

    public static IonFactory getInstance() {
        if (instance == null) {
            instance = new IonFactory();
        }
        return instance;
    }

    public static ArrayList<NeutralLoss> getDefaultNeutralLosses() {
        if (defaultNeutralLosses == null) {
            IonFactory.setDefaultNeutralLosses();
        }
        return defaultNeutralLosses;
    }

    private static synchronized void setDefaultNeutralLosses() {
        if (defaultNeutralLosses == null) {
            defaultNeutralLosses = new ArrayList(2);
            defaultNeutralLosses.add(NeutralLoss.H2O);
            defaultNeutralLosses.add(NeutralLoss.NH3);
        }
    }

    public static ArrayList<NeutralLoss> getNeutralLosses(PtmSettings ptmSettings) {
        ArrayList<NeutralLoss> neutralLosses = new ArrayList<NeutralLoss>();
        neutralLosses.addAll(IonFactory.getDefaultNeutralLosses());
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (String modification : ptmSettings.getAllModifications()) {
            PTM currentPtm = ptmFactory.getPTM(modification);
            boolean found = false;
            for (NeutralLoss ptmNeutralLoss : currentPtm.getNeutralLosses()) {
                for (NeutralLoss neutralLoss : neutralLosses) {
                    if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                neutralLosses.add(ptmNeutralLoss);
            }
        }
        return neutralLosses;
    }

    public static HashSet<Integer> getReporterIons(PtmSettings ptmSettings) {
        HashSet<Integer> reporterIons = new HashSet<Integer>();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (String modification : ptmSettings.getAllModifications()) {
            PTM currentPtm = ptmFactory.getPTM(modification);
            for (ReporterIon reporterIon : currentPtm.getReporterIons()) {
                reporterIons.add(reporterIon.getSubType());
            }
        }
        return reporterIons;
    }

    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Peptide peptide) {
        return this.getFragmentIons(peptide, null);
    }

    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Peptide peptide, SpecificAnnotationSettings specificAnnotationSettings) {
        HashMap<Ion.IonType, HashSet<Integer>> selectedIonTypes = null;
        if (specificAnnotationSettings != null) {
            selectedIonTypes = specificAnnotationSettings.getIonTypes();
        }
        HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> result = new HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>();
        String sequence = peptide.getSequence();
        HashMap<Integer, ArrayList<PTM>> modifications = new HashMap<Integer, ArrayList<PTM>>(peptide.getNModifications());
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> processedPtms = null;
        ArrayList<NeutralLoss> possibleNeutralLosses = null;
        if (specificAnnotationSettings == null || !specificAnnotationSettings.getNeutralLossesMap().isEmpty()) {
            possibleNeutralLosses = new ArrayList<NeutralLoss>(IonFactory.getDefaultNeutralLosses());
        }
        if (peptide.isModified()) {
            for (ModificationMatch ptmMatch : peptide.getModificationMatches()) {
                int location = ptmMatch.getModificationSite();
                String ptmName = ptmMatch.getTheoreticPtm();
                PTM ptm = ptmFactory.getPTM(ptmName);
                if (ptm == null) {
                    throw new IllegalArgumentException("PTM " + ptmName + " not loaded in the PTM factory.");
                }
                ArrayList<PTM> modificationsAtSite = (ArrayList<PTM>)modifications.get(location);
                if (modificationsAtSite == null) {
                    modificationsAtSite = new ArrayList<PTM>(1);
                    modifications.put(location, modificationsAtSite);
                }
                modificationsAtSite.add(ptm);
                if (processedPtms != null && processedPtms.contains(ptmName)) continue;
                if (selectedIonTypes == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.REPORTER_ION)) {
                    for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                        int subType;
                        ArrayList<Ion> ions;
                        HashMap<Integer, ArrayList<Ion>> ionsMap = result.get(Ion.IonType.REPORTER_ION.index);
                        if (ionsMap == null) {
                            ionsMap = new HashMap(ptm.getReporterIons().size());
                            result.put(Ion.IonType.REPORTER_ION.index, ionsMap);
                        }
                        if ((ions = ionsMap.get(subType = ptmReporterIon.getSubType())) != null) continue;
                        ions = new ArrayList(1);
                        ionsMap.put(subType, ions);
                        ions.add(ptmReporterIon);
                    }
                }
                if (specificAnnotationSettings == null || !specificAnnotationSettings.getNeutralLossesMap().isEmpty()) {
                    for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                        boolean found = false;
                        for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                            if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        possibleNeutralLosses.add(ptmNeutralLoss);
                    }
                }
                if (processedPtms == null) {
                    processedPtms = new ArrayList<String>(peptide.getNModifications());
                }
                processedPtms.add(ptmName);
            }
        }
        NeutralLossCombination[] neutralLossesCombinations = null;
        if (specificAnnotationSettings == null || !specificAnnotationSettings.getNeutralLossesMap().isEmpty()) {
            neutralLossesCombinations = this.getNeutralLossesCombinations(possibleNeutralLosses);
        }
        double forwardMass = 0.0;
        double rewindMass = Atom.O.getMonoisotopicMass();
        for (int aa = 0; aa < sequence.length() - 1; ++aa) {
            HashMap<Integer, ArrayList<Ion>> ionsMap;
            Object ions;
            char aaName = sequence.charAt(aa);
            if (selectedIonTypes == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.IMMONIUM_ION)) {
                ImmoniumIon immoniumIon;
                int subType;
                ArrayList<ImmoniumIon> ions2;
                HashMap ionsMap2 = (HashMap)result.get(Ion.IonType.IMMONIUM_ION.index);
                if (ionsMap2 == null) {
                    ionsMap2 = new HashMap(sequence.length());
                    result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap2);
                }
                if ((ions2 = (ArrayList<ImmoniumIon>)ionsMap2.get(subType = (immoniumIon = ImmoniumIon.getImmoniumIon(aaName)).getSubType())) == null) {
                    ions2 = new ArrayList<ImmoniumIon>(1);
                    ions2.add(immoniumIon);
                    ionsMap2.put(subType, ions2);
                }
            }
            if (selectedIonTypes == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.RELATED_ION)) {
                ArrayList<RelatedIon> relatedIons;
                HashMap<Integer, NeutralLossCombination[]> ionsMap3 = (HashMap<Integer, NeutralLossCombination[]>)result.get(Ion.IonType.RELATED_ION.index);
                if (ionsMap3 == null) {
                    ionsMap3 = new HashMap<Integer, NeutralLossCombination[]>(sequence.length());
                    result.put(Ion.IonType.RELATED_ION.index, ionsMap3);
                }
                if ((relatedIons = RelatedIon.getRelatedIons(AminoAcid.getAminoAcid(aaName))) != null) {
                    for (RelatedIon tempRelated : relatedIons) {
                        int subType = tempRelated.getSubType();
                        ions = (NeutralLossCombination[])ionsMap3.get(subType);
                        if (ions == null) {
                            ions = new ArrayList(1);
                        }
                        ((ArrayList)ions).add(tempRelated);
                        ionsMap3.put(subType, (NeutralLossCombination[])ions);
                    }
                }
            }
            int faa = aa + 1;
            AminoAcid currentAA = AminoAcid.getAminoAcid(aaName);
            forwardMass += currentAA.getMonoisotopicMass();
            if (modifications.get(faa) != null) {
                for (PTM ptm : (ArrayList)modifications.get(faa)) {
                    forwardMass += ptm.getMass();
                }
            }
            if ((ionsMap = result.get(Ion.IonType.PEPTIDE_FRAGMENT_ION.index)) == null) {
                ionsMap = new HashMap(6);
                result.put(Ion.IonType.PEPTIDE_FRAGMENT_ION.index, ionsMap);
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(0)) {
                int subType = 0;
                ArrayList<Ion> ions3 = ionsMap.get(subType);
                if (ions3 == null) {
                    ions3 = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, ions3);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions3.add(new PeptideFragmentIon(subType, faa, forwardMass - co - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ions3.add(new PeptideFragmentIon(subType, faa, forwardMass - co, null));
                }
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(1)) {
                int subType = 1;
                ArrayList<Ion> ions4 = ionsMap.get(subType);
                if (ions4 == null) {
                    ions4 = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, ions4);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions4.add(new PeptideFragmentIon(subType, faa, forwardMass - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ions4.add(new PeptideFragmentIon(subType, faa, forwardMass, null));
                }
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(2)) {
                int subType = 2;
                ArrayList<Ion> ions5 = ionsMap.get(subType);
                if (ions5 == null) {
                    ions5 = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, ions5);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions5.add(new PeptideFragmentIon(subType, faa, forwardMass + nh3 - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ions5.add(new PeptideFragmentIon(subType, faa, forwardMass + nh3, null));
                }
            }
            int raa = sequence.length() - aa - 1;
            currentAA = AminoAcid.getAminoAcid(sequence.charAt(raa));
            rewindMass += currentAA.getMonoisotopicMass();
            if (modifications.get(raa + 1) != null) {
                for (PTM ptm : (ArrayList)modifications.get(raa + 1)) {
                    rewindMass += ptm.getMass();
                }
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(3)) {
                int subType = 3;
                ions = ionsMap.get(subType);
                if (ions == null) {
                    ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, (ArrayList<Ion>)ions);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + co - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + co, null));
                }
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(4)) {
                int subType = 4;
                ions = ionsMap.get(subType);
                if (ions == null) {
                    ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, (ArrayList<Ion>)ions);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + h2 - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + h2, null));
                }
            }
            if (specificAnnotationSettings != null && (!selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) || !specificAnnotationSettings.getFragmentIonTypes().contains(5))) continue;
            int subType = 5;
            ions = ionsMap.get(subType);
            if (ions == null) {
                ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                ionsMap.put(subType, (ArrayList<Ion>)ions);
            }
            if (neutralLossesCombinations != null) {
                for (NeutralLossCombination losses : neutralLossesCombinations) {
                    ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass - Atom.N.getMonoisotopicMass() - losses.getMass(), losses.getNeutralLossCombination()));
                }
                continue;
            }
            ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass - Atom.N.getMonoisotopicMass(), null));
        }
        AminoAcid currentAA = AminoAcid.getAminoAcid(sequence.charAt(sequence.length() - 1));
        forwardMass += currentAA.getMonoisotopicMass();
        if (modifications.get(sequence.length()) != null) {
            for (PTM ptm : (ArrayList)modifications.get(sequence.length())) {
                forwardMass += ptm.getMass();
            }
        }
        if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PRECURSOR_ION)) {
            int subType;
            ArrayList<PrecursorIon> ions;
            HashMap<Integer, ArrayList<PrecursorIon>> ionsMap = (HashMap<Integer, ArrayList<PrecursorIon>>)result.get(Ion.IonType.PRECURSOR_ION.index);
            if (ionsMap == null) {
                ionsMap = new HashMap<Integer, ArrayList<PrecursorIon>>(1);
                result.put(Ion.IonType.PRECURSOR_ION.index, ionsMap);
            }
            if ((ions = (ArrayList<PrecursorIon>)ionsMap.get(subType = 0)) == null) {
                ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList<PrecursorIon>(1);
                ionsMap.put(subType, ions);
            }
            if (neutralLossesCombinations != null) {
                for (NeutralLossCombination losses : neutralLossesCombinations) {
                    ions.add(new PrecursorIon(forwardMass + h2o - losses.getMass(), losses.getNeutralLossCombination()));
                }
            } else {
                ions.add(new PrecursorIon(forwardMass + ho, null));
            }
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     */
    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Tag tag) {
        int subType;
        ArrayList<PrecursorIon> ions;
        HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> result = new HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>();
        ArrayList<NeutralLoss> possibleNeutralLosses = new ArrayList<NeutralLoss>(IonFactory.getDefaultNeutralLosses());
        ArrayList<String> processedPtms = null;
        NeutralLossCombination[] neutralLossesCombinations = this.getNeutralLossesCombinations(possibleNeutralLosses);
        int ionNumberOffset = 1;
        ArrayList<Double> massOffsets = new ArrayList<Double>();
        massOffsets.add(0.0);
        for (Object tagComponent : tag.getContent()) {
            if (tagComponent instanceof AminoAcidPattern) {
                double mass;
                Object aminoAcidMasses;
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                ArrayList patternMasses = new ArrayList();
                for (int i = 0; i < aminoAcidPattern.length(); ++i) {
                    HashMap<Object, Object> ionsMap;
                    Object aa2;
                    aminoAcidMasses = new ArrayList();
                    for (Object aa2 : aminoAcidPattern.getTargetedAA(i)) {
                        ArrayList<RelatedIon> relatedIons;
                        ImmoniumIon immoniumIon;
                        int subType2;
                        ArrayList<RelatedIon> ions2;
                        Object ptmNeutralLoss2;
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(((Character)aa2).charValue());
                        mass = aminoAcid.getMonoisotopicMass();
                        for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(i + 1)) {
                            String ptmName = modificationMatch.getTheoreticPtm();
                            PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                            if (processedPtms == null || !processedPtms.contains(ptmName)) {
                                for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                    int subType3;
                                    ArrayList<Ion> ions3;
                                    HashMap<Integer, ArrayList<Ion>> ionsMap2 = result.get(Ion.IonType.REPORTER_ION.index);
                                    if (ionsMap2 == null) {
                                        ionsMap2 = new HashMap();
                                        result.put(Ion.IonType.REPORTER_ION.index, ionsMap2);
                                    }
                                    if ((ions3 = ionsMap2.get(subType3 = ptmReporterIon.getSubType())) != null) continue;
                                    ions3 = new ArrayList();
                                    ionsMap2.put(subType3, ions3);
                                    ions3.add(ptmReporterIon);
                                }
                                for (Object ptmNeutralLoss2 : ptm.getNeutralLosses()) {
                                    boolean found = false;
                                    for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                        if (!((NeutralLoss)ptmNeutralLoss2).isSameAs(neutralLoss)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    possibleNeutralLosses.add((NeutralLoss)ptmNeutralLoss2);
                                }
                                if (processedPtms == null) {
                                    processedPtms = new ArrayList<String>();
                                }
                                processedPtms.add(ptmName);
                            }
                            mass += ptm.getMass();
                        }
                        if (!((ArrayList)aminoAcidMasses).contains(mass)) {
                            ((ArrayList)aminoAcidMasses).add(mass);
                        }
                        if ((ionsMap = result.get(Ion.IonType.IMMONIUM_ION.index)) == null) {
                            ionsMap = new HashMap();
                            result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                        }
                        if ((ions2 = (ArrayList<RelatedIon>)ionsMap.get(subType2 = (immoniumIon = ImmoniumIon.getImmoniumIon(aminoAcid.getSingleLetterCodeAsChar())).getSubType())) == null) {
                            ions2 = new ArrayList<RelatedIon>();
                            ions2.add((RelatedIon)((Object)immoniumIon));
                            ionsMap.put(subType2, ions2);
                        }
                        if ((ionsMap = result.get(Ion.IonType.RELATED_ION.index)) == null) {
                            ionsMap = new HashMap();
                            result.put(Ion.IonType.RELATED_ION.index, ionsMap);
                        }
                        if ((relatedIons = RelatedIon.getRelatedIons(aminoAcid)) == null) continue;
                        ptmNeutralLoss2 = relatedIons.iterator();
                        while (ptmNeutralLoss2.hasNext()) {
                            RelatedIon tempRelated = (RelatedIon)ptmNeutralLoss2.next();
                            subType2 = tempRelated.getSubType();
                            ions2 = (ArrayList<RelatedIon>)ionsMap.get(subType2);
                            if (ions2 == null) {
                                ions2 = new ArrayList<RelatedIon>(1);
                            }
                            ions2.add(tempRelated);
                            ionsMap.put(subType2, ions2);
                        }
                    }
                    HashMap ionsMap3 = (HashMap)result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (ionsMap3 == null) {
                        ionsMap3 = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap3);
                    }
                    aa2 = massOffsets.iterator();
                    while (aa2.hasNext()) {
                        double massOffset = (Double)aa2.next();
                        ArrayList<Double> newPatternMassess = new ArrayList<Double>();
                        if (patternMasses.isEmpty()) {
                            ionsMap = ((ArrayList)aminoAcidMasses).iterator();
                            while (ionsMap.hasNext()) {
                                double mass2 = (Double)ionsMap.next();
                                int aa3 = ionNumberOffset + i;
                                int subaa = i + 1;
                                double forwardMass = massOffset + mass2;
                                int subType4 = 0;
                                ArrayList<TagFragmentIon> ions4 = (ArrayList<TagFragmentIon>)ionsMap3.get(subType4);
                                if (ions4 == null) {
                                    ions4 = new ArrayList<TagFragmentIon>();
                                    ionsMap3.put(subType4, ions4);
                                }
                                for (NeutralLossCombination losses : neutralLossesCombinations) {
                                    ions4.add(new TagFragmentIon(subType4, aa3, subaa, forwardMass - co - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                                }
                                subType4 = 1;
                                ions4 = (ArrayList<TagFragmentIon>)ionsMap3.get(subType4);
                                if (ions4 == null) {
                                    ions4 = new ArrayList<TagFragmentIon>();
                                    ionsMap3.put(subType4, ions4);
                                }
                                for (NeutralLossCombination losses : neutralLossesCombinations) {
                                    ions4.add(new TagFragmentIon(subType4, aa3, subaa, forwardMass - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                                }
                                subType4 = 1;
                                ions4 = (ArrayList<TagFragmentIon>)ionsMap3.get(subType4);
                                if (ions4 == null) {
                                    ions4 = new ArrayList<TagFragmentIon>();
                                    ionsMap3.put(subType4, ions4);
                                }
                                for (NeutralLossCombination losses : neutralLossesCombinations) {
                                    ions4.add(new TagFragmentIon(subType4, aa3, subaa, forwardMass + nh3 - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                                }
                                if (newPatternMassess.contains(mass2)) continue;
                                newPatternMassess.add(mass2);
                            }
                        } else {
                            ionsMap = patternMasses.iterator();
                            while (ionsMap.hasNext()) {
                                double patternMass = (Double)ionsMap.next();
                                Iterator aa3 = ((ArrayList)aminoAcidMasses).iterator();
                                while (aa3.hasNext()) {
                                    double mass3 = (Double)aa3.next();
                                    int aa4 = ionNumberOffset + i;
                                    int subaa = i + 1;
                                    double patternFragmentMass = patternMass + mass3;
                                    double forwardMass = massOffset + patternFragmentMass;
                                    int subType5 = 0;
                                    ArrayList<TagFragmentIon> ions5 = (ArrayList<TagFragmentIon>)ionsMap3.get(subType5);
                                    if (ions5 == null) {
                                        ions5 = new ArrayList<TagFragmentIon>();
                                        ionsMap3.put(subType5, ions5);
                                    }
                                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                                        ions5.add(new TagFragmentIon(subType5, aa4, subaa, forwardMass - co - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                                    }
                                    subType5 = 1;
                                    ions5 = (ArrayList<TagFragmentIon>)ionsMap3.get(subType5);
                                    if (ions5 == null) {
                                        ions5 = new ArrayList<TagFragmentIon>();
                                        ionsMap3.put(subType5, ions5);
                                    }
                                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                                        ions5.add(new TagFragmentIon(subType5, aa4, subaa, forwardMass - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                                    }
                                    subType5 = 2;
                                    ions5 = (ArrayList<TagFragmentIon>)ionsMap3.get(subType5);
                                    if (ions5 == null) {
                                        ions5 = new ArrayList<TagFragmentIon>();
                                        ionsMap3.put(subType5, ions5);
                                    }
                                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                                        ions5.add(new TagFragmentIon(subType5, aa4, subaa, forwardMass + nh3 - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                                    }
                                    if (newPatternMassess.contains(patternFragmentMass)) continue;
                                    newPatternMassess.add(patternFragmentMass);
                                }
                            }
                        }
                        patternMasses = newPatternMassess;
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                aminoAcidMasses = massOffsets.iterator();
                while (aminoAcidMasses.hasNext()) {
                    double offsetMass = (Double)aminoAcidMasses.next();
                    Iterator massOffset = patternMasses.iterator();
                    while (massOffset.hasNext()) {
                        mass = (Double)massOffset.next();
                        double newMass = offsetMass + mass;
                        if (newOffsetMasses.contains(newMass)) continue;
                        newOffsetMasses.add(newMass);
                    }
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidPattern.length();
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                Object aminoAcid;
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                double sequenceMass = 0.0;
                for (int i = 0; i < aminoAcidSequence.length(); ++i) {
                    ArrayList<RelatedIon> relatedIons;
                    ImmoniumIon immoniumIon;
                    int subType6;
                    ArrayList ions6;
                    aminoAcid = aminoAcidSequence.getAminoAcidAt(i);
                    HashMap<Object, Object> ionsMap = (HashMap)result.get(Ion.IonType.IMMONIUM_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                    }
                    if ((ions6 = (ArrayList)ionsMap.get(subType6 = (immoniumIon = ImmoniumIon.getImmoniumIon(((AminoAcid)aminoAcid).getSingleLetterCodeAsChar())).getSubType())) == null) {
                        ions6 = new ArrayList();
                        ions6.add(immoniumIon);
                        ionsMap.put(subType6, ions6);
                    }
                    if ((ionsMap = (HashMap)result.get(Ion.IonType.RELATED_ION.index)) == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.RELATED_ION.index, ionsMap);
                    }
                    if ((relatedIons = RelatedIon.getRelatedIons((AminoAcid)aminoAcid)) != null) {
                        for (RelatedIon tempRelated : relatedIons) {
                            subType6 = tempRelated.getSubType();
                            ions6 = (ArrayList)ionsMap.get(subType6);
                            if (ions6 == null) {
                                ions6 = new ArrayList(1);
                            }
                            ions6.add(tempRelated);
                            ionsMap.put(subType6, ions6);
                        }
                    }
                    double mass = ((AminoAcid)aminoAcid).getMonoisotopicMass();
                    for (ModificationMatch modificationMatch : aminoAcidSequence.getModificationsAt(i + 1)) {
                        String ptmName = modificationMatch.getTheoreticPtm();
                        PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                        if (processedPtms == null || !processedPtms.contains(ptmName)) {
                            for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                ionsMap = result.get(Ion.IonType.REPORTER_ION.index);
                                if (ionsMap == null) {
                                    ionsMap = new HashMap();
                                    result.put(Ion.IonType.REPORTER_ION.index, ionsMap);
                                }
                                if ((ions6 = (ArrayList)ionsMap.get(subType6 = ptmReporterIon.getSubType())) != null) continue;
                                ions6 = new ArrayList();
                                ionsMap.put(subType6, ions6);
                                ions6.add(ptmReporterIon);
                            }
                            for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                                boolean found = false;
                                for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                    if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                possibleNeutralLosses.add(ptmNeutralLoss);
                            }
                            if (processedPtms == null) {
                                processedPtms = new ArrayList();
                            }
                            processedPtms.add(ptmName);
                        }
                        mass += ptm.getMass();
                    }
                    sequenceMass += mass;
                    ionsMap = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                    }
                    Iterator aa3 = massOffsets.iterator();
                    while (aa3.hasNext()) {
                        double massOffset = (Double)aa3.next();
                        int aa = ionNumberOffset + i;
                        int subaa = i + 1;
                        double forwardMass = massOffset + sequenceMass;
                        subType6 = 0;
                        ions6 = (ArrayList)ionsMap.get(subType6);
                        if (ions6 == null) {
                            ions6 = new ArrayList();
                            ionsMap.put(subType6, ions6);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions6.add(new TagFragmentIon(subType6, aa, subaa, forwardMass - co - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                        }
                        subType6 = 1;
                        ions6 = (ArrayList)ionsMap.get(subType6);
                        if (ions6 == null) {
                            ions6 = new ArrayList();
                            ionsMap.put(subType6, ions6);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions6.add(new TagFragmentIon(subType6, aa, subaa, forwardMass - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                        }
                        subType6 = 2;
                        ions6 = (ArrayList)ionsMap.get(subType6);
                        if (ions6 == null) {
                            ions6 = new ArrayList();
                            ionsMap.put(subType6, ions6);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions6.add(new TagFragmentIon(subType6, aa, subaa, forwardMass + nh3 - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                        }
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                aminoAcid = massOffsets.iterator();
                while (aminoAcid.hasNext()) {
                    double offsetMass = (Double)aminoAcid.next();
                    double newMass = offsetMass + sequenceMass;
                    if (newOffsetMasses.contains(newMass)) continue;
                    newOffsetMasses.add(newMass);
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                double gapMass = tagComponent.getMass();
                int aa = ionNumberOffset;
                int subaa = 0;
                HashMap ionsMap = (HashMap)result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                if (ionsMap == null) {
                    ionsMap = new HashMap();
                    result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                }
                Iterator offsetMass = massOffsets.iterator();
                while (offsetMass.hasNext()) {
                    double massOffset = (Double)offsetMass.next();
                    double forwardMass = massOffset + gapMass;
                    int subType7 = 0;
                    ArrayList<TagFragmentIon> ions7 = (ArrayList<TagFragmentIon>)ionsMap.get(subType7);
                    if (ions7 == null) {
                        ions7 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType7, ions7);
                    }
                    for (Object losses : neutralLossesCombinations) {
                        ions7.add(new TagFragmentIon(subType7, aa, subaa, forwardMass - co - ((NeutralLossCombination)losses).getMass(), ((NeutralLossCombination)losses).getNeutralLossCombination(), massOffset));
                    }
                    subType7 = 1;
                    ions7 = (ArrayList<TagFragmentIon>)ionsMap.get(subType7);
                    if (ions7 == null) {
                        ions7 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType7, ions7);
                    }
                    for (Object losses : neutralLossesCombinations) {
                        ions7.add(new TagFragmentIon(subType7, aa, subaa, forwardMass - ((NeutralLossCombination)losses).getMass(), ((NeutralLossCombination)losses).getNeutralLossCombination(), massOffset));
                    }
                    subType7 = 2;
                    ions7 = (ArrayList<TagFragmentIon>)ionsMap.get(subType7);
                    if (ions7 == null) {
                        ions7 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType7, ions7);
                    }
                    for (Object losses : neutralLossesCombinations) {
                        ions7.add(new TagFragmentIon(subType7, aa, subaa, forwardMass + nh3 - ((NeutralLossCombination)losses).getMass(), ((NeutralLossCombination)losses).getNeutralLossCombination(), massOffset));
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator massOffset = massOffsets.iterator();
                while (massOffset.hasNext()) {
                    double offsetMass2 = (Double)massOffset.next();
                    newOffsetMasses.add(offsetMass2 + gapMass);
                }
                massOffsets = newOffsetMasses;
                ++ionNumberOffset;
                continue;
            }
            throw new UnsupportedOperationException("Fragment ion not implemented for tag component " + tagComponent.getClass() + ".");
        }
        ArrayList<TagComponent> reversedTag = new ArrayList<TagComponent>(tag.getContent());
        Collections.reverse(reversedTag);
        ionNumberOffset = 0;
        massOffsets.clear();
        massOffsets.add(0.0);
        for (TagComponent tagComponent : reversedTag) {
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                ArrayList patternMasses = new ArrayList();
                for (int i = aminoAcidPattern.length() - 1; i >= 0; --i) {
                    HashMap<Object, Object> ionsMap;
                    Object aa5;
                    ArrayList<Double> aminoAcidMasses = new ArrayList<Double>();
                    for (Object aa5 : aminoAcidPattern.getTargetedAA(i)) {
                        ArrayList<RelatedIon> relatedIons;
                        ImmoniumIon immoniumIon;
                        int subType8;
                        ArrayList<RelatedIon> ions8;
                        Object ptmNeutralLoss3;
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(((Character)aa5).charValue());
                        double mass = aminoAcid.getMonoisotopicMass();
                        for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(i + 1)) {
                            String ptmName = modificationMatch.getTheoreticPtm();
                            PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                            if (processedPtms == null || !processedPtms.contains(ptmName)) {
                                for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                    int subType9;
                                    ArrayList<Ion> ions9;
                                    HashMap<Integer, ArrayList<Ion>> ionsMap4 = result.get(Ion.IonType.REPORTER_ION.index);
                                    if (ionsMap4 == null) {
                                        ionsMap4 = new HashMap();
                                        result.put(Ion.IonType.REPORTER_ION.index, ionsMap4);
                                    }
                                    if ((ions9 = ionsMap4.get(subType9 = ptmReporterIon.getSubType())) != null) continue;
                                    ions9 = new ArrayList();
                                    ionsMap4.put(subType9, ions9);
                                    ions9.add(ptmReporterIon);
                                }
                                for (Object ptmNeutralLoss3 : ptm.getNeutralLosses()) {
                                    boolean found = false;
                                    for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                        if (!((NeutralLoss)ptmNeutralLoss3).isSameAs(neutralLoss)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    possibleNeutralLosses.add((NeutralLoss)ptmNeutralLoss3);
                                }
                                if (processedPtms == null) {
                                    processedPtms = new ArrayList();
                                }
                                processedPtms.add(ptmName);
                            }
                            mass += ptm.getMass();
                        }
                        if (!aminoAcidMasses.contains(mass)) {
                            aminoAcidMasses.add(mass);
                        }
                        if ((ionsMap = result.get(Ion.IonType.IMMONIUM_ION.index)) == null) {
                            ionsMap = new HashMap();
                            result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                        }
                        if ((ions8 = (ArrayList<RelatedIon>)ionsMap.get(subType8 = (immoniumIon = ImmoniumIon.getImmoniumIon(aminoAcid.getSingleLetterCodeAsChar())).getSubType())) == null) {
                            ions8 = new ArrayList<RelatedIon>();
                            ions8.add((RelatedIon)((Object)immoniumIon));
                            ionsMap.put(subType8, ions8);
                        }
                        if ((ionsMap = result.get(Ion.IonType.RELATED_ION.index)) == null) {
                            ionsMap = new HashMap();
                            result.put(Ion.IonType.RELATED_ION.index, ionsMap);
                        }
                        if ((relatedIons = RelatedIon.getRelatedIons(aminoAcid)) == null) continue;
                        ptmNeutralLoss3 = relatedIons.iterator();
                        while (ptmNeutralLoss3.hasNext()) {
                            RelatedIon tempRelated = (RelatedIon)ptmNeutralLoss3.next();
                            subType8 = tempRelated.getSubType();
                            ions8 = (ArrayList<RelatedIon>)ionsMap.get(subType8);
                            if (ions8 == null) {
                                ions8 = new ArrayList<RelatedIon>(1);
                            }
                            ions8.add(tempRelated);
                            ionsMap.put(subType8, ions8);
                        }
                    }
                    HashMap<Integer, ArrayList<Ion>> ionsMap5 = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (ionsMap5 == null) {
                        ionsMap5 = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap5);
                    }
                    aa5 = massOffsets.iterator();
                    while (aa5.hasNext()) {
                        double massOffset = (Double)aa5.next();
                        ArrayList<Double> newPatternMassess = new ArrayList<Double>();
                        if (patternMasses.isEmpty()) {
                            ionsMap = aminoAcidMasses.iterator();
                            while (ionsMap.hasNext()) {
                                int subType10;
                                ArrayList<Ion> ions10;
                                double mass = (Double)ionsMap.next();
                                int aa6 = ionNumberOffset + aminoAcidPattern.length() - i;
                                int subaa = aminoAcidPattern.length() - i;
                                double rewindMass = massOffset + mass;
                                double gap = 0.0;
                                if (massOffset != Atom.O.getMonoisotopicMass()) {
                                    gap = massOffset;
                                }
                                if ((ions10 = ionsMap5.get(subType10 = 3)) == null) {
                                    ions10 = new ArrayList();
                                    ionsMap5.put(subType10, ions10);
                                }
                                for (NeutralLossCombination losses : neutralLossesCombinations) {
                                    ions10.add(new TagFragmentIon(subType10, aa6, subaa, rewindMass + co2 - losses.getMass(), losses.getNeutralLossCombination(), gap));
                                }
                                subType10 = 4;
                                ions10 = ionsMap5.get(subType10);
                                if (ions10 == null) {
                                    ions10 = new ArrayList();
                                    ionsMap5.put(subType10, ions10);
                                }
                                for (NeutralLossCombination losses : neutralLossesCombinations) {
                                    ions10.add(new TagFragmentIon(subType10, aa6, subaa, rewindMass + h2o - losses.getMass(), losses.getNeutralLossCombination(), gap));
                                }
                                subType10 = 5;
                                ions10 = ionsMap5.get(subType10);
                                if (ions10 == null) {
                                    ions10 = new ArrayList();
                                    ionsMap5.put(subType10, ions10);
                                }
                                for (NeutralLossCombination losses : neutralLossesCombinations) {
                                    ions10.add(new TagFragmentIon(subType10, aa6, subaa, rewindMass - nMinusO - losses.getMass(), losses.getNeutralLossCombination(), gap));
                                }
                                if (newPatternMassess.contains(mass)) continue;
                                newPatternMassess.add(mass);
                            }
                        } else {
                            ionsMap = patternMasses.iterator();
                            while (ionsMap.hasNext()) {
                                double patternMass = (Double)ionsMap.next();
                                Iterator aa6 = aminoAcidMasses.iterator();
                                while (aa6.hasNext()) {
                                    int subType11;
                                    ArrayList<Ion> ions11;
                                    double mass = (Double)aa6.next();
                                    int aa7 = ionNumberOffset + aminoAcidPattern.length() - i;
                                    int subaa = aminoAcidPattern.length() - i;
                                    double patternFragmentMass = patternMass + mass;
                                    double rewindMass = massOffset + patternFragmentMass;
                                    double gap = 0.0;
                                    if (massOffset != Atom.O.getMonoisotopicMass()) {
                                        gap = massOffset;
                                    }
                                    if ((ions11 = ionsMap5.get(subType11 = 3)) == null) {
                                        ions11 = new ArrayList();
                                        ionsMap5.put(subType11, ions11);
                                    }
                                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                                        ions11.add(new TagFragmentIon(subType11, aa7, subaa, rewindMass + co2 - losses.getMass(), losses.getNeutralLossCombination(), gap));
                                    }
                                    subType11 = 4;
                                    ions11 = ionsMap5.get(subType11);
                                    if (ions11 == null) {
                                        ions11 = new ArrayList();
                                        ionsMap5.put(subType11, ions11);
                                    }
                                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                                        ions11.add(new TagFragmentIon(subType11, aa7, subaa, rewindMass + h2o - losses.getMass(), losses.getNeutralLossCombination(), gap));
                                    }
                                    subType11 = 5;
                                    ions11 = ionsMap5.get(subType11);
                                    if (ions11 == null) {
                                        ions11 = new ArrayList();
                                        ionsMap5.put(subType11, ions11);
                                    }
                                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                                        ions11.add(new TagFragmentIon(subType11, aa7, subaa, rewindMass - nMinusO - losses.getMass(), losses.getNeutralLossCombination(), gap));
                                    }
                                    if (newPatternMassess.contains(patternFragmentMass)) continue;
                                    newPatternMassess.add(patternFragmentMass);
                                }
                            }
                        }
                        patternMasses = newPatternMassess;
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator aminoAcidMasses = massOffsets.iterator();
                while (aminoAcidMasses.hasNext()) {
                    double offsetMass = (Double)aminoAcidMasses.next();
                    Iterator massOffset = patternMasses.iterator();
                    while (massOffset.hasNext()) {
                        double mass = (Double)massOffset.next();
                        double newMass = offsetMass + mass;
                        if (newOffsetMasses.contains(newMass)) continue;
                        newOffsetMasses.add(newMass);
                    }
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidPattern.length();
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                Object aminoAcid;
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                double sequenceMass = 0.0;
                for (int i = aminoAcidSequence.length() - 1; i >= 0; --i) {
                    ArrayList<RelatedIon> relatedIons;
                    ImmoniumIon immoniumIon;
                    int subType12;
                    ArrayList<RelatedIon> ions12;
                    aminoAcid = aminoAcidSequence.getAminoAcidAt(i);
                    HashMap<Object, Object> ionsMap = (HashMap)result.get(Ion.IonType.IMMONIUM_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                    }
                    if ((ions12 = (ArrayList<RelatedIon>)ionsMap.get(subType12 = (immoniumIon = ImmoniumIon.getImmoniumIon(((AminoAcid)aminoAcid).getSingleLetterCodeAsChar())).getSubType())) == null) {
                        ions12 = new ArrayList<RelatedIon>();
                        ions12.add((RelatedIon)((Object)immoniumIon));
                        ionsMap.put(subType12, ions12);
                    }
                    if ((ionsMap = result.get(Ion.IonType.RELATED_ION.index)) == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.RELATED_ION.index, ionsMap);
                    }
                    if ((relatedIons = RelatedIon.getRelatedIons((AminoAcid)aminoAcid)) != null) {
                        for (RelatedIon tempRelated : relatedIons) {
                            subType12 = tempRelated.getSubType();
                            ions12 = (ArrayList<RelatedIon>)ionsMap.get(subType12);
                            if (ions12 == null) {
                                ions12 = new ArrayList<RelatedIon>(1);
                            }
                            ions12.add(tempRelated);
                            ionsMap.put(subType12, ions12);
                        }
                    }
                    double mass = ((AminoAcid)aminoAcid).getMonoisotopicMass();
                    for (ModificationMatch modificationMatch : aminoAcidSequence.getModificationsAt(i + 1)) {
                        String ptmName = modificationMatch.getTheoreticPtm();
                        PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                        if (processedPtms == null || !processedPtms.contains(ptmName)) {
                            for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                ionsMap = result.get(Ion.IonType.REPORTER_ION.index);
                                if (ionsMap == null) {
                                    ionsMap = new HashMap();
                                    result.put(Ion.IonType.REPORTER_ION.index, ionsMap);
                                }
                                if ((ions12 = (ArrayList<RelatedIon>)ionsMap.get(subType12 = ptmReporterIon.getSubType())) != null) continue;
                                ions12 = new ArrayList<RelatedIon>();
                                ionsMap.put(subType12, ions12);
                                ions12.add((RelatedIon)((Object)ptmReporterIon));
                            }
                            for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                                boolean found = false;
                                for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                    if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                possibleNeutralLosses.add(ptmNeutralLoss);
                            }
                            if (processedPtms == null) {
                                processedPtms = new ArrayList();
                            }
                            processedPtms.add(ptmName);
                        }
                        mass += ptm.getMass();
                    }
                    sequenceMass += mass;
                    ionsMap = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                    }
                    Iterator<ModificationMatch> aa6 = massOffsets.iterator();
                    while (aa6.hasNext()) {
                        double massOffset = (Double)((Object)aa6.next());
                        int aa = ionNumberOffset + aminoAcidSequence.length() - i;
                        int subaa = aminoAcidSequence.length() - i;
                        double rewindMass = massOffset + sequenceMass;
                        double gap = 0.0;
                        if (massOffset != Atom.O.getMonoisotopicMass()) {
                            gap = massOffset;
                        }
                        if ((ions12 = (ArrayList<RelatedIon>)ionsMap.get(subType12 = 3)) == null) {
                            ions12 = new ArrayList<RelatedIon>();
                            ionsMap.put(subType12, ions12);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions12.add((RelatedIon)((Object)new TagFragmentIon(subType12, aa, subaa, rewindMass + co2 - losses.getMass(), losses.getNeutralLossCombination(), gap)));
                        }
                        subType12 = 4;
                        ions12 = (ArrayList<RelatedIon>)ionsMap.get(subType12);
                        if (ions12 == null) {
                            ions12 = new ArrayList<RelatedIon>();
                            ionsMap.put(subType12, ions12);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions12.add((RelatedIon)((Object)new TagFragmentIon(subType12, aa, subaa, rewindMass + h2o - losses.getMass(), losses.getNeutralLossCombination(), gap)));
                        }
                        subType12 = 5;
                        ions12 = (ArrayList<RelatedIon>)ionsMap.get(subType12);
                        if (ions12 == null) {
                            ions12 = new ArrayList<RelatedIon>();
                            ionsMap.put(subType12, ions12);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions12.add((RelatedIon)((Object)new TagFragmentIon(subType12, aa, subaa, rewindMass - nMinusO - losses.getMass(), losses.getNeutralLossCombination(), gap)));
                        }
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                aminoAcid = massOffsets.iterator();
                while (aminoAcid.hasNext()) {
                    double offsetMass = (Double)aminoAcid.next();
                    double newMass = offsetMass + sequenceMass;
                    if (newOffsetMasses.contains(newMass)) continue;
                    newOffsetMasses.add(newMass);
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                double gapMass = tagComponent.getMass();
                int aa = ionNumberOffset;
                int subaa = 0;
                HashMap ionsMap = (HashMap)result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                if (ionsMap == null) {
                    ionsMap = new HashMap();
                    result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                }
                Iterator offsetMass = massOffsets.iterator();
                while (offsetMass.hasNext()) {
                    double massOffset = (Double)offsetMass.next();
                    double gap = gapMass;
                    if (massOffset != Atom.O.getMonoisotopicMass()) {
                        gap += massOffset;
                    }
                    double rewindMass = massOffset + gapMass;
                    int subType13 = 3;
                    ArrayList<TagFragmentIon> ions13 = (ArrayList<TagFragmentIon>)ionsMap.get(subType13);
                    if (ions13 == null) {
                        ions13 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType13, ions13);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions13.add(new TagFragmentIon(subType13, aa, subaa, rewindMass + co2 - losses.getMass(), losses.getNeutralLossCombination(), gap));
                    }
                    subType13 = 4;
                    ions13 = (ArrayList<TagFragmentIon>)ionsMap.get(subType13);
                    if (ions13 == null) {
                        ions13 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType13, ions13);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions13.add(new TagFragmentIon(subType13, aa, subaa, rewindMass + h2o - losses.getMass(), losses.getNeutralLossCombination(), gap));
                    }
                    subType13 = 5;
                    ions13 = (ArrayList<TagFragmentIon>)ionsMap.get(subType13);
                    if (ions13 == null) {
                        ions13 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType13, ions13);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions13.add(new TagFragmentIon(subType13, aa, subaa, rewindMass - nMinusO - losses.getMass(), losses.getNeutralLossCombination(), gap));
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator iterator = massOffsets.iterator();
                while (iterator.hasNext()) {
                    double offsetMass3 = (Double)iterator.next();
                    newOffsetMasses.add(offsetMass3 + gapMass);
                }
                massOffsets = newOffsetMasses;
                ++ionNumberOffset;
                continue;
            }
            throw new UnsupportedOperationException("Fragment ion not implemented for tag component " + tagComponent.getClass() + ".");
        }
        HashMap ionsMap = (HashMap)result.get(Ion.IonType.PRECURSOR_ION.index);
        if (ionsMap == null) {
            ionsMap = new HashMap(1);
            result.put(Ion.IonType.PRECURSOR_ION.index, ionsMap);
        }
        if ((ions = (ArrayList<PrecursorIon>)ionsMap.get(subType = 0)) == null) {
            ions = new ArrayList<PrecursorIon>(neutralLossesCombinations.length);
            ionsMap.put(subType, ions);
        }
        for (NeutralLossCombination losses : neutralLossesCombinations) {
            ions.add(new PrecursorIon(tag.getMass() - losses.getMass(), losses.getNeutralLossCombination()));
        }
        return result;
    }

    public NeutralLossCombination[] getNeutralLossesCombinations(ArrayList<NeutralLoss> possibleNeutralLosses) {
        String lossesKey = this.getNeutralLossesKey(possibleNeutralLosses);
        NeutralLossCombination[] neutralLossesCombinations = this.neutralLossesCombinationsCache.get(lossesKey);
        if (neutralLossesCombinations == null) {
            ArrayList<ArrayList<NeutralLoss>> neutralLossesCombinationsLists = this.estimateNeutralLossesCombinations(possibleNeutralLosses);
            neutralLossesCombinations = new NeutralLossCombination[neutralLossesCombinationsLists.size()];
            for (int i = 0; i < neutralLossesCombinationsLists.size(); ++i) {
                NeutralLossCombination combinationObject;
                ArrayList<NeutralLoss> combination = neutralLossesCombinationsLists.get(i);
                NeutralLoss[] combinationAsArray = new NeutralLoss[combination.size()];
                combinationAsArray = combination.toArray(combinationAsArray);
                neutralLossesCombinations[i] = combinationObject = new NeutralLossCombination(combinationAsArray);
            }
            this.neutralLossesCombinationsCache.put(lossesKey, neutralLossesCombinations);
        }
        return neutralLossesCombinations;
    }

    private ArrayList<ArrayList<NeutralLoss>> estimateNeutralLossesCombinations(ArrayList<NeutralLoss> possibleNeutralLosses) {
        ArrayList<ArrayList<NeutralLoss>> neutralLossesCombinations = new ArrayList<ArrayList<NeutralLoss>>();
        ArrayList<NeutralLoss> tempList = new ArrayList<NeutralLoss>(0);
        neutralLossesCombinations.add(tempList);
        for (NeutralLoss neutralLoss1 : possibleNeutralLosses) {
            boolean found = false;
            for (ArrayList<NeutralLoss> accountedCombination : neutralLossesCombinations) {
                if (accountedCombination.size() != 1 || !accountedCombination.get(0).isSameAs(neutralLoss1)) continue;
                found = true;
            }
            if (!found) {
                tempList = new ArrayList(1);
                tempList.add(neutralLoss1);
                neutralLossesCombinations.add(tempList);
            }
            for (NeutralLoss neutralLoss2 : possibleNeutralLosses) {
                if (neutralLoss1.isSameAs(neutralLoss2)) continue;
                found = false;
                for (ArrayList<NeutralLoss> accountedCombination : neutralLossesCombinations) {
                    if (accountedCombination.size() != 2) continue;
                    if (accountedCombination.get(0).isSameAs(neutralLoss1) && accountedCombination.get(1).isSameAs(neutralLoss2)) {
                        found = true;
                        break;
                    }
                    if (!accountedCombination.get(0).isSameAs(neutralLoss2) || !accountedCombination.get(1).isSameAs(neutralLoss1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                tempList = new ArrayList(2);
                tempList.add(neutralLoss1);
                tempList.add(neutralLoss2);
                neutralLossesCombinations.add(tempList);
            }
        }
        return neutralLossesCombinations;
    }

    private String getNeutralLossesKey(ArrayList<NeutralLoss> possibleNeutralLosses) {
        StringBuilder stringBuilder = new StringBuilder(possibleNeutralLosses.size() * 3);
        for (NeutralLoss neutralLoss : possibleNeutralLosses) {
            stringBuilder.append(neutralLoss.name);
        }
        return stringBuilder.toString();
    }

    public static double getLossesMass(ArrayList<NeutralLoss> neutralLosses) {
        double result = 0.0;
        for (NeutralLoss neutralLoss : neutralLosses) {
            result += neutralLoss.getMass().doubleValue();
        }
        return result;
    }
}

