/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.taxonomy.mappings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class EnsemblSpecies {
    public static final String SEPARATOR = "\",\"";
    private HashMap<Integer, String> idToNameMap = new HashMap();
    private HashMap<Integer, String> idToCommonNameMap = new HashMap();
    private HashMap<Integer, String> idToAssemblyMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapping(File speciesFile) throws IOException {
        FileReader r = new FileReader(speciesFile);
        try {
            BufferedReader br = new BufferedReader(r);
            try {
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    line = line.substring(1, line.length() - 1);
                    String[] elements = line.split(SEPARATOR);
                    String id = elements[2].trim();
                    String scientificName = elements[1].trim();
                    String commonName = elements[0].trim();
                    String assembly = elements[3].trim();
                    if (id.equals("") || id.equals("-")) continue;
                    Integer taxon = new Integer(id);
                    if (!scientificName.equals("-")) {
                        this.idToNameMap.put(taxon, scientificName);
                    }
                    if (!commonName.equals("-")) {
                        this.idToCommonNameMap.put(taxon, commonName);
                    }
                    if (assembly.equals("-")) continue;
                    this.idToAssemblyMap.put(taxon, assembly);
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            r.close();
        }
    }

    public String getScientificName(Integer id) {
        return this.idToNameMap.get(id);
    }

    public String getCommonName(Integer id) {
        return this.idToCommonNameMap.get(id);
    }

    public String getAssembly(Integer id) {
        return this.idToAssemblyMap.get(id);
    }

    public HashSet<Integer> getTaxons() {
        return new HashSet<Integer>(this.idToAssemblyMap.keySet());
    }
}

