/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.variants;

import com.compomics.util.experiment.biology.AminoAcid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class AaSubstitutionMatrix
implements Serializable {
    static final long serialVersionUID = -4257237524665484732L;
    private String name;
    private String description;
    private final HashMap<Character, HashSet<Character>> substitutions = new HashMap(26);
    private final HashMap<Character, HashSet<Character>> reverseMap = new HashMap(26);
    public static final AaSubstitutionMatrix noSubstitution = new AaSubstitutionMatrix("No Substitution", "No substitution");
    public static final AaSubstitutionMatrix singleBaseSubstitution = AaSubstitutionMatrix.singleBaseSubstitution();
    public static final AaSubstitutionMatrix transitionsSingleBaseSubstitution = AaSubstitutionMatrix.transitionsSingleBaseSubstitution();
    public static final AaSubstitutionMatrix transversalSingleBaseSubstitution = AaSubstitutionMatrix.transversalSingleBaseSubstitution();
    public static final AaSubstitutionMatrix allSubstitutions = AaSubstitutionMatrix.all();
    public static final AaSubstitutionMatrix synonymousVariant = AaSubstitutionMatrix.synonymousVariant();
    public static final AaSubstitutionMatrix[] defaultMutationMatrices = new AaSubstitutionMatrix[]{noSubstitution, singleBaseSubstitution, transitionsSingleBaseSubstitution, transversalSingleBaseSubstitution, synonymousVariant, allSubstitutions};

    public AaSubstitutionMatrix(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public void addSubstitution(Character originalAa, Character substitutionAa) {
        HashSet<Character> substitutedAas = this.substitutions.get(originalAa);
        if (substitutedAas == null) {
            substitutedAas = new HashSet();
            this.substitutions.put(originalAa, substitutedAas);
        }
        substitutedAas.add(substitutionAa);
        HashSet<Character> originalAas = this.reverseMap.get(originalAa);
        if (originalAas == null) {
            originalAas = new HashSet();
            this.reverseMap.put(substitutionAa, originalAas);
        }
        originalAas.add(originalAa);
    }

    public HashSet<Character> getSubstitutionAminoAcids(Character originalAminoAcid) {
        return this.substitutions.get(originalAminoAcid);
    }

    public HashSet<Character> getOriginalAminoAcids(Character substitutedAminoAcid) {
        return this.reverseMap.get(substitutedAminoAcid);
    }

    public HashSet<Character> getOriginalAminoAcids() {
        return new HashSet<Character>(this.substitutions.keySet());
    }

    public HashSet<Character> getSubstitutionAminoAcids() {
        return new HashSet<Character>(this.substitutions.keySet());
    }

    public void add(AaSubstitutionMatrix otherMatrix) {
        for (Character originalAa : otherMatrix.getOriginalAminoAcids()) {
            for (Character substitutionAa : otherMatrix.getSubstitutionAminoAcids(originalAa)) {
                this.addSubstitution(originalAa, substitutionAa);
            }
        }
    }

    private static AaSubstitutionMatrix singleBaseSubstitution() {
        AaSubstitutionMatrix result = new AaSubstitutionMatrix("Single Base Substitution", "Single base substitutions");
        char[] bases = new char[]{'A', 'T', 'G', 'C'};
        for (char originalAa : AminoAcid.getUniqueAminoAcids()) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char originalBase = geneCode.charAt(i);
                    for (char base : bases) {
                        char substitutionAa;
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid substitutionAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        if (substitutionAminoAcid == null || originalAa == (substitutionAa = substitutionAminoAcid.getSingleLetterCodeAsChar())) continue;
                        result.addSubstitution(Character.valueOf(originalAa), Character.valueOf(substitutionAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    private static AaSubstitutionMatrix transitionsSingleBaseSubstitution() {
        AaSubstitutionMatrix result = new AaSubstitutionMatrix("Single Base Transition", "Single base transitions substitutions.");
        char[] purines = new char[]{'A', 'G'};
        char[] pyrimidines = new char[]{'T', 'C'};
        for (char originalAa : AminoAcid.getUniqueAminoAcids()) {
            if (originalAa == 'X') continue;
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char[] bases;
                    char originalBase = geneCode.charAt(i);
                    if (originalBase == purines[0] || originalBase == purines[1]) {
                        bases = purines;
                    } else if (originalBase == pyrimidines[0] || originalBase == pyrimidines[1]) {
                        bases = pyrimidines;
                    } else {
                        throw new IllegalArgumentException(originalBase + " not recognized for transitions substitution.");
                    }
                    for (char base : bases) {
                        char substitutionAa;
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid substitutionAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        if (substitutionAminoAcid == null || originalAa == (substitutionAa = substitutionAminoAcid.getSingleLetterCodeAsChar())) continue;
                        result.addSubstitution(Character.valueOf(originalAa), Character.valueOf(substitutionAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    private static AaSubstitutionMatrix transversalSingleBaseSubstitution() {
        AaSubstitutionMatrix result = new AaSubstitutionMatrix("Single Base Transversion", "Single base transversion substitutions.");
        char[] purines = new char[]{'A', 'G'};
        char[] pyrimidines = new char[]{'T', 'C'};
        for (char originalAa : AminoAcid.getUniqueAminoAcids()) {
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(originalAa);
            for (String geneCode : aminoAcid.getStandardGeneticCode()) {
                StringBuilder geneCodeStringBuilder = new StringBuilder(geneCode);
                for (int i = 0; i < geneCode.length(); ++i) {
                    char[] bases;
                    char originalBase = geneCode.charAt(i);
                    if (originalBase == purines[0] || originalBase == purines[1]) {
                        bases = pyrimidines;
                    } else if (originalBase == pyrimidines[0] || originalBase == pyrimidines[1]) {
                        bases = purines;
                    } else {
                        throw new IllegalArgumentException(originalBase + " not recognized for transversion substitutions.");
                    }
                    for (char base : bases) {
                        char substitutionAa;
                        geneCodeStringBuilder.setCharAt(i, base);
                        String newCode = geneCodeStringBuilder.toString();
                        AminoAcid substitutionAminoAcid = AminoAcid.getAminoAcidFromGeneticCode(newCode);
                        if (substitutionAminoAcid == null || originalAa == (substitutionAa = substitutionAminoAcid.getSingleLetterCodeAsChar())) continue;
                        result.addSubstitution(Character.valueOf(originalAa), Character.valueOf(substitutionAa));
                    }
                    geneCodeStringBuilder.setCharAt(i, originalBase);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static AaSubstitutionMatrix synonymousVariant() {
        char[] cArray;
        char[] basic;
        char[] polarNeutral;
        void var5_9;
        char[] aromatic;
        char[] nonPolarAliphatic;
        AaSubstitutionMatrix result = new AaSubstitutionMatrix("Synonymous Variant", "Variants keeping amino acid properties.");
        for (char c : nonPolarAliphatic = new char[]{'G', 'A', 'V', 'L', 'M', 'I'}) {
            for (char c2 : nonPolarAliphatic) {
                if (c == c2) continue;
                result.addSubstitution(Character.valueOf(c), Character.valueOf(c2));
            }
        }
        char[] cArray2 = aromatic = new char[]{'F', 'Y', 'W'};
        int n = cArray2.length;
        boolean bl = false;
        while (var5_9 < n) {
            char originalAminoAcid = cArray2[var5_9];
            for (char substitutionAminoAcid : aromatic) {
                if (originalAminoAcid == substitutionAminoAcid) continue;
                result.addSubstitution(Character.valueOf(originalAminoAcid), Character.valueOf(substitutionAminoAcid));
            }
            ++var5_9;
        }
        for (char originalAminoAcid : polarNeutral = new char[]{'S', 'T', 'C', 'P', 'N', 'Q'}) {
            for (char substitutionAminoAcid : polarNeutral) {
                if (originalAminoAcid == substitutionAminoAcid) continue;
                result.addSubstitution(Character.valueOf(originalAminoAcid), Character.valueOf(substitutionAminoAcid));
            }
        }
        for (char originalAminoAcid : basic = new char[]{'K', 'R', 'H'}) {
            for (char substitutionAminoAcid : basic) {
                if (originalAminoAcid == substitutionAminoAcid) continue;
                result.addSubstitution(Character.valueOf(originalAminoAcid), Character.valueOf(substitutionAminoAcid));
            }
        }
        for (char c : cArray = new char[]{'D', 'E'}) {
            for (char substitutionAminoAcid : cArray) {
                if (c == substitutionAminoAcid) continue;
                result.addSubstitution(Character.valueOf(c), Character.valueOf(substitutionAminoAcid));
            }
        }
        return result;
    }

    private static AaSubstitutionMatrix all() {
        AaSubstitutionMatrix result = new AaSubstitutionMatrix("All", "All possible substitutions.");
        for (char originalAa : AminoAcid.getUniqueAminoAcids()) {
            for (char varianAa : AminoAcid.getUniqueAminoAcids()) {
                if (originalAa == varianAa) continue;
                result.addSubstitution(Character.valueOf(originalAa), Character.valueOf(varianAa));
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSameAs(AaSubstitutionMatrix aaSubstitutionMatrix) {
        if (this.equals(aaSubstitutionMatrix)) {
            return true;
        }
        if (!this.name.equals(aaSubstitutionMatrix.getName())) {
            return false;
        }
        if (!this.description.equals(aaSubstitutionMatrix.getDescription())) {
            return false;
        }
        for (Character aa : this.substitutions.keySet()) {
            HashSet<Character> aaMutations = this.substitutions.get(aa);
            HashSet<Character> otherMutations = aaSubstitutionMatrix.getSubstitutionAminoAcids(aa);
            if (otherMutations == null || aaMutations.size() != otherMutations.size()) {
                return false;
            }
            for (Character substitutionAa : aaMutations) {
                if (otherMutations.contains(substitutionAa)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.name;
    }
}

