/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filtering;

import java.util.Arrays;
import java.util.List;

public enum FilterItemComparator {
    equal("=", "Equals"),
    higher(">", "Higher"),
    lower("<", "Lower"),
    higherOrEqual(">=", "Higher or Equal"),
    lowerOrEqual("<=", "Lower or Equal"),
    contains("contains", "Contains"),
    excludes("excludes", "Does not contain"),
    matches("matches", "Matches the given regular expression");

    public final String name;
    public final String description;
    public static final String[] trueFalse;

    private FilterItemComparator(String symbol, String description) {
        this.name = symbol;
        this.description = description;
    }

    public boolean passes(String threshold, String value) {
        switch (this) {
            case equal: {
                return threshold.equals(value);
            }
            case higher: {
                Double thresholdDouble = new Double(threshold);
                Double valueDouble = new Double(value);
                return valueDouble > thresholdDouble;
            }
            case lower: {
                Double thresholdDouble = new Double(threshold);
                Double valueDouble = new Double(value);
                return valueDouble < thresholdDouble;
            }
            case higherOrEqual: {
                Double thresholdDouble = new Double(threshold);
                Double valueDouble = new Double(value);
                return valueDouble >= thresholdDouble;
            }
            case lowerOrEqual: {
                Double thresholdDouble = new Double(threshold);
                Double valueDouble = new Double(value);
                return valueDouble <= thresholdDouble;
            }
            case contains: {
                return value.contains(threshold);
            }
            case excludes: {
                return !value.contains(threshold);
            }
            case matches: {
                return value.matches(threshold);
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public boolean passes(String threshold, List<String> values) {
        switch (this) {
            case equal: {
                for (String value : values) {
                    if (!threshold.equals(value)) continue;
                    return true;
                }
                return false;
            }
            case higher: {
                Double thresholdDouble = new Double(threshold);
                for (String value : values) {
                    Double valueDouble = new Double(value);
                    if (!(valueDouble > thresholdDouble)) continue;
                    return true;
                }
                return false;
            }
            case lower: {
                Double thresholdDouble = new Double(threshold);
                for (String value : values) {
                    Double valueDouble = new Double(value);
                    if (!(valueDouble < thresholdDouble)) continue;
                    return true;
                }
                return false;
            }
            case higherOrEqual: {
                Double thresholdDouble = new Double(threshold);
                for (String value : values) {
                    Double valueDouble = new Double(value);
                    if (!(valueDouble >= thresholdDouble)) continue;
                    return true;
                }
                return false;
            }
            case lowerOrEqual: {
                Double thresholdDouble = new Double(threshold);
                for (String value : values) {
                    Double valueDouble = new Double(value);
                    if (!(valueDouble <= thresholdDouble)) continue;
                    return true;
                }
                return false;
            }
            case contains: {
                for (String value : values) {
                    if (!value.contains(threshold)) continue;
                    return true;
                }
                return false;
            }
            case excludes: {
                for (String value : values) {
                    if (!value.contains(threshold)) continue;
                    return false;
                }
                return true;
            }
            case matches: {
                for (String value : values) {
                    if (!value.matches(threshold)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public boolean passes(String threshold, String[] values) {
        return this.passes(threshold, Arrays.asList(values));
    }

    public String toString() {
        return this.name;
    }

    static {
        trueFalse = new String[]{"Yes", "No"};
    }
}

