/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters.tool_specific;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.preferences.DigestionPreferences;

public class MyriMatchParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 8755937399680481097L;
    private Integer minPeptideLength = 8;
    private Integer maxPeptideLength = 30;
    private Integer numberOfSpectrumMatches = 10;
    private Double ticCutoffPercentage = 0.98;
    private Integer maxDynamicMods = 2;
    private Integer minTerminiCleavages = 2;
    private Double minPrecursorMass = 600.0;
    private Double maxPrecursorMass = 5000.0;
    private Boolean useSmartPlusThreeModel = true;
    private Boolean computeXCorr = false;
    private Integer numIntensityClasses = 3;
    private Integer classSizeMultiplier = 2;
    private Integer numberOfBatches = 50;
    private Integer lowerIsotopeCorrection = -1;
    private Integer upperIsotopeCorrection = 2;
    private String fragmentationRule = "CID";
    private Integer maxPeakCount = 300;
    private String outputFormat = "mzIdentML";

    @Override
    public Advocate getAlgorithm() {
        return Advocate.myriMatch;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MyriMatchParameters) {
            MyriMatchParameters myriMatchParameters = (MyriMatchParameters)identificationAlgorithmParameter;
            if (!this.minPeptideLength.equals(myriMatchParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.maxPeptideLength.equals(myriMatchParameters.getMaxPeptideLength())) {
                return false;
            }
            if (!this.numberOfSpectrumMatches.equals(myriMatchParameters.getNumberOfSpectrumMatches())) {
                return false;
            }
            double diff = Math.abs(this.ticCutoffPercentage - myriMatchParameters.getTicCutoffPercentage());
            if (diff > 1.0E-13) {
                return false;
            }
            if (!this.maxDynamicMods.equals(myriMatchParameters.getMaxDynamicMods())) {
                return false;
            }
            if (!this.minTerminiCleavages.equals(myriMatchParameters.getMinTerminiCleavages())) {
                return false;
            }
            diff = Math.abs(this.minPrecursorMass - myriMatchParameters.getMinPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxPrecursorMass - myriMatchParameters.getMaxPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.useSmartPlusThreeModel.booleanValue() != myriMatchParameters.getUseSmartPlusThreeModel()) {
                return false;
            }
            if (this.computeXCorr.booleanValue() != myriMatchParameters.getComputeXCorr()) {
                return false;
            }
            if (!this.numIntensityClasses.equals(myriMatchParameters.getNumIntensityClasses())) {
                return false;
            }
            if (!this.classSizeMultiplier.equals(myriMatchParameters.getClassSizeMultiplier())) {
                return false;
            }
            if (!this.numberOfBatches.equals(myriMatchParameters.getNumberOfBatches())) {
                return false;
            }
            if (!this.fragmentationRule.equalsIgnoreCase(myriMatchParameters.getFragmentationRule())) {
                return false;
            }
            if (!this.maxPeakCount.equals(myriMatchParameters.getMaxPeakCount())) {
                return false;
            }
            return this.getOutputFormat().equalsIgnoreCase(myriMatchParameters.getOutputFormat());
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMatches);
        output.append(newLine);
        output.append("TIC_CUTOFF_PERCENTAGE=");
        output.append(this.ticCutoffPercentage);
        output.append(newLine);
        output.append("MAX_DYNMIC_MODS=");
        output.append(this.maxDynamicMods);
        output.append(newLine);
        output.append("MIN_TERMINI_CLEAVAGES=");
        output.append(this.minTerminiCleavages);
        output.append(newLine);
        output.append("MIN_PRECURSOR_MASS=");
        output.append(this.minPrecursorMass);
        output.append(newLine);
        output.append("MAX_PRECURSOR_MASS=");
        output.append(this.maxPrecursorMass);
        output.append(newLine);
        output.append("USE_SMART_PLUS_THREE_MODEL=");
        output.append(this.useSmartPlusThreeModel);
        output.append(newLine);
        output.append("COMPUTE_XCORR=");
        output.append(this.computeXCorr);
        output.append(newLine);
        output.append("NUM_INTENSITY_CLASSES=");
        output.append(this.numIntensityClasses);
        output.append(newLine);
        output.append("CLASS_SIZE_MULTIPLIER=");
        output.append(this.classSizeMultiplier);
        output.append(newLine);
        output.append("NUM_BATCHES=");
        output.append(this.numberOfBatches);
        output.append(newLine);
        output.append("FRAGMENTATION_RULE=");
        output.append(this.fragmentationRule);
        output.append(newLine);
        output.append("MAX_PEAK_COUNT=");
        output.append(this.maxPeakCount);
        output.append(newLine);
        output.append("OUTPUT_FORMAT=");
        output.append(this.outputFormat);
        output.append(newLine);
        return output.toString();
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Integer getNumberOfSpectrumMatches() {
        if (this.numberOfSpectrumMatches == null) {
            this.numberOfSpectrumMatches = 10;
        }
        return this.numberOfSpectrumMatches;
    }

    public void setNumberOfSpectrumMatches(Integer numberOfSpectrumMarches) {
        this.numberOfSpectrumMatches = numberOfSpectrumMarches;
    }

    public Double getTicCutoffPercentage() {
        return this.ticCutoffPercentage;
    }

    public void setTicCutoffPercentage(Double ticCutoffPercentage) {
        this.ticCutoffPercentage = ticCutoffPercentage;
    }

    public Integer getMaxDynamicMods() {
        return this.maxDynamicMods;
    }

    public void setMaxDynamicMods(Integer maxDynamicMods) {
        this.maxDynamicMods = maxDynamicMods;
    }

    public Integer getMinTerminiCleavages() {
        return this.minTerminiCleavages;
    }

    public void setMinTerminiCleavages(Integer minTerminiCleavages) {
        this.minTerminiCleavages = minTerminiCleavages;
    }

    public Double getMinPrecursorMass() {
        return this.minPrecursorMass;
    }

    public void setMinPrecursorMass(Double minPrecursorMass) {
        this.minPrecursorMass = minPrecursorMass;
    }

    public Double getMaxPrecursorMass() {
        return this.maxPrecursorMass;
    }

    public void setMaxPrecursorMass(Double maxPrecursorMass) {
        this.maxPrecursorMass = maxPrecursorMass;
    }

    public boolean getUseSmartPlusThreeModel() {
        return this.useSmartPlusThreeModel;
    }

    public void setUseSmartPlusThreeModel(boolean useSmartPlusThreeModel) {
        this.useSmartPlusThreeModel = useSmartPlusThreeModel;
    }

    public boolean getComputeXCorr() {
        return this.computeXCorr;
    }

    public void setComputeXCorr(boolean computeXCorr) {
        this.computeXCorr = computeXCorr;
    }

    public Integer getNumIntensityClasses() {
        return this.numIntensityClasses;
    }

    public void setNumIntensityClasses(Integer numIntensityClasses) {
        this.numIntensityClasses = numIntensityClasses;
    }

    public Integer getClassSizeMultiplier() {
        return this.classSizeMultiplier;
    }

    public void setClassSizeMultiplier(Integer classSizeMultiplier) {
        this.classSizeMultiplier = classSizeMultiplier;
    }

    public Integer getNumberOfBatches() {
        return this.numberOfBatches;
    }

    public void setNumberOfBatches(Integer numberOfBatches) {
        this.numberOfBatches = numberOfBatches;
    }

    public String getFragmentationRule() {
        return this.fragmentationRule;
    }

    public void setFragmentationRule(String fragmentationRule) {
        this.fragmentationRule = fragmentationRule;
    }

    public Integer getMaxPeakCount() {
        if (this.maxPeakCount == null) {
            this.maxPeakCount = 100;
        }
        return this.maxPeakCount;
    }

    public void setMaxPeakCount(Integer maxPeakCount) {
        this.maxPeakCount = maxPeakCount;
    }

    public String getOutputFormat() {
        if (this.outputFormat == null) {
            this.outputFormat = "mzIdentML";
        }
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public static String enzymeMapping(DigestionPreferences digestionPreferences) {
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.unSpecific) {
            return "unspecific cleavage";
        }
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.wholeProtein) {
            return "no cleavage";
        }
        if (digestionPreferences.getEnzymes().size() == 1) {
            Enzyme enzyme = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme.getName();
            if (enzymeName.equalsIgnoreCase("Trypsin")) {
                return "Trypsin";
            }
            if (enzymeName.equalsIgnoreCase("Trypsin (no P rule)")) {
                return "Trypsin/P";
            }
            if (enzymeName.equalsIgnoreCase("Chymotrypsin")) {
                return "Chymotrypsin";
            }
            if (enzymeName.equalsIgnoreCase("Glu-C")) {
                return "glutamyl endopeptidase";
            }
            if (enzymeName.equalsIgnoreCase("Arg-C")) {
                return "Arg-C";
            }
            if (enzymeName.equalsIgnoreCase("Asp-N")) {
                return "Asp-N";
            }
            if (enzymeName.equalsIgnoreCase("CNBr")) {
                return "CNBr";
            }
            if (enzymeName.equalsIgnoreCase("Formic Acid")) {
                return "Formic_acid";
            }
            if (enzymeName.equalsIgnoreCase("Lys-C")) {
                return "Lys-C/P";
            }
            if (enzymeName.equalsIgnoreCase("Lys-C (no P rule)")) {
                return "Lys-C";
            }
            if (enzymeName.equalsIgnoreCase("Pepsin A")) {
                return "Pepsin A";
            }
            if (enzymeName.equalsIgnoreCase("Asp-N")) {
                return "Asp-N";
            }
        }
        return digestionPreferences.getMyriMatchFormat();
    }
}

