/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches_iterators;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class ProteinMatchesIterator {
    private final Identification identification;
    private final ArrayList<String> proteinKeys;
    private final ArrayList<UrParameter> proteinParameters;
    private final boolean loadPeptides;
    private final ArrayList<UrParameter> peptidesParameters;
    private final boolean loadPsms;
    private final ArrayList<UrParameter> psmParameters;
    private final int nMatches;
    private int index = -1;
    public final int defaultBatchSize = 1000;
    private int batchSize = 1000;
    private int loadingIndex = -1;
    private boolean buffering = false;
    private Semaphore bufferingMutex = new Semaphore(1);
    public final double defaultMargin = 0.1;
    private double margin = 0.1;
    private WaitingHandler waitingHandler;

    public ProteinMatchesIterator(ArrayList<String> proteinKeys, Identification identification, ArrayList<UrParameter> proteinParameters, boolean loadPeptides, ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        this.identification = identification;
        this.proteinKeys = proteinKeys == null ? new ArrayList<String>(identification.getProteinIdentification()) : proteinKeys;
        this.nMatches = this.proteinKeys.size();
        this.proteinParameters = proteinParameters;
        this.loadPeptides = loadPeptides;
        this.peptidesParameters = peptideParameters;
        this.loadPsms = loadPsms;
        this.psmParameters = psmParameters;
        this.waitingHandler = waitingHandler;
        if (proteinKeys != null) {
            this.batchSize = Math.max(50, proteinKeys.size() / 100);
            this.batchSize = Math.min(1000, Math.max(this.batchSize, proteinKeys.size() / 1000));
        }
    }

    public ProteinMatchesIterator(Identification identification, ArrayList<UrParameter> proteinParameters, boolean loadPeptides, ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        this(null, identification, proteinParameters, loadPeptides, peptideParameters, loadPsms, psmParameters, waitingHandler);
    }

    public ProteinMatch next() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        int threadIndex = this.incrementIndex();
        if (threadIndex < this.nMatches) {
            this.checkBuffer();
            String key = this.proteinKeys.get(threadIndex);
            ProteinMatch match = this.identification.getProteinMatch(key);
            return match;
        }
        return null;
    }

    private void checkBuffer() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.buffering) {
            int trigger = this.loadingIndex - (int)(this.margin * (double)this.batchSize);
            if (this.index >= trigger) {
                this.bufferingMutex.acquire();
                trigger = this.loadingIndex - (int)(this.margin * (double)this.batchSize);
                if (this.index >= trigger) {
                    this.buffering = true;
                    int newLoadingIndex = Math.min(this.loadingIndex + this.batchSize, this.nMatches - 1);
                    ArrayList<String> keysInBatch = new ArrayList<String>(this.proteinKeys.subList(this.loadingIndex + 1, newLoadingIndex + 1));
                    this.identification.loadProteinMatches(keysInBatch, this.waitingHandler, false);
                    if (this.waitingHandler != null && this.waitingHandler.isRunCanceled()) {
                        return;
                    }
                    if (this.proteinParameters != null) {
                        for (UrParameter urParameter : this.proteinParameters) {
                            if (urParameter == null) {
                                throw new IllegalArgumentException("Parameter to batch load is null.");
                            }
                            this.identification.loadProteinMatchParameters(keysInBatch, urParameter, this.waitingHandler, false);
                            if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) continue;
                            return;
                        }
                    }
                    ArrayList<String> peptideKeys = null;
                    if (this.loadPeptides || this.peptidesParameters != null) {
                        peptideKeys = new ArrayList<String>(this.batchSize);
                        for (String string : keysInBatch) {
                            ProteinMatch proteinMatch = this.identification.getProteinMatch(string);
                            peptideKeys.addAll(proteinMatch.getPeptideMatchesKeys());
                        }
                    }
                    if (this.loadPeptides) {
                        this.identification.loadPeptideMatches(peptideKeys, this.waitingHandler, false);
                        if (this.loadPsms) {
                            ArrayList<String> arrayList = new ArrayList<String>(peptideKeys.size());
                            for (String peptideKey : peptideKeys) {
                                PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
                                arrayList.addAll(peptideMatch.getSpectrumMatchesKeys());
                            }
                            this.identification.loadSpectrumMatches(arrayList, this.waitingHandler, false);
                            if (this.psmParameters != null) {
                                for (UrParameter urParameter : this.psmParameters) {
                                    if (urParameter == null) {
                                        throw new IllegalArgumentException("Parameter to batch load is null.");
                                    }
                                    this.identification.loadSpectrumMatchParameters(arrayList, urParameter, this.waitingHandler, false);
                                    if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) continue;
                                    return;
                                }
                            }
                        }
                    }
                    if (this.peptidesParameters != null) {
                        for (UrParameter urParameter : this.peptidesParameters) {
                            if (urParameter == null) {
                                throw new IllegalArgumentException("Parameter to batch load is null.");
                            }
                            this.identification.loadPeptideMatchParameters(peptideKeys, urParameter, this.waitingHandler, false);
                            if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) continue;
                            return;
                        }
                    }
                    this.loadingIndex = newLoadingIndex;
                    trigger += (int)(this.margin * (double)this.batchSize / 2.0);
                    if (this.index < (trigger = Math.max(0, trigger))) {
                        if (this.batchSize > 1000) {
                            this.batchSize = Math.max(1000, 0 * this.batchSize);
                        } else if (this.margin > 0.1) {
                            this.margin = Math.max(0.1, 0.9 * this.margin);
                        }
                    }
                }
                if (!this.bufferingMutex.hasQueuedThreads()) {
                    this.buffering = false;
                }
                this.bufferingMutex.release();
            }
        } else if (this.index == this.loadingIndex) {
            this.margin *= 1.1;
            if (this.margin >= 0.25) {
                this.batchSize = (int)((double)this.batchSize * 1.1);
                this.margin = 0.1;
            }
        }
    }

    private synchronized int incrementIndex() {
        int localIndex = ++this.index;
        return localIndex;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

