/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.fm_index;

import com.compomics.util.experiment.identification.protein_inference.fm_index.Rank;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.Collections;

public class WaveletTree {
    private Rank rank;
    private long[] alphabetDirections = new long[2];
    private int firstChar;
    private int lastChar;
    private int lenText;
    private boolean continueLeftRangeQuery = false;
    private boolean continueRightRangeQuery = false;
    private WaveletTree leftChild;
    private WaveletTree rightChild;
    private final int shift = 6;
    private final int mask = 63;
    private int numMasses;
    private int leftRightMask;
    private int[] less;

    public WaveletTree(byte[] text, long[] aAlphabet, WaitingHandler waitingHandler, int numMasses, boolean hasPTMatTerminus) {
        this.prepareWaveletTree(text, aAlphabet, waitingHandler, numMasses, hasPTMatTerminus);
    }

    public WaveletTree(byte[] text, long[] aAlphabet, WaitingHandler waitingHandler, int numMasses) {
        this.prepareWaveletTree(text, aAlphabet, waitingHandler, numMasses, false);
    }

    private void prepareWaveletTree(byte[] text, long[] aAlphabet, WaitingHandler waitingHandler, int numMasses, boolean hasPTMatTerminus) {
        int[] counts = new int[128];
        byte[] byArray = text;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte c;
            byte by = c = byArray[i];
            counts[by] = counts[by] + 1;
        }
        ArrayList<HuffmanNode> huffmanNodes = new ArrayList<HuffmanNode>();
        for (int i = 0; i < 128; ++i) {
            if ((aAlphabet[i >>> 6] >>> (i & 0x3F) & 1L) != 1L) continue;
            huffmanNodes.add(new HuffmanNode(counts[i], i));
        }
        while (huffmanNodes.size() > 1) {
            Collections.sort(huffmanNodes);
            HuffmanNode first = (HuffmanNode)huffmanNodes.remove(0);
            HuffmanNode second = (HuffmanNode)huffmanNodes.remove(0);
            huffmanNodes.add(new HuffmanNode(first, second));
        }
        this.createWaveletTreeHuffman(text, waitingHandler, (HuffmanNode)huffmanNodes.get(0), numMasses, hasPTMatTerminus);
        this.less = new int[128];
        long[] alphabet = new long[]{((HuffmanNode)huffmanNodes.get((int)0)).alphabet[0], ((HuffmanNode)huffmanNodes.get((int)0)).alphabet[1]};
        int cumulativeSum = 0;
        for (int i = 0; i < 128; ++i) {
            this.less[i] = cumulativeSum;
            if ((alphabet[i >>> 6] >>> (i & 0x3F) & 1L) == 0L) continue;
            cumulativeSum += this.getRank(this.lenText - 1, i);
        }
    }

    public WaveletTree(byte[] text, WaitingHandler waitingHandler, HuffmanNode root, int numMasses, boolean hasPTMatTerminus) {
        this.numMasses = numMasses;
        this.createWaveletTreeHuffman(text, waitingHandler, root, numMasses, hasPTMatTerminus);
    }

    public void createWaveletTreeHuffman(byte[] text, WaitingHandler waitingHandler, HuffmanNode root, int numMasses, boolean hasPTMatTerminus) {
        long bit;
        int pos;
        int cell;
        int i;
        int j;
        int pos2;
        int cell2;
        int i2;
        this.numMasses = numMasses;
        long[] alphabet = new long[]{root.alphabet[0], root.alphabet[1]};
        long[] alphabetExcluded = new long[2];
        alphabetExcluded[0] = 0x1000000000L;
        if (!hasPTMatTerminus) {
            alphabetExcluded[0] = alphabetExcluded[0] | 0x800000000000L;
        }
        long[] alphabet_left = new long[2];
        long[] alphabet_right = new long[2];
        this.alphabetDirections[0] = alphabet_left[0] = root.leftChild.alphabet[0];
        this.alphabetDirections[1] = alphabet_left[1] = root.leftChild.alphabet[1];
        alphabet_right[0] = root.rightChild.alphabet[0];
        alphabet_right[1] = root.rightChild.alphabet[1];
        this.continueLeftRangeQuery = (alphabet_left[0] & (alphabetExcluded[0] ^ 0xFFFFFFFFFFFFFFFFL)) + (alphabet_left[1] & (alphabetExcluded[1] ^ 0xFFFFFFFFFFFFFFFFL)) > 0L;
        this.continueRightRangeQuery = (alphabet_right[0] & (alphabetExcluded[0] ^ 0xFFFFFFFFFFFFFFFFL)) + (alphabet_right[1] & (alphabetExcluded[1] ^ 0xFFFFFFFFFFFFFFFFL)) > 0L;
        this.lenText = text.length;
        this.rank = new Rank(text, alphabet_right);
        this.leftChild = null;
        this.rightChild = null;
        int lenAlphabet = Long.bitCount(alphabet[0]) + Long.bitCount(alphabet[1]);
        byte[] charAlphabetField = new byte[lenAlphabet];
        for (int i3 = 0; i3 < root.charAlphabet.size(); ++i3) {
            charAlphabetField[i3] = root.charAlphabet.get(i3);
        }
        this.firstChar = charAlphabetField[0];
        this.lastChar = charAlphabetField[lenAlphabet - 1];
        int len_alphabet_left = Long.bitCount(alphabet_left[0]) + Long.bitCount(alphabet_left[1]);
        int len_alphabet_right = Long.bitCount(alphabet_right[0]) + Long.bitCount(alphabet_right[1]);
        if (len_alphabet_left > 1) {
            int len_text_left = 0;
            for (i2 = 0; i2 < text.length; ++i2) {
                cell2 = text[i2] >>> 6;
                pos2 = text[i2] & 0x3F;
                len_text_left += (int)(alphabet_left[cell2] >>> pos2 & 1L);
            }
            if (len_text_left > 0) {
                byte[] text_left = new byte[len_text_left];
                j = 0;
                for (i = 0; i < text.length; ++i) {
                    cell = text[i] >>> 6;
                    pos = text[i] & 0x3F;
                    bit = alphabet_left[cell] >>> pos & 1L;
                    if (bit <= 0L) continue;
                    text_left[j++] = text[i];
                }
                this.leftChild = new WaveletTree(text_left, waitingHandler, root.leftChild, numMasses, hasPTMatTerminus);
            }
        }
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return;
        }
        if (len_alphabet_right > 1) {
            int len_text_right = 0;
            for (i2 = 0; i2 < text.length; ++i2) {
                cell2 = text[i2] >>> 6;
                pos2 = text[i2] & 0x3F;
                len_text_right += (int)(alphabet_right[cell2] >>> pos2 & 1L);
            }
            if (len_text_right > 0) {
                byte[] text_right = new byte[len_text_right];
                j = 0;
                for (i = 0; i < text.length; ++i) {
                    cell = text[i] >>> 6;
                    pos = text[i] & 0x3F;
                    bit = alphabet_right[cell] >>> pos & 1L;
                    if (bit <= 0L) continue;
                    text_right[j++] = text[i];
                }
                this.rightChild = new WaveletTree(text_right, waitingHandler, root.rightChild, numMasses, hasPTMatTerminus);
            }
        }
        if (this.leftChild != null) {
            this.leftRightMask = 4;
        }
        if (this.rightChild != null) {
            this.leftRightMask |= 2;
        }
    }

    public int[] createLessTable() {
        return this.less;
    }

    public int getRank(int index, int character) {
        if (index < this.lenText) {
            return this.getRankRecursive(index, character);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getRankRecursive(int index, int character) {
        if (index >= 0) {
            int cell = character >>> 6;
            int pos = character & 0x3F;
            boolean left = (this.alphabetDirections[cell] >>> pos & 1L) == 1L;
            int result = this.rank.getRank(index, left);
            if (left && this.leftChild != null) {
                return this.leftChild.getRankRecursive(result - 1, character);
            }
            if (!left && this.rightChild != null) {
                return this.rightChild.getRankRecursive(result - 1, character);
            }
            return result;
        }
        return 0;
    }

    public int[] getCharacterInfo(int index) {
        if (index < this.lenText) {
            boolean left = !this.rank.isOne(index);
            int result = this.rank.getRank(index, left);
            if (result == 0) {
                return new int[]{this.firstChar, 0};
            }
            --result;
            if (left) {
                if (this.leftChild == null) {
                    return new int[]{this.firstChar, result};
                }
                return this.leftChild.getCharacterInfo(result);
            }
            if (this.rightChild == null) {
                return new int[]{this.lastChar, result};
            }
            return this.rightChild.getCharacterInfo(result);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getAllocatedBytes() {
        int bytes = this.rank.getAllocatedBytes();
        if (this.leftChild != null) {
            bytes += this.leftChild.getAllocatedBytes();
        }
        if (this.rightChild != null) {
            bytes += this.rightChild.getAllocatedBytes();
        }
        return bytes;
    }

    public int[][] rangeQuery(int leftIndex, int rightIndex) {
        int[][] query = new int[this.numMasses + 1][];
        query[this.numMasses] = new int[]{0};
        if (leftIndex + 1 < rightIndex) {
            this.rangeQuery(leftIndex, rightIndex, query);
        } else {
            this.rangeQueryOneValue(rightIndex, query);
        }
        return query;
    }

    public void rangeQuery(int leftIndex, int rightIndex, int[][] setCharacter) {
        int newRightIndex;
        int newLeftIndex = leftIndex >= 0 ? this.rank.getRankOne(leftIndex) : 0;
        int n = newRightIndex = rightIndex >= 0 ? this.rank.getRankOne(rightIndex) : 0;
        if (this.continueRightRangeQuery && newRightIndex - newLeftIndex > 0) {
            if (this.rightChild != null) {
                this.rightChild.rangeQuery(newLeftIndex - 1, newRightIndex - 1, setCharacter);
            } else {
                int[] nArray = setCharacter[this.numMasses];
                int n2 = nArray[0];
                nArray[0] = n2 + 1;
                setCharacter[n2] = new int[]{this.lastChar, newLeftIndex, newRightIndex, this.lastChar, -1};
            }
        }
        newLeftIndex = leftIndex - newLeftIndex;
        newRightIndex = rightIndex - newRightIndex;
        if (this.continueLeftRangeQuery && newRightIndex - newLeftIndex > 0) {
            if (this.leftChild != null) {
                this.leftChild.rangeQuery(newLeftIndex, newRightIndex, setCharacter);
            } else {
                int[] nArray = setCharacter[this.numMasses];
                int n3 = nArray[0];
                nArray[0] = n3 + 1;
                setCharacter[n3] = new int[]{this.firstChar, newLeftIndex + 1, newRightIndex + 1, this.firstChar, -1};
            }
        }
    }

    public void rangeQueryOneValue(int index, int[][] setCharacter) {
        int switchOption = this.rank.isOneInt(index);
        switchOption += this.leftRightMask & 4 >> switchOption;
        switch (switchOption) {
            case 3: {
                int newIndex3 = this.rank.getRankOne(index);
                this.rightChild.rangeQueryOneValue(newIndex3 - 1, setCharacter);
                break;
            }
            case 4: {
                int newIndex4 = this.rank.getRankZero(index);
                this.leftChild.rangeQueryOneValue(newIndex4 - 1, setCharacter);
                break;
            }
            case 0: {
                int newIndex0 = this.rank.getRankZero(index);
                int[] nArray = setCharacter[this.numMasses];
                int n = nArray[0];
                nArray[0] = n + 1;
                setCharacter[n] = new int[]{this.firstChar, newIndex0 - 1, newIndex0, this.firstChar, -1};
                break;
            }
            case 1: {
                int newIndex1 = this.rank.getRankOne(index);
                int[] nArray = setCharacter[this.numMasses];
                int n = nArray[0];
                nArray[0] = n + 1;
                setCharacter[n] = new int[]{this.lastChar, newIndex1 - 1, newIndex1, this.lastChar, -1};
            }
        }
    }

    public int[] singleRangeQuery(int leftIndex, int rightIndex, int character) {
        int newRightIndex;
        boolean left;
        boolean bl = left = (this.alphabetDirections[character >>> 6] >>> (character & 0x3F) & 1L) == 1L;
        if (left) {
            int newRightIndex2;
            int newLeftIndex = leftIndex >= 0 ? this.rank.getRankZero(leftIndex) : 0;
            int n = newRightIndex2 = rightIndex >= 0 ? this.rank.getRankZero(rightIndex) : 0;
            if (this.leftChild != null) {
                return this.leftChild.singleRangeQuery(newLeftIndex - 1, newRightIndex2 - 1, character);
            }
            return new int[]{newLeftIndex, newRightIndex2};
        }
        int newLeftIndex = leftIndex >= 0 ? this.rank.getRankOne(leftIndex) : 0;
        int n = newRightIndex = rightIndex >= 0 ? this.rank.getRankOne(rightIndex) : 0;
        if (this.rightChild != null) {
            return this.rightChild.singleRangeQuery(newLeftIndex - 1, newRightIndex - 1, character);
        }
        return new int[]{newLeftIndex, newRightIndex};
    }

    public class HuffmanNode
    implements Comparable<HuffmanNode> {
        long[] alphabet = new long[]{0L, 0L};
        int counts = 0;
        int depth = 0;
        int innernodes = 0;
        HuffmanNode leftChild = null;
        HuffmanNode rightChild = null;
        ArrayList<Byte> charAlphabet = new ArrayList();

        public HuffmanNode(int counts, int character) {
            this.counts = counts;
            int n = character >>> 6;
            this.alphabet[n] = this.alphabet[n] | 1L << (character & 0x3F);
            this.charAlphabet.add((byte)character);
        }

        public HuffmanNode(HuffmanNode first, HuffmanNode second) {
            this.counts = first.counts + second.counts;
            this.alphabet[0] = this.alphabet[0] | first.alphabet[0];
            this.alphabet[0] = this.alphabet[0] | second.alphabet[0];
            this.alphabet[1] = this.alphabet[1] | first.alphabet[1];
            this.alphabet[1] = this.alphabet[1] | second.alphabet[1];
            this.leftChild = first;
            this.rightChild = second;
            this.charAlphabet.addAll(first.charAlphabet);
            this.charAlphabet.addAll(second.charAlphabet);
            this.depth = Math.max(first.depth, second.depth) + 1;
            this.innernodes = first.innernodes + second.innernodes + 1;
        }

        @Override
        public int compareTo(HuffmanNode argument) {
            if (this.counts < argument.counts) {
                return -1;
            }
            if (this.counts > argument.counts) {
                return 1;
            }
            return 0;
        }
    }
}

