/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences;

import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapperType;
import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTree;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.PeptideVariantsPreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.protein.Header;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import javax.swing.JProgressBar;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class SequenceFactory {
    private static SequenceFactory instance = null;
    private HashMap<String, Header> currentHeaderMap = new HashMap();
    private HashMap<String, Protein> currentProteinMap = new HashMap();
    private FastaIndex fastaIndex = null;
    private BufferedRandomAccessFile currentRandomAccessFile = null;
    private File currentFastaFile = null;
    private int nCache = 1000000;
    private ArrayList<String> loadedProteins = new ArrayList();
    private static final String[] DECOY_FLAGS = new String[]{"REVERSED", "RND", "SHUFFLED", "DECOY"};
    private HashMap<String, Double> molecularWeights = new HashMap();
    private PeptideMapper defaultPeptideMapper = null;
    private boolean reading = false;
    public static final long TIME_OUT = 10000L;
    private boolean decoyInMemory = true;
    public static int minProteinCount = 1000;
    public static final int nAaOccurrence = 1000000;

    private SequenceFactory() {
    }

    public static SequenceFactory getInstance() {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        return instance;
    }

    public static SequenceFactory getInstance(int nCache) {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        instance.setnCache(nCache);
        return instance;
    }

    public boolean hasEnoughSequences() {
        return this.getNTargetSequences() > minProteinCount;
    }

    public void clearFactory() throws IOException, SQLException, InterruptedException {
        this.closeFile();
        this.defaultPeptideMapper = null;
        this.currentHeaderMap.clear();
        this.currentProteinMap.clear();
        this.fastaIndex = null;
        this.currentRandomAccessFile = null;
        this.currentFastaFile = null;
        this.loadedProteins.clear();
        this.molecularWeights.clear();
    }

    public void emptyCache() {
        this.currentHeaderMap.clear();
        this.currentProteinMap.clear();
        this.loadedProteins.clear();
        this.molecularWeights.clear();
        if (this.defaultPeptideMapper != null) {
            this.defaultPeptideMapper.emptyCache();
        }
    }

    public Protein getProtein(String accession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException {
        return this.getProtein(accession, true);
    }

    private Protein getProtein(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException {
        if (this.fastaIndex == null) {
            throw new IllegalArgumentException("Protein sequences not loaded in the sequence factory.");
        }
        Protein currentProtein = this.currentProteinMap.get(accession);
        if (currentProtein == null && this.isDefaultReversed() && this.isDecoyAccession(accession)) {
            currentProtein = this.decoyInMemory ? this.getDecoyProteinFromTargetSynchronized(accession, reindex) : this.getDecoyProteinFromTarget(accession, reindex);
        }
        if (currentProtein == null) {
            currentProtein = this.getProteinSynchronized(accession, reindex);
        }
        if (currentProtein == null) {
            throw new IllegalArgumentException("Protein not found: " + accession + ".");
        }
        return currentProtein;
    }

    public synchronized Protein getDecoyProteinFromTargetSynchronized(String accession, boolean reindex) throws IOException, IllegalArgumentException, FileNotFoundException {
        Protein currentProtein = this.currentProteinMap.get(accession);
        if (currentProtein == null) {
            currentProtein = this.getDecoyProteinFromTarget(accession, reindex);
        }
        return currentProtein;
    }

    public Protein getDecoyProteinFromTarget(String accession, boolean reindex) throws IOException, IllegalArgumentException, FileNotFoundException {
        Protein currentProtein = null;
        String targetAccession = SequenceFactory.getDefaultTargetAccession(accession);
        try {
            Protein targetProtein = this.currentProteinMap.get(targetAccession);
            if (targetProtein == null && this.decoyInMemory) {
                currentProtein = this.getProteinSynchronized(accession, reindex);
            } else {
                if (targetProtein == null) {
                    targetProtein = this.getProtein(targetAccession, reindex);
                }
                currentProtein = new Protein(accession, targetProtein.getDatabaseType(), SequenceFactory.reverseSequence(targetProtein.getSequence()), true);
                if (this.decoyInMemory) {
                    this.addProteinToCache(accession, currentProtein);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentProtein;
    }

    private synchronized Protein getProteinSynchronized(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException {
        Protein currentProtein = this.currentProteinMap.get(accession);
        if (currentProtein == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                if (reindex) {
                    this.fastaIndex = this.getFastaIndex(true, null);
                    return this.getProtein(accession, false);
                }
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            return this.getProtein(accession, index, 1L);
        }
        return currentProtein;
    }

    private synchronized Protein getProtein(String accession, long index, long waitingTime) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException {
        if (waitingTime <= 0L) {
            throw new IllegalArgumentException("Waiting time should be a positive number.");
        }
        try {
            String line;
            if (this.reading) {
                throw new IllegalStateException("Attempting to read new line before current read operation is completed.");
            }
            this.reading = true;
            this.currentRandomAccessFile.seek(index);
            StringBuilder sequence = new StringBuilder();
            Header currentHeader = this.currentHeaderMap.get(accession);
            boolean headerFound = false;
            while ((line = this.currentRandomAccessFile.readLine()) != null) {
                if ((line = line.trim()).startsWith(">")) {
                    if (sequence.length() != 0 || headerFound) break;
                    if (currentHeader == null) {
                        currentHeader = Header.parseFromFASTA(line);
                        if (currentHeader == null) {
                            throw new IllegalArgumentException("Could not parse FASTA header \"" + line + "\".");
                        }
                        this.currentHeaderMap.put(accession, currentHeader);
                    }
                    headerFound = true;
                    continue;
                }
                sequence.append(line.trim());
            }
            Protein currentProtein = new Protein(accession, currentHeader.getDatabaseType(), SequenceFactory.importSequenceFromFasta(sequence), this.isDecoyAccession(accession));
            this.addProteinToCache(accession, currentProtein);
            this.reading = false;
            return currentProtein;
        }
        catch (IOException e) {
            this.reading = false;
            if (waitingTime < 10000L) {
                this.wait(waitingTime);
                e.printStackTrace();
                return this.getProtein(accession, index, 2L * waitingTime);
            }
            throw e;
        }
    }

    public static String importSequenceFromFasta(StringBuilder fastaSequence) {
        String sequence = fastaSequence.charAt(fastaSequence.length() - 1) == '*' ? fastaSequence.substring(0, fastaSequence.length() - 1) : fastaSequence.toString();
        return sequence;
    }

    public static void validateSequence(char[] proteinSequence) {
        for (char aa : proteinSequence) {
            if (AminoAcid.isAa(aa)) continue;
            throw new IllegalArgumentException("Found character in protein sequence that cannot be mapped to an amino acid (" + aa + ").");
        }
    }

    private synchronized void addProteinToCache(String accession, Protein protein) {
        while (this.loadedProteins.size() >= this.nCache) {
            String accessionToRemove = this.loadedProteins.get(0);
            this.currentProteinMap.remove(accessionToRemove);
            this.currentHeaderMap.remove(accessionToRemove);
            this.loadedProteins.remove(0);
        }
        this.loadedProteins.add(accession);
        this.currentProteinMap.put(accession, protein);
    }

    public Header getHeader(String accession) throws IOException, InterruptedException {
        return this.getHeader(accession, true);
    }

    private Header getHeader(String accession, boolean reindex) throws IOException, InterruptedException {
        Header result = this.currentHeaderMap.get(accession);
        if (result == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                if (reindex) {
                    this.fastaIndex = this.getFastaIndex(true, null);
                    result = this.getHeader(accession, false);
                }
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            result = this.getHeader(index, 0);
            this.currentHeaderMap.put(accession, result);
        }
        return result;
    }

    private synchronized Header getHeader(long index, int nTries) throws InterruptedException, IOException {
        if (this.reading) {
            throw new IllegalStateException("Attempting to read new line before current read operation is completed.");
        }
        try {
            this.reading = true;
            this.currentRandomAccessFile.seek(index);
            Header result = Header.parseFromFASTA(this.currentRandomAccessFile.readLine());
            this.reading = false;
            return result;
        }
        catch (IOException e) {
            this.reading = false;
            if (nTries <= 100) {
                this.wait(10L);
                return this.getHeader(index, nTries + 1);
            }
            throw e;
        }
    }

    public void loadFastaFile(File fastaFile) throws IOException, ClassNotFoundException {
        this.loadFastaFile(fastaFile, null);
    }

    public void loadFastaFile(File fastaFile, WaitingHandler waitingHandler) throws IOException, ClassNotFoundException {
        if (!fastaFile.exists()) {
            throw new FileNotFoundException("The FASTA file '" + fastaFile.getAbsolutePath() + "' could not be found!");
        }
        this.defaultPeptideMapper = null;
        this.currentFastaFile = fastaFile;
        this.currentRandomAccessFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        this.fastaIndex = this.getFastaIndex(false, waitingHandler);
    }

    public boolean isClosed() {
        return this.currentFastaFile == null;
    }

    public void resetConnection() throws IOException {
        this.currentRandomAccessFile.close();
        this.currentRandomAccessFile = new BufferedRandomAccessFile(this.currentFastaFile, "r", 102400);
    }

    private FastaIndex getFastaIndex() throws IOException, ClassNotFoundException {
        return this.getFastaIndex(false, null);
    }

    private synchronized FastaIndex getFastaIndex(boolean overwrite, WaitingHandler waitingHandler) throws IOException, StringIndexOutOfBoundsException {
        return SequenceFactory.getFastaIndex(this.currentFastaFile, overwrite, waitingHandler);
    }

    public static synchronized FastaIndex getFastaIndex(File fastaFile, boolean overwrite, WaitingHandler waitingHandler) throws IOException, StringIndexOutOfBoundsException {
        FastaIndex tempFastaIndex;
        File indexFile;
        String fileName = fastaFile.getName();
        if (!overwrite && (indexFile = new File(fastaFile.getParent(), fastaFile.getName() + ".cui")).exists()) {
            try {
                tempFastaIndex = (FastaIndex)SerializationUtils.readObject(indexFile);
                Long indexLastModified = tempFastaIndex.getLastModified();
                if (indexLastModified != null) {
                    long fileLastModified = fastaFile.lastModified();
                    if (indexLastModified == fileLastModified) {
                        return tempFastaIndex;
                    }
                    System.err.println("Reindexing: " + fileName + ". (changes in the file detected)");
                }
            }
            catch (InvalidClassException e) {
                System.err.println("Reindexing: " + fileName + ". (Reason: " + e.getLocalizedMessage() + ")");
            }
            catch (Exception e) {
                System.err.println("Reindexing: " + fileName + ". (Reason: " + e.getLocalizedMessage() + ")");
            }
        }
        String decoyTag = null;
        String name = null;
        String version = null;
        String description = null;
        String accessionParsingRule = null;
        File indexFile2 = new File(fastaFile.getParent(), fileName + ".cui");
        if (indexFile2.exists()) {
            try {
                tempFastaIndex = (FastaIndex)SerializationUtils.readObject(indexFile2);
                decoyTag = tempFastaIndex.getDecoyTag();
                version = tempFastaIndex.getVersion();
                name = tempFastaIndex.getName();
                description = tempFastaIndex.getDescription();
                accessionParsingRule = tempFastaIndex.getAccessionParsingRule();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Reindexing: " + fileName + ".");
        tempFastaIndex = SequenceFactory.createFastaIndex(fastaFile, name, decoyTag, version, waitingHandler);
        tempFastaIndex.setDescription(description);
        tempFastaIndex.setAccessionParsingRule(accessionParsingRule);
        if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
            try {
                SequenceFactory.writeIndex(tempFastaIndex, fastaFile.getParentFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tempFastaIndex;
    }

    private static FastaIndex createFastaIndex(File fastaFile, String name, String decoyTag, String version, WaitingHandler waitingHandler) throws IOException {
        String line;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        HashSet<String> decoyAccessions = new HashSet<String>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        boolean decoy = false;
        boolean defaultReversed = false;
        int nTarget = 0;
        long index = bufferedRandomAccessFile.getFilePointer();
        HashMap<Header.DatabaseType, Integer> databaseTypes = new HashMap<Header.DatabaseType, Integer>();
        HashMap<String, Integer> species = new HashMap<String, Integer>();
        int[] aaOccurrence = new int[26];
        LinkedList<int[]> aaOccurrenceList = new LinkedList<int[]>();
        int nAAs = 0;
        StringBuilder sequenceBuilder = new StringBuilder();
        String accession = null;
        int lineNumber = 0;
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            ++lineNumber;
            if (line.startsWith(">")) {
                Header fastaHeader;
                if (sequenceBuilder.length() != 0 && accession != null) {
                    String sequence = SequenceFactory.importSequenceFromFasta(sequenceBuilder);
                    char[] aaSequence = sequence.toCharArray();
                    try {
                        SequenceFactory.validateSequence(aaSequence);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("An error occurred while parsing the sequence of " + accession + " at line " + lineNumber + ": " + e.toString());
                    }
                    for (char aa : aaSequence) {
                        int aaIndex;
                        if (!AminoAcid.isUniqueAa(aa)) continue;
                        int n = aaIndex = aa - 65;
                        aaOccurrence[n] = aaOccurrence[n] + 1;
                        if (++nAAs != 1000000) continue;
                        aaOccurrenceList.add(aaOccurrence);
                        aaOccurrence = new int[26];
                        nAAs = 0;
                    }
                }
                if ((accession = (fastaHeader = Header.parseFromFASTA(line)).getAccessionOrRest()) == null) {
                    throw new IllegalArgumentException("No accession found for header at line " + lineNumber + ".");
                }
                if (accession.lastIndexOf("'") != -1 || accession.lastIndexOf("\"") != -1) {
                    throw new IllegalArgumentException("Accession numbers cannot contain quotation marks: '" + accession + "'!\nPlease check your FASTA file.");
                }
                if (indexes.containsKey(accession)) {
                    throw new IllegalArgumentException("Non unique accession number found '" + accession + "'!\nPlease check your FASTA file.");
                }
                indexes.put(accession, index);
                if (decoyTag == null) {
                    decoyTag = SequenceFactory.getDecoyFlag(accession);
                }
                if (decoyTag == null || !SequenceFactory.isDecoy(accession, decoyTag)) {
                    Integer occurrence;
                    ++nTarget;
                    Header.DatabaseType tempDatabaseType = fastaHeader.getDatabaseType();
                    Integer typeCounter = (Integer)databaseTypes.get((Object)tempDatabaseType);
                    if (typeCounter == null) {
                        databaseTypes.put(tempDatabaseType, 1);
                    } else {
                        databaseTypes.put(tempDatabaseType, typeCounter + 1);
                    }
                    String taxonomy = fastaHeader.getTaxonomy();
                    if (taxonomy == null || taxonomy.equals("")) {
                        taxonomy = "Unknown";
                    }
                    if ((occurrence = (Integer)species.get(taxonomy)) == null) {
                        species.put(taxonomy, 1);
                    } else {
                        species.put(taxonomy, occurrence + 1);
                    }
                } else {
                    decoyAccessions.add(accession);
                    if (!decoy) {
                        decoy = true;
                        if (accession.endsWith(SequenceFactory.getDefaultDecoyAccessionSuffix())) {
                            defaultReversed = true;
                        }
                    }
                }
                if (waitingHandler != null && progressUnit != 0L) {
                    waitingHandler.setSecondaryProgressCounter((int)(index / progressUnit));
                    if (waitingHandler.isRunCanceled()) break;
                }
                index = bufferedRandomAccessFile.getFilePointer();
                sequenceBuilder = new StringBuilder();
                continue;
            }
            index = bufferedRandomAccessFile.getFilePointer();
            sequenceBuilder.append(line.trim());
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        bufferedRandomAccessFile.close();
        long lastModified = fastaFile.lastModified();
        if (version == null) {
            version = FastaIndex.getDefaultVersion(lastModified);
        }
        String fileName = fastaFile.getName();
        if (name == null) {
            name = Util.removeExtension(fileName);
        }
        Header.DatabaseType mainDatabaseType = null;
        int maxCounter = 0;
        for (Header.DatabaseType tempDatabaseType : databaseTypes.keySet()) {
            if ((Integer)databaseTypes.get((Object)tempDatabaseType) <= maxCounter) continue;
            maxCounter = (Integer)databaseTypes.get((Object)tempDatabaseType);
            mainDatabaseType = tempDatabaseType;
        }
        double scaling = (double)nAAs / 1000000.0;
        scaling += (double)aaOccurrenceList.size();
        double[] aaOccurrenceSummary = new double[aaOccurrence.length];
        for (int[] aaOccurrenceTemp : aaOccurrenceList) {
            for (int i = 0; i < aaOccurrenceTemp.length; ++i) {
                int n = i;
                aaOccurrenceSummary[n] = aaOccurrenceSummary[n] + (double)aaOccurrenceTemp[i] / scaling;
            }
        }
        for (int i = 0; i < aaOccurrence.length; ++i) {
            aaOccurrence[i] = (int)((double)aaOccurrence[i] / scaling + aaOccurrenceSummary[i]);
        }
        return new FastaIndex(indexes, decoyAccessions, fileName, name, decoy, defaultReversed, nTarget, lastModified, mainDatabaseType, databaseTypes, decoyTag, version, species, aaOccurrence);
    }

    public static void writeIndex(FastaIndex fastaIndex, File directory) throws IOException {
        File destinationFile = new File(directory, SequenceFactory.getIndexName(fastaIndex.getFileName()));
        SerializationUtils.writeObject(fastaIndex, destinationFile);
    }

    public static String getIndexName(String fastaName) {
        return fastaName + ".cui";
    }

    public void saveIndex() throws IOException {
        SequenceFactory.writeIndex(this.fastaIndex, this.currentFastaFile.getParentFile());
    }

    public void closeFile() throws IOException, SQLException, InterruptedException {
        if (this.currentRandomAccessFile != null) {
            this.currentRandomAccessFile.close();
            this.currentFastaFile = null;
        }
        if (this.defaultPeptideMapper != null) {
            this.defaultPeptideMapper.close();
        }
    }

    public static boolean isDecoy(String proteinAccession, String decoyFlag) {
        if (decoyFlag == null || decoyFlag.isEmpty()) {
            return false;
        }
        String start = decoyFlag + ".*";
        String end = ".*" + decoyFlag;
        return proteinAccession.matches(start) || proteinAccession.matches(end);
    }

    private static String getDecoyFlag(String proteinAccession) {
        for (String flag : DECOY_FLAGS) {
            if (!SequenceFactory.isDecoy(proteinAccession, flag)) continue;
            return flag;
        }
        return null;
    }

    public boolean isDecoyAccession(String proteinAccession) {
        return this.fastaIndex.isDecoy(proteinAccession);
    }

    public boolean concatenatedTargetDecoy() {
        return this.fastaIndex.isConcatenatedTargetDecoy();
    }

    public boolean isDefaultReversed() {
        return this.fastaIndex.isDefaultReversed();
    }

    public int getNTargetSequences() {
        return this.fastaIndex.getNTarget();
    }

    public int getNSequences() {
        return this.fastaIndex.getNSequences();
    }

    public void appendDecoySequences(File destinationFile) throws IOException, InterruptedException, ClassNotFoundException {
        this.appendDecoySequences(destinationFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendDecoySequences(File destinationFile, WaitingHandler waitingHandler) throws IOException, InterruptedException, ClassNotFoundException {
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(this.fastaIndex.getNTarget());
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(destinationFile));
        String lineBreak = System.getProperty("line.separator");
        try {
            ProteinIterator proteinIterator = this.getProteinIterator(true);
            while (proteinIterator.hasNext()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                    break;
                }
                if (waitingHandler != null) {
                    waitingHandler.increaseSecondaryProgressCounter();
                }
                Protein currentProtein = proteinIterator.getNextProtein();
                String accession = currentProtein.getAccession();
                Header currentHeader = this.getHeader(accession);
                String decoyAccession = SequenceFactory.getDefaultDecoyAccession(currentProtein.getAccession());
                String currentRawHeader = currentHeader.getRawHeader();
                String escapedString = Pattern.quote(accession);
                currentRawHeader = currentRawHeader.replaceAll(escapedString, decoyAccession);
                if (currentHeader.getDescription() != null && !currentHeader.getDescription().isEmpty()) {
                    escapedString = Pattern.quote(currentHeader.getDescription());
                    currentRawHeader = currentRawHeader.replaceAll(escapedString, SequenceFactory.getDefaultDecoyDescription(currentHeader.getDescription()));
                }
                bufferedWriter.write(currentHeader.getRawHeader() + lineBreak);
                bufferedWriter.write(currentProtein.getSequence() + lineBreak);
                bufferedWriter.write(currentRawHeader + lineBreak);
                bufferedWriter.write(SequenceFactory.reverseSequence(currentProtein.getSequence()) + lineBreak);
            }
        }
        finally {
            bufferedWriter.close();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        boolean indexFile = true;
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            indexFile = false;
        }
        if (indexFile) {
            this.loadFastaFile(destinationFile, waitingHandler);
        } else {
            destinationFile.delete();
        }
    }

    public static String reverseSequence(String sequence) {
        return new StringBuilder(sequence).reverse().toString();
    }

    public Set<String> getAccessions() {
        Set<String> setToFill = new HashSet<String>();
        if (this.fastaIndex != null) {
            setToFill = this.fastaIndex.getIndexes().keySet();
        }
        return setToFill;
    }

    public int getnCache() {
        return this.nCache;
    }

    public void setnCache(int nCache) {
        this.nCache = nCache;
    }

    public HashMap<String, Long> getAAOccurrences(JProgressBar progressBar) throws IOException, InterruptedException, ClassNotFoundException {
        HashMap<String, Long> aaMap = new HashMap<String, Long>(26);
        Set<String> accessions = this.getAccessions();
        if (progressBar != null) {
            progressBar.setIndeterminate(false);
            progressBar.setMaximum(accessions.size());
            progressBar.setValue(0);
        }
        for (String accession : accessions) {
            if (!this.isDecoyAccession(accession)) {
                Protein protein = this.getProtein(accession);
                for (String aa : protein.getSequence().split("")) {
                    Long n = aaMap.get(aa);
                    if (n == null) {
                        n = 0L;
                    }
                    aaMap.put(aa, n + 1L);
                }
            }
            if (progressBar == null) continue;
            progressBar.setValue(progressBar.getValue() + 1);
        }
        if (progressBar != null) {
            progressBar.setIndeterminate(true);
        }
        return aaMap;
    }

    public double computeMolecularWeight(String accession) throws IOException, InterruptedException, ClassNotFoundException {
        Double molecularWeight;
        if (this.isDefaultReversed() && this.isDecoyAccession(accession)) {
            try {
                return this.computeMolecularWeight(SequenceFactory.getDefaultTargetAccession(accession));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((molecularWeight = this.molecularWeights.get(accession)) == null) {
            Protein protein = this.getProtein(accession);
            molecularWeight = protein.computeMolecularWeight() / 1000.0;
            this.molecularWeights.put(accession, molecularWeight);
        }
        return molecularWeight;
    }

    public String getFileName() {
        if (this.fastaIndex == null) {
            return null;
        }
        return this.fastaIndex.getFileName();
    }

    public File getCurrentFastaFile() {
        return this.currentFastaFile;
    }

    public static String getDefaultDecoyAccessionSuffix() {
        return "_" + DECOY_FLAGS[0];
    }

    public static String getDefaultDecoyAccession(String targetAccession) {
        return targetAccession + SequenceFactory.getDefaultDecoyAccessionSuffix();
    }

    public static String getDefaultDecoyDescription(String targetDescription) {
        return targetDescription + "-" + DECOY_FLAGS[0];
    }

    public static String getDefaultTargetAccession(String decoyAccession) {
        return decoyAccession.substring(0, decoyAccession.length() - SequenceFactory.getDefaultDecoyAccessionSuffix().length());
    }

    public FastaIndex getCurrentFastaIndex() {
        return this.fastaIndex;
    }

    public PeptideMapper getDefaultPeptideMapper() {
        return this.defaultPeptideMapper;
    }

    public PeptideMapper getDefaultPeptideMapper(SequenceMatchingPreferences sequenceMatchingPreferences, SearchParameters searchParameters, PeptideVariantsPreferences peptideVariantsPreferences, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        int nThreads = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        return this.getDefaultPeptideMapper(sequenceMatchingPreferences, searchParameters, peptideVariantsPreferences, waitingHandler, exceptionHandler, true, nThreads);
    }

    public PeptideMapper getDefaultPeptideMapper(WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads, IdentificationParameters identificationParameters) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        return this.getDefaultPeptideMapper(identificationParameters.getSequenceMatchingPreferences(), identificationParameters.getSearchParameters(), identificationParameters.getPeptideVariantsPreferences(), waitingHandler, exceptionHandler, true, nThreads);
    }

    public synchronized PeptideMapper getDefaultPeptideMapper(SequenceMatchingPreferences sequenceMatchingPreferences, SearchParameters searchParameters, PeptideVariantsPreferences peptideVariantsPreferences, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, boolean displayProgress, int nThreads) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        if (this.defaultPeptideMapper == null) {
            PeptideMapperType peptideMapperType = sequenceMatchingPreferences.getPeptideMapperType();
            switch (peptideMapperType) {
                case fm_index: {
                    this.defaultPeptideMapper = new FMIndex(waitingHandler, displayProgress, peptideVariantsPreferences, searchParameters);
                    break;
                }
                case tree: {
                    UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
                    int memoryPreference = userPreferences.getMemoryPreference();
                    int memoryAllocated = 3 * memoryPreference / 4;
                    int cacheSize = 250000;
                    if (memoryPreference < 2500) {
                        cacheSize = 5000;
                    } else if (memoryPreference < 10000) {
                        cacheSize = 25000;
                    }
                    ProteinTree defaultProteinTree = new ProteinTree(memoryAllocated, cacheSize);
                    int tagLength = 3;
                    defaultProteinTree.initiateTree(tagLength, 50, 50, waitingHandler, exceptionHandler, true, displayProgress, nThreads);
                    this.emptyCache();
                    int treeSize = memoryPreference / 4;
                    defaultProteinTree.setMemoryAllocation(treeSize);
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                        defaultProteinTree.deleteDb();
                    }
                    this.defaultPeptideMapper = defaultProteinTree;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Peptide mapper type " + (Object)((Object)peptideMapperType) + " not supported.");
                }
            }
        }
        return this.defaultPeptideMapper;
    }

    public HeaderIterator getHeaderIterator(boolean targetOnly) throws FileNotFoundException {
        return new HeaderIterator(this.currentFastaFile, targetOnly);
    }

    public ProteinIterator getProteinIterator(boolean targetOnly) throws FileNotFoundException {
        return new ProteinIterator(this.currentFastaFile, targetOnly);
    }

    public boolean isDecoyInMemory() {
        return this.decoyInMemory;
    }

    public void setDecoyInMemory(boolean decoyInMemory) {
        this.decoyInMemory = decoyInMemory;
    }

    public class ProteinIterator {
        private Header nextHeader = null;
        private Protein nextProtein = null;
        private final Semaphore nextProteinMutex = new Semaphore(1);
        private final Semaphore readerMutex = new Semaphore(1);
        private final BufferedReader br;
        private final boolean targetOnly;

        public ProteinIterator(File file, boolean targetOnly) throws FileNotFoundException {
            this.targetOnly = targetOnly;
            this.br = new BufferedReader(new FileReader(file));
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean hasNext() throws IOException, InterruptedException {
            this.readerMutex.acquire();
            String line = this.br.readLine();
            if (line == null) {
                this.readerMutex.release();
                return false;
            }
            StringBuilder sequence = new StringBuilder();
            Header header = this.nextHeader;
            boolean newHeaderFound = false;
            while (line != null) {
                block8: {
                    if (line.startsWith(">")) {
                        Header tempHeader = Header.parseFromFASTA(line);
                        String accession = tempHeader.getAccessionOrRest();
                        if (this.targetOnly && SequenceFactory.this.isDecoyAccession(accession)) {
                            while ((line = this.br.readLine()) != null && (!line.startsWith(">") || SequenceFactory.this.isDecoyAccession((tempHeader = Header.parseFromFASTA(line)).getAccessionOrRest()))) {
                            }
                            if (line == null) break;
                        }
                        if (header == null) {
                            header = tempHeader;
                            break block8;
                        } else {
                            this.nextHeader = tempHeader;
                            newHeaderFound = true;
                            break;
                        }
                    }
                    sequence.append(line.trim());
                }
                line = this.br.readLine();
            }
            this.readerMutex.release();
            if (!newHeaderFound && line != null) {
                this.close();
                return false;
            }
            String accession = header.getAccessionOrRest();
            Header.DatabaseType databaseType = header.getDatabaseType();
            String cleanedSequence = SequenceFactory.importSequenceFromFasta(sequence);
            boolean decoy = SequenceFactory.this.isDecoyAccession(accession);
            this.nextProteinMutex.acquire();
            this.nextProtein = new Protein(accession, databaseType, cleanedSequence, decoy);
            return true;
        }

        public Protein getNextProtein() {
            Protein result = this.nextProtein;
            this.nextProteinMutex.release();
            return result;
        }

        public void close() throws IOException {
            this.br.close();
        }
    }

    public class HeaderIterator {
        private Header nextHeader = null;
        private final Semaphore nextHeaderMutex = new Semaphore(1);
        private final Semaphore readerMutex = new Semaphore(1);
        private BufferedReader br;
        private final boolean targetOnly;

        public HeaderIterator(File file, boolean targetOnly) throws FileNotFoundException {
            this.targetOnly = targetOnly;
            this.br = new BufferedReader(new FileReader(file));
        }

        public boolean hasNext() throws IOException, InterruptedException {
            String line;
            this.readerMutex.acquire();
            Header threadNextHeader = null;
            while ((line = this.br.readLine()) != null) {
                if ((line = line.trim()).equals("") || !line.startsWith(">")) continue;
                threadNextHeader = Header.parseFromFASTA(line);
                if (!this.targetOnly || !SequenceFactory.this.isDecoyAccession(threadNextHeader.getAccession())) break;
                threadNextHeader = null;
            }
            this.readerMutex.release();
            if (threadNextHeader != null) {
                this.nextHeaderMutex.acquire();
                this.nextHeader = threadNextHeader;
                return true;
            }
            this.close();
            return false;
        }

        public Header getNext() {
            Header result = this.nextHeader;
            this.nextHeaderMutex.release();
            return result;
        }

        public void close() throws IOException {
            this.br.close();
        }
    }
}

