/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion.iterators;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.protein_sequences.AmbiguousSequenceIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.PeptideWithPosition;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;
import com.compomics.util.general.BoxedObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class SpecificSingleEnzymeCombinationIterator
implements SequenceIterator {
    private ProteinIteratorUtils proteinIteratorUtils;
    private String proteinSequence;
    private char[] proteinSequenceAsCharArray;
    private double massMin;
    private double massMax;
    private Enzyme enzyme;
    private int nMissedCleavages;
    private HashMap<Integer, Integer> peptideStartMap;
    private HashMap<String, Integer> ambiguousPeptidesStartMap;
    private HashMap<String, Integer> ambiguousPeptidesMC;
    private HashMap<String, Integer> ambiguousPeptidesXs;
    private String[] ambiguousPeptides;
    private AmbiguousSequenceIterator ambiguousSequenceIterator = null;
    private int sequenceIndex = 0;
    private ArrayList<PeptideWithPosition> result;
    private int resultIndex = -1;
    private int ambiguousPeptidesIndex = 0;

    public SpecificSingleEnzymeCombinationIterator(ProteinIteratorUtils proteinIteratorUtils, String proteinSequence, Enzyme enzyme, int nMissedCleavages, double massMin, double massMax) {
        this.proteinIteratorUtils = proteinIteratorUtils;
        this.proteinSequence = proteinSequence;
        this.proteinSequenceAsCharArray = proteinSequence.toCharArray();
        this.enzyme = enzyme;
        this.nMissedCleavages = nMissedCleavages;
        this.massMin = massMin;
        this.massMax = massMax;
        this.peptideStartMap = new HashMap(nMissedCleavages + 1);
        this.result = new ArrayList(nMissedCleavages + 1);
        this.ambiguousPeptidesStartMap = new HashMap(nMissedCleavages + 1);
        this.ambiguousPeptidesMC = new HashMap(nMissedCleavages + 1);
        this.ambiguousPeptidesXs = new HashMap(nMissedCleavages + 1);
        this.ambiguousPeptides = new String[0];
    }

    @Override
    public PeptideWithPosition getNextPeptide() throws InterruptedException {
        ++this.resultIndex;
        if (this.resultIndex < this.result.size()) {
            return this.result.get(this.resultIndex);
        }
        if (this.ambiguousSequenceIterator != null) {
            char[] newSequence = this.ambiguousSequenceIterator.getNextSequence();
            if (newSequence == null) {
                this.ambiguousSequenceIterator = null;
                return this.getNextPeptide();
            }
            int peptidesMissedCleavages = 0;
            for (int i = 1; i < newSequence.length; ++i) {
                char aaBefore = newSequence[i - 1];
                char aaAfter = newSequence[i];
                if (!this.enzyme.isCleavageSiteNoCombination(Character.valueOf(aaBefore), Character.valueOf(aaAfter)) || ++peptidesMissedCleavages <= this.nMissedCleavages) continue;
                return this.getNextPeptide();
            }
            String ambiguousSequence = this.ambiguousPeptides[this.ambiguousPeptidesIndex - 1];
            int startIndex = this.ambiguousPeptidesStartMap.get(ambiguousSequence);
            Peptide peptide = this.proteinIteratorUtils.getPeptideFromProtein(newSequence, this.proteinSequence, startIndex, this.massMin, this.massMax);
            if (peptide != null && peptide.getMass() >= this.massMin && peptide.getMass() <= this.massMax) {
                return new PeptideWithPosition(peptide, startIndex);
            }
            return this.getNextPeptide();
        }
        if (this.ambiguousPeptidesIndex < this.ambiguousPeptides.length) {
            String ambiguousSequence = this.ambiguousPeptides[this.ambiguousPeptidesIndex];
            this.ambiguousSequenceIterator = new AmbiguousSequenceIterator(ambiguousSequence, this.proteinIteratorUtils.getMaxXsInSequence());
            ++this.ambiguousPeptidesIndex;
            return this.getNextPeptide();
        }
        if (this.sequenceIndex == this.proteinSequenceAsCharArray.length) {
            return null;
        }
        this.iterateSequence();
        return this.getNextPeptide();
    }

    private void iterateSequence() throws InterruptedException {
        char aaBefore;
        char aaAfter;
        AminoAcid aminoAcidAfter;
        int initialIndex = this.sequenceIndex;
        ArrayList<Character> firstAaCombination = new ArrayList<Character>(1);
        if (this.sequenceIndex > 0 && (aminoAcidAfter = AminoAcid.getAminoAcid(aaAfter = this.proteinSequenceAsCharArray[this.sequenceIndex])).iscombination()) {
            aaBefore = this.proteinSequenceAsCharArray[this.sequenceIndex - 1];
            AminoAcid aminoAcidBefore = AminoAcid.getAminoAcid(aaBefore);
            for (char aaBeforeTemp : aminoAcidBefore.getSubAminoAcids(false)) {
                char[] cArray = aminoAcidAfter.getSubAminoAcids(false);
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    char aaAfterTemp = cArray[i];
                    if (!this.enzyme.isCleavageSiteNoCombination(Character.valueOf(aaBeforeTemp), Character.valueOf(aaAfterTemp))) continue;
                    firstAaCombination.add(Character.valueOf(aaAfterTemp));
                }
            }
        }
        if (firstAaCombination.isEmpty()) {
            firstAaCombination.add(Character.valueOf(this.proteinSequenceAsCharArray[this.sequenceIndex]));
        }
        ArrayList<Character> lastAaCombination = new ArrayList<Character>(1);
        int nX = 0;
        while (++this.sequenceIndex < this.proteinSequenceAsCharArray.length) {
            aaBefore = this.proteinSequenceAsCharArray[this.sequenceIndex - 1];
            if (aaBefore == 'X') {
                ++nX;
            }
            char aaAfter2 = this.proteinSequenceAsCharArray[this.sequenceIndex];
            if (this.enzyme.isCleavageSiteNoCombination(Character.valueOf(aaBefore), Character.valueOf(aaAfter2))) break;
            AminoAcid aminoAcidBefore = AminoAcid.getAminoAcid(aaBefore);
            AminoAcid aminoAcidAfter2 = AminoAcid.getAminoAcid(aaAfter2);
            if (!aminoAcidBefore.iscombination() && !aminoAcidAfter2.iscombination()) continue;
            boolean cleavage = false;
            for (char aaBeforeTemp : aminoAcidBefore.getSubAminoAcids(false)) {
                for (char aaAfterTemp : aminoAcidAfter2.getSubAminoAcids(false)) {
                    if (!this.enzyme.isCleavageSiteNoCombination(Character.valueOf(aaBeforeTemp), Character.valueOf(aaAfterTemp))) continue;
                    if (aminoAcidBefore.iscombination()) {
                        lastAaCombination.add(Character.valueOf(aaBeforeTemp));
                    }
                    cleavage = true;
                }
            }
            if (!cleavage) continue;
            break;
        }
        if (lastAaCombination.isEmpty()) {
            lastAaCombination.add(Character.valueOf(this.proteinSequenceAsCharArray[this.sequenceIndex - 1]));
        }
        this.result.clear();
        HashMap<String, Integer> newAmbiguousPeptidesStartMap = new HashMap<String, Integer>(this.ambiguousPeptidesStartMap.size());
        HashMap<String, Integer> newambiguousPeptidesMC = new HashMap<String, Integer>(this.ambiguousPeptidesMC.size());
        HashMap<String, Integer> newambiguousPeptidesXs = new HashMap<String, Integer>(this.ambiguousPeptidesXs.size());
        HashMap<Integer, Integer> newPeptideStartMap = new HashMap<Integer, Integer>(this.peptideStartMap.size());
        char[] newSequence = Arrays.copyOfRange(this.proteinSequenceAsCharArray, initialIndex, this.sequenceIndex);
        Iterator aaBeforeTemp = firstAaCombination.iterator();
        while (aaBeforeTemp.hasNext()) {
            char firstAa;
            newSequence[0] = firstAa = ((Character)aaBeforeTemp.next()).charValue();
            Iterator iterator = lastAaCombination.iterator();
            while (iterator.hasNext()) {
                Iterator<Object> iterator2;
                char lastAa;
                newSequence[newSequence.length - 1] = lastAa = ((Character)iterator.next()).charValue();
                BoxedObject<Boolean> smallMass = new BoxedObject<Boolean>(Boolean.TRUE);
                if (!AminoAcidSequence.hasCombination(newSequence)) {
                    Peptide peptide = this.proteinIteratorUtils.getPeptideFromProtein(newSequence, this.proteinSequence, initialIndex, this.massMin, this.massMax, smallMass);
                    if (peptide != null && peptide.getMass() >= this.massMin && peptide.getMass() <= this.massMax) {
                        this.result.add(new PeptideWithPosition(peptide, initialIndex));
                    }
                } else if (nX <= this.proteinIteratorUtils.getMaxXsInSequence()) {
                    smallMass.setObject(AminoAcidSequence.getMinMass(newSequence) <= this.massMax);
                    if (smallMass.getObject().booleanValue()) {
                        String newSequenceAsString = new String(newSequence);
                        newAmbiguousPeptidesStartMap.put(newSequenceAsString, initialIndex);
                        newambiguousPeptidesMC.put(newSequenceAsString, 0);
                        newambiguousPeptidesXs.put(newSequenceAsString, nX);
                    }
                }
                if (this.nMissedCleavages <= 0 || !smallMass.getObject().booleanValue()) continue;
                if (!AminoAcidSequence.hasCombination(newSequence)) {
                    newPeptideStartMap.put(initialIndex, 0);
                    iterator2 = this.peptideStartMap.keySet().iterator();
                    while (iterator2.hasNext()) {
                        int peptideStart = (Integer)iterator2.next();
                        newSequence = Arrays.copyOfRange(this.proteinSequenceAsCharArray, peptideStart, this.sequenceIndex);
                        smallMass.setObject(Boolean.TRUE);
                        Peptide peptide = this.proteinIteratorUtils.getPeptideFromProtein(newSequence, this.proteinSequence, peptideStart, this.massMin, this.massMax, smallMass);
                        if (peptide != null && peptide.getMass() >= this.massMin && peptide.getMass() <= this.massMax) {
                            this.result.add(new PeptideWithPosition(peptide, initialIndex));
                        }
                        int peptideMissedCleavages = this.peptideStartMap.get(peptideStart);
                        if (!smallMass.getObject().booleanValue() || peptideMissedCleavages >= this.nMissedCleavages) continue;
                        newPeptideStartMap.put(peptideStart, peptideMissedCleavages + 1);
                    }
                } else {
                    iterator2 = this.peptideStartMap.keySet().iterator();
                    while (iterator2.hasNext()) {
                        int peptideStart = iterator2.next();
                        int peptideMissedCleavages = this.peptideStartMap.get(peptideStart);
                        if (peptideMissedCleavages >= this.nMissedCleavages) continue;
                        char[] previousSequence = Arrays.copyOfRange(this.proteinSequenceAsCharArray, peptideStart, initialIndex);
                        char[] misCleavedSequence = Util.mergeCharArrays(previousSequence, newSequence);
                        String newSequenceAsString = new String(misCleavedSequence);
                        newAmbiguousPeptidesStartMap.put(newSequenceAsString, peptideStart);
                        newambiguousPeptidesMC.put(newSequenceAsString, peptideMissedCleavages + 1);
                        newambiguousPeptidesXs.put(newSequenceAsString, nX);
                    }
                }
                for (String previousSequence : this.ambiguousPeptidesStartMap.keySet()) {
                    int previousNX;
                    int newNX;
                    int peptideMissedCleavages = this.ambiguousPeptidesMC.get(previousSequence);
                    if (peptideMissedCleavages >= this.nMissedCleavages || (newNX = (previousNX = this.ambiguousPeptidesXs.get(previousSequence).intValue()) + nX) >= this.proteinIteratorUtils.getMaxXsInSequence()) continue;
                    int peptideStart = this.ambiguousPeptidesStartMap.get(previousSequence);
                    StringBuilder misCleavedSequenceBuilder = new StringBuilder(previousSequence.length() + newSequence.length);
                    misCleavedSequenceBuilder.append(previousSequence);
                    misCleavedSequenceBuilder.append(newSequence);
                    String misCleavedSequence = misCleavedSequenceBuilder.toString();
                    newAmbiguousPeptidesStartMap.put(misCleavedSequence, peptideStart);
                    newambiguousPeptidesMC.put(misCleavedSequence, peptideMissedCleavages + 1);
                    newambiguousPeptidesXs.put(misCleavedSequence, newNX);
                }
            }
        }
        this.peptideStartMap = newPeptideStartMap;
        this.ambiguousPeptidesStartMap = newAmbiguousPeptidesStartMap;
        this.ambiguousPeptidesMC = newambiguousPeptidesMC;
        this.ambiguousPeptidesXs = newambiguousPeptidesXs;
        this.ambiguousPeptides = new String[this.ambiguousPeptidesStartMap.size()];
        int count = 0;
        Iterator<String> iterator = this.ambiguousPeptidesStartMap.keySet().iterator();
        while (iterator.hasNext()) {
            String sequence;
            this.ambiguousPeptides[count] = sequence = iterator.next();
            ++count;
        }
        this.resultIndex = -1;
        this.ambiguousPeptidesIndex = 0;
    }
}

