/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion.iterators;

import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.protein_sequences.AmbiguousSequenceIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.PeptideWithPosition;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;
import com.compomics.util.general.BoxedObject;
import java.util.Arrays;

public class UnspecificCombinationIterator
implements SequenceIterator {
    private ProteinIteratorUtils proteinIteratorUtils;
    private String proteinSequence;
    private char[] proteinSequenceAsCharArray;
    private Double massMin;
    private Double massMax;
    private int index1 = 0;
    private int index2 = 0;
    AmbiguousSequenceIterator ambiguousSequenceIterator = null;

    public UnspecificCombinationIterator(ProteinIteratorUtils proteinIteratorUtils, String proteinSequence, Double massMin, Double massMax) {
        this.proteinIteratorUtils = proteinIteratorUtils;
        this.proteinSequence = proteinSequence;
        this.proteinSequenceAsCharArray = proteinSequence.toCharArray();
        this.massMin = massMin;
        this.massMax = massMax;
    }

    @Override
    public PeptideWithPosition getNextPeptide() throws InterruptedException {
        if (this.ambiguousSequenceIterator != null) {
            char[] sequence = this.ambiguousSequenceIterator.getNextSequence();
            if (sequence == null) {
                this.ambiguousSequenceIterator = null;
                return this.getNextPeptide();
            }
            Peptide peptide = this.proteinIteratorUtils.getPeptideFromProtein(sequence, this.proteinSequence, this.index1, this.massMin, this.massMax);
            if (peptide != null && (this.massMin == null || peptide.getMass() >= this.massMin) && (this.massMax == null || peptide.getMass() <= this.massMax)) {
                return new PeptideWithPosition(peptide, this.index1);
            }
            return this.getNextPeptide();
        }
        if (!this.increaseIndex()) {
            return null;
        }
        char[] sequence = Arrays.copyOfRange(this.proteinSequenceAsCharArray, this.index1, this.index2);
        if (AminoAcidSequence.hasCombination(sequence)) {
            this.ambiguousSequenceIterator = new AmbiguousSequenceIterator(sequence, this.proteinIteratorUtils.getMaxXsInSequence());
            return this.getNextPeptide();
        }
        BoxedObject<Boolean> smallMass = new BoxedObject<Boolean>(Boolean.TRUE);
        Peptide peptide = this.proteinIteratorUtils.getPeptideFromProtein(sequence, this.proteinSequence, this.index1, this.massMin, this.massMax, smallMass);
        if (!smallMass.getObject().booleanValue()) {
            ++this.index1;
            if (this.index1 == this.proteinSequenceAsCharArray.length) {
                return null;
            }
            this.index2 = this.index1;
        }
        if (peptide != null && (this.massMin == null || peptide.getMass() >= this.massMin) && (this.massMax == null || peptide.getMass() <= this.massMax)) {
            return new PeptideWithPosition(peptide, this.index1);
        }
        return this.getNextPeptide();
    }

    private boolean increaseIndex() {
        ++this.index2;
        if (this.index2 == this.proteinSequenceAsCharArray.length + 1) {
            ++this.index1;
            if (this.index1 == this.proteinSequenceAsCharArray.length) {
                return false;
            }
            this.index2 = this.index1 + 1;
        }
        return true;
    }
}

