/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.math.BasicMathFunctions;
import java.util.ArrayList;
import org.apache.commons.math.MathException;

public class MS2MzFidelityScore {
    public double getScore(Peptide peptide, MSnSpectrum spectrum, AnnotationSettings annotationPreferences, SpecificAnnotationSettings specificAnnotationPreferences, PeptideSpectrumAnnotator peptideSpectrumAnnotator) throws InterruptedException, MathException {
        ArrayList<IonMatch> matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationPreferences, specificAnnotationPreferences, spectrum, peptide);
        ArrayList<Double> mzDeviations = new ArrayList<Double>(matches.size());
        for (IonMatch ionMatch : matches) {
            double mzError = ionMatch.getAbsoluteError();
            mzDeviations.add(mzError);
        }
        if (mzDeviations.size() < 2) {
            return specificAnnotationPreferences.getFragmentIonAccuracyInDa(spectrum.getMaxMz());
        }
        double deviationUp = BasicMathFunctions.percentile(mzDeviations, 0.75);
        double deviationDown = BasicMathFunctions.percentile(mzDeviations, 0.25);
        return (deviationUp - deviationDown) / 2.0;
    }
}

