/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class AnnotationSettings
implements Serializable {
    static final long serialVersionUID = -3739182405876385430L;
    private boolean yAxisZoomExcludesBackgroundPeaks = true;
    private boolean showAllPeaks = false;
    private IntensityThresholdType intensityThresholdType = IntensityThresholdType.percentile;
    private double intensityLimit = 0.75;
    private boolean automaticAnnotation = true;
    private HashMap<Ion.IonType, HashSet<Integer>> selectedIonsMap = new HashMap(4);
    private ArrayList<NeutralLoss> neutralLossesList;
    private Boolean neutralLossesAuto = true;
    private Boolean reporterIons = true;
    private Boolean relatedIons = true;
    private double fragmentIonAccuracy;
    private Boolean fragmentIonPpm = false;
    private boolean showForwardIonDeNovoTags = false;
    private boolean showRewindIonDeNovoTags = false;
    private int deNovoCharge = 1;
    private Boolean highResolutionAnnotation = true;
    private SpectrumAnnotator.TiesResolution tiesResolution = SpectrumAnnotator.TiesResolution.mostAccurateMz;

    public AnnotationSettings() {
    }

    public SpecificAnnotationSettings getSpecificAnnotationPreferences(String spectrumKey, SpectrumIdentificationAssumption spectrumIdentificationAssumption, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        SpecificAnnotationSettings specificAnnotationPreferences = new SpecificAnnotationSettings(spectrumKey, spectrumIdentificationAssumption);
        specificAnnotationPreferences.setNeutralLossesAuto(this.neutralLossesAuto);
        if (this.neutralLossesAuto.booleanValue()) {
            specificAnnotationPreferences.setNeutralLossesMap(SpectrumAnnotator.getDefaultLosses(spectrumIdentificationAssumption, sequenceMatchingPreferences, ptmSequenceMatchingPreferences));
        } else {
            NeutralLossesMap tempNeutralLossesMap = new NeutralLossesMap();
            for (NeutralLoss neutralLoss : this.getNeutralLosses()) {
                tempNeutralLossesMap.addNeutralLoss(neutralLoss, (Integer)1, (Integer)1);
            }
            specificAnnotationPreferences.setNeutralLossesMap(tempNeutralLossesMap);
        }
        ArrayList<Integer> charges = new ArrayList<Integer>(4);
        int precursorCharge = spectrumIdentificationAssumption.getIdentificationCharge().value;
        if (precursorCharge == 1) {
            charges.add(precursorCharge);
        } else {
            for (int charge = 1; charge < precursorCharge; ++charge) {
                charges.add(charge);
            }
        }
        specificAnnotationPreferences.setSelectedCharges(charges);
        specificAnnotationPreferences.setSelectedIonsMap((HashMap)this.selectedIonsMap.clone());
        specificAnnotationPreferences.setFragmentIonAccuracy(this.fragmentIonAccuracy);
        specificAnnotationPreferences.setFragmentIonPpm(this.fragmentIonPpm);
        return specificAnnotationPreferences;
    }

    public AnnotationSettings(SearchParameters searchParameters) {
        this.setPreferencesFromSearchParameters(searchParameters);
    }

    public void setPreferencesFromSearchParameters(SearchParameters searchParameters) {
        this.clearIonTypes();
        for (Integer ion : searchParameters.getForwardIons()) {
            this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, ion);
            this.addIonType(Ion.IonType.TAG_FRAGMENT_ION, ion);
        }
        for (Integer ion : searchParameters.getRewindIons()) {
            this.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, ion);
            this.addIonType(Ion.IonType.TAG_FRAGMENT_ION, ion);
        }
        this.addIonType(Ion.IonType.PRECURSOR_ION);
        this.addIonType(Ion.IonType.IMMONIUM_ION);
        this.addIonType(Ion.IonType.REPORTER_ION);
        this.addIonType(Ion.IonType.RELATED_ION);
        this.setFragmentIonAccuracy(searchParameters.getFragmentIonAccuracy());
        this.setFragmentIonPpm(searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM);
        PtmSettings ptmSettings = searchParameters.getPtmSettings();
        if (this.getReporterIons().booleanValue()) {
            HashSet<Integer> ptmReporterIons = IonFactory.getReporterIons(ptmSettings);
            this.selectedIonsMap.put(Ion.IonType.REPORTER_ION, ptmReporterIons);
        }
        if (this.isAutomaticAnnotation() || this.areNeutralLossesSequenceAuto().booleanValue()) {
            ArrayList<NeutralLoss> neutralLosses = IonFactory.getNeutralLosses(searchParameters.getPtmSettings());
            for (NeutralLoss neutralLoss : neutralLosses) {
                this.addNeutralLoss(neutralLoss);
            }
        }
    }

    public Boolean areNeutralLossesSequenceAuto() {
        return this.neutralLossesAuto;
    }

    public void setNeutralLossesSequenceAuto(Boolean neutralLossesAuto) {
        this.neutralLossesAuto = neutralLossesAuto;
    }

    public Boolean getReporterIons() {
        if (this.reporterIons == null) {
            this.reporterIons = true;
        }
        return this.reporterIons;
    }

    public void setReporterIons(Boolean reporterIons) {
        this.reporterIons = reporterIons;
    }

    public Boolean getRelatedIons() {
        if (this.relatedIons == null) {
            this.relatedIons = true;
        }
        return this.relatedIons;
    }

    public void setRelatedIons(Boolean relatedIons) {
        this.relatedIons = relatedIons;
    }

    public void clearNeutralLosses() {
        this.neutralLossesList.clear();
    }

    public ArrayList<NeutralLoss> getNeutralLosses() {
        if (this.neutralLossesList == null) {
            this.neutralLossesList = new ArrayList(2);
        }
        return this.neutralLossesList;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        if (this.neutralLossesList == null) {
            this.neutralLossesList = new ArrayList(2);
        }
        boolean alreadyInList = false;
        for (NeutralLoss tempNeutralLoss : this.neutralLossesList) {
            if (!neutralLoss.isSameAs(tempNeutralLoss)) continue;
            alreadyInList = true;
            break;
        }
        if (!alreadyInList) {
            this.neutralLossesList.add(neutralLoss);
        }
    }

    public HashMap<Ion.IonType, HashSet<Integer>> getIonTypes() {
        return this.selectedIonsMap;
    }

    public HashSet<Integer> getFragmentIonTypes() {
        if (this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) == null) {
            return new HashSet<Integer>();
        }
        return this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION);
    }

    public void addIonType(Ion.IonType ionType, int subType) {
        HashSet<Integer> selectedSubtypes = this.selectedIonsMap.get((Object)ionType);
        if (selectedSubtypes == null) {
            selectedSubtypes = new HashSet(1);
            this.selectedIonsMap.put(ionType, selectedSubtypes);
        }
        selectedSubtypes.add(subType);
    }

    public void addIonType(Ion.IonType ionType) {
        ArrayList<Integer> possibleSubtypes = Ion.getPossibleSubtypes(ionType);
        HashSet<Integer> selectedSubtypes = this.selectedIonsMap.get((Object)ionType);
        if (selectedSubtypes == null) {
            selectedSubtypes = new HashSet<Integer>(possibleSubtypes);
            this.selectedIonsMap.put(ionType, selectedSubtypes);
        } else {
            selectedSubtypes.addAll(possibleSubtypes);
        }
    }

    public void clearIonTypes() {
        this.selectedIonsMap.clear();
    }

    public void setAutomaticAnnotation(boolean automaticAnnotation) {
        this.automaticAnnotation = automaticAnnotation;
        if (automaticAnnotation) {
            this.neutralLossesAuto = true;
        }
    }

    public boolean isAutomaticAnnotation() {
        return this.automaticAnnotation;
    }

    public double getFragmentIonAccuracy() {
        return this.fragmentIonAccuracy;
    }

    public double getFragmentIonAccuracyInDa(Double refMass) {
        if (this.fragmentIonPpm.booleanValue()) {
            return this.fragmentIonAccuracy * refMass / 1000000.0;
        }
        return this.fragmentIonAccuracy;
    }

    public void setFragmentIonAccuracy(double fragmentIonAccuracy) {
        this.fragmentIonAccuracy = fragmentIonAccuracy;
    }

    public boolean isFragmentIonPpm() {
        if (this.fragmentIonPpm == null) {
            this.fragmentIonPpm = false;
        }
        return this.fragmentIonPpm;
    }

    public void setFragmentIonPpm(boolean fragmentIonPpm) {
        this.fragmentIonPpm = fragmentIonPpm;
    }

    public double getAnnotationIntensityLimit() {
        return this.intensityLimit;
    }

    public void setIntensityLimit(double intensityLimit) {
        this.intensityLimit = intensityLimit;
    }

    public IntensityThresholdType getIntensityThresholdType() {
        if (this.intensityThresholdType == null) {
            this.intensityThresholdType = IntensityThresholdType.percentile;
        }
        return this.intensityThresholdType;
    }

    public void setIntensityThresholdType(IntensityThresholdType intensityThresholdType) {
        this.intensityThresholdType = intensityThresholdType;
    }

    public boolean showAllPeaks() {
        return this.showAllPeaks;
    }

    public void setShowAllPeaks(boolean showAllPeaks) {
        this.showAllPeaks = showAllPeaks;
    }

    public boolean yAxisZoomExcludesBackgroundPeaks() {
        return this.yAxisZoomExcludesBackgroundPeaks;
    }

    public void setYAxisZoomExcludesBackgroundPeaks(boolean yAxisZoomExcludesBackgroundPeaks) {
        this.yAxisZoomExcludesBackgroundPeaks = yAxisZoomExcludesBackgroundPeaks;
    }

    public boolean showForwardIonDeNovoTags() {
        return this.showForwardIonDeNovoTags;
    }

    public void setShowForwardIonDeNovoTags(boolean showForwardIonDeNovoTags) {
        this.showForwardIonDeNovoTags = showForwardIonDeNovoTags;
    }

    public boolean showRewindIonDeNovoTags() {
        return this.showRewindIonDeNovoTags;
    }

    public void setShowRewindIonDeNovoTags(boolean showRewindIonDeNovoTags) {
        this.showRewindIonDeNovoTags = showRewindIonDeNovoTags;
    }

    public int getDeNovoCharge() {
        return this.deNovoCharge;
    }

    public void setDeNovoCharge(int deNovoCharge) {
        this.deNovoCharge = deNovoCharge;
    }

    public boolean isHighResolutionAnnotation() {
        if (this.highResolutionAnnotation == null) {
            this.highResolutionAnnotation = true;
        }
        return this.highResolutionAnnotation;
    }

    public void setHighResolutionAnnotation(boolean highResolutionAnnotation) {
        this.highResolutionAnnotation = highResolutionAnnotation;
    }

    public SpectrumAnnotator.TiesResolution getTiesResolution() {
        if (this.tiesResolution == null) {
            this.tiesResolution = this.highResolutionAnnotation != false ? SpectrumAnnotator.TiesResolution.mostAccurateMz : SpectrumAnnotator.TiesResolution.mostIntense;
        }
        return this.tiesResolution;
    }

    public void setTiesResolution(SpectrumAnnotator.TiesResolution tiesResolution) {
        this.tiesResolution = tiesResolution;
    }

    public AnnotationSettings clone() {
        AnnotationSettings annotationSettings = new AnnotationSettings();
        annotationSettings.setYAxisZoomExcludesBackgroundPeaks(this.yAxisZoomExcludesBackgroundPeaks);
        annotationSettings.setShowAllPeaks(this.showAllPeaks);
        annotationSettings.setIntensityLimit(this.intensityLimit);
        annotationSettings.setAutomaticAnnotation(this.automaticAnnotation);
        annotationSettings.setFragmentIonAccuracy(this.fragmentIonAccuracy);
        annotationSettings.setFragmentIonPpm(this.fragmentIonPpm);
        annotationSettings.setShowForwardIonDeNovoTags(this.showForwardIonDeNovoTags);
        annotationSettings.setShowRewindIonDeNovoTags(this.showRewindIonDeNovoTags);
        annotationSettings.setDeNovoCharge(this.deNovoCharge);
        annotationSettings.setTiesResolution(this.getTiesResolution());
        annotationSettings.setNeutralLossesSequenceAuto(this.neutralLossesAuto);
        annotationSettings.setReporterIons(this.getReporterIons());
        annotationSettings.setReporterIons(this.getRelatedIons());
        for (NeutralLoss neutralLoss : this.neutralLossesList) {
            annotationSettings.addNeutralLoss(neutralLoss);
        }
        for (Ion.IonType ionType : this.selectedIonsMap.keySet()) {
            for (Integer subType : this.selectedIonsMap.get((Object)ionType)) {
                annotationSettings.addIonType(ionType, subType);
            }
        }
        return annotationSettings;
    }

    public boolean isSameAs(AnnotationSettings annotationSettings) {
        if (this.yAxisZoomExcludesBackgroundPeaks != annotationSettings.yAxisZoomExcludesBackgroundPeaks()) {
            return false;
        }
        if (this.showAllPeaks != annotationSettings.showAllPeaks()) {
            return false;
        }
        if (this.intensityThresholdType != annotationSettings.getIntensityThresholdType()) {
            return false;
        }
        if (this.intensityLimit != annotationSettings.getAnnotationIntensityLimit()) {
            return false;
        }
        if (this.automaticAnnotation != annotationSettings.isAutomaticAnnotation()) {
            return false;
        }
        if (this.fragmentIonAccuracy != annotationSettings.getFragmentIonAccuracy()) {
            return false;
        }
        if (this.fragmentIonPpm.booleanValue() != annotationSettings.isFragmentIonPpm()) {
            return false;
        }
        if (this.showForwardIonDeNovoTags != annotationSettings.showForwardIonDeNovoTags()) {
            return false;
        }
        if (this.showRewindIonDeNovoTags != annotationSettings.showRewindIonDeNovoTags()) {
            return false;
        }
        if (this.deNovoCharge != annotationSettings.getDeNovoCharge()) {
            return false;
        }
        if (this.getTiesResolution() != annotationSettings.getTiesResolution()) {
            return false;
        }
        if (!this.neutralLossesAuto.equals(annotationSettings.areNeutralLossesSequenceAuto())) {
            return false;
        }
        if (!this.getReporterIons().equals(annotationSettings.getReporterIons())) {
            return false;
        }
        if (!this.getRelatedIons().equals(annotationSettings.getRelatedIons())) {
            return false;
        }
        ArrayList<NeutralLoss> otherNeutralLosses = annotationSettings.getNeutralLosses();
        if (this.getNeutralLosses().size() != otherNeutralLosses.size()) {
            return false;
        }
        for (NeutralLoss neutralLoss1 : this.getNeutralLosses()) {
            boolean found = false;
            for (NeutralLoss neutralLoss2 : otherNeutralLosses) {
                if (!neutralLoss1.isSameAs(neutralLoss2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = annotationSettings.getIonTypes();
        if (ionTypes.size() != this.selectedIonsMap.size()) {
            return false;
        }
        for (Ion.IonType ionType : ionTypes.keySet()) {
            HashSet<Integer> thisSubIons = this.selectedIonsMap.get((Object)ionType);
            if (thisSubIons == null) {
                return false;
            }
            HashSet<Integer> otherSubIons = ionTypes.get((Object)ionType);
            if (thisSubIons.size() != otherSubIons.size()) {
                return false;
            }
            for (Integer subIon1 : thisSubIons) {
                boolean found = false;
                for (Integer subIon2 : otherSubIons) {
                    if (!subIon1.equals(subIon2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public String getShortDescription() {
        ArrayList<NeutralLoss> selectedNeutralLosses;
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        if (!this.selectedIonsMap.isEmpty()) {
            output.append("Ion Types: ");
            String ionTypes = "";
            block15: for (Ion.IonType ionType : this.selectedIonsMap.keySet()) {
                if (null == ionType) continue;
                switch (ionType) {
                    case IMMONIUM_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "immonium ions";
                        break;
                    }
                    case RELATED_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "related ions";
                        break;
                    }
                    case PEPTIDE_FRAGMENT_ION: {
                        for (int subType : this.selectedIonsMap.get((Object)ionType)) {
                            switch (subType) {
                                case 0: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "a ions";
                                    break;
                                }
                                case 1: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "b ions";
                                    break;
                                }
                                case 2: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "x ions";
                                    break;
                                }
                                case 3: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "x ions";
                                    break;
                                }
                                case 4: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "y ions";
                                    break;
                                }
                                case 5: {
                                    if (!ionTypes.isEmpty()) {
                                        ionTypes = ionTypes + ", ";
                                    }
                                    ionTypes = ionTypes + "z ions";
                                    break;
                                }
                            }
                        }
                        continue block15;
                    }
                    case PRECURSOR_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "precursor ions";
                        break;
                    }
                    case REPORTER_ION: {
                        if (!ionTypes.isEmpty()) {
                            ionTypes = ionTypes + ", ";
                        }
                        ionTypes = ionTypes + "reporter ions";
                        break;
                    }
                }
            }
            output.append(ionTypes).append(".").append(newLine);
        }
        if (!(selectedNeutralLosses = this.getNeutralLosses()).isEmpty()) {
            output.append("Neutral Losses: ");
            String neutralLosses = "";
            for (NeutralLoss selectedNeutralLoss : selectedNeutralLosses) {
                if (!neutralLosses.isEmpty()) {
                    neutralLosses = neutralLosses + ", ";
                }
                neutralLosses = neutralLosses + selectedNeutralLoss.name;
            }
            output.append(neutralLosses).append(".").append(newLine);
        }
        output.append("Intensity Threshold Type: ").append((Object)this.intensityThresholdType).append(".").append(newLine);
        output.append("Intensity Threshold: ").append(this.intensityLimit * 100.0).append(".").append(newLine);
        String unit = this.fragmentIonPpm != false ? "ppm" : "Da";
        output.append("Fragment Ion Accuracy: ").append(this.fragmentIonAccuracy).append(" ").append(unit).append(".").append(newLine);
        output.append("Best peak selection: ").append(this.tiesResolution.description).append(".").append(newLine);
        return output.toString();
    }

    public static enum IntensityThresholdType {
        percentile("Percentile of the intensities."),
        snp("Signal to noise probability.");

        public final String description;

        private IntensityThresholdType(String description) {
            this.description = description;
        }
    }
}

