/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.ElementaryElement;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.indexes.SpectrumIndex;
import java.util.ArrayList;
import java.util.HashSet;

public class PrecursorAnnotator {
    private final PTMFactory ptmFactory = PTMFactory.getInstance();
    private double precursorMass;
    private double[] neutralLossesMasses;
    private NeutralLoss[] neutralLosses = null;

    public PrecursorAnnotator(Peptide peptide) throws InterruptedException {
        this.precursorMass = peptide.getMass();
        ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
        if (modificationMatches != null) {
            HashSet<String> modificationLosses = new HashSet<String>(0);
            for (ModificationMatch modificationMatch : modificationMatches) {
                String modificationName = modificationMatch.getTheoreticPtm();
                PTM modification = this.ptmFactory.getPTM(modificationName);
                for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                    modificationLosses.add(neutralLoss.name);
                }
            }
            if (!modificationLosses.isEmpty()) {
                int nNeutralLosses = modificationLosses.size() + 2;
                this.neutralLosses = new NeutralLoss[nNeutralLosses];
                this.neutralLossesMasses = new double[nNeutralLosses];
                int cpt = 0;
                this.neutralLosses[cpt] = NeutralLoss.H2O;
                this.neutralLossesMasses[cpt++] = NeutralLoss.H2O.getMass();
                this.neutralLosses[cpt] = NeutralLoss.NH3;
                this.neutralLossesMasses[cpt++] = NeutralLoss.NH3.getMass();
                for (String modificationLoss : modificationLosses) {
                    NeutralLoss neutralLoss;
                    this.neutralLosses[cpt] = neutralLoss = NeutralLoss.getNeutralLoss(modificationLoss);
                    this.neutralLossesMasses[cpt++] = neutralLoss.getMass();
                }
            } else {
                this.neutralLosses = new NeutralLoss[]{NeutralLoss.H2O, NeutralLoss.NH3};
                this.neutralLossesMasses = new double[]{NeutralLoss.H2O.getMass(), NeutralLoss.NH3.getMass()};
            }
        } else {
            this.neutralLosses = new NeutralLoss[]{NeutralLoss.H2O, NeutralLoss.NH3};
            this.neutralLossesMasses = new double[]{NeutralLoss.H2O.getMass(), NeutralLoss.NH3.getMass()};
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex, int peptideCharge, int isotopeMax) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        double protonatedMass = this.precursorMass + ElementaryIon.getProtonMassMultiple(peptideCharge);
        for (int isotope = 0; isotope <= isotopeMax; ++isotope) {
            double mass = protonatedMass + ElementaryElement.getNeutronMassMultiple(isotope);
            double mz = mass / (double)peptideCharge;
            ArrayList<Peak> peaks = spectrumIndex.getMatchingPeaks(mz);
            for (Peak peak : peaks) {
                PrecursorIon ion = new PrecursorIon(this.precursorMass, null);
                results.add(new IonMatch(peak, ion, peptideCharge));
            }
            for (int i = 0; i < this.neutralLosses.length; ++i) {
                NeutralLoss neutralLoss1 = this.neutralLosses[i];
                double massWithLoss1 = mass - neutralLoss1.getMass();
                mz = massWithLoss1 / (double)peptideCharge;
                peaks = spectrumIndex.getMatchingPeaks(mz);
                if (!peaks.isEmpty()) {
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLoss1};
                    for (Peak peak : peaks) {
                        PrecursorIon ion = new PrecursorIon(massWithLoss1, ionLosses);
                        results.add(new IonMatch(peak, ion, peptideCharge));
                    }
                }
                for (int j = i + 1; j < this.neutralLosses.length; ++j) {
                    NeutralLoss neutralLoss2 = this.neutralLosses[j];
                    double massWithLoss2 = massWithLoss1 - neutralLoss2.getMass();
                    mz = massWithLoss1 / (double)peptideCharge;
                    peaks = spectrumIndex.getMatchingPeaks(mz);
                    if (peaks.isEmpty()) continue;
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLoss1, neutralLoss2};
                    for (Peak peak : peaks) {
                        PrecursorIon ion = new PrecursorIon(massWithLoss2, ionLosses);
                        results.add(new IonMatch(peak, ion, peptideCharge));
                    }
                }
            }
        }
        return results;
    }
}

