/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.NovorParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class NovorIdfileReader
extends ExperimentObject
implements IdfileReader {
    private String softwareName = "Novor";
    private String softwareVersion = null;
    private File novorCsvFile;
    private SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();

    public NovorIdfileReader() {
    }

    public NovorIdfileReader(File novorCsvFile) throws FileNotFoundException, IOException {
        this(novorCsvFile, null);
    }

    public NovorIdfileReader(File novorCsvFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        this.novorCsvFile = novorCsvFile;
        this.extractVersionNumber();
    }

    private void extractVersionNumber() throws IOException {
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(this.novorCsvFile, "r", 102400);
        String line = bufferedRandomAccessFile.readLine();
        boolean versionNumberFound = false;
        String versionNumberString = null;
        while (line.startsWith("#") && !versionNumberFound) {
            if (line.contains(" v")) {
                versionNumberString = line;
                versionNumberString = versionNumberString.substring(1);
                versionNumberString = versionNumberString.trim();
                versionNumberFound = true;
            }
            line = bufferedRandomAccessFile.readLine();
        }
        if (versionNumberFound) {
            this.softwareVersion = versionNumberString.trim();
        }
        bufferedRandomAccessFile.close();
    }

    @Override
    public String getExtension() {
        return ".novor.csv";
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, true);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        String line;
        NovorParameters novorParameters = (NovorParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex());
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(this.novorCsvFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        String inputFile = null;
        String fixedModificationsLine = null;
        String variableModificationsLine = null;
        while ((line = bufferedRandomAccessFile.readLine()) != null && !line.startsWith("# id,")) {
            if (line.startsWith("# input file = ")) {
                inputFile = line.substring("# input file = ".length()).trim();
            }
            if (line.startsWith("# fixedModifications = ")) {
                fixedModificationsLine = line.substring("# fixedModifications = ".length()).trim();
            }
            if (!line.startsWith("# variableModifications = ")) continue;
            variableModificationsLine = line.substring("# variableModifications = ".length()).trim();
        }
        if (inputFile == null) {
            throw new IllegalArgumentException("Mandatory header information is missing in the Novor csv file (the input file tag). Please check the file!");
        }
        if (fixedModificationsLine == null) {
            throw new IllegalArgumentException("Mandatory header information is missing in the Novor csv file (the fixedModifications tag). Please check the file!");
        }
        if (variableModificationsLine == null) {
            throw new IllegalArgumentException("Mandatory header information is missing in the Novor csv file (the variableModifications tag). Please check the file!");
        }
        String spectrumFileName = new File(inputFile).getName();
        HashMap<Integer, String> variableModificationsMap = new HashMap<Integer, String>();
        String[] tempVariable = variableModificationsLine.split(", ");
        for (int i = 0; i < tempVariable.length; ++i) {
            variableModificationsMap.put(i, tempVariable[i]);
        }
        HashMap<Integer, String> fixedModificationsMap = new HashMap<Integer, String>();
        String[] tempFixed = fixedModificationsLine.split(", ");
        for (int i = 0; i < tempFixed.length; ++i) {
            fixedModificationsMap.put(variableModificationsMap.size() + i, tempFixed[i]);
        }
        String headerString = line.substring(1).trim();
        if (headerString.endsWith(",")) {
            headerString = headerString.substring(0, headerString.length() - 1);
        }
        String[] headers = headerString.split(", ");
        int idIndex = -1;
        int scanNumberIndex = -1;
        int rtIndex = -1;
        int mzIndex = -1;
        int chargeIndex = -1;
        int pepMassIndex = -1;
        int erorrIndex = -1;
        int ppmIndex = -1;
        int scoreIndex = -1;
        int peptideIndex = -1;
        int aaScoreIndex = -1;
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (header.equalsIgnoreCase("id")) {
                idIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("scanNum")) {
                scanNumberIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("RT")) {
                rtIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("mz(data)")) {
                mzIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("z")) {
                chargeIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("pepMass(denovo)")) {
                pepMassIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("err(data-denovo)")) {
                erorrIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("ppm(1e6*err/(mz*z))")) {
                ppmIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("score")) {
                scoreIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("peptide")) {
                peptideIndex = i;
                continue;
            }
            if (!header.equalsIgnoreCase("aaScore")) continue;
            aaScoreIndex = i;
        }
        if (idIndex == -1 || scanNumberIndex == -1 || rtIndex == -1 || mzIndex == -1 || chargeIndex == -1 || pepMassIndex == -1 || erorrIndex == -1 || ppmIndex == -1 || scoreIndex == -1 || peptideIndex == -1 || aaScoreIndex == -1) {
            throw new IllegalArgumentException("Mandatory columns are missing in the Novor csv file. Please check the file!");
        }
        String currentSpectrumTitle = null;
        SpectrumMatch currentMatch = null;
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            String peptideSequence;
            String[] elements = line.split(", ");
            if (line.trim().isEmpty()) continue;
            int id = Integer.valueOf(elements[idIndex]);
            int charge = Integer.valueOf(elements[chargeIndex]);
            String peptideSequenceWithMods = elements[peptideIndex];
            String scoreAsText = elements[scoreIndex];
            double novorScore = Util.readDoubleAsString(scoreAsText);
            String aminoAcidScoresAsString = elements[aaScoreIndex];
            String[] tempAminoAcidScores = aminoAcidScoresAsString.split("-");
            double[] aminoAcidScoresAsList = new double[tempAminoAcidScores.length];
            for (int i = 0; i < tempAminoAcidScores.length; ++i) {
                aminoAcidScoresAsList[i] = Double.valueOf(tempAminoAcidScores[i]);
            }
            ArrayList<double[]> aminoAcidScores = new ArrayList<double[]>(1);
            aminoAcidScores.add(aminoAcidScoresAsList);
            String spectrumTitle = id + "";
            if (this.spectrumFactory.fileLoaded(spectrumFileName)) {
                spectrumTitle = this.spectrumFactory.getSpectrumTitle(spectrumFileName, id);
            }
            if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                if (currentMatch != null) {
                    result.add(currentMatch);
                }
                currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(spectrumFileName, spectrumTitle));
                currentMatch.setSpectrumNumber(id);
                currentSpectrumTitle = spectrumTitle;
            }
            ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>();
            if (peptideSequenceWithMods.contains("(") || peptideSequenceWithMods.contains("[")) {
                peptideSequence = "";
                for (int i = 0; i < peptideSequenceWithMods.length(); ++i) {
                    char currentChar = peptideSequenceWithMods.charAt(i);
                    if (currentChar == '(') {
                        int currentModAsInt;
                        int modStart = i + 1;
                        int modEnd = peptideSequenceWithMods.indexOf(")", i + 1);
                        String currentMod = peptideSequenceWithMods.substring(modStart, modEnd);
                        if (currentMod.toLowerCase().startsWith("n-term|")) {
                            currentModAsInt = new Integer(currentMod.substring("n-term|".length()));
                            if (variableModificationsMap.containsKey(currentModAsInt)) {
                                utilitiesModifications.add(new ModificationMatch((String)variableModificationsMap.get(currentModAsInt), true, 1));
                            } else if (fixedModificationsMap.containsKey(currentModAsInt)) {
                                utilitiesModifications.add(new ModificationMatch((String)fixedModificationsMap.get(currentModAsInt), false, 1));
                            } else if (novorParameters.getNovorPtmMap() == null) {
                                throw new IllegalArgumentException("Unknown PTM! Please check the Novor results file.");
                            }
                        } else if (currentMod.toLowerCase().startsWith("c-term|")) {
                            currentModAsInt = new Integer(currentMod.substring("c-term|".length()));
                            if (variableModificationsMap.containsKey(currentModAsInt)) {
                                utilitiesModifications.add(new ModificationMatch((String)variableModificationsMap.get(currentModAsInt), true, peptideSequence.length()));
                            } else if (fixedModificationsMap.containsKey(currentModAsInt)) {
                                utilitiesModifications.add(new ModificationMatch((String)fixedModificationsMap.get(currentModAsInt), false, peptideSequence.length()));
                            } else if (novorParameters.getNovorPtmMap() == null) {
                                throw new IllegalArgumentException("Unknown PTM! Please check the Novor results file.");
                            }
                        } else {
                            currentModAsInt = new Integer(currentMod);
                            if (variableModificationsMap.containsKey(currentModAsInt)) {
                                utilitiesModifications.add(new ModificationMatch((String)variableModificationsMap.get(currentModAsInt), true, peptideSequence.length()));
                            } else if (fixedModificationsMap.containsKey(currentModAsInt)) {
                                utilitiesModifications.add(new ModificationMatch((String)fixedModificationsMap.get(currentModAsInt), false, peptideSequence.length()));
                            } else if (novorParameters.getNovorPtmMap() == null) {
                                throw new IllegalArgumentException("Unknown PTM! Please check the Novor results file.");
                            }
                        }
                        i = modEnd;
                        continue;
                    }
                    peptideSequence = peptideSequence + currentChar;
                }
            } else {
                peptideSequence = peptideSequenceWithMods;
            }
            Charge peptideCharge = new Charge(1, charge);
            Peptide peptide = new Peptide(peptideSequence, utilitiesModifications, true);
            PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, 1, Advocate.novor.getIndex(), peptideCharge, novorScore, this.novorCsvFile.getName());
            peptideAssumption.setAminoAcidScores(aminoAcidScores);
            if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                ArrayList<ModificationMatch> previousModificationMatches = peptide.getModificationMatches();
                ArrayList<ModificationMatch> newModificationMatches = null;
                if (previousModificationMatches != null) {
                    newModificationMatches = new ArrayList<ModificationMatch>(previousModificationMatches.size());
                }
                for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                    Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                    if (previousModificationMatches != null) {
                        for (ModificationMatch modificationMatch : previousModificationMatches) {
                            newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                        }
                    }
                    PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                    currentMatch.addHit(Advocate.novor.getIndex(), newAssumption, true);
                }
            } else {
                currentMatch.addHit(Advocate.novor.getIndex(), peptideAssumption, true);
            }
            if (waitingHandler == null || progressUnit == 0L) continue;
            waitingHandler.setSecondaryProgressCounter((int)(bufferedRandomAccessFile.getFilePointer() / progressUnit));
            if (!waitingHandler.isRunCanceled()) continue;
            bufferedRandomAccessFile.close();
            break;
        }
        if (currentMatch != null) {
            result.add(currentMatch);
        }
        bufferedRandomAccessFile.close();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.novorCsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put(this.softwareName, versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

