/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry.proteowizard;

import java.util.Vector;

public enum MsFormat {
    mgf(0, "mgf", "mgf", "Mascot generic format", ".mgf", false, true),
    ms1(1, "ms1", "ms1", "ms1 format", ".ms1", false, true),
    ms2(2, "ms2", "ms2", "ms2 format", ".ms2", false, true),
    cms1(3, "cms1", "cms1", "cms1 format", ".cms1", false, true),
    cms2(4, "cms2", "cms2", "cms2 format", ".cms2", false, true),
    bms2(5, "bms2", "bms2", "bms2 format", ".bms2", false, true),
    mzML(6, "mzML", "mzML", "mzML generic PSI format", ".mzml", true, true),
    mzXML(7, "mzXML", "mzXML", "mzXML format", ".mzxml", true, true),
    mz5(8, "mz5", "mz5", "mzML based on HDF5", ".mz5", true, true),
    raw(9, "raw", null, "Thermo/Waters raw format", ".raw", true, false),
    d(10, "d", null, "Agilent/Buker d format", ".d", true, false),
    fid(11, "fid", null, "Bruker FID format", ".fid", true, false),
    yep(12, "yep", null, "Bruker YEP format", ".yep", true, false),
    baf(13, "baf", null, "Bruker BAF format", ".baf", true, false),
    wiff(14, "wiff", null, "Applied Biosystems wiff format", ".wiff", true, false);

    public final int index;
    public final String commandLineOption;
    public final String name;
    public final String description;
    public final boolean rawFormat;
    public final String fileNameEnding;
    public final boolean outputFormat;

    private MsFormat(int index, String commandLineOption, String name, String description, String fileNameEnding, boolean rawFormat, boolean outputFormat) {
        this.index = index;
        this.commandLineOption = commandLineOption;
        this.name = name;
        this.description = description;
        this.fileNameEnding = fileNameEnding;
        this.rawFormat = rawFormat;
        this.outputFormat = outputFormat;
    }

    public String toString() {
        return this.name;
    }

    public static Vector<MsFormat> getDataFormats(Boolean raw, Boolean outputFormat) {
        Vector<MsFormat> rawFormats = new Vector<MsFormat>();
        for (MsFormat format : MsFormat.values()) {
            boolean rawFilter = true;
            boolean outputFilter = true;
            if (raw != null) {
                boolean bl = rawFilter = format.rawFormat == raw;
            }
            if (outputFormat != null) {
                boolean bl = outputFilter = format.outputFormat == outputFormat;
            }
            if (!rawFilter || !outputFilter) continue;
            rawFormats.add(format);
        }
        return rawFormats;
    }
}

