/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.units;

import com.compomics.util.experiment.units.MetricsPrefix;
import com.compomics.util.experiment.units.StandardUnit;
import java.io.Serializable;

public class UnitOfMeasurement
implements Serializable {
    static final long serialVersionUID = 607774099178502699L;
    private String fullName;
    private String abbreviation;
    private MetricsPrefix metricsPrefix;

    public UnitOfMeasurement(String fullName, String abbreviation, MetricsPrefix metricsPrefix) {
        this.fullName = fullName;
        this.abbreviation = abbreviation;
        this.metricsPrefix = metricsPrefix;
    }

    public UnitOfMeasurement(StandardUnit standardUnit, MetricsPrefix metricsPrefix) {
        this.fullName = standardUnit.FULL_NAME;
        this.abbreviation = standardUnit.ABBREVIATION;
        this.metricsPrefix = metricsPrefix;
    }

    public UnitOfMeasurement(StandardUnit standardUnit) {
        this.fullName = standardUnit.FULL_NAME;
        this.abbreviation = standardUnit.ABBREVIATION;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public MetricsPrefix getMetricsPrefix() {
        return this.metricsPrefix;
    }

    public String getDisplayName() {
        if (this.metricsPrefix == null) {
            return this.abbreviation;
        }
        return this.metricsPrefix.SYMBOL + this.abbreviation;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean isSameAs(UnitOfMeasurement unitOfMeasurement) {
        if (this.getMetricsPrefix() == null && unitOfMeasurement.getMetricsPrefix() != null || this.getMetricsPrefix() != null && unitOfMeasurement.getMetricsPrefix() == null) {
            return false;
        }
        if (this.getMetricsPrefix() != null && unitOfMeasurement.getMetricsPrefix() != null && this.getMetricsPrefix() != unitOfMeasurement.getMetricsPrefix()) {
            return false;
        }
        return this.fullName.equals(unitOfMeasurement.getFullName());
    }
}

