/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import com.compomics.util.enumeration.MolecularElement;
import com.compomics.util.general.IsotopicElement;
import com.compomics.util.protein.MolecularFormula;
import java.util.Vector;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.apache.log4j.Logger;

public class IsotopicDistribution {
    Logger logger = Logger.getLogger(IsotopicDistribution.class);
    private Vector<Double> iPercTot = null;
    private Vector<Double> iPercMax = null;
    private MolecularFormula iMolecularFormula;
    private boolean iLabel = false;
    private int iLabelDaltonDifference;

    public IsotopicDistribution(MolecularFormula lFormula) {
        this.iMolecularFormula = lFormula;
    }

    public IsotopicDistribution(MolecularFormula lFormula, int lDaltonDifference) {
        this.iMolecularFormula = lFormula;
        this.iLabel = true;
        this.iLabelDaltonDifference = lDaltonDifference;
    }

    public void setLabelDifference(int lLabelDifference) {
        this.iLabel = true;
        this.iLabelDaltonDifference = lLabelDifference;
    }

    public void calculate() {
        Vector lPerc = new Vector();
        Vector<Integer> lNumbers = new Vector<Integer>();
        Vector<Integer> lDaltonDifferences = new Vector<Integer>();
        Vector<BinomialDistributionImpl> lBinomDistributions = new Vector<BinomialDistributionImpl>();
        Vector<IsotopicElement> lElements = IsotopicElement.getAllIsotopicElements(this.getClass(), this.logger);
        for (int e = 0; e < lElements.size(); ++e) {
            IsotopicElement lElmnt = lElements.get(e);
            int lCount = this.iMolecularFormula.getElementCount(lElmnt.getElement());
            if (lCount <= 0) continue;
            lNumbers.add(lCount);
            Vector lPercElement = new Vector();
            lPerc.add(lPercElement);
            lBinomDistributions.add(new BinomialDistributionImpl(lCount, lElmnt.getOccurrence()));
            lDaltonDifferences.add(lElmnt.getDaltonDifference());
        }
        for (int i = 0; i < 15; ++i) {
            for (int p = 0; p < lPerc.size(); ++p) {
                Vector lPercElement = (Vector)lPerc.get(p);
                BinomialDistributionImpl lBinom = (BinomialDistributionImpl)lBinomDistributions.get(p);
                int lDaltonDiff = (Integer)lDaltonDifferences.get(p);
                if (lDaltonDiff > 1) {
                    if (i % lDaltonDiff == 0) {
                        lPercElement.add(lBinom.probability(i / lDaltonDiff) * (double)((Integer)lNumbers.get(p)).intValue());
                        continue;
                    }
                    lPercElement.add(0.0);
                    continue;
                }
                lPercElement.add(lBinom.probability(i) * (double)((Integer)lNumbers.get(p)).intValue());
            }
        }
        Vector lPercTotal = new Vector();
        for (int i = 0; i < lPerc.size(); ++i) {
            if (i == 0) {
                for (int j = 0; j < ((Vector)lPerc.get(i)).size(); ++j) {
                    lPercTotal.add(((Vector)lPerc.get(i)).get(j));
                }
                continue;
            }
            if ((Integer)lNumbers.get(i) == 0) continue;
            Vector<Double> lTempTotal = new Vector<Double>();
            for (int k = 1; k <= lPercTotal.size(); ++k) {
                double lTempValue = 0.0;
                for (int l = 0; l < k; ++l) {
                    if ((Double)lPercTotal.get(l) == 0.0 || (Double)((Vector)lPerc.get(i)).get(k - l - 1) == 0.0) continue;
                    lTempValue += (Double)lPercTotal.get(l) * (Double)((Vector)lPerc.get(i)).get(k - l - 1);
                }
                lTempTotal.add(lTempValue);
            }
            lPercTotal = lTempTotal;
        }
        double lMax = 0.0;
        for (int k = 0; k < lPercTotal.size(); ++k) {
            for (int e = 0; e < lNumbers.size(); ++e) {
                lPercTotal.set(k, (Double)lPercTotal.get(k) / (double)((Integer)lNumbers.get(e)).intValue());
            }
            if (!((Double)lPercTotal.get(k) > lMax)) continue;
            lMax = (Double)lPercTotal.get(k);
        }
        if (this.iLabel) {
            lMax = 0.0;
            Vector<Double> lTempPercTotal = new Vector<Double>();
            for (int i = 0; i < lPercTotal.size(); ++i) {
                double lTempPeak1 = (Double)lPercTotal.get(i);
                double lTempPeak2 = 0.0;
                if (i - this.iLabelDaltonDifference >= 0) {
                    lTempPeak2 = (Double)lPercTotal.get(i - this.iLabelDaltonDifference);
                }
                lTempPercTotal.add((lTempPeak1 += lTempPeak2) / 2.0);
            }
            for (int k = 0; k < lTempPercTotal.size(); ++k) {
                if (!((Double)lTempPercTotal.get(k) > lMax)) continue;
                lMax = (Double)lTempPercTotal.get(k);
            }
            lPercTotal = lTempPercTotal;
        }
        this.iPercTot = lPercTotal;
        this.iPercMax = new Vector();
        for (int k = 0; k < this.iPercTot.size(); ++k) {
            this.iPercMax.add(this.iPercTot.get(k) / lMax);
        }
    }

    public IsotopicDistribution(int lC, int lN, int lH, int lO, int lS) {
        this.iMolecularFormula = new MolecularFormula();
        this.iMolecularFormula.addElement(MolecularElement.C, lC);
        this.iMolecularFormula.addElement(MolecularElement.N, lN);
        this.iMolecularFormula.addElement(MolecularElement.H, lH);
        this.iMolecularFormula.addElement(MolecularElement.O, lO);
        this.iMolecularFormula.addElement(MolecularElement.S, lS);
    }

    public Double[] getPercMax() {
        if (this.iPercMax == null) {
            this.calculate();
        }
        Double[] lReturn = new Double[this.iPercMax.size()];
        this.iPercMax.toArray(lReturn);
        return lReturn;
    }

    public Double[] getPercTot() {
        if (this.iPercTot == null) {
            this.calculate();
        }
        Double[] lReturn = new Double[this.iPercTot.size()];
        this.iPercTot.toArray(lReturn);
        return lReturn;
    }
}

