/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.NovorParameters;
import com.compomics.util.gui.parameters.identification_parameters.AlgorithmSettingsDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class NovorSettingsDialog
extends JDialog
implements AlgorithmSettingsDialog {
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox fragmentationMethodCmb;
    private JLabel fragmentationMethodLabel;
    private JComboBox massAnalyzerCmb;
    private JLabel massAnalyzerLabel;
    private JPanel novorPanel;
    private JButton okButton;
    private JButton openDialogHelpJButton;

    public NovorSettingsDialog(Frame parent, NovorParameters novorParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(novorParameters);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public NovorSettingsDialog(Dialog owner, Frame parent, NovorParameters novorParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(novorParameters);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.fragmentationMethodCmb.setRenderer(new AlignedListCellRenderer(0));
        this.massAnalyzerCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentationMethodCmb.setEnabled(this.editable);
        this.massAnalyzerCmb.setEnabled(this.editable);
    }

    private void populateGUI(NovorParameters novorParameters) {
        this.fragmentationMethodCmb.setSelectedItem(novorParameters.getFragmentationMethod());
        this.massAnalyzerCmb.setSelectedItem(novorParameters.getMassAnalyzer());
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.novorPanel = new JPanel();
        this.fragmentationMethodLabel = new JLabel();
        this.fragmentationMethodCmb = new JComboBox();
        this.massAnalyzerLabel = new JLabel();
        this.massAnalyzerCmb = new JComboBox();
        this.cancelButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Novor Advanced Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NovorSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NovorSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.novorPanel.setBorder(BorderFactory.createTitledBorder("De Novo Settings"));
        this.novorPanel.setOpaque(false);
        this.fragmentationMethodLabel.setText("Fragmentation Method");
        this.fragmentationMethodCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"HCD", "CID"}));
        this.massAnalyzerLabel.setText("Mass Analyzer");
        this.massAnalyzerCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Trap", "TOF", "FT"}));
        GroupLayout novorPanelLayout = new GroupLayout(this.novorPanel);
        this.novorPanel.setLayout(novorPanelLayout);
        novorPanelLayout.setHorizontalGroup(novorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(novorPanelLayout.createSequentialGroup().addContainerGap().addGroup(novorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(novorPanelLayout.createSequentialGroup().addComponent(this.fragmentationMethodLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.fragmentationMethodCmb, 0, 140, Short.MAX_VALUE)).addGroup(novorPanelLayout.createSequentialGroup().addComponent(this.massAnalyzerLabel, -2, 180, -2).addGap(18, 18, 18).addComponent(this.massAnalyzerCmb, 0, 140, Short.MAX_VALUE))).addContainerGap()));
        novorPanelLayout.setVerticalGroup(novorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(novorPanelLayout.createSequentialGroup().addContainerGap().addGroup(novorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentationMethodLabel).addComponent(this.fragmentationMethodCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(novorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.massAnalyzerLabel).addComponent(this.massAnalyzerCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NovorSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Open the Novor web page");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NovorSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NovorSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NovorSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.novorPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.novorPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addGap(5, 5, 5)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean valid = this.validateParametersInput(true);
        if (valid) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://rapidnovor.com");
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    public boolean validateParametersInput(boolean showMessage) {
        boolean valid = true;
        this.okButton.setEnabled(valid);
        return valid;
    }

    public NovorParameters getInput() {
        NovorParameters novorParameters = new NovorParameters();
        novorParameters.setFragmentationMethod((String)this.fragmentationMethodCmb.getSelectedItem());
        novorParameters.setMassAnalyzer((String)this.massAnalyzerCmb.getSelectedItem());
        return novorParameters;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }
}

