/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification_parameters.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.TideParameters;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.parameters.identification_parameters.AlgorithmSettingsDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class TideSettingsDialog
extends JDialog
implements AlgorithmSettingsDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JComboBox chargesCombo;
    private JLabel chargesLabel;
    private JButton closeButton;
    private JComboBox decoyFormatCombo;
    private JLabel decoySeedLabel;
    private JTextField decoySeedTxt;
    private JLabel decoyformatLabel;
    private JComboBox enzymeTypeCmb;
    private JLabel enzymeTypeLabel;
    private JComboBox exactPvalueCombo;
    private JLabel exactPvalueLabel;
    private JPanel indexPanel;
    private JComboBox keepTerminalAaCombo;
    private JLabel keepTerminalAaLabel;
    private JTextField maxPepLengthTxt;
    private JTextField maxPrecursorMassTxt;
    private JLabel maxPtmsLabel;
    private JTextField maxPtmsTxt;
    private JTextField maxSpectrumMzTxt;
    private JLabel maxVariablePtmsPerTypeLabel;
    private JTextField maxVariablePtmsPerTypeTxt;
    private JLabel minPeaksLbl;
    private JTextField minPeaksTxt;
    private JTextField minPepLengthTxt;
    private JTextField minPrecursorMassTxt;
    private JTextField minSpectrumMzTxt;
    private JComboBox monoPrecursorCmb;
    private JLabel monoPrecursorLabel;
    private JLabel mzBinOffsetLabel;
    private JTextField mzBinOffsetTxt;
    private JLabel mzBinWidthLabel;
    private JTextField mzBinWidthTxt;
    private JLabel numberMatchesLabel;
    private JTextField numberMatchesTxt;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JComboBox outputFormatCombo;
    private JLabel outputFormatLabel;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthLabel;
    private JComboBox peptideListCmb;
    private JLabel peptideListLabel;
    private JLabel precursorMassDividerLabel;
    private JLabel precursorMassLabel;
    private JComboBox removeMethionineCmb;
    private JLabel removeMethionineLabel;
    private JComboBox removePrecursorPeakCombo;
    private JLabel removePrecursorPeakLabel;
    private JLabel removePrecursorPeakToleranceLbl;
    private JTextField removePrecursorPeakToleranceTxt;
    private JComboBox removeTempFoldersCmb;
    private JLabel removeTempFoldersLabel;
    private JPanel searchPanel;
    private JComboBox spScoreCombo;
    private JLabel spScoreLabel;
    private JLabel spectrumMzDividerLabel;
    private JLabel spectrumMzLabel;
    private JTabbedPane tabbedPane;
    private JComboBox useFlankingCmb;
    private JLabel useFlankingLabel;
    private JComboBox useNeutralLossCmb;
    private JLabel useNeutralLossLabel;

    public TideSettingsDialog(Frame parent, TideParameters tideParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(tideParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public TideSettingsDialog(Dialog owner, Frame parent, TideParameters tideParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(tideParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.removePrecursorPeakCombo.setRenderer(new AlignedListCellRenderer(0));
        this.enzymeTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.useFlankingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.removePrecursorPeakCombo.setRenderer(new AlignedListCellRenderer(0));
        this.monoPrecursorCmb.setRenderer(new AlignedListCellRenderer(0));
        this.peptideListCmb.setRenderer(new AlignedListCellRenderer(0));
        this.decoyFormatCombo.setRenderer(new AlignedListCellRenderer(0));
        this.keepTerminalAaCombo.setRenderer(new AlignedListCellRenderer(0));
        this.removeMethionineCmb.setRenderer(new AlignedListCellRenderer(0));
        this.exactPvalueCombo.setRenderer(new AlignedListCellRenderer(0));
        this.spScoreCombo.setRenderer(new AlignedListCellRenderer(0));
        this.chargesCombo.setRenderer(new AlignedListCellRenderer(0));
        this.useNeutralLossCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputFormatCombo.setRenderer(new AlignedListCellRenderer(0));
        this.removeTempFoldersCmb.setRenderer(new AlignedListCellRenderer(0));
        this.minPepLengthTxt.setEditable(this.editable);
        this.minPepLengthTxt.setEnabled(this.editable);
        this.maxPepLengthTxt.setEditable(this.editable);
        this.maxPepLengthTxt.setEnabled(this.editable);
        this.minPrecursorMassTxt.setEditable(this.editable);
        this.minPrecursorMassTxt.setEnabled(this.editable);
        this.maxPrecursorMassTxt.setEditable(this.editable);
        this.maxPrecursorMassTxt.setEnabled(this.editable);
        this.monoPrecursorCmb.setEnabled(this.editable);
        this.removeMethionineCmb.setEnabled(this.editable);
        this.maxPtmsTxt.setEditable(this.editable);
        this.maxPtmsTxt.setEnabled(this.editable);
        this.maxVariablePtmsPerTypeTxt.setEditable(this.editable);
        this.maxVariablePtmsPerTypeTxt.setEnabled(this.editable);
        this.enzymeTypeCmb.setEnabled(this.editable);
        this.peptideListCmb.setEnabled(this.editable);
        this.decoyFormatCombo.setEnabled(this.editable);
        this.keepTerminalAaCombo.setEnabled(this.editable);
        this.decoySeedTxt.setEditable(this.editable);
        this.decoySeedTxt.setEnabled(this.editable);
        this.removeTempFoldersCmb.setEnabled(this.editable);
        this.exactPvalueCombo.setEnabled(this.editable);
        this.spScoreCombo.setEnabled(this.editable);
        this.minSpectrumMzTxt.setEditable(this.editable);
        this.minSpectrumMzTxt.setEnabled(this.editable);
        this.maxSpectrumMzTxt.setEditable(this.editable);
        this.maxSpectrumMzTxt.setEnabled(this.editable);
        this.minPeaksTxt.setEditable(this.editable);
        this.minPeaksTxt.setEnabled(this.editable);
        this.chargesCombo.setEnabled(this.editable);
        this.removePrecursorPeakCombo.setEnabled(this.editable);
        this.removePrecursorPeakToleranceTxt.setEditable(this.editable);
        this.removePrecursorPeakToleranceTxt.setEnabled(this.editable);
        this.useFlankingCmb.setEnabled(this.editable);
        this.useNeutralLossCmb.setEnabled(this.editable);
        this.mzBinWidthTxt.setEditable(this.editable);
        this.mzBinWidthTxt.setEnabled(this.editable);
        this.mzBinOffsetTxt.setEditable(this.editable);
        this.mzBinOffsetTxt.setEnabled(this.editable);
        this.numberMatchesTxt.setEditable(this.editable);
        this.numberMatchesTxt.setEnabled(this.editable);
        this.outputFormatCombo.setEnabled(this.editable);
    }

    private void populateGUI(TideParameters tideParameters) {
        if (tideParameters.getMinPeptideLength() != null) {
            this.minPepLengthTxt.setText(tideParameters.getMinPeptideLength() + "");
        }
        if (tideParameters.getMaxPeptideLength() != null) {
            this.maxPepLengthTxt.setText(tideParameters.getMaxPeptideLength() + "");
        }
        if (tideParameters.getMinPrecursorMass() != null) {
            this.minPrecursorMassTxt.setText(tideParameters.getMinPrecursorMass() + "");
        }
        if (tideParameters.getMaxPrecursorMass() != null) {
            this.maxPrecursorMassTxt.setText(tideParameters.getMaxPrecursorMass() + "");
        }
        if (tideParameters.getMonoisotopicPrecursor() != null) {
            if (tideParameters.getMonoisotopicPrecursor().booleanValue()) {
                this.monoPrecursorCmb.setSelectedIndex(0);
            } else {
                this.monoPrecursorCmb.setSelectedIndex(1);
            }
        }
        if (tideParameters.getClipNtermMethionine() != null) {
            if (tideParameters.getClipNtermMethionine().booleanValue()) {
                this.removeMethionineCmb.setSelectedIndex(0);
            } else {
                this.removeMethionineCmb.setSelectedIndex(1);
            }
        }
        if (tideParameters.getMaxVariablePtmsPerPeptide() != null) {
            this.maxPtmsTxt.setText(tideParameters.getMaxVariablePtmsPerPeptide() + "");
        }
        if (tideParameters.getMaxVariablePtmsPerTypePerPeptide() != null) {
            this.maxVariablePtmsPerTypeTxt.setText(tideParameters.getMaxVariablePtmsPerTypePerPeptide() + "");
        }
        if (tideParameters.getDigestionType() != null) {
            this.enzymeTypeCmb.setSelectedItem(tideParameters.getDigestionType());
        }
        if (tideParameters.getPrintPeptides() != null) {
            if (tideParameters.getPrintPeptides().booleanValue()) {
                this.peptideListCmb.setSelectedIndex(0);
            } else {
                this.peptideListCmb.setSelectedIndex(1);
            }
        }
        if (tideParameters.getDecoyFormat() != null) {
            this.decoyFormatCombo.setSelectedItem(tideParameters.getDecoyFormat());
        }
        if (tideParameters.getKeepTerminalAminoAcids() != null) {
            this.keepTerminalAaCombo.setSelectedItem(tideParameters.getKeepTerminalAminoAcids());
        }
        if (tideParameters.getDecoySeed() != null) {
            this.decoySeedTxt.setText(tideParameters.getDecoySeed() + "");
        }
        if (tideParameters.getRemoveTempFolders() != null) {
            if (tideParameters.getRemoveTempFolders().booleanValue()) {
                this.removeTempFoldersCmb.setSelectedIndex(0);
            } else {
                this.removeTempFoldersCmb.setSelectedIndex(1);
            }
        }
        if (tideParameters.getComputeExactPValues() != null) {
            if (tideParameters.getComputeExactPValues().booleanValue()) {
                this.exactPvalueCombo.setSelectedIndex(0);
            } else {
                this.exactPvalueCombo.setSelectedIndex(1);
            }
        }
        if (tideParameters.getComputeSpScore() != null) {
            if (tideParameters.getComputeSpScore().booleanValue()) {
                this.spScoreCombo.setSelectedIndex(0);
            } else {
                this.spScoreCombo.setSelectedIndex(1);
            }
        }
        if (tideParameters.getMinSpectrumMz() != null) {
            this.minSpectrumMzTxt.setText(tideParameters.getMinSpectrumMz() + "");
        }
        if (tideParameters.getMaxSpectrumMz() != null) {
            this.maxSpectrumMzTxt.setText(tideParameters.getMaxSpectrumMz() + "");
        }
        if (tideParameters.getMinSpectrumPeaks() != null) {
            this.minPeaksTxt.setText(tideParameters.getMinSpectrumPeaks() + "");
        }
        if (tideParameters.getSpectrumCharges() != null) {
            this.chargesCombo.setSelectedItem(tideParameters.getSpectrumCharges());
        }
        if (tideParameters.getRemovePrecursor() != null) {
            if (tideParameters.getRemovePrecursor().booleanValue()) {
                this.removePrecursorPeakCombo.setSelectedIndex(0);
            } else {
                this.removePrecursorPeakCombo.setSelectedIndex(1);
            }
        }
        if (tideParameters.getRemovePrecursorTolerance() != null) {
            this.removePrecursorPeakToleranceTxt.setText("" + tideParameters.getRemovePrecursorTolerance());
        }
        if (tideParameters.getUseFlankingPeaks() != null) {
            if (tideParameters.getUseFlankingPeaks().booleanValue()) {
                this.useFlankingCmb.setSelectedIndex(0);
            } else {
                this.useFlankingCmb.setSelectedIndex(1);
            }
        }
        if (tideParameters.getUseNeutralLossPeaks() != null) {
            if (tideParameters.getUseNeutralLossPeaks().booleanValue()) {
                this.useNeutralLossCmb.setSelectedIndex(0);
            } else {
                this.useNeutralLossCmb.setSelectedIndex(1);
            }
        }
        if (tideParameters.getMzBinWidth() != null) {
            this.mzBinWidthTxt.setText("" + tideParameters.getMzBinWidth());
        }
        if (tideParameters.getMzBinOffset() != null) {
            this.mzBinOffsetTxt.setText("" + tideParameters.getMzBinOffset());
        }
        if (tideParameters.getNumberOfSpectrumMatches() != null) {
            this.numberMatchesTxt.setText("" + tideParameters.getNumberOfSpectrumMatches());
        }
        if (tideParameters.getTextOutput().booleanValue()) {
            this.outputFormatCombo.setSelectedItem("Text");
        } else if (tideParameters.getSqtOutput().booleanValue()) {
            this.outputFormatCombo.setSelectedItem("SQT");
        } else if (tideParameters.getPepXmlOutput().booleanValue()) {
            this.outputFormatCombo.setSelectedItem("pepxml");
        } else if (tideParameters.getMzidOutput().booleanValue()) {
            this.outputFormatCombo.setSelectedItem("mzIdentML");
        } else if (tideParameters.getPinOutput().booleanValue()) {
            this.outputFormatCombo.setSelectedItem("Percolator input file");
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public TideParameters getInput() {
        int selectedIndex;
        TideParameters result = new TideParameters();
        String input = this.minPepLengthTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeptideLength(new Integer(input));
        }
        if (!(input = this.maxPepLengthTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLength(new Integer(input));
        }
        if (!(input = this.minPrecursorMassTxt.getText().trim()).equals("")) {
            result.setMinPrecursorMass(new Double(input));
        }
        if (!(input = this.maxPrecursorMassTxt.getText().trim()).equals("")) {
            result.setMaxPrecursorMass(new Double(input));
        }
        result.setMonoisotopicPrecursor(this.monoPrecursorCmb.getSelectedIndex() == 0);
        result.setClipNtermMethionine(this.removeMethionineCmb.getSelectedIndex() == 0);
        input = this.maxPtmsTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaxVariablePtmsPerPeptide(new Integer(input));
        }
        if (!(input = this.maxVariablePtmsPerTypeTxt.getText().trim()).equals("")) {
            result.setMaxVariablePtmsPerTypePerPeptide(new Integer(input));
        }
        result.setDigestionType((String)this.enzymeTypeCmb.getSelectedItem());
        result.setPrintPeptides(this.peptideListCmb.getSelectedIndex() == 0);
        result.setDecoyFormat((String)this.decoyFormatCombo.getSelectedItem());
        result.setRemoveTempFolders(this.removeTempFoldersCmb.getSelectedIndex() == 0);
        result.setKeepTerminalAminoAcids((String)this.keepTerminalAaCombo.getSelectedItem());
        input = this.decoySeedTxt.getText().trim();
        if (!input.equals("")) {
            result.setDecoySeed(new Integer(input));
        }
        result.setComputeExactPValues(this.exactPvalueCombo.getSelectedIndex() == 0);
        result.setComputeSpScore(this.spScoreCombo.getSelectedIndex() == 0);
        input = this.minSpectrumMzTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinSpectrumMz(new Double(input));
        }
        if (!(input = this.maxSpectrumMzTxt.getText().trim()).equals("")) {
            result.setMaxSpectrumMz(new Double(input));
        }
        if (!(input = this.minPeaksTxt.getText().trim()).equals("")) {
            result.setMinSpectrumPeaks(new Integer(input));
        }
        result.setSpectrumCharges((String)this.chargesCombo.getSelectedItem());
        result.setRemovePrecursor(this.removePrecursorPeakCombo.getSelectedIndex() == 0);
        input = this.removePrecursorPeakToleranceTxt.getText().trim();
        if (!input.equals("")) {
            result.setRemovePrecursorTolerance(new Double(input));
        }
        result.setUseFlankingPeaks(this.useFlankingCmb.getSelectedIndex() == 0);
        result.setUseNeutralLossPeaks(this.useNeutralLossCmb.getSelectedIndex() == 0);
        input = this.mzBinWidthTxt.getText().trim();
        if (!input.equals("")) {
            result.setMzBinWidth(new Double(input));
        }
        if (!(input = this.mzBinOffsetTxt.getText().trim()).equals("")) {
            result.setMzBinOffset(new Double(input));
        }
        if (!(input = this.numberMatchesTxt.getText().trim()).equals("")) {
            result.setNumberOfSpectrumMatches(new Integer(input));
        }
        result.setTextOutput((selectedIndex = this.outputFormatCombo.getSelectedIndex()) == 0);
        result.setSqtOutput(selectedIndex == 1);
        result.setPepXmlOutput(selectedIndex == 2);
        result.setMzidOutput(selectedIndex == 3);
        result.setPinOutput(selectedIndex == 4);
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.indexPanel = new JPanel();
        this.peptideLengthLabel = new JLabel();
        this.minPepLengthTxt = new JTextField();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPepLengthTxt = new JTextField();
        this.precursorMassLabel = new JLabel();
        this.minPrecursorMassTxt = new JTextField();
        this.precursorMassDividerLabel = new JLabel();
        this.maxPrecursorMassTxt = new JTextField();
        this.monoPrecursorLabel = new JLabel();
        this.monoPrecursorCmb = new JComboBox();
        this.removeMethionineLabel = new JLabel();
        this.removeMethionineCmb = new JComboBox();
        this.maxPtmsLabel = new JLabel();
        this.maxPtmsTxt = new JTextField();
        this.decoyformatLabel = new JLabel();
        this.decoyFormatCombo = new JComboBox();
        this.keepTerminalAaLabel = new JLabel();
        this.keepTerminalAaCombo = new JComboBox();
        this.decoySeedLabel = new JLabel();
        this.decoySeedTxt = new JTextField();
        this.enzymeTypeLabel = new JLabel();
        this.enzymeTypeCmb = new JComboBox();
        this.peptideListLabel = new JLabel();
        this.peptideListCmb = new JComboBox();
        this.maxVariablePtmsPerTypeLabel = new JLabel();
        this.maxVariablePtmsPerTypeTxt = new JTextField();
        this.removeTempFoldersLabel = new JLabel();
        this.removeTempFoldersCmb = new JComboBox();
        this.searchPanel = new JPanel();
        this.useFlankingLabel = new JLabel();
        this.useFlankingCmb = new JComboBox();
        this.spectrumMzLabel = new JLabel();
        this.minSpectrumMzTxt = new JTextField();
        this.spectrumMzDividerLabel = new JLabel();
        this.maxSpectrumMzTxt = new JTextField();
        this.numberMatchesLabel = new JLabel();
        this.numberMatchesTxt = new JTextField();
        this.chargesLabel = new JLabel();
        this.chargesCombo = new JComboBox();
        this.removePrecursorPeakLabel = new JLabel();
        this.removePrecursorPeakCombo = new JComboBox();
        this.removePrecursorPeakToleranceLbl = new JLabel();
        this.removePrecursorPeakToleranceTxt = new JTextField();
        this.mzBinWidthLabel = new JLabel();
        this.mzBinWidthTxt = new JTextField();
        this.minPeaksLbl = new JLabel();
        this.minPeaksTxt = new JTextField();
        this.exactPvalueLabel = new JLabel();
        this.exactPvalueCombo = new JComboBox();
        this.spScoreLabel = new JLabel();
        this.spScoreCombo = new JComboBox();
        this.useNeutralLossLabel = new JLabel();
        this.useNeutralLossCmb = new JComboBox();
        this.mzBinOffsetLabel = new JLabel();
        this.mzBinOffsetTxt = new JTextField();
        this.outputFormatLabel = new JLabel();
        this.outputFormatCombo = new JComboBox();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Tide Advanced Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setOpaque(true);
        this.indexPanel.setBackground(new Color(230, 230, 230));
        this.indexPanel.setPreferredSize(new Dimension(518, 143));
        this.peptideLengthLabel.setText("Peptide Length (min - max)");
        this.minPepLengthTxt.setHorizontalAlignment(0);
        this.minPepLengthTxt.setText("6");
        this.minPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.minPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthDividerLabel.setText("-");
        this.maxPepLengthTxt.setHorizontalAlignment(0);
        this.maxPepLengthTxt.setText("30");
        this.maxPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.maxPepLengthTxtKeyReleased(evt);
            }
        });
        this.precursorMassLabel.setText("Precursor Mass (min - max)");
        this.minPrecursorMassTxt.setHorizontalAlignment(0);
        this.minPrecursorMassTxt.setText("0");
        this.minPrecursorMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.minPrecursorMassTxtKeyReleased(evt);
            }
        });
        this.precursorMassDividerLabel.setHorizontalAlignment(0);
        this.precursorMassDividerLabel.setText("-");
        this.maxPrecursorMassTxt.setHorizontalAlignment(0);
        this.maxPrecursorMassTxt.setText("10000");
        this.maxPrecursorMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.maxPrecursorMassTxtKeyReleased(evt);
            }
        });
        this.monoPrecursorLabel.setText("Monoisotopic Precursor");
        this.monoPrecursorCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.removeMethionineLabel.setText("Remove Starting Methionine");
        this.removeMethionineCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.removeMethionineCmb.setSelectedIndex(1);
        this.maxPtmsLabel.setText("Max Variable PTMs per Peptide");
        this.maxPtmsTxt.setHorizontalAlignment(0);
        this.maxPtmsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.maxPtmsTxtKeyReleased(evt);
            }
        });
        this.decoyformatLabel.setText("Decoy Format");
        this.decoyFormatCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "shuffle", "peptide-reverse", "protein-reverse"}));
        this.keepTerminalAaLabel.setText("Keep Terminal AAs");
        this.keepTerminalAaCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"N", "C", "NC", "none"}));
        this.keepTerminalAaCombo.setSelectedIndex(2);
        this.decoySeedLabel.setText("Decoy Seed");
        this.decoySeedTxt.setHorizontalAlignment(0);
        this.decoySeedTxt.setText("1");
        this.decoySeedTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.decoySeedTxtKeyReleased(evt);
            }
        });
        this.enzymeTypeLabel.setText("Enzyme Type");
        this.enzymeTypeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"full-digest", "partial-digest"}));
        this.peptideListLabel.setText("Peptide List");
        this.peptideListCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.peptideListCmb.setSelectedIndex(1);
        this.maxVariablePtmsPerTypeLabel.setText("Max Variable PTMs Per Type");
        this.maxVariablePtmsPerTypeTxt.setHorizontalAlignment(0);
        this.maxVariablePtmsPerTypeTxt.setText("2");
        this.maxVariablePtmsPerTypeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.maxVariablePtmsPerTypeTxtKeyReleased(evt);
            }
        });
        this.removeTempFoldersLabel.setText("Remove Temp Folders");
        this.removeTempFoldersCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout indexPanelLayout = new GroupLayout(this.indexPanel);
        this.indexPanel.setLayout(indexPanelLayout);
        indexPanelLayout.setHorizontalGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.maxVariablePtmsPerTypeLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.maxVariablePtmsPerTypeTxt, -2, 200, -2)).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.peptideLengthLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.minPepLengthTxt, -2, 71, -2).addGap(12, 12, 12).addComponent(this.peptideLengthDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.maxPepLengthTxt, -2, 77, -2)).addGroup(indexPanelLayout.createSequentialGroup().addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.precursorMassLabel, -1, 200, Short.MAX_VALUE).addGap(18, 18, 18)).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.monoPrecursorLabel, -1, 200, Short.MAX_VALUE).addGap(18, 18, 18))).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.monoPrecursorCmb, -2, 200, -2).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.minPrecursorMassTxt, -2, 71, -2).addGap(12, 12, 12).addComponent(this.precursorMassDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.maxPrecursorMassTxt, -2, 77, -2)).addComponent(this.removeMethionineCmb, 0, 200, Short.MAX_VALUE))).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.keepTerminalAaLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.keepTerminalAaCombo, -2, 200, -2)).addGroup(indexPanelLayout.createSequentialGroup().addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.enzymeTypeLabel, GroupLayout.Alignment.TRAILING, -1, 200, Short.MAX_VALUE).addComponent(this.peptideListLabel, -1, 200, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.peptideListCmb, 0, -1, Short.MAX_VALUE).addComponent(this.enzymeTypeCmb, 0, 200, Short.MAX_VALUE))).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.decoyformatLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.decoyFormatCombo, -2, 200, -2)).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.maxPtmsLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.maxPtmsTxt, -1, 200, Short.MAX_VALUE)).addComponent(this.removeMethionineLabel, -2, 200, -2).addGroup(indexPanelLayout.createSequentialGroup().addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.removeTempFoldersLabel, -1, -1, Short.MAX_VALUE).addComponent(this.decoySeedLabel, -1, 200, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.decoySeedTxt, -1, 200, Short.MAX_VALUE).addComponent(this.removeTempFoldersCmb, 0, -1, Short.MAX_VALUE)))).addGap(0, 25, Short.MAX_VALUE)));
        indexPanelLayout.linkSize(0, this.enzymeTypeCmb, this.maxPtmsTxt, this.removeMethionineCmb);
        indexPanelLayout.linkSize(0, this.maxPrecursorMassTxt, this.minPrecursorMassTxt);
        indexPanelLayout.linkSize(0, this.maxPepLengthTxt, this.minPepLengthTxt);
        indexPanelLayout.setVerticalGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPepLengthTxt, -2, -1, -2).addComponent(this.maxPepLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel).addComponent(this.peptideLengthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPrecursorMassTxt, -2, -1, -2).addComponent(this.maxPrecursorMassTxt, -2, -1, -2).addComponent(this.precursorMassDividerLabel).addComponent(this.precursorMassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.monoPrecursorLabel).addComponent(this.monoPrecursorCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeMethionineLabel).addComponent(this.removeMethionineCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmsLabel).addComponent(this.maxPtmsTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxVariablePtmsPerTypeLabel).addComponent(this.maxVariablePtmsPerTypeTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enzymeTypeLabel).addComponent(this.enzymeTypeCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideListLabel).addComponent(this.peptideListCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyformatLabel).addComponent(this.decoyFormatCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keepTerminalAaLabel).addComponent(this.keepTerminalAaCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoySeedLabel).addComponent(this.decoySeedTxt, -2, -1, -2)).addGap(18, 18, 18).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeTempFoldersLabel).addComponent(this.removeTempFoldersCmb, -2, -1, -2)).addContainerGap(102, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Index", this.indexPanel);
        this.searchPanel.setBackground(new Color(230, 230, 230));
        this.searchPanel.setPreferredSize(new Dimension(518, 143));
        this.useFlankingLabel.setText("Use Flanking Peaks");
        this.useFlankingCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.useFlankingCmb.setSelectedIndex(1);
        this.useFlankingCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TideSettingsDialog.this.useFlankingCmbActionPerformed(evt);
            }
        });
        this.spectrumMzLabel.setText("Spectrum m/z (min - max)");
        this.minSpectrumMzTxt.setHorizontalAlignment(0);
        this.minSpectrumMzTxt.setText("0");
        this.minSpectrumMzTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.minSpectrumMzTxtKeyReleased(evt);
            }
        });
        this.spectrumMzDividerLabel.setHorizontalAlignment(0);
        this.spectrumMzDividerLabel.setText("-");
        this.maxSpectrumMzTxt.setHorizontalAlignment(0);
        this.maxSpectrumMzTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.maxSpectrumMzTxtKeyReleased(evt);
            }
        });
        this.numberMatchesLabel.setText("Number of Spectrum Matches");
        this.numberMatchesTxt.setHorizontalAlignment(0);
        this.numberMatchesTxt.setText("10");
        this.numberMatchesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.numberMatchesTxtKeyReleased(evt);
            }
        });
        this.chargesLabel.setText("Charges");
        this.chargesCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "all"}));
        this.chargesCombo.setSelectedIndex(3);
        this.removePrecursorPeakLabel.setText("Remove Precursor Peak (PP)");
        this.removePrecursorPeakCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.removePrecursorPeakToleranceLbl.setText("Remove PP Tolerance (in Da)");
        this.removePrecursorPeakToleranceTxt.setHorizontalAlignment(0);
        this.removePrecursorPeakToleranceTxt.setText("0.0");
        this.removePrecursorPeakToleranceTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.removePrecursorPeakToleranceTxtKeyReleased(evt);
            }
        });
        this.mzBinWidthLabel.setText("m/z Bin Width");
        this.mzBinWidthTxt.setHorizontalAlignment(0);
        this.mzBinWidthTxt.setText("0.02");
        this.mzBinWidthTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TideSettingsDialog.this.mzBinWidthTxtActionPerformed(evt);
            }
        });
        this.mzBinWidthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.mzBinWidthTxtKeyReleased(evt);
            }
        });
        this.minPeaksLbl.setText("Minimum Number of Peaks");
        this.minPeaksTxt.setHorizontalAlignment(0);
        this.minPeaksTxt.setText("10");
        this.minPeaksTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.minPeaksTxtKeyReleased(evt);
            }
        });
        this.exactPvalueLabel.setText("Calculate Exact p-value");
        this.exactPvalueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.spScoreLabel.setText("Calculate SP Score");
        this.spScoreCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.useNeutralLossLabel.setText("Use Neutral Loss Peaks");
        this.useNeutralLossCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.useNeutralLossCmb.setSelectedIndex(1);
        this.mzBinOffsetLabel.setText("m/z Bin Offset");
        this.mzBinOffsetTxt.setHorizontalAlignment(0);
        this.mzBinOffsetTxt.setText("0.0");
        this.mzBinOffsetTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TideSettingsDialog.this.mzBinOffsetTxtKeyReleased(evt);
            }
        });
        this.outputFormatLabel.setText("Output Format");
        this.outputFormatCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Text", "SQT", "pepxml", "mzIdentML", "Percolator input file"}));
        this.outputFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TideSettingsDialog.this.outputFormatComboActionPerformed(evt);
            }
        });
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.outputFormatLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.outputFormatCombo, -2, 200, -2)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.mzBinOffsetLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.mzBinOffsetTxt, -2, 200, -2)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.mzBinWidthLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.mzBinWidthTxt, -2, 200, -2)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.minPeaksLbl, -2, 200, -2).addGap(18, 18, 18).addComponent(this.minPeaksTxt, -1, 200, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.spectrumMzLabel, -1, -1, Short.MAX_VALUE).addComponent(this.spScoreLabel, -1, 200, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.spScoreCombo, -2, 200, -2).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.minSpectrumMzTxt, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spectrumMzDividerLabel, -2, 27, -2).addGap(18, 18, 18).addComponent(this.maxSpectrumMzTxt)))).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.exactPvalueLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.exactPvalueCombo, -2, 200, -2)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.numberMatchesLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.numberMatchesTxt)).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addComponent(this.useNeutralLossLabel, -2, 200, -2).addGap(18, 18, 18).addComponent(this.useNeutralLossCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removePrecursorPeakLabel, -2, 200, -2).addComponent(this.removePrecursorPeakToleranceLbl, -2, 200, -2)).addGap(18, 18, 18).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removePrecursorPeakCombo, 0, 200, Short.MAX_VALUE).addComponent(this.removePrecursorPeakToleranceTxt))).addGroup(searchPanelLayout.createSequentialGroup().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.chargesLabel, -2, 200, -2).addGap(18, 18, 18)).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addComponent(this.useFlankingLabel, -2, 200, -2).addGap(18, 18, 18))).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chargesCombo, -2, 200, -2).addComponent(this.useFlankingCmb, -2, 200, -2)))).addContainerGap(28, Short.MAX_VALUE)));
        searchPanelLayout.linkSize(0, this.minPeaksTxt, this.removePrecursorPeakCombo);
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exactPvalueLabel).addComponent(this.exactPvalueCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spScoreLabel).addComponent(this.spScoreCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minSpectrumMzTxt, -2, -1, -2).addComponent(this.maxSpectrumMzTxt, -2, -1, -2).addComponent(this.spectrumMzDividerLabel).addComponent(this.spectrumMzLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeaksLbl).addComponent(this.minPeaksTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chargesLabel).addComponent(this.chargesCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removePrecursorPeakLabel).addComponent(this.removePrecursorPeakCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removePrecursorPeakToleranceLbl).addComponent(this.removePrecursorPeakToleranceTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useFlankingLabel).addComponent(this.useFlankingCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useNeutralLossLabel).addComponent(this.useNeutralLossCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mzBinWidthLabel).addComponent(this.mzBinWidthTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mzBinOffsetLabel).addComponent(this.mzBinOffsetTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberMatchesLabel).addComponent(this.numberMatchesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFormatLabel).addComponent(this.outputFormatCombo, -2, -1, -2)).addContainerGap(88, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Search", this.searchPanel);
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TideSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TideSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TideSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the Tide help page.");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TideSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TideSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addGap(10, 10, 10)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, 476, -2).addContainerGap(-1, Short.MAX_VALUE)));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 473, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://cruxtoolkit.sourceforge.net/");
        this.setCursor(new Cursor(0));
    }

    private void numberMatchesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPtmsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minSpectrumMzTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxSpectrumMzTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void mzBinWidthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeaksTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void removePrecursorPeakToleranceTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPrecursorMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPrecursorMassTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void decoySeedTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxVariablePtmsPerTypeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void mzBinOffsetTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void mzBinWidthTxtActionPerformed(ActionEvent evt) {
        this.validateInput(false);
    }

    private void useFlankingCmbActionPerformed(ActionEvent evt) {
        this.validateInput(false);
    }

    private void outputFormatComboActionPerformed(ActionEvent evt) {
        if (this.outputFormatCombo.getSelectedIndex() != 0 && this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(TideSettingsDialog.this, JOptionEditorPane.getJOptionEditorPane("Note that the Tide " + (String)TideSettingsDialog.this.outputFormatCombo.getSelectedItem() + " format is not compatible with <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>."), "Format Warning", 2);
                }
            });
        }
    }

    public boolean validateInput(boolean showMessage) {
        double highValue;
        double lowValue2;
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.minPepLengthTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.maxPepLengthTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorMassLabel, this.minPrecursorMassTxt, "minimum precursor mass", "Precursor Mass Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.precursorMassLabel, this.maxPrecursorMassTxt, "maximum precursor mass", "Precursor Mass Error", true, showMessage, valid);
        if (!this.maxPtmsTxt.getText().trim().isEmpty()) {
            valid = GuiUtilities.validateIntegerInput(this, this.maxPtmsLabel, this.maxPtmsTxt, "maximum number of variable PTMs", "Variable PTMs Error", true, showMessage, valid);
        }
        valid = GuiUtilities.validateIntegerInput(this, this.maxVariablePtmsPerTypeLabel, this.maxVariablePtmsPerTypeTxt, "maximum number of variable PTMs per type", "Variable PTMs Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.decoySeedLabel, this.decoySeedTxt, "decoy seed", "Decoy Seed Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.spectrumMzLabel, this.minSpectrumMzTxt, "minimum spectrum mz", "Spectrum Mz Error", true, showMessage, valid);
        if (!this.maxSpectrumMzTxt.getText().trim().isEmpty()) {
            valid = GuiUtilities.validateDoubleInput(this, this.spectrumMzLabel, this.maxSpectrumMzTxt, "maximum spectrum mz", "Spectrum Mz Error", true, showMessage, valid);
        }
        valid = GuiUtilities.validateIntegerInput(this, this.minPeaksLbl, this.minPeaksTxt, "minimum number of peaks", "Spectrum Peaks Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.removePrecursorPeakLabel, this.removePrecursorPeakToleranceTxt, "remove precursor peak tolerance", "Precursor Peak Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.mzBinWidthLabel, this.mzBinWidthTxt, "mz bin width", "Mz Bin Width Error", true, showMessage, valid);
        valid = GuiUtilities.validateDoubleInput(this, this.mzBinOffsetLabel, this.mzBinOffsetTxt, "mz bin offset", "Mz Bin Offset Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberMatchesLabel, this.numberMatchesTxt, "number of spectrum matches", "Number of Spectrum Matches Error", true, showMessage, valid);
        try {
            lowValue2 = Double.parseDouble(this.minPepLengthTxt.getText().trim());
            highValue = Double.parseDouble(this.maxPepLengthTxt.getText().trim());
            if (lowValue2 > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Peptide Length Error", 2);
                }
                valid = false;
                this.peptideLengthLabel.setForeground(Color.RED);
                this.peptideLengthLabel.setToolTipText("Please select a valid range (upper <= higher)");
            }
        }
        catch (NumberFormatException lowValue2) {
            // empty catch block
        }
        try {
            lowValue2 = Double.parseDouble(this.minPrecursorMassTxt.getText().trim());
            highValue = Double.parseDouble(this.maxPrecursorMassTxt.getText().trim());
            if (lowValue2 > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Precursor Mass Range Error", 2);
                }
                valid = false;
                this.precursorMassLabel.setForeground(Color.RED);
                this.precursorMassLabel.setToolTipText("Please select a valid range (upper <= higher)");
            }
        }
        catch (NumberFormatException lowValue3) {
            // empty catch block
        }
        try {
            double lowValue4 = Double.parseDouble(this.minSpectrumMzTxt.getText().trim());
            highValue = Double.parseDouble(this.maxSpectrumMzTxt.getText().trim());
            if (lowValue4 > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Spectrum Mz Range Error", 2);
                }
                valid = false;
                this.spectrumMzLabel.setForeground(Color.RED);
                this.spectrumMzLabel.setToolTipText("Please select a valid range (upper <= higher)");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

