/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.protein;

import com.compomics.util.Util;
import com.compomics.util.gui.protein.ModificationProfile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;

public class SequenceModificationPanel
extends JPanel {
    private HashMap<String, Rectangle> fragmentIonRectangles;
    private String[] iSequenceComponents;
    private ArrayList<ModificationProfile> profiles;
    private Font iBaseFont = new Font("Monospaced", 0, 14);
    private final double iMaxBarHeight = 20.0;
    private final int iBarWidth = 3;
    private final int iHorizontalSpace = 3;
    private final int iXStart = 30;
    private final int iYStart = 10;
    private boolean isModifiedSequence;
    private String score1Name;
    private String score2Name;

    public SequenceModificationPanel(String aSequence, ArrayList<ModificationProfile> profiles, boolean boolModifiedSequence, String score1Name, String score2Name) throws HeadlessException {
        this.score1Name = score1Name;
        this.score2Name = score2Name;
        this.isModifiedSequence = boolModifiedSequence;
        this.iSequenceComponents = this.parseSequenceIntoComponents(aSequence);
        this.profiles = profiles;
        this.setPreferredSize(new Dimension(this.estimateWidth(), this.estimateHeight()));
        this.setMaximumSize(new Dimension(this.estimateWidth(), this.estimateHeight()));
        this.fragmentIonRectangles = new HashMap();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                SequenceModificationPanel.this.mouseMovedHandler(me);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        int i;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.iBaseFont);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yLocation = 30;
        int xLocation = 30;
        int lFontHeight = g2.getFontMetrics().getHeight();
        Double lMidStringHeight = (double)yLocation - (double)lFontHeight * 0.2;
        Double aboveSequenceHeight = (double)yLocation - (double)lFontHeight * 0.5;
        Double belowSequenceHeight = (double)yLocation + (double)lFontHeight * 0.15;
        double maxAScore = 0.0;
        for (i = 0; i < this.iSequenceComponents.length; ++i) {
            for (int j = 0; j < this.profiles.size(); ++j) {
                ModificationProfile currentModificationProfile = this.profiles.get(j);
                if (!(maxAScore < currentModificationProfile.getProfile()[i][1])) continue;
                maxAScore = currentModificationProfile.getProfile()[i][1];
            }
        }
        for (i = 0; i < this.iSequenceComponents.length; ++i) {
            Rectangle tempRectangle;
            int barStart;
            int lBarHeight;
            ModificationProfile currentModificationProfile;
            int j;
            g2.setColor(Color.black);
            g2.setColor(Color.black);
            g2.drawString(this.iSequenceComponents[i], xLocation, yLocation);
            int tempXLocation = xLocation;
            if (i == 0) {
                xLocation += g2.getFontMetrics().stringWidth(this.iSequenceComponents[i]) - g2.getFontMetrics().stringWidth("X");
            }
            for (j = 0; j < this.profiles.size(); ++j) {
                currentModificationProfile = this.profiles.get(j);
                if (!(currentModificationProfile.getProfile()[i][1] > 0.0)) continue;
                g2.setColor(currentModificationProfile.getColor());
                lBarHeight = (int)(currentModificationProfile.getProfile()[i][1] / maxAScore * 20.0);
                if (lBarHeight < 5) {
                    lBarHeight = 7;
                }
                barStart = belowSequenceHeight.intValue() + 1;
                tempRectangle = new Rectangle(xLocation + 1, barStart, g2.getFontMetrics().stringWidth("X") - 2, lBarHeight);
                g2.fill(tempRectangle);
                this.fragmentIonRectangles.put(currentModificationProfile.getPtmName() + " (" + (i + 1) + ") [" + this.score2Name + ": " + Util.roundDouble(currentModificationProfile.getProfile()[i][1], 2) + "]", tempRectangle);
                g2.setColor(Color.black);
            }
            for (j = 0; j < this.profiles.size(); ++j) {
                currentModificationProfile = this.profiles.get(j);
                if (!(currentModificationProfile.getProfile()[i][0] > 0.0)) continue;
                g2.setColor(currentModificationProfile.getColor());
                lBarHeight = (int)(currentModificationProfile.getProfile()[i][0] / 100.0 * 20.0);
                if (lBarHeight < 5) {
                    lBarHeight = 7;
                }
                barStart = aboveSequenceHeight.intValue() - 2 - lBarHeight;
                tempRectangle = new Rectangle(xLocation + 1, barStart, g2.getFontMetrics().stringWidth("X") - 2, lBarHeight);
                g2.fill(tempRectangle);
                this.fragmentIonRectangles.put(currentModificationProfile.getPtmName() + " (" + (i + 1) + ") [" + this.score1Name + ": " + Util.roundDouble(currentModificationProfile.getProfile()[i][0], 2) + "]", tempRectangle);
                g2.setColor(Color.black);
            }
            xLocation = tempXLocation;
            xLocation = xLocation + g2.getFontMetrics().stringWidth(this.iSequenceComponents[i]) + 3;
            xLocation = xLocation + 3 + 3;
        }
        this.setPreferredSize(new Dimension(xLocation, 200));
    }

    private String[] parseSequenceIntoComponents(String aSequence) {
        String[] result;
        if (this.isModifiedSequence) {
            ArrayList<String> parts = new ArrayList<String>();
            String temp = aSequence;
            int start = 0;
            if (temp.startsWith("#")) {
                int nterm = temp.indexOf("#", start + 1);
                start = temp.indexOf("-", nterm);
            } else {
                start = temp.indexOf("-");
            }
            String part = temp.substring(0, ++start).trim();
            temp = temp.substring(start).trim();
            int endIndex = 1;
            if (temp.charAt(endIndex) == '<') {
                ++endIndex;
                while (temp.charAt(endIndex) != '>') {
                    ++endIndex;
                }
                ++endIndex;
            }
            part = part + temp.substring(0, endIndex);
            temp = temp.substring(endIndex);
            parts.add(part);
            while (temp.length() > 0) {
                start = 0;
                endIndex = 1;
                if (temp.charAt(start + endIndex) == '<') {
                    ++endIndex;
                    while (temp.charAt(start + endIndex) != '>') {
                        ++endIndex;
                    }
                    ++endIndex;
                }
                if (temp.charAt(start + endIndex) == '-') {
                    endIndex = temp.length();
                }
                part = temp.substring(0, endIndex);
                temp = temp.substring(endIndex);
                parts.add(part);
            }
            result = new String[parts.size()];
            parts.toArray(result);
        } else {
            result = new String[aSequence.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Character.toString(aSequence.charAt(i));
            }
        }
        return result;
    }

    private int estimateWidth() {
        int lEstimateX = 30;
        for (int i = 0; i < this.iSequenceComponents.length; ++i) {
            lEstimateX += this.getFontMetrics(this.iBaseFont).stringWidth(this.iSequenceComponents[i]) + 3;
            lEstimateX += 6;
        }
        return lEstimateX += 30;
    }

    private int estimateHeight() {
        int lEstimateY = 0;
        lEstimateY += 60;
        lEstimateY = (int)((double)lEstimateY + 36.0);
        return lEstimateY;
    }

    public void setSequence(String lSequence, boolean boolModifiedSequence) {
        this.isModifiedSequence = boolModifiedSequence;
        this.iSequenceComponents = this.parseSequenceIntoComponents(lSequence);
    }

    private void mouseMovedHandler(MouseEvent me) {
        String tooltip = null;
        Iterator<String> ions = this.fragmentIonRectangles.keySet().iterator();
        boolean matchFound = false;
        while (ions.hasNext() && !matchFound) {
            String key = ions.next();
            if (!this.fragmentIonRectangles.get(key).contains(me.getPoint())) continue;
            tooltip = key;
            matchFound = true;
        }
        this.setToolTipText(tooltip);
    }
}

