/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.ptm;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.gui.AminoAcidPatternDialog;
import com.compomics.util.gui.atoms.AtomChainDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.renderers.ToolTipComboBoxRenderer;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.pride.PtmToPrideMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;

public class PtmDialog
extends JDialog {
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private PTM currentPtm = null;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList();
    private ArrayList<ReporterIon> reporterIons = new ArrayList();
    private boolean editable;
    private AminoAcidPattern pattern;
    private AtomChain atomChainAdded;
    private AtomChain atomChainRemoved;
    private ArrayList<String> reporterIonTableToolTips;
    private ArrayList<String> neutralLossesTableToolTips;
    private boolean canceled = false;
    private JButton addNeutralLoss;
    private JButton addReporterIon;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel compositionLabel;
    private JTextField compositionTxt;
    private JLabel cvExampleLabel;
    private JPanel detailsPanel;
    private JButton helpJButton;
    private JLabel jLabel1;
    private JLabel massLabel;
    private JTextField massTxt;
    private JLabel nameLabel;
    private JLabel nameShortLabel;
    private JTextField nameShortTxt;
    private JTextField nameTxt;
    private JScrollPane neutralLossesJScrollPane;
    private JPanel neutralLossesPanel;
    private JTable neutralLossesTable;
    private JButton okButton;
    private JLabel patternLabel;
    private JTextField patternTxt;
    private JButton removeNeutralLoss;
    private JButton removerReporterIon;
    private JScrollPane reporterIonsJScrollPane;
    private JPanel reporterIonsPanel;
    private JTable reporterIonsTable;
    private JScrollPane scrollPane;
    private JPanel scrollPanePanel;
    private JComboBox typeCmb;
    private JTextField unimodAccessionJTextField;
    private JLabel unimodAccessionLabel;
    private JLabel unimodLinkLabel;
    private JPanel unimodMappingPanel;
    private JTextField unimodNameJTextField;
    private JLabel unimodNameLabel;

    public PtmDialog(JDialog parent, PTM currentPTM, boolean editable) {
        super((Dialog)parent, true);
        this.currentPtm = currentPTM;
        if (currentPTM != null) {
            this.pattern = this.currentPtm.getPattern();
            this.atomChainAdded = currentPTM.getAtomChainAdded();
            this.atomChainRemoved = currentPTM.getAtomChainRemoved();
        } else {
            this.pattern = null;
            this.atomChainAdded = new AtomChain();
            this.atomChainRemoved = new AtomChain();
        }
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public PtmDialog(JFrame parent, PtmToPrideMap ptmToPrideMap, PTM currentPTM, boolean editable) {
        super((Frame)parent, true);
        this.currentPtm = currentPTM;
        this.editable = editable;
        if (currentPTM != null) {
            this.pattern = this.currentPtm.getPattern();
            this.atomChainAdded = currentPTM.getAtomChainAdded();
            this.atomChainRemoved = currentPTM.getAtomChainRemoved();
        } else {
            this.pattern = null;
            this.atomChainAdded = new AtomChain();
            this.atomChainRemoved = new AtomChain();
        }
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.typeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.neutralLossesTable.getTableHeader().setReorderingAllowed(false);
        this.reporterIonsTable.getTableHeader().setReorderingAllowed(false);
        this.neutralLossesJScrollPane.getViewport().setOpaque(false);
        this.reporterIonsJScrollPane.getViewport().setOpaque(false);
        this.neutralLossesTable.getColumn(" ").setMaxWidth(50);
        this.neutralLossesTable.getColumn(" ").setMinWidth(50);
        this.neutralLossesTable.getColumn("Fixed").setMaxWidth(50);
        this.neutralLossesTable.getColumn("Fixed").setMinWidth(50);
        this.reporterIonsTable.getColumn(" ").setMaxWidth(50);
        this.reporterIonsTable.getColumn(" ").setMinWidth(50);
        this.neutralLossesTable.getColumn("Fixed").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green.png")), null, "Fixed", null));
        this.reporterIonTableToolTips = new ArrayList();
        this.reporterIonTableToolTips.add(null);
        this.reporterIonTableToolTips.add("Reporter Ion Name");
        this.reporterIonTableToolTips.add("Reporter Ion Composition");
        this.reporterIonTableToolTips.add("Reporter Ion Mass (m/z)");
        this.neutralLossesTableToolTips = new ArrayList();
        this.neutralLossesTableToolTips.add(null);
        this.neutralLossesTableToolTips.add("Neutral Loss Name");
        this.neutralLossesTableToolTips.add("Neutral Loss Composition");
        this.neutralLossesTableToolTips.add("Neutral Loss Mass");
        this.neutralLossesTableToolTips.add("Fixed Neutral Loss");
        Vector<String> comboboxTooltips = new Vector<String>();
        comboboxTooltips.add("Modification at particular amino acids");
        comboboxTooltips.add("Modification at the N terminus of a protein");
        comboboxTooltips.add("Modification at the N terminus of a protein at particular amino acids");
        comboboxTooltips.add("Modification at the C terminus of a protein");
        comboboxTooltips.add("Modification at the C terminus of a protein at particular amino acids");
        comboboxTooltips.add("Modification at the N terminus of a peptide");
        comboboxTooltips.add("Modification at the N terminus of a peptide at particular amino acids");
        comboboxTooltips.add("Modification at the C terminus of a peptide");
        comboboxTooltips.add("Modification at the C terminus of a peptide at particular amino acids");
        this.typeCmb.setRenderer(new ToolTipComboBoxRenderer(comboboxTooltips, 0));
        this.typeCmb.setEnabled(this.editable);
        this.nameTxt.setEditable(this.editable);
        this.nameShortTxt.setEditable(this.editable);
        this.addNeutralLoss.setEnabled(this.editable);
        this.removeNeutralLoss.setEnabled(this.editable);
        this.addReporterIon.setEnabled(this.editable);
        this.removerReporterIon.setEnabled(this.editable);
        this.patternTxt.setEditable(this.editable);
        this.unimodAccessionJTextField.setEditable(this.editable);
        this.unimodNameJTextField.setEditable(this.editable);
        if (this.currentPtm != null) {
            this.typeCmb.setSelectedIndex(this.currentPtm.getType());
            this.nameTxt.setText(this.currentPtm.getName());
            this.nameShortTxt.setText(this.currentPtm.getShortName());
            String addition = "";
            if (this.atomChainAdded != null) {
                addition = this.atomChainAdded.toString();
            }
            String deletion = "";
            if (this.atomChainRemoved != null) {
                deletion = "-" + this.atomChainRemoved.toString();
            }
            String temp = addition + " " + deletion;
            this.compositionTxt.setText(temp.trim());
            if (this.pattern != null) {
                this.patternTxt.setText(this.pattern.toString());
            }
            this.updateMass();
            if (!this.currentPtm.getNeutralLosses().isEmpty()) {
                for (NeutralLoss tempNeutralLoss : this.currentPtm.getNeutralLosses()) {
                    this.neutralLosses.add(tempNeutralLoss.clone());
                }
            }
            if (!this.currentPtm.getReporterIons().isEmpty()) {
                for (ReporterIon tempReporterIon : this.currentPtm.getReporterIons()) {
                    this.reporterIons.add(tempReporterIon.clone());
                }
            }
            this.updateTables();
            CvTerm cvTerm = this.currentPtm.getCvTerm();
            if (cvTerm != null) {
                this.updateModMappingText(cvTerm);
            }
            if (cvTerm == null) {
                this.unimodAccessionJTextField.setEditable(true);
                this.unimodNameJTextField.setEditable(true);
            }
            this.setTitle("Edit Modification");
        }
        this.validateInput(false);
    }

    private void updateMass() {
        try {
            double mass = 0.0;
            if (this.atomChainAdded != null) {
                mass += this.atomChainAdded.getMass();
            }
            if (this.atomChainRemoved != null) {
                mass -= this.atomChainRemoved.getMass();
            }
            this.massTxt.setText("" + Util.roundDouble(mass, 4));
        }
        catch (IllegalArgumentException e) {
            this.massTxt.setText("");
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private boolean validateInput(boolean showMessage) {
        int outcome;
        String newName;
        String name;
        boolean error = false;
        this.nameLabel.setForeground(Color.BLACK);
        this.compositionLabel.setForeground(Color.BLACK);
        this.patternLabel.setForeground(Color.BLACK);
        this.unimodAccessionLabel.setForeground(Color.BLACK);
        this.unimodNameLabel.setForeground(Color.BLACK);
        ((TitledBorder)this.neutralLossesPanel.getBorder()).setTitleColor(Color.BLACK);
        this.neutralLossesPanel.repaint();
        ((TitledBorder)this.reporterIonsPanel.getBorder()).setTitleColor(Color.BLACK);
        this.reporterIonsPanel.repaint();
        this.nameLabel.setToolTipText(null);
        this.nameTxt.setToolTipText(null);
        this.compositionLabel.setToolTipText(null);
        this.compositionTxt.setToolTipText(null);
        this.patternLabel.setToolTipText(null);
        this.patternTxt.setToolTipText(null);
        this.unimodAccessionLabel.setToolTipText(null);
        this.unimodAccessionJTextField.setToolTipText(null);
        this.neutralLossesPanel.setToolTipText(null);
        this.reporterIonsPanel.setToolTipText(null);
        if (this.compositionTxt.getText().trim().length() == 0) {
            error = true;
            this.compositionLabel.setForeground(Color.RED);
            this.compositionLabel.setToolTipText("Please provide a modification composition");
        }
        if ((name = this.nameTxt.getText().trim()).length() == 0) {
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Please provide a modification name");
            this.nameTxt.setToolTipText("Please provide a modification name");
        }
        if (name.lastIndexOf("|") != -1) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Modification names cannot contain '|'.");
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Modification names cannot contain '|'");
            this.nameTxt.setToolTipText("Modification names cannot contain '|'");
        }
        if (name.lastIndexOf(",") != -1) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Modification names cannot contain ','.");
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("Modification names cannot contain ','");
            this.nameTxt.setToolTipText("Modification names cannot contain ','");
        }
        if (name.contains("_")) {
            newName = name.replace("_", " ");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'_' should be avoided in modification names.\nShall " + name + " be replaced by " + newName + "?", "'_' in Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'_' should be avoided in modification names");
                    this.nameTxt.setToolTipText("'_' should be avoided in modification names");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'_' should be avoided in modification names");
                this.nameTxt.setToolTipText("'_' should be avoided in modification names");
            }
        }
        if (name.contains("-ATAA-")) {
            newName = name.replace("-ATAA-", "AT-AA");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'-ATAA-' should be avoided in modification names.\nShall " + name + " be replaced by " + newName + "?", "'-ATAA-' in Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'-ATAA-' should be avoided in modification names.");
                    this.nameTxt.setToolTipText("'-ATAA-' should be avoided in modification names.");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'-ATAA-' should be avoided in modification names.");
                this.nameTxt.setToolTipText("'-ATAA-' should be avoided in modification names.");
            }
        }
        if (name.contains("|single_aa")) {
            newName = name.replace("|single_aa", "SEARCH-ONLY");
            if (showMessage && !error) {
                outcome = JOptionPane.showConfirmDialog(this, "'|single_aa' should be avoided in the end of modification names.\nShall " + name + " be replaced by " + newName + "?", "'|single_aa' Ending Name", 0);
                if (outcome == 0) {
                    this.nameTxt.setText(newName);
                } else {
                    error = true;
                    this.nameLabel.setForeground(Color.RED);
                    this.nameLabel.setToolTipText("'|single_aa' should be avoided in modification names.");
                    this.nameTxt.setToolTipText("'|single_aa' should be avoided in modification names.");
                }
            } else {
                error = true;
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("'|single_aa' should be avoided in modification names.");
                this.nameTxt.setToolTipText("'|single_aa' should be avoided in modification names.");
            }
        }
        name = this.nameTxt.getText().trim();
        if (this.ptmFactory.getDefaultModifications().contains(name) && (this.currentPtm == null || !name.equals(this.currentPtm.getName()))) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "A modification named '" + name + "' already exists in the default modification lists.\nPlease select the default modification or use another name.", "Modification Already Exists", 2);
            } else {
                this.nameLabel.setForeground(Color.RED);
                this.nameLabel.setToolTipText("<html>A modification named '" + name + "' already exists in the default modification lists.<br>Please select the default modification or use another name.</html>");
                this.nameTxt.setToolTipText("<html>A modification named '" + name + "' already exists in the default modification lists.<br>Please select the default modification or use another name.</html>");
            }
            error = true;
        }
        if (this.ptmFactory.getUserModifications().contains(name) && (this.currentPtm == null || !name.equals(this.currentPtm.getName()))) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "There is already a modification named '" + name + "'!", "Modification Already Exists", 2);
            }
            error = true;
            this.nameLabel.setForeground(Color.RED);
            this.nameLabel.setToolTipText("There is already a modification named '" + name + "'!");
            this.nameTxt.setToolTipText("There is already a modification named '" + name + "'!");
        }
        if (this.patternTxt.getText().length() == 0 && (this.typeCmb.getSelectedIndex() == 0 || this.typeCmb.getSelectedIndex() == 2 || this.typeCmb.getSelectedIndex() == 4 || this.typeCmb.getSelectedIndex() == 6 || this.typeCmb.getSelectedIndex() == 8)) {
            if (showMessage && !error) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the modification pattern.", "Missing Pattern", 2);
            }
            error = true;
            this.patternLabel.setForeground(Color.RED);
            this.patternLabel.setToolTipText("Please provide a modification pattern");
            this.patternTxt.setToolTipText("Please provide a modification pattern");
        }
        if (!this.unimodAccessionJTextField.getText().trim().isEmpty()) {
            try {
                new Integer(this.unimodAccessionJTextField.getText().trim());
            }
            catch (NumberFormatException e) {
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "Please provide the Unimod accession number as an integer.", "Unimod Accession", 2);
                }
                error = true;
                this.unimodAccessionLabel.setForeground(Color.RED);
                this.unimodAccessionLabel.setToolTipText("Please provide the Unimod accession number as an integer");
                this.unimodAccessionJTextField.setToolTipText("Please provide the Unimod accession number as an integer");
            }
        }
        if (!this.neutralLosses.isEmpty()) {
            for (NeutralLoss tempNeutralLoss : this.neutralLosses) {
                NeutralLoss existingNeutralLoss = NeutralLoss.getNeutralLoss(tempNeutralLoss.name);
                if (existingNeutralLoss == null || tempNeutralLoss.isSameAs(existingNeutralLoss)) continue;
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "A neutral loss named '" + tempNeutralLoss.name + "' already exists. Please choose a different name.", "Neutral Loss", 2);
                }
                error = true;
                ((TitledBorder)this.neutralLossesPanel.getBorder()).setTitleColor(Color.RED);
                this.neutralLossesPanel.setToolTipText("A neutral loss named '" + tempNeutralLoss.name + "' already exists");
                this.neutralLossesPanel.repaint();
            }
        }
        if (!this.reporterIons.isEmpty()) {
            for (ReporterIon tempReporterIon : this.reporterIons) {
                ReporterIon existingReporterIon = ReporterIon.getReporterIon(tempReporterIon.getName());
                if (existingReporterIon == null || tempReporterIon.isSameAs(existingReporterIon)) continue;
                if (showMessage && !error) {
                    JOptionPane.showMessageDialog(this, "A reporter ion named '" + tempReporterIon.getName() + "' already exists. Please choose a different name.", "Reporter Ion", 2);
                }
                error = true;
                ((TitledBorder)this.reporterIonsPanel.getBorder()).setTitleColor(Color.RED);
                this.reporterIonsPanel.setToolTipText("A reporter ion named '" + tempReporterIon.getName() + "' already exists");
                this.reporterIonsPanel.repaint();
            }
        }
        this.okButton.setEnabled(!error);
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.helpJButton = new JButton();
        this.cancelButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.scrollPanePanel = new JPanel();
        this.unimodMappingPanel = new JPanel();
        this.unimodAccessionJTextField = new JTextField();
        this.unimodAccessionLabel = new JLabel();
        this.unimodNameLabel = new JLabel();
        this.unimodNameJTextField = new JTextField();
        this.unimodLinkLabel = new JLabel();
        this.cvExampleLabel = new JLabel();
        this.reporterIonsPanel = new JPanel();
        this.reporterIonsJScrollPane = new JScrollPane();
        this.reporterIonsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PtmDialog.this.reporterIonTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.removerReporterIon = new JButton();
        this.addReporterIon = new JButton();
        this.detailsPanel = new JPanel();
        this.typeCmb = new JComboBox();
        this.jLabel1 = new JLabel();
        this.nameLabel = new JLabel();
        this.nameTxt = new JTextField();
        this.compositionTxt = new JTextField();
        this.patternLabel = new JLabel();
        this.patternTxt = new JTextField();
        this.nameShortLabel = new JLabel();
        this.nameShortTxt = new JTextField();
        this.compositionLabel = new JLabel();
        this.massLabel = new JLabel();
        this.massTxt = new JTextField();
        this.neutralLossesPanel = new JPanel();
        this.neutralLossesJScrollPane = new JScrollPane();
        this.neutralLossesTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PtmDialog.this.neutralLossesTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.addNeutralLoss = new JButton();
        this.removeNeutralLoss = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Modification");
        this.setMinimumSize(new Dimension(500, 500));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PtmDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PtmDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.scrollPane.setBorder(null);
        this.scrollPanePanel.setBackground(new Color(230, 230, 230));
        this.unimodMappingPanel.setBorder(BorderFactory.createTitledBorder("Unimod Mapping"));
        this.unimodMappingPanel.setOpaque(false);
        this.unimodAccessionJTextField.setEditable(false);
        this.unimodAccessionJTextField.setHorizontalAlignment(0);
        this.unimodAccessionJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PtmDialog.this.unimodAccessionJTextFieldKeyReleased(evt);
            }
        });
        this.unimodAccessionLabel.setText("Accession");
        this.unimodNameLabel.setText("PSI-MS Name");
        this.unimodNameJTextField.setEditable(false);
        this.unimodNameJTextField.setHorizontalAlignment(0);
        this.unimodNameJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PtmDialog.this.unimodNameJTextFieldKeyReleased(evt);
            }
        });
        this.unimodLinkLabel.setText("<html><a href>See: http://www.unimod.org</a></html>");
        this.unimodLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PtmDialog.this.unimodLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PtmDialog.this.unimodLinkLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.unimodLinkLabelMouseReleased(evt);
            }
        });
        this.cvExampleLabel.setFont(this.cvExampleLabel.getFont().deriveFont(this.cvExampleLabel.getFont().getStyle() | 2));
        this.cvExampleLabel.setText("Ex.: Accession:1, PSI-MS Name: Acetyl");
        GroupLayout unimodMappingPanelLayout = new GroupLayout(this.unimodMappingPanel);
        this.unimodMappingPanel.setLayout(unimodMappingPanelLayout);
        unimodMappingPanelLayout.setHorizontalGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unimodMappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unimodNameLabel, -2, 90, -2).addComponent(this.unimodAccessionLabel, -2, 90, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(unimodMappingPanelLayout.createSequentialGroup().addComponent(this.cvExampleLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.unimodLinkLabel, -2, -1, -2)).addComponent(this.unimodAccessionJTextField).addComponent(this.unimodNameJTextField, GroupLayout.Alignment.LEADING)).addContainerGap()));
        unimodMappingPanelLayout.setVerticalGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unimodMappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unimodAccessionJTextField, -2, -1, -2).addComponent(this.unimodAccessionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unimodNameJTextField, -2, -1, -2).addComponent(this.unimodNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(unimodMappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unimodLinkLabel, -2, -1, -2).addComponent(this.cvExampleLabel, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.reporterIonsPanel.setBorder(BorderFactory.createTitledBorder("Reporter Ions"));
        this.reporterIonsPanel.setOpaque(false);
        this.reporterIonsTable.setModel(new ReporterIonsTable());
        this.reporterIonsTable.setSelectionMode(0);
        this.reporterIonsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.reporterIonsTableMouseReleased(evt);
            }
        });
        this.reporterIonsJScrollPane.setViewportView(this.reporterIonsTable);
        this.removerReporterIon.setText("Remove");
        this.removerReporterIon.setToolTipText("Remove the selected reporter ion");
        this.removerReporterIon.setEnabled(false);
        this.removerReporterIon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.removerReporterIonActionPerformed(evt);
            }
        });
        this.addReporterIon.setText("Add");
        this.addReporterIon.setToolTipText("Add a reporter ion");
        this.addReporterIon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.addReporterIonActionPerformed(evt);
            }
        });
        GroupLayout reporterIonsPanelLayout = new GroupLayout(this.reporterIonsPanel);
        this.reporterIonsPanel.setLayout(reporterIonsPanelLayout);
        reporterIonsPanelLayout.setHorizontalGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterIonsPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addReporterIon, -1, -1, Short.MAX_VALUE).addComponent(this.removerReporterIon, -2, 90, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.reporterIonsJScrollPane, -2, 0, Short.MAX_VALUE).addContainerGap()));
        reporterIonsPanelLayout.setVerticalGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterIonsPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterIonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reporterIonsJScrollPane, -2, 0, Short.MAX_VALUE).addGroup(reporterIonsPanelLayout.createSequentialGroup().addGap(0, 33, Short.MAX_VALUE).addComponent(this.addReporterIon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removerReporterIon))).addContainerGap()));
        this.detailsPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.detailsPanel.setOpaque(false);
        this.typeCmb.setMaximumRowCount(15);
        this.typeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Particular Amino Acid", "Protein N-term", "Protein N-term - Particular Amino Acid(s)", "Protein C-term", "Protein C-term - Particular Amino Acid(s)", "Peptide N-term", "Peptide N-term - Particular Amino Acid(s)", "Peptide C-term", "Peptide C-term - Particular Amino Acid(s)"}));
        this.typeCmb.setToolTipText("The modification type. See help for details.");
        this.typeCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.typeCmbActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Type");
        this.jLabel1.setToolTipText("The modification type. See help for details.");
        this.nameLabel.setText("Name");
        this.nameLabel.setToolTipText("The modification name");
        this.nameTxt.setEditable(false);
        this.nameTxt.setHorizontalAlignment(0);
        this.nameTxt.setToolTipText("The modification name");
        this.nameTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PtmDialog.this.nameTxtKeyReleased(evt);
            }
        });
        this.compositionTxt.setEditable(false);
        this.compositionTxt.setHorizontalAlignment(0);
        this.compositionTxt.setToolTipText("Monoisotopic mass in Dalton");
        this.compositionTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.compositionTxtMouseReleased(evt);
            }
        });
        this.patternLabel.setText("Pattern");
        this.patternLabel.setToolTipText("Residues modified");
        this.patternTxt.setEditable(false);
        this.patternTxt.setHorizontalAlignment(0);
        this.patternTxt.setToolTipText("Residues modified");
        this.patternTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.patternTxtMouseReleased(evt);
            }
        });
        this.nameShortLabel.setText("Short Name");
        this.nameShortLabel.setToolTipText("The modification name");
        this.nameShortTxt.setEditable(false);
        this.nameShortTxt.setHorizontalAlignment(0);
        this.nameShortTxt.setToolTipText("The modification name");
        this.nameShortTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PtmDialog.this.nameShortTxtKeyReleased(evt);
            }
        });
        this.compositionLabel.setText("Composition");
        this.massLabel.setText("Mass");
        this.massLabel.setToolTipText("Monoisotopic mass");
        this.massTxt.setEditable(false);
        this.massTxt.setHorizontalAlignment(0);
        this.massTxt.setToolTipText("Monoisotopic mass in Dalton");
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameLabel, -1, 90, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 90, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeCmb, 0, -1, Short.MAX_VALUE).addComponent(this.nameTxt))).addGroup(detailsPanelLayout.createSequentialGroup().addComponent(this.patternLabel, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.patternTxt)).addGroup(detailsPanelLayout.createSequentialGroup().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameShortLabel, -2, 90, -2).addComponent(this.compositionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addComponent(this.compositionTxt).addGap(18, 18, 18).addComponent(this.massLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.massTxt, -2, 116, -2)).addComponent(this.nameShortTxt, -1, 444, Short.MAX_VALUE)))).addContainerGap()));
        detailsPanelLayout.linkSize(0, this.jLabel1, this.nameLabel, this.nameShortLabel, this.patternLabel);
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeCmb, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTxt, -2, -1, -2).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameShortTxt, -2, -1, -2).addComponent(this.nameShortLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compositionTxt, -2, -1, -2).addComponent(this.compositionLabel).addComponent(this.massLabel).addComponent(this.massTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patternTxt, -2, -1, -2).addComponent(this.patternLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.neutralLossesPanel.setBorder(BorderFactory.createTitledBorder("Neutral Losses"));
        this.neutralLossesPanel.setOpaque(false);
        this.neutralLossesTable.setModel(new NeutralLossesTable());
        this.neutralLossesTable.setSelectionMode(0);
        this.neutralLossesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PtmDialog.this.neutralLossesTableMouseReleased(evt);
            }
        });
        this.neutralLossesJScrollPane.setViewportView(this.neutralLossesTable);
        this.addNeutralLoss.setText("Add");
        this.addNeutralLoss.setToolTipText("Add a neutral loss");
        this.addNeutralLoss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.addNeutralLossActionPerformed(evt);
            }
        });
        this.removeNeutralLoss.setText("Remove");
        this.removeNeutralLoss.setToolTipText("Remove the selected neutral loss");
        this.removeNeutralLoss.setEnabled(false);
        this.removeNeutralLoss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmDialog.this.removeNeutralLossActionPerformed(evt);
            }
        });
        GroupLayout neutralLossesPanelLayout = new GroupLayout(this.neutralLossesPanel);
        this.neutralLossesPanel.setLayout(neutralLossesPanelLayout);
        neutralLossesPanelLayout.setHorizontalGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossesPanelLayout.createSequentialGroup().addContainerGap().addGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addNeutralLoss, -2, 90, -2).addComponent(this.removeNeutralLoss, -2, 90, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.neutralLossesJScrollPane, -2, 0, Short.MAX_VALUE).addContainerGap()));
        neutralLossesPanelLayout.setVerticalGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(neutralLossesPanelLayout.createSequentialGroup().addContainerGap().addGroup(neutralLossesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.neutralLossesJScrollPane, -2, 0, Short.MAX_VALUE).addGroup(neutralLossesPanelLayout.createSequentialGroup().addGap(0, 33, Short.MAX_VALUE).addComponent(this.addNeutralLoss).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeNeutralLoss))).addContainerGap()));
        GroupLayout scrollPanePanelLayout = new GroupLayout(this.scrollPanePanel);
        this.scrollPanePanel.setLayout(scrollPanePanelLayout);
        scrollPanePanelLayout.setHorizontalGroup(scrollPanePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.detailsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.neutralLossesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.unimodMappingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.reporterIonsPanel, -1, -1, Short.MAX_VALUE));
        scrollPanePanelLayout.setVerticalGroup(scrollPanePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scrollPanePanelLayout.createSequentialGroup().addComponent(this.detailsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.neutralLossesPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reporterIonsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unimodMappingPanel, -2, -1, -2)));
        this.scrollPane.setViewportView(this.scrollPanePanel);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane).addGap(11, 11, 11).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            if (this.editable) {
                boolean cvTermOk = true;
                if (!this.unimodNameJTextField.getText().trim().isEmpty()) {
                    try {
                        new Integer(this.unimodAccessionJTextField.getText().trim());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(this, "Please provide the Unimod accession number as an integer.", "Unimod Accession", 2);
                        cvTermOk = false;
                        this.unimodAccessionLabel.setForeground(Color.RED);
                        this.unimodAccessionLabel.setToolTipText("Please provide the Unimod accession number as an integer");
                        this.unimodAccessionJTextField.setToolTipText("Please provide the Unimod accession number as an integer");
                    }
                } else {
                    cvTermOk = false;
                    int option = JOptionPane.showConfirmDialog(this, "Adding a controlled vocabulary mapping is strongly recommended. This\nis for example mandatory when exporting the data to mzIdentML.\n\nContinue without such a mapping?", "Modification Controlled Vocabulary", 1, 2);
                    if (option != 0) {
                        return;
                    }
                }
                CvTerm cvTerm = null;
                if (cvTermOk) {
                    int unimodAccession = new Integer(this.unimodAccessionJTextField.getText().trim());
                    cvTerm = new CvTerm("UNIMOD", "UNIMOD:" + unimodAccession, this.unimodNameJTextField.getText().trim(), null);
                }
                PTM newPTM = new PTM(this.typeCmb.getSelectedIndex(), this.nameTxt.getText().trim(), this.nameShortTxt.getText().trim().toLowerCase(), this.atomChainAdded, this.atomChainRemoved, this.pattern, cvTerm);
                newPTM.setNeutralLosses(this.neutralLosses);
                newPTM.setReporterIons(this.reporterIons);
                for (String ptm : this.ptmFactory.getPTMs()) {
                    int outcome;
                    PTM otherPTM;
                    if (this.currentPtm != null && ptm.equals(this.currentPtm.getName()) || !newPTM.isSameAs(otherPTM = this.ptmFactory.getPTM(ptm)) || (outcome = JOptionPane.showConfirmDialog(this, "The modification '" + ptm + "' presents characteristics similar to your input.\nAre you sure you want to create this new modification?", "Modification Already Exists", 0)) != 1) continue;
                    return;
                }
                this.ptmFactory.addUserPTM(newPTM);
            }
            this.saveChanges();
            this.dispose();
        }
    }

    private void typeCmbActionPerformed(ActionEvent evt) {
        if (this.typeCmb.getSelectedIndex() == 0 || this.typeCmb.getSelectedIndex() == 2 || this.typeCmb.getSelectedIndex() == 4 || this.typeCmb.getSelectedIndex() == 6 || this.typeCmb.getSelectedIndex() == 8) {
            this.patternTxt.setEnabled(true);
        } else {
            this.pattern = null;
            this.patternTxt.setText(null);
            this.patternTxt.setEnabled(false);
        }
        this.validateInput(false);
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/PtmDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), null, "New Modification - Help");
        this.setCursor(new Cursor(0));
    }

    private void addNeutralLossActionPerformed(ActionEvent evt) {
        this.neutralLosses.add(new NeutralLoss("new neutral loss", new AtomChain(), false, null, false));
        this.updateTables();
    }

    private void addReporterIonActionPerformed(ActionEvent evt) {
        this.reporterIons.add(new ReporterIon("New reporter ion", 0.0, false));
        this.updateTables();
    }

    private void removeNeutralLossActionPerformed(ActionEvent evt) {
        int row = this.neutralLossesTable.getSelectedRow();
        if (row != -1) {
            int index = this.neutralLossesTable.convertRowIndexToModel(row);
            this.neutralLosses.remove(index);
            this.updateTables();
        }
        this.removeNeutralLoss.setEnabled((row = this.neutralLossesTable.getSelectedRow()) != -1);
    }

    private void removerReporterIonActionPerformed(ActionEvent evt) {
        int row = this.reporterIonsTable.getSelectedRow();
        if (row != -1) {
            int index = this.reporterIonsTable.convertRowIndexToModel(row);
            this.reporterIons.remove(index);
            this.updateTables();
        }
        this.removerReporterIon.setEnabled((row = this.reporterIonsTable.getSelectedRow()) != -1);
    }

    private void neutralLossesTableMouseReleased(MouseEvent evt) {
        int row;
        NeutralLoss neutralLoss;
        AtomChain atomChain;
        AtomChainDialog atomChainDialog;
        int column;
        if (this.editable) {
            int row2 = this.neutralLossesTable.getSelectedRow();
            this.removeNeutralLoss.setEnabled(row2 != -1);
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2 && this.editable && ((column = this.neutralLossesTable.columnAtPoint(evt.getPoint())) == 2 || column == 3) && !(atomChainDialog = new AtomChainDialog(this, atomChain = (neutralLoss = this.neutralLosses.get(row = this.neutralLossesTable.rowAtPoint(evt.getPoint()))).getComposition(), new AtomChain(), true)).isCanceled()) {
            atomChain = atomChainDialog.getAtomChainAdded();
            if (atomChain.size() > 0) {
                neutralLoss.setComposition(atomChain);
            }
            this.updateTables();
        }
    }

    private void reporterIonsTableMouseReleased(MouseEvent evt) {
        int row;
        ReporterIon reporterIon;
        AtomChain atomChain;
        AtomChainDialog atomChainDialog;
        int column;
        if (this.editable) {
            int row2 = this.reporterIonsTable.getSelectedRow();
            this.removerReporterIon.setEnabled(row2 != -1);
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2 && this.editable && ((column = this.reporterIonsTable.columnAtPoint(evt.getPoint())) == 2 || column == 3) && !(atomChainDialog = new AtomChainDialog(this, atomChain = (reporterIon = this.reporterIons.get(row = this.reporterIonsTable.rowAtPoint(evt.getPoint()))).getAtomicComposition(), new AtomChain(), true)).isCanceled()) {
            atomChain = atomChainDialog.getAtomChainAdded();
            if (atomChain.size() > 0) {
                reporterIon.setAtomicComposition(atomChain);
            }
            this.updateTables();
        }
    }

    private void patternTxtMouseReleased(MouseEvent evt) {
        AminoAcidPatternDialog dialog;
        if (this.editable && this.patternTxt.isEnabled() && evt.getButton() == 1 && !(dialog = new AminoAcidPatternDialog(null, this.pattern, this.editable)).isCanceled()) {
            this.pattern = dialog.getPattern();
            this.patternTxt.setText(this.pattern.toString());
            this.validateInput(false);
        }
    }

    private void nameTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void unimodLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void unimodLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void unimodLinkLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.unimod.org");
        this.setCursor(new Cursor(0));
    }

    private void unimodAccessionJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void unimodNameJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void nameShortTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void compositionTxtMouseReleased(MouseEvent evt) {
        if (this.editable) {
            AtomChainDialog atomChainDialog = new AtomChainDialog(this, this.atomChainAdded, this.atomChainRemoved, false);
            if (!atomChainDialog.isCanceled()) {
                this.atomChainAdded = atomChainDialog.getAtomChainAdded();
                this.atomChainRemoved = atomChainDialog.getAtomChainRemoved();
                String addition = "";
                if (this.atomChainAdded.size() > 0) {
                    addition = this.atomChainAdded.toString();
                }
                String deletion = "";
                if (this.atomChainRemoved.size() > 0) {
                    deletion = "-" + this.atomChainRemoved.toString();
                }
                String temp = addition + " " + deletion;
                this.compositionTxt.setText(temp.trim());
            }
            this.validateInput(false);
            this.updateMass();
        }
    }

    private void updateModMappingText(CvTerm cvTerm) {
        this.unimodAccessionJTextField.setText(cvTerm.getAccession().substring("Unimod:".length()));
        this.unimodNameJTextField.setText(cvTerm.getName());
        this.unimodNameJTextField.setCaretPosition(0);
    }

    private void updateTables() {
        ((DefaultTableModel)this.neutralLossesTable.getModel()).fireTableDataChanged();
        ((DefaultTableModel)this.reporterIonsTable.getModel()).fireTableDataChanged();
        this.validateInput(false);
    }

    private void saveChanges() {
        try {
            this.ptmFactory.saveFactory();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the modification.", "Saving Error", 2);
        }
    }

    private class ReporterIonsTable
    extends DefaultTableModel {
        private ReporterIonsTable() {
        }

        @Override
        public int getRowCount() {
            return PtmDialog.this.reporterIons.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Composition";
                }
                case 3: {
                    return "Mass";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ((ReporterIon)PtmDialog.this.reporterIons.get(row)).getName();
                }
                case 2: {
                    ReporterIon reporterIon = (ReporterIon)PtmDialog.this.reporterIons.get(row);
                    if (reporterIon.getAtomicComposition() != null) {
                        return reporterIon.getAtomicComposition().toString();
                    }
                    return "";
                }
                case 3: {
                    ReporterIon reporterIon = (ReporterIon)PtmDialog.this.reporterIons.get(row);
                    return reporterIon.getTheoreticMz(1);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && PtmDialog.this.editable;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            int index = PtmDialog.this.reporterIonsTable.convertRowIndexToModel(row);
            ReporterIon reporterIon = (ReporterIon)PtmDialog.this.reporterIons.get(index);
            if (column == 1) {
                reporterIon.setName((String)aValue);
            }
        }
    }

    private class NeutralLossesTable
    extends DefaultTableModel {
        private NeutralLossesTable() {
        }

        @Override
        public int getRowCount() {
            return PtmDialog.this.neutralLosses.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Composition";
                }
                case 3: {
                    return "Mass";
                }
                case 4: {
                    return "Fixed";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ((NeutralLoss)((PtmDialog)PtmDialog.this).neutralLosses.get((int)row)).name;
                }
                case 2: {
                    NeutralLoss neutralLoss = (NeutralLoss)PtmDialog.this.neutralLosses.get(row);
                    if (neutralLoss.getComposition() != null) {
                        return neutralLoss.getComposition().toString();
                    }
                    return "";
                }
                case 3: {
                    NeutralLoss neutralLoss = (NeutralLoss)PtmDialog.this.neutralLosses.get(row);
                    return neutralLoss.getMass();
                }
                case 4: {
                    return ((NeutralLoss)PtmDialog.this.neutralLosses.get(row)).isFixed();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return (columnIndex == 1 || columnIndex == 4) && PtmDialog.this.editable;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            int index = PtmDialog.this.neutralLossesTable.convertRowIndexToModel(row);
            NeutralLoss neutralLoss = (NeutralLoss)PtmDialog.this.neutralLosses.get(index);
            if (column == 1) {
                String newName = aValue.toString();
                NeutralLoss newLoss = new NeutralLoss(newName, neutralLoss.getComposition(), neutralLoss.isFixed());
                PtmDialog.this.neutralLosses.set(index, newLoss);
            } else if (column == 4) {
                neutralLoss.setFixed((Boolean)aValue);
            }
        }
    }
}

