/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.MassGap;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.gui.interfaces.SpectrumAnnotation;
import com.compomics.util.gui.spectrum.GraphicsPanel;
import com.compomics.util.gui.spectrum.ReferenceArea;
import com.compomics.util.interfaces.SpectrumFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import org.apache.log4j.Logger;

public class SpectrumPanel
extends GraphicsPanel {
    static Logger logger = Logger.getLogger(SpectrumPanel.class);
    private Color spectrumPeakColor = Color.RED;
    private Color spectrumProfileModeLineColor = Color.PINK;
    private static HashMap<Ion.IonType, HashMap<Integer, HashMap<String, Color>>> colorMap = new HashMap();

    public SpectrumPanel(SpectrumFile aSpecFile) {
        this(aSpecFile, GraphicsPanel.DrawingStyle.LINES, true);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, boolean aEnableInteraction) {
        this(aSpecFile, GraphicsPanel.DrawingStyle.LINES, aEnableInteraction);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, GraphicsPanel.DrawingStyle aDrawStyle, boolean aEnableInteraction) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, null);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, GraphicsPanel.DrawingStyle aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, 50, false, true, true);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, GraphicsPanel.DrawingStyle aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, aMaxPadding, aShowFileName, true, true);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, GraphicsPanel.DrawingStyle aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, 0);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, GraphicsPanel.DrawingStyle aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel) {
        this(aSpecFile, aDrawStyle, aEnableInteraction, aSpectrumFilenameColor, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, aMSLevel, false);
    }

    public SpectrumPanel(SpectrumFile aSpecFile, GraphicsPanel.DrawingStyle aDrawStyle, boolean aEnableInteraction, Color aSpectrumFilenameColor, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel, boolean aProfileMode) {
        this.iCurrentDrawStyle = aDrawStyle;
        this.iSpecPanelListeners = new ArrayList();
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBackground(Color.WHITE);
        if (aSpecFile != null) {
            this.dataSetCounter = 0;
            this.processSpectrumFile(aSpecFile, this.spectrumPeakColor, this.spectrumProfileModeLineColor);
        }
        if (aEnableInteraction) {
            this.addListeners();
        }
        this.iFilenameColor = aSpectrumFilenameColor;
        this.maxPadding = aMaxPadding;
        this.showFileName = aShowFileName;
        this.showPrecursorDetails = aShowPrecursorDetails;
        this.showResolution = aShowResolution;
        this.iMSLevel = aMSLevel;
        this.currentGraphicsPanelType = aProfileMode ? GraphicsPanel.GraphicsPanelType.profileSpectrum : GraphicsPanel.GraphicsPanelType.centroidSpectrum;
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, 50, false, true, true);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, boolean aShowFileName) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, 50, aShowFileName, true, true);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, aMaxPadding, aShowFileName, true, true);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, 0);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel) {
        this(aXAxisData, aYAxisData, aPrecursorMZ, aPrecursorCharge, aFileName, aMaxPadding, aShowFileName, aShowPrecursorDetails, aShowResolution, aMSLevel, false);
    }

    public SpectrumPanel(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, int aMaxPadding, boolean aShowFileName, boolean aShowPrecursorDetails, boolean aShowResolution, int aMSLevel, boolean aProfileMode) {
        this.iCurrentDrawStyle = GraphicsPanel.DrawingStyle.LINES;
        this.iSpecPanelListeners = new ArrayList();
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBackground(Color.WHITE);
        this.dataSetCounter = 0;
        this.processXAndYData(aXAxisData, aYAxisData, this.spectrumPeakColor, this.spectrumProfileModeLineColor);
        this.iPrecursorMZ = aPrecursorMZ;
        this.iPrecursorCharge = aPrecursorCharge;
        this.iFilename = aFileName;
        this.maxPadding = aMaxPadding;
        this.showFileName = aShowFileName;
        this.showPrecursorDetails = aShowPrecursorDetails;
        this.showResolution = aShowResolution;
        this.iMSLevel = aMSLevel;
        this.currentGraphicsPanelType = aProfileMode ? GraphicsPanel.GraphicsPanelType.profileSpectrum : GraphicsPanel.GraphicsPanelType.centroidSpectrum;
        this.addListeners();
    }

    public void addMirroredSpectrum(double[] aXAxisData, double[] aYAxisData, double aPrecursorMZ, String aPrecursorCharge, String aFileName, boolean aProfileMode, Color aSpectrumPeakColor, Color aSpectrumProfileModeLineColor) {
        this.iPrecursorMZMirroredSpectrum = aPrecursorMZ;
        this.iPrecursorChargeMirorredSpectrum = aPrecursorCharge;
        this.iFilenameMirrorredSpectrum = aFileName;
        this.processMirroredXAndYData(aXAxisData, aYAxisData, aSpectrumPeakColor, aSpectrumProfileModeLineColor);
        this.currentGraphicsPanelType = aProfileMode ? GraphicsPanel.GraphicsPanelType.profileSpectrum : GraphicsPanel.GraphicsPanelType.centroidSpectrum;
        this.showFileName = false;
        this.showPrecursorDetails = false;
        this.showResolution = false;
        this.yAxisZoomExcludesBackgroundPeaks = false;
        this.yDataIsPositive = false;
    }

    public void addAdditionalDataset(double[] aXAxisData, double[] aYAxisData, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        this.processXAndYData(aXAxisData, aYAxisData, dataPointAndLineColor, areaUnderCurveColor);
        this.showFileName = false;
        this.showPrecursorDetails = false;
        this.showResolution = false;
    }

    public void addAdditionalMirroredDataset(double[] aXAxisData, double[] aYAxisData, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        this.processMirroredXAndYData(aXAxisData, aYAxisData, dataPointAndLineColor, areaUnderCurveColor);
        this.showFileName = false;
        this.showPrecursorDetails = false;
        this.showResolution = false;
    }

    public void setProfileMode(boolean aProfileMode) {
        this.currentGraphicsPanelType = aProfileMode ? GraphicsPanel.GraphicsPanelType.profileSpectrum : GraphicsPanel.GraphicsPanelType.centroidSpectrum;
    }

    public void setSpectrumPeakColor(Color aSpectrumPeakColor) {
        this.spectrumPeakColor = aSpectrumPeakColor;
    }

    public void setSpectrumProfileModeLineColor(Color aSpectrumProfileModeLineColor) {
        this.spectrumProfileModeLineColor = aSpectrumProfileModeLineColor;
    }

    public void showAnnotatedPeaksOnly(boolean aAnnotatedPeaks) {
        this.showAllPeaks = !aAnnotatedPeaks;
    }

    public void setSpectrumFile(SpectrumFile aSpecFile) {
        this.processSpectrumFile(aSpecFile, this.spectrumPeakColor, this.spectrumProfileModeLineColor);
    }

    private void processSpectrumFile(SpectrumFile aSpecFile, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        if (this.dataSetCounter == 0) {
            this.iXAxisData = new ArrayList();
            this.iYAxisData = new ArrayList();
        }
        this.iDataPointAndLineColor.add(dataPointAndLineColor);
        this.iAreaUnderCurveColor.add(areaUnderCurveColor);
        HashMap peaks = aSpecFile.getPeaks();
        this.iXAxisData.add(new double[peaks.size()]);
        this.iYAxisData.add(new double[peaks.size()]);
        this.iFilename = aSpecFile.getFilename();
        double maxInt = 0.0;
        TreeSet masses = new TreeSet(peaks.keySet());
        Iterator iter = masses.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Double key = (Double)iter.next();
            double mass = key;
            double intensity = (Double)peaks.get(key);
            if (intensity > maxInt) {
                maxInt = intensity;
            }
            ((double[])this.iXAxisData.get((int)this.dataSetCounter))[count] = mass;
            ((double[])this.iYAxisData.get((int)this.dataSetCounter))[count] = intensity;
            ++count;
        }
        if (this.iXAxisStartAtZero) {
            this.rescale(0.0, this.getMaxXAxisValue());
        } else {
            this.rescale(this.getMinXAxisValue(), this.getMaxXAxisValue());
        }
        this.iPrecursorMZ = aSpecFile.getPrecursorMZ();
        int liTemp = aSpecFile.getCharge();
        if (liTemp == 0) {
            this.iPrecursorCharge = "?";
        } else {
            this.iPrecursorCharge = Integer.toString(liTemp);
            this.iPrecursorCharge = this.iPrecursorCharge + (liTemp > 0 ? "+" : "-");
        }
        ++this.dataSetCounter;
    }

    public static Color determineColorOfPeak(String peakLabel) {
        Color currentColor = Color.GRAY;
        if (peakLabel.startsWith("a")) {
            currentColor = new Color(153, 0, 0);
            if (peakLabel.lastIndexOf("H2O") != -1 || peakLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(171, 161, 255);
            } else if (peakLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(248, 151, 202);
            }
        } else if (peakLabel.startsWith("b")) {
            currentColor = new Color(0, 0, 255);
            if (peakLabel.lastIndexOf("H2O") != -1 || peakLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(0, 125, 200);
            } else if (peakLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(153, 0, 255);
            }
        } else if (peakLabel.startsWith("c")) {
            currentColor = new Color(188, 0, 255);
        } else if (peakLabel.startsWith("x")) {
            currentColor = new Color(78, 200, 0);
        } else if (peakLabel.startsWith("y")) {
            currentColor = new Color(0, 0, 0);
            if (peakLabel.lastIndexOf("H2O") != -1 || peakLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(0, 70, 135);
            } else if (peakLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(155, 0, 155);
            }
        } else if (peakLabel.startsWith("z")) {
            currentColor = new Color(64, 179, 0);
        } else if (peakLabel.startsWith("Prec") || peakLabel.startsWith("MH")) {
            currentColor = Color.gray;
        } else if (peakLabel.startsWith("i")) {
            currentColor = Color.gray;
        }
        return currentColor;
    }

    public static Vector<SpectrumAnnotation> filterAnnotations(Vector<SpectrumAnnotation> annotations, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<NeutralLoss> neutralLosses, boolean singleChargeSelected, boolean doubleChargeSelected, boolean moreThanTwoChargesSelected) {
        Vector<SpectrumAnnotation> filteredAnnotations = new Vector<SpectrumAnnotation>();
        for (SpectrumAnnotation annotation : annotations) {
            String currentLabel = annotation.getLabel();
            boolean useAnnotation = false;
            if (currentLabel.startsWith("a")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(0)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("b")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(1)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("c")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(2)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("x")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(3)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("y")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(4)) {
                    useAnnotation = true;
                }
            } else if (currentLabel.startsWith("z")) {
                if (iontypes.containsKey((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && iontypes.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION).contains(5)) {
                    useAnnotation = true;
                }
            } else if (iontypes.containsKey((Object)Ion.IonType.IMMONIUM_ION) || iontypes.containsKey((Object)Ion.IonType.PRECURSOR_ION) || iontypes.containsKey((Object)Ion.IonType.REPORTER_ION) || iontypes.containsKey((Object)Ion.IonType.RELATED_ION)) {
                useAnnotation = true;
            }
            if (useAnnotation) {
                boolean h2oLossSelected = false;
                boolean nh3LossSelected = false;
                boolean phosphoLossSelected = false;
                boolean moxLossSelected = false;
                for (NeutralLoss neutralLoss : neutralLosses) {
                    if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                        h2oLossSelected = true;
                        continue;
                    }
                    if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                        nh3LossSelected = true;
                        continue;
                    }
                    if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                        phosphoLossSelected = true;
                        continue;
                    }
                    if (!neutralLoss.isSameAs(NeutralLoss.CH4OS)) continue;
                    moxLossSelected = true;
                }
                if (!(currentLabel.lastIndexOf("-H2O") == -1 && currentLabel.lastIndexOf("-H20") == -1 || h2oLossSelected)) {
                    useAnnotation = false;
                }
                if (currentLabel.lastIndexOf("-NH3") != -1 && !nh3LossSelected) {
                    useAnnotation = false;
                }
                if (!(currentLabel.lastIndexOf("-H3PO4") == -1 && currentLabel.lastIndexOf("-HPO3") == -1 || phosphoLossSelected)) {
                    useAnnotation = false;
                }
                if (currentLabel.lastIndexOf("-CH4OS") != -1 && !moxLossSelected) {
                    useAnnotation = false;
                }
            }
            if (useAnnotation) {
                if (currentLabel.lastIndexOf("+") == -1) {
                    if ((currentLabel.startsWith("a") || currentLabel.startsWith("b") || currentLabel.startsWith("c") || currentLabel.startsWith("x") || currentLabel.startsWith("y") || currentLabel.startsWith("z")) && !singleChargeSelected) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("+++") != -1) {
                    if (!moreThanTwoChargesSelected) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("++") != -1 && !doubleChargeSelected) {
                    useAnnotation = false;
                }
            }
            if (!useAnnotation) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    public static void setIonColor(Ion ion, Color color) {
        if (!colorMap.containsKey((Object)ion.getType())) {
            colorMap.put(ion.getType(), new HashMap());
        }
        if (!colorMap.get((Object)ion.getType()).containsKey(ion.getSubType())) {
            colorMap.get((Object)ion.getType()).put(ion.getSubType(), new HashMap());
        }
        colorMap.get((Object)ion.getType()).get(ion.getSubType()).put(ion.getNeutralLossesAsString(), color);
    }

    public static Color determineFragmentIonColor(Ion ion, boolean isSpectrum) {
        if (colorMap.containsKey((Object)ion.getType()) && colorMap.get((Object)ion.getType()).containsKey(ion.getSubType()) && colorMap.get((Object)ion.getType()).get(ion.getSubType()).containsKey(ion.getNeutralLossesAsString())) {
            return colorMap.get((Object)ion.getType()).get(ion.getSubType()).get(ion.getNeutralLossesAsString());
        }
        return SpectrumPanel.determineDefaultFragmentIonColor(ion, isSpectrum);
    }

    public static Color determineDefaultFragmentIonColor(Ion ion, boolean isSpectrum) {
        switch (ion.getType()) {
            case PEPTIDE_FRAGMENT_ION: 
            case TAG_FRAGMENT_ION: {
                switch (ion.getSubType()) {
                    case 0: {
                        if (ion.hasNeutralLosses()) {
                            NeutralLoss[] neutralLosses = ion.getNeutralLosses();
                            if (neutralLosses.length == 1) {
                                NeutralLoss neutralLoss = neutralLosses[0];
                                if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                    return new Color(171, 161, 255);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                    return new Color(248, 151, 202);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                    return Color.BLACK;
                                }
                            } else if (neutralLosses.length > 1) {
                                return Color.GRAY;
                            }
                        }
                        return new Color(153, 0, 0);
                    }
                    case 1: {
                        if (ion.hasNeutralLosses()) {
                            NeutralLoss[] neutralLosses = ion.getNeutralLosses();
                            if (neutralLosses.length == 1) {
                                NeutralLoss neutralLoss = neutralLosses[0];
                                if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                    return new Color(0, 125, 200);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                    return new Color(153, 0, 255);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                    return Color.BLACK;
                                }
                            } else if (neutralLosses.length > 1) {
                                return Color.GRAY;
                            }
                        }
                        return new Color(0, 0, 255);
                    }
                    case 2: {
                        if (ion.hasNeutralLosses()) {
                            NeutralLoss[] neutralLosses = ion.getNeutralLosses();
                            if (neutralLosses.length == 1) {
                                NeutralLoss neutralLoss = neutralLosses[0];
                                if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                    return new Color(188, 150, 255);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                    return new Color(255, 0, 255);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                    return Color.BLACK;
                                }
                            } else if (neutralLosses.length > 1) {
                                return Color.GRAY;
                            }
                        }
                        return new Color(188, 0, 255);
                    }
                    case 3: {
                        if (ion.hasNeutralLosses()) {
                            NeutralLoss[] neutralLosses = ion.getNeutralLosses();
                            if (neutralLosses.length == 1) {
                                NeutralLoss neutralLoss = neutralLosses[0];
                                if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                    return new Color(78, 200, 150);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                    return new Color(255, 200, 255);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                    return Color.BLACK;
                                }
                            } else if (neutralLosses.length > 1) {
                                return Color.GRAY;
                            }
                        }
                        return new Color(78, 200, 0);
                    }
                    case 4: {
                        if (ion.hasNeutralLosses()) {
                            NeutralLoss[] neutralLosses = ion.getNeutralLosses();
                            if (neutralLosses.length == 1) {
                                NeutralLoss neutralLoss = neutralLosses[0];
                                if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                    if (isSpectrum) {
                                        return new Color(0, 70, 135);
                                    }
                                    return new Color(255, 150, 0);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                    if (isSpectrum) {
                                        return new Color(155, 0, 155);
                                    }
                                    return new Color(255, 0, 150);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                    return Color.BLACK;
                                }
                            } else if (neutralLosses.length > 1) {
                                return Color.GRAY;
                            }
                        }
                        if (isSpectrum) {
                            return Color.BLACK;
                        }
                        return new Color(255, 0, 0);
                    }
                    case 5: {
                        if (ion.hasNeutralLosses()) {
                            NeutralLoss[] neutralLosses = ion.getNeutralLosses();
                            if (neutralLosses.length == 1) {
                                NeutralLoss neutralLoss = neutralLosses[0];
                                if (neutralLoss.isSameAs(NeutralLoss.H2O)) {
                                    return new Color(64, 179, 150);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.NH3)) {
                                    return new Color(255, 179, 150);
                                }
                                if (neutralLoss.isSameAs(NeutralLoss.H3PO4) || neutralLoss.isSameAs(NeutralLoss.HPO3)) {
                                    return Color.BLACK;
                                }
                            } else if (neutralLosses.length > 1) {
                                return Color.GRAY;
                            }
                        }
                        return new Color(64, 179, 0);
                    }
                }
                return Color.GRAY;
            }
            case PRECURSOR_ION: {
                return Color.GRAY;
            }
            case IMMONIUM_ION: {
                return Color.GRAY;
            }
            case REPORTER_ION: {
                return Color.ORANGE;
            }
            case RELATED_ION: {
                return Color.GRAY;
            }
        }
        return Color.GRAY;
    }

    public static Color determineFragmentIonColor(String seriesLabel) {
        Color currentColor = Color.GRAY;
        if (seriesLabel.startsWith("a")) {
            currentColor = new Color(153, 0, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(171, 161, 255);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(248, 151, 202);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed() - 100, currentColor.getGreen(), currentColor.getBlue());
            }
        } else if (seriesLabel.startsWith("b")) {
            currentColor = new Color(0, 0, 255);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(0, 150, 255);
            } else if (seriesLabel.lastIndexOf("NH3") != -1 || seriesLabel.equalsIgnoreCase("b ions - mod.")) {
                currentColor = new Color(150, 0, 255);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue() - 100);
            }
        } else if (seriesLabel.startsWith("c")) {
            currentColor = new Color(188, 0, 255);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(188, 150, 255);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(255, 0, 255);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue() - 100);
            }
        } else if (seriesLabel.startsWith("x")) {
            currentColor = new Color(78, 200, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(78, 200, 150);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(255, 200, 255);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen() - 100, currentColor.getBlue());
            }
        } else if (seriesLabel.startsWith("y")) {
            currentColor = new Color(255, 0, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(255, 150, 0);
            } else if (seriesLabel.lastIndexOf("NH3") != -1 || seriesLabel.equalsIgnoreCase("y ions - mod.")) {
                currentColor = new Color(255, 0, 150);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed() - 100, currentColor.getGreen(), currentColor.getBlue());
            }
        } else if (seriesLabel.startsWith("z")) {
            currentColor = new Color(64, 179, 0);
            if (seriesLabel.lastIndexOf("H2O") != -1 || seriesLabel.lastIndexOf("H20") != -1) {
                currentColor = new Color(64, 179, 150);
            } else if (seriesLabel.lastIndexOf("NH3") != -1) {
                currentColor = new Color(255, 179, 150);
            }
            if (seriesLabel.lastIndexOf("++") != -1) {
                currentColor = new Color(currentColor.getRed(), currentColor.getGreen() - 100, currentColor.getBlue());
            }
        } else if (seriesLabel.startsWith("iTRAQ") || seriesLabel.startsWith("TMT")) {
            return Color.ORANGE;
        }
        return currentColor;
    }

    public void addAutomaticDeNovoSequencing(Peptide currentPeptide, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, boolean mirrored) {
        this.addAutomaticDeNovoSequencing(currentPeptide, annotations, aForwardIon, aRewindIon, aDeNovoCharge, showForwardTags, showRewindTags, 0.9, 1.0, 0.2f, 0.2f, null, true, mirrored);
    }

    public void addAutomaticDeNovoSequencing(Peptide currentPeptide, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, double forwardIonPercentHeight, double rewindIonPercentHeight, boolean mirrored) {
        this.addAutomaticDeNovoSequencing(currentPeptide, annotations, aForwardIon, aRewindIon, aDeNovoCharge, showForwardTags, showRewindTags, forwardIonPercentHeight, rewindIonPercentHeight, 0.2f, 0.2f, null, true, mirrored);
    }

    public void addAutomaticDeNovoSequencing(Peptide currentPeptide, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, double forwardIonPercentHeight, double rewindIonPercentHeight, boolean excludeFixedPtms, boolean mirrored) {
        this.addAutomaticDeNovoSequencing(currentPeptide, annotations, aForwardIon, aRewindIon, aDeNovoCharge, showForwardTags, showRewindTags, forwardIonPercentHeight, rewindIonPercentHeight, 0.2f, 0.2f, null, excludeFixedPtms, mirrored);
    }

    public void addAutomaticDeNovoSequencing(Tag tag, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, boolean mirrored) {
        this.addAutomaticDeNovoSequencing(tag, annotations, aForwardIon, aRewindIon, aDeNovoCharge, showForwardTags, showRewindTags, 0.9, 1.0, 0.2f, 0.2f, null, true, mirrored);
    }

    public void addAutomaticDeNovoSequencing(Tag tag, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, double forwardIonPercentHeight, double rewindIonPercentHeight, boolean mirrored) {
        this.addAutomaticDeNovoSequencing(tag, annotations, aForwardIon, aRewindIon, aDeNovoCharge, showForwardTags, showRewindTags, forwardIonPercentHeight, rewindIonPercentHeight, 0.2f, 0.2f, null, true, mirrored);
    }

    public void addAutomaticDeNovoSequencing(Tag tag, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, double forwardIonPercentHeight, double rewindIonPercentHeight, ArrayList<float[]> alphaLevels, boolean excludeFixedPtms, boolean mirrored) {
        this.addAutomaticDeNovoSequencing(tag, annotations, aForwardIon, aRewindIon, aDeNovoCharge, showForwardTags, showRewindTags, forwardIonPercentHeight, rewindIonPercentHeight, 0.2f, 0.2f, alphaLevels, excludeFixedPtms, mirrored);
    }

    public void addAutomaticDeNovoSequencing(Peptide currentPeptide, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, double forwardIonPercentHeight, double rewindIonPercentHeight, ArrayList<float[]> alphaLevels, boolean excludeFixedPtms, boolean mirrored) {
        this.addAutomaticDeNovoSequencing(currentPeptide, annotations, aForwardIon, aRewindIon, aDeNovoCharge, showForwardTags, showRewindTags, forwardIonPercentHeight, rewindIonPercentHeight, 0.2f, 0.2f, alphaLevels, excludeFixedPtms, mirrored);
    }

    public void addAutomaticDeNovoSequencing(Peptide currentPeptide, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showRewindTags, double forwardIonPercentHeight, double rewindIonPercentHeight, float forwardIonAlphaLevel, float rewindIonAlphaLevel, ArrayList<float[]> alphaLevels, boolean excludeFixedPtms, boolean mirrored) {
        float currentAlphaLevel;
        String mod;
        Color annotationColor;
        int forwardIon = aForwardIon;
        int reverseIon = aRewindIon;
        int deNovoCharge = aDeNovoCharge;
        IonMatch[] forwardIons = new IonMatch[currentPeptide.getSequence().length()];
        IonMatch[] reverseIons = new IonMatch[currentPeptide.getSequence().length()];
        for (IonMatch tempMatch : annotations) {
            if (tempMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION || tempMatch.ion.hasNeutralLosses() || tempMatch.charge != deNovoCharge) continue;
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)tempMatch.ion;
            if (fragmentIon.getSubType() == forwardIon) {
                forwardIons[fragmentIon.getNumber() - 1] = tempMatch;
                continue;
            }
            if (fragmentIon.getSubType() != reverseIon) continue;
            reverseIons[fragmentIon.getNumber() - 1] = tempMatch;
        }
        ArrayList<Integer> modifiedIndexes = currentPeptide.getModifiedIndexes(excludeFixedPtms);
        if (showRewindTags) {
            annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, reverseIon), false);
            for (int i = 1; i < reverseIons.length; ++i) {
                if (reverseIons[i] == null || reverseIons[i - 1] == null) continue;
                mod = "";
                if (modifiedIndexes.contains(currentPeptide.getSequence().length() - i)) {
                    mod = "*";
                }
                currentAlphaLevel = rewindIonAlphaLevel;
                if (alphaLevels != null) {
                    currentAlphaLevel = alphaLevels.get(0)[currentPeptide.getSequence().length() - i];
                }
                this.addReferenceAreaXAxis(new ReferenceArea("r" + i + "_" + mirrored, currentPeptide.getSequence().substring(currentPeptide.getSequence().length() - i - 1, currentPeptide.getSequence().length() - i) + mod, reverseIons[i - 1].peak.mz, reverseIons[i].peak.mz, annotationColor, currentAlphaLevel, false, true, annotationColor, true, Color.lightGray, 0.2f, rewindIonPercentHeight, !mirrored));
            }
        }
        if (showForwardTags) {
            annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, forwardIon), false);
            for (int i = 1; i < forwardIons.length; ++i) {
                if (forwardIons[i] == null || forwardIons[i - 1] == null) continue;
                mod = "";
                if (modifiedIndexes.contains(i + 1)) {
                    mod = "*";
                }
                currentAlphaLevel = forwardIonAlphaLevel;
                if (alphaLevels != null) {
                    currentAlphaLevel = alphaLevels.get(0)[i];
                }
                this.addReferenceAreaXAxis(new ReferenceArea("f" + i + "_" + mirrored, currentPeptide.getSequence().substring(i, i + 1) + mod, forwardIons[i - 1].peak.mz, forwardIons[i].peak.mz, annotationColor, currentAlphaLevel, false, true, annotationColor, true, Color.lightGray, 0.2f, forwardIonPercentHeight, !mirrored));
            }
        }
    }

    public void addAutomaticDeNovoSequencing(Tag tag, ArrayList<IonMatch> annotations, int aForwardIon, int aRewindIon, int aDeNovoCharge, boolean showForwardTags, boolean showReverseTags, double forwardIonPercentHeight, double rewindIonPercentHeight, float forwardIonAlphaLevel, float rewindIonAlphaLevel, ArrayList<float[]> alphaLevels, boolean excludeFixedPtms, boolean mirrored) {
        int forwardIon = aForwardIon;
        int rewindIon = aRewindIon;
        int deNovoCharge = aDeNovoCharge;
        HashMap<Integer, IonMatch> forwardMap = new HashMap<Integer, IonMatch>();
        HashMap<Integer, IonMatch> rewindMap = new HashMap<Integer, IonMatch>();
        for (IonMatch ionMatch : annotations) {
            if (ionMatch.ion.getType() != Ion.IonType.TAG_FRAGMENT_ION || ionMatch.ion.hasNeutralLosses() || ionMatch.charge != deNovoCharge) continue;
            TagFragmentIon fragmentIon = (TagFragmentIon)ionMatch.ion;
            if (fragmentIon.getSubType() == forwardIon) {
                forwardMap.put(fragmentIon.getSubNumber(), ionMatch);
                continue;
            }
            if (fragmentIon.getSubType() != rewindIon) continue;
            rewindMap.put(fragmentIon.getSubNumber(), ionMatch);
        }
        for (int tagCount = 0; tagCount < tag.getContent().size(); ++tagCount) {
            float currentAlphaLevel;
            ArrayList<ModificationMatch> modificationMatches;
            String mod;
            IonMatch ionMatch2;
            IonMatch ionMatch1;
            int i;
            Color annotationColor;
            TagComponent tagComponent = tag.getContent().get(tagCount);
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                if (!showForwardTags) continue;
                annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, forwardIon), false);
                for (i = 0; i < aminoAcidPattern.length(); ++i) {
                    ionMatch1 = (IonMatch)forwardMap.get(i);
                    ionMatch2 = (IonMatch)forwardMap.get(i + 1);
                    if (ionMatch1 == null || ionMatch2 == null) continue;
                    mod = "";
                    modificationMatches = aminoAcidPattern.getModificationsAt(i + 1);
                    if (!modificationMatches.isEmpty()) {
                        mod = "*";
                    }
                    currentAlphaLevel = forwardIonAlphaLevel;
                    if (alphaLevels != null) {
                        currentAlphaLevel = alphaLevels.get(tagCount)[i];
                    }
                    this.addReferenceAreaXAxis(new ReferenceArea("f" + i + "_" + mirrored, aminoAcidPattern.asSequence(i) + mod, ionMatch1.peak.mz, ionMatch2.peak.mz, annotationColor, currentAlphaLevel, false, true, annotationColor, true, Color.lightGray, 0.2f, forwardIonPercentHeight, !mirrored));
                }
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                if (!showForwardTags) continue;
                annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, forwardIon), false);
                for (i = 0; i < aminoAcidSequence.length(); ++i) {
                    ionMatch1 = (IonMatch)forwardMap.get(i);
                    ionMatch2 = (IonMatch)forwardMap.get(i + 1);
                    if (ionMatch1 == null || ionMatch2 == null) continue;
                    mod = "";
                    modificationMatches = aminoAcidSequence.getModificationsAt(i + 1);
                    if (!modificationMatches.isEmpty()) {
                        mod = "*";
                    }
                    currentAlphaLevel = forwardIonAlphaLevel;
                    if (alphaLevels != null) {
                        currentAlphaLevel = alphaLevels.get(tagCount)[i];
                    }
                    this.addReferenceAreaXAxis(new ReferenceArea("f" + i + "_" + mirrored, aminoAcidSequence.charAt(i) + mod, ionMatch1.peak.mz, ionMatch2.peak.mz, annotationColor, currentAlphaLevel, false, true, annotationColor, true, Color.lightGray, 0.2f, forwardIonPercentHeight, !mirrored));
                }
                continue;
            }
            if (tagComponent instanceof MassGap) continue;
            throw new UnsupportedOperationException("Spectrum annotation not implemented for tag component " + tagComponent.getClass() + ".");
        }
        ArrayList<TagComponent> reversedTag = new ArrayList<TagComponent>(tag.getContent());
        Collections.reverse(reversedTag);
        for (int tagCount = 0; tagCount < reversedTag.size(); ++tagCount) {
            float currentAlphaLevel;
            ArrayList<ModificationMatch> modificationMatches;
            String mod;
            int sequenceIndex;
            IonMatch ionMatch2;
            IonMatch ionMatch1;
            int i;
            Color annotationColor;
            TagComponent tagComponent = reversedTag.get(tagCount);
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                if (!showReverseTags) continue;
                annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, rewindIon), false);
                for (i = 0; i < aminoAcidPattern.length(); ++i) {
                    ionMatch1 = (IonMatch)rewindMap.get(i);
                    ionMatch2 = (IonMatch)rewindMap.get(i + 1);
                    if (ionMatch1 == null || ionMatch2 == null) continue;
                    sequenceIndex = aminoAcidPattern.length() - i - 1;
                    mod = "";
                    modificationMatches = aminoAcidPattern.getModificationsAt(sequenceIndex + 1);
                    if (!modificationMatches.isEmpty()) {
                        mod = "*";
                    }
                    currentAlphaLevel = rewindIonAlphaLevel;
                    if (alphaLevels != null) {
                        currentAlphaLevel = alphaLevels.get(tagCount)[sequenceIndex];
                    }
                    this.addReferenceAreaXAxis(new ReferenceArea("r" + sequenceIndex + "_" + mirrored, aminoAcidPattern.asSequence(sequenceIndex) + mod, ionMatch1.peak.mz, ionMatch2.peak.mz, annotationColor, currentAlphaLevel, false, true, annotationColor, true, Color.lightGray, 0.2f, rewindIonPercentHeight, !mirrored));
                }
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                if (!showReverseTags) continue;
                annotationColor = SpectrumPanel.determineFragmentIonColor(Ion.getGenericIon(Ion.IonType.PEPTIDE_FRAGMENT_ION, rewindIon), false);
                for (i = 0; i < aminoAcidSequence.length(); ++i) {
                    ionMatch1 = (IonMatch)rewindMap.get(i);
                    ionMatch2 = (IonMatch)rewindMap.get(i + 1);
                    if (ionMatch1 == null || ionMatch2 == null) continue;
                    sequenceIndex = aminoAcidSequence.length() - i - 1;
                    mod = "";
                    modificationMatches = aminoAcidSequence.getModificationsAt(sequenceIndex + 1);
                    if (!modificationMatches.isEmpty()) {
                        mod = "*";
                    }
                    currentAlphaLevel = rewindIonAlphaLevel;
                    if (alphaLevels != null) {
                        currentAlphaLevel = alphaLevels.get(tagCount)[sequenceIndex];
                    }
                    this.addReferenceAreaXAxis(new ReferenceArea("r" + sequenceIndex + "_" + mirrored, aminoAcidSequence.charAt(sequenceIndex) + mod, ionMatch1.peak.mz, ionMatch2.peak.mz, annotationColor, currentAlphaLevel, false, true, annotationColor, true, Color.lightGray, 0.2f, rewindIonPercentHeight, !mirrored));
                }
                continue;
            }
            if (tagComponent instanceof MassGap) continue;
            throw new UnsupportedOperationException("Spectrum annotation not implemented for tag component " + tagComponent.getClass() + ".");
        }
    }
}

