/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.waiting.waitinghandlers;

import com.compomics.util.waiting.WaitingHandler;
import java.util.Date;

public class WaitingHandlerCLIImpl
implements WaitingHandler {
    private boolean runFinished = false;
    private boolean runCanceled = false;
    private boolean displayProgress = true;
    private int primaryProgressCounter = 0;
    private int secondaryProgressCounter = 0;
    private int primaryMaxProgressCounter = 0;
    private int secondaryMaxProgressCounter = 0;
    protected String iReport = "";
    private boolean needNewLine = false;
    private String lineBreak = System.getProperty("line.separator");

    @Override
    public synchronized void setMaxPrimaryProgressCounter(int maxProgressValue) {
        if (this.displayProgress) {
            this.primaryMaxProgressCounter = maxProgressValue;
        }
    }

    @Override
    public synchronized void increasePrimaryProgressCounter() {
        if (this.displayProgress) {
            ++this.primaryProgressCounter;
        }
    }

    @Override
    public synchronized void increasePrimaryProgressCounter(int amount) {
        if (this.displayProgress) {
            this.primaryProgressCounter += amount;
        }
    }

    @Override
    public void setPrimaryProgressCounter(int value) {
        if (this.displayProgress) {
            this.primaryProgressCounter = value;
        }
    }

    @Override
    public synchronized void setMaxSecondaryProgressCounter(int maxProgressValue) {
        if (this.displayProgress) {
            this.secondaryMaxProgressCounter = maxProgressValue;
        }
    }

    @Override
    public synchronized void resetSecondaryProgressCounter() {
        if (this.displayProgress) {
            this.secondaryProgressCounter = 0;
        }
    }

    @Override
    public synchronized void increaseSecondaryProgressCounter() {
        if (this.displayProgress) {
            if (this.secondaryMaxProgressCounter != 0) {
                int progress1 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                ++this.secondaryProgressCounter;
                int progress2 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.printProgress(progress1, progress2);
            } else {
                ++this.secondaryProgressCounter;
            }
        }
    }

    @Override
    public synchronized void setSecondaryProgressCounter(int value) {
        if (this.displayProgress) {
            if (this.secondaryMaxProgressCounter != 0) {
                int progress1 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.secondaryProgressCounter = value;
                int progress2 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.printProgress(progress1, progress2);
            } else {
                this.secondaryProgressCounter = value;
            }
        }
    }

    @Override
    public synchronized void increaseSecondaryProgressCounter(int amount) {
        if (this.displayProgress) {
            if (this.secondaryMaxProgressCounter != 0) {
                int progress1 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.secondaryProgressCounter += amount;
                int progress2 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.printProgress(progress1, progress2);
            } else {
                this.secondaryProgressCounter += amount;
            }
        }
    }

    private synchronized void printProgress(int progress1, int progress2) {
        if (progress2 > progress1) {
            int progress = 10 * progress2;
            if (progress1 == 0) {
                if (this.needNewLine) {
                    System.out.append(this.lineBreak);
                }
                System.out.print("10%");
                this.needNewLine = true;
            } else if (progress2 > 99) {
                System.out.print(" " + progress + "%");
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            } else {
                System.out.print(" " + progress + "%");
                this.needNewLine = true;
            }
        }
    }

    @Override
    public synchronized void setSecondaryProgressCounterIndeterminate(boolean indeterminate) {
        if (this.displayProgress) {
            this.secondaryProgressCounter = -1;
        }
    }

    @Override
    public void setRunFinished() {
        this.runFinished = true;
    }

    @Override
    public void setRunCanceled() {
        this.runCanceled = true;
    }

    @Override
    public synchronized void appendReport(String report, boolean includeDate, boolean addNewLine) {
        if (this.displayProgress) {
            String tempReport = report;
            if (includeDate) {
                Date date = new Date();
                tempReport = date + " " + report;
            }
            if (addNewLine) {
                tempReport = tempReport + this.lineBreak;
            }
            this.iReport = this.iReport + tempReport;
            if (this.needNewLine) {
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            }
            System.out.append(tempReport);
        }
    }

    @Override
    public synchronized void appendReportNewLineNoDate() {
        if (this.displayProgress) {
            if (this.needNewLine) {
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            }
            this.iReport = this.iReport + this.lineBreak;
            System.out.append(this.lineBreak);
        }
    }

    @Override
    public synchronized void appendReportEndLine() {
        if (this.displayProgress) {
            if (this.needNewLine) {
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            }
            this.iReport = this.iReport + this.lineBreak;
            System.out.append(this.lineBreak);
        }
    }

    @Override
    public boolean isRunCanceled() {
        return this.runCanceled;
    }

    @Override
    public boolean isRunFinished() {
        return this.runFinished;
    }

    @Override
    public void setWaitingText(String text) {
        if (this.displayProgress) {
            this.appendReport(text, true, true);
        }
    }

    @Override
    public synchronized void setPrimaryProgressCounterIndeterminate(boolean indeterminate) {
        if (this.displayProgress && indeterminate) {
            this.primaryProgressCounter = -1;
        }
    }

    @Override
    public boolean isReport() {
        return true;
    }

    @Override
    public void setSecondaryProgressText(String text) {
        if (this.displayProgress) {
            this.appendReport(text, true, true);
        }
    }

    @Override
    public synchronized void resetPrimaryProgressCounter() {
        if (this.displayProgress) {
            this.primaryProgressCounter = 0;
        }
    }

    @Override
    public synchronized int getPrimaryProgressCounter() {
        return this.primaryProgressCounter;
    }

    @Override
    public synchronized int getMaxPrimaryProgressCounter() {
        return this.primaryMaxProgressCounter;
    }

    @Override
    public synchronized int getSecondaryProgressCounter() {
        return this.secondaryProgressCounter;
    }

    @Override
    public synchronized int getMaxSecondaryProgressCounter() {
        return this.secondaryMaxProgressCounter;
    }

    @Override
    public void setDisplayProgress(boolean displayProgress) {
        this.displayProgress = displayProgress;
    }

    @Override
    public boolean getDisplayProgress() {
        return this.displayProgress;
    }
}

