/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.clustering;

import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import no.uib.jsparklines.renderers.util.Util;

public class KMeansClustering {
    private final int NUM_CLUSTERS;
    private final int NUM_SAMPLES;
    private final int NUM_VALUES;
    private final double[][] SAMPLES;
    private final String[] SAMPLE_IDS;
    private double[][] centroids;
    private int[] clusters;
    private int maxIterations = 500;

    public KMeansClustering(double[][] samples, String[] sampleIds, int numClusters) {
        this.SAMPLES = samples;
        this.SAMPLE_IDS = sampleIds;
        this.NUM_SAMPLES = samples.length;
        this.NUM_VALUES = samples[0].length;
        this.NUM_CLUSTERS = numClusters;
        if (this.NUM_CLUSTERS > this.NUM_SAMPLES) {
            throw new IllegalArgumentException("The number of clusters cannot be bigger than the number of samples! #clusters: " + this.NUM_CLUSTERS + ", #samples: " + this.NUM_SAMPLES);
        }
        this.initialize();
    }

    public KMeansClustering(File dataFile, int numClusters) {
        SampleData sampleData = this.readDataFromFile(dataFile);
        this.SAMPLES = sampleData.getSamples();
        this.SAMPLE_IDS = sampleData.getSampleIds();
        this.NUM_SAMPLES = this.SAMPLES.length;
        this.NUM_VALUES = this.SAMPLES[0].length;
        this.NUM_CLUSTERS = numClusters;
        if (this.NUM_CLUSTERS > this.NUM_SAMPLES) {
            throw new IllegalArgumentException("The number of clusters cannot be bigger than the number of samples! #clusters: " + this.NUM_CLUSTERS + ", #samples: " + this.NUM_SAMPLES);
        }
        this.initialize();
    }

    private void initialize() {
        this.clusters = new int[this.NUM_SAMPLES];
        this.centroids = new double[this.NUM_CLUSTERS][this.NUM_VALUES];
        Random rand = new Random();
        for (int centroidCounter = 0; centroidCounter < this.NUM_CLUSTERS; ++centroidCounter) {
            int randomSample = rand.nextInt(this.NUM_SAMPLES);
            System.arraycopy(this.SAMPLES[randomSample], 0, this.centroids[centroidCounter], 0, this.NUM_VALUES);
        }
    }

    public void kMeanCluster(WaitingHandler waitingHandler) {
        boolean clustersChanged = true;
        this.assignToClusters();
        for (int iterationCounter = 0; clustersChanged && iterationCounter < this.maxIterations && !waitingHandler.isRunCanceled(); ++iterationCounter) {
            this.calculateNewCentroids();
            clustersChanged = this.assignToClusters();
        }
    }

    private boolean assignToClusters() {
        boolean clustersChanged = false;
        for (int sampleNumber = 0; sampleNumber < this.NUM_SAMPLES; ++sampleNumber) {
            double minimumValue = Double.MAX_VALUE;
            int selectedCentroidNumber = 0;
            for (int centroidNumber = 0; centroidNumber < this.NUM_CLUSTERS; ++centroidNumber) {
                double distance = this.distSampleToCentroid(sampleNumber, centroidNumber);
                if (!(distance < minimumValue)) continue;
                minimumValue = distance;
                selectedCentroidNumber = centroidNumber;
            }
            if (this.clusters[sampleNumber] != selectedCentroidNumber) {
                clustersChanged = true;
            }
            this.clusters[sampleNumber] = selectedCentroidNumber;
        }
        return clustersChanged;
    }

    private void calculateNewCentroids() {
        this.clearCentroids();
        for (int centroidNumber = 0; centroidNumber < this.NUM_CLUSTERS; ++centroidNumber) {
            int totalInCluster = 0;
            for (int sampleCounter = 0; sampleCounter < this.NUM_SAMPLES; ++sampleCounter) {
                if (this.clusters[sampleCounter] != centroidNumber) continue;
                for (int valueNumber = 0; valueNumber < this.NUM_VALUES; ++valueNumber) {
                    double[] dArray = this.centroids[centroidNumber];
                    int n = valueNumber;
                    dArray[n] = dArray[n] + this.SAMPLES[sampleCounter][valueNumber];
                }
                ++totalInCluster;
            }
            if (totalInCluster <= 0) continue;
            int valueNumber = 0;
            while (valueNumber < this.NUM_VALUES) {
                double[] dArray = this.centroids[centroidNumber];
                int n = valueNumber++;
                dArray[n] = dArray[n] / (double)totalInCluster;
            }
        }
    }

    private void clearCentroids() {
        for (int centroidNumber = 0; centroidNumber < this.NUM_CLUSTERS; ++centroidNumber) {
            for (int valueNumber = 0; valueNumber < this.NUM_VALUES; ++valueNumber) {
                this.centroids[centroidNumber][valueNumber] = 0.0;
            }
        }
    }

    private double distSampleToCentroid(int sampleNumber, int centroidNumber) {
        double distance = 0.0;
        for (int valueNumber = 0; valueNumber < this.NUM_VALUES; ++valueNumber) {
            distance += Math.pow(this.SAMPLES[sampleNumber][valueNumber] - this.centroids[centroidNumber][valueNumber], 2.0);
        }
        return Math.sqrt(distance);
    }

    private double distSampleToSample(int sampleNumber1, int sampleNumber2) {
        double distance = 0.0;
        for (int valueNumber = 0; valueNumber < this.NUM_VALUES; ++valueNumber) {
            distance += Math.pow(this.SAMPLES[sampleNumber1][valueNumber] - this.SAMPLES[sampleNumber2][valueNumber], 2.0);
        }
        return Math.sqrt(distance);
    }

    public static void main(String[] args) {
        double[][] samples = new double[][]{{1.018387278, 0.983270041, 1.063472453, 0.713225975, 0.731043734, 0.973387687, 0.936300274, 1.039486067, 1.134279088, 0.986361721}, {0.981590377, 1.02987824, 1.089762055, 0.927909537, 0.745221317, 0.709817942, 0.655031878, 1.047253604, 0.952668566, 1.037703939}, {1.03694662, 1.080079418, 1.041962748, 1.258192406, 1.342060684, 0.996528485, 0.924128553, 0.936412377, 0.920298185, 0.918456169}, {0.990287761, 0.892692992, 0.914314664, 1.279408351, 1.31410923, 0.941641721, 0.910025757, 1.064973225, 1.041036986, 1.049735711}, {1.040106591, 0.938527051, 0.965804511, 0.695864906, 0.813267072, 1.064862452, 1.128367944, 0.9798703, 1.268314349, 0.890250862}, {1.283690338, 1.221861511, 1.237727692, 1.131154141, 0.991934148, 0.962126821, 0.943197586, 0.872215846, 0.912011518, 0.829430491}, {0.981473817, 0.805082739, 0.979007845, 0.685868656, 0.467881815, 1.30464142, 1.031580941, 1.120770021, 1.163524042, 0.948936962}, {0.935739165, 0.961540471, 0.948513884, 1.1214119, 1.139158941, 0.952546774, 1.061539826, 0.967187465, 0.969725485, 1.066965917}, {0.98084797, 0.99517748, 0.967601553, 1.408483587, 1.242533492, 0.809655819, 1.012664473, 0.972120169, 0.90671428, 1.064156888}, {1.114446123, 1.024968093, 1.034149441, 0.783212889, 0.801006499, 0.983516619, 1.026256729, 0.996830977, 0.975588315, 0.942473673}, {0.905988305, 0.908986417, 0.925003413, 1.19651456, 1.106383596, 0.997060333, 1.030914868, 1.07807453, 1.146596783, 1.079137402}, {1.040040646, 1.049901339, 0.989359079, 1.017323675, 1.008910963, 0.983004953, 0.984566787, 1.040902927, 1.02390089, 1.015875601}, {1.038052043, 0.999666309, 1.011292944, 0.862294159, 0.878858798, 0.98299443, 0.963822514, 0.982571918, 0.975889047, 1.009450539}, {0.821272331, 0.767589262, 0.817114369, 1.059135199, 0.884487875, 1.091284726, 1.022820961, 1.148307617, 1.032334252, 1.167097238}, {1.016334545, 1.090488723, 0.981954941, 1.223423201, 1.07287664, 0.967790703, 0.894805565, 1.103557481, 1.031495908, 1.028484672}, {0.991456092, 0.665417264, 0.862248473, 1.005142654, 0.919656901, 1.244190762, 1.056869139, 1.031395099, 0.898937035, 0.946095374}};
        String[] sampleNames = new String[]{"O95071", "Q6ZT21", "Q99590", "Q14517", "Q9P219", "Q14692", "Q8TF74", "Q13427", "Q9ULD9", "Q9UPN9", "P51805", "Q92621", "Q5SRE5", "Q8TB73", "Q96CP6", "Q13671"};
        KMeansClustering kMeansClutering = new KMeansClustering(samples, sampleNames, 5);
        System.out.println("Centroids initialized at:");
        kMeansClutering.printCentroids();
        System.out.print("\n");
        kMeansClutering.kMeanCluster(new WaitingHandlerCLIImpl());
        kMeansClutering.printClusters();
        System.out.println("Centroids finalized at:");
        kMeansClutering.printCentroids();
        System.out.print("\n");
    }

    public void printCentroids() {
        for (int centroidNumber = 0; centroidNumber < this.NUM_CLUSTERS; ++centroidNumber) {
            System.out.print("     " + (centroidNumber + 1) + "\t\t");
            for (int valueNumber = 0; valueNumber < this.NUM_VALUES; ++valueNumber) {
                if (valueNumber > 0) {
                    System.out.print("\t");
                }
                System.out.print(Util.roundDouble((double)this.centroids[centroidNumber][valueNumber], (int)2));
            }
            System.out.println();
        }
    }

    public void printClusters() {
        for (int clusterIndex = 0; clusterIndex < this.NUM_CLUSTERS; ++clusterIndex) {
            System.out.println("Cluster " + (clusterIndex + 1) + " includes:");
            for (int sampleIndex = 0; sampleIndex < this.NUM_SAMPLES; ++sampleIndex) {
                if (this.clusters[sampleIndex] != clusterIndex) continue;
                System.out.print("     " + this.SAMPLE_IDS[sampleIndex] + "\t");
                for (int valueNumber = 0; valueNumber < this.NUM_VALUES; ++valueNumber) {
                    if (valueNumber > 0) {
                        System.out.print("\t");
                    }
                    System.out.print(Util.roundDouble((double)this.SAMPLES[sampleIndex][valueNumber], (int)2));
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public ArrayList<String> getClusterMembers(int clusterIndex) {
        ArrayList<String> clusterMembers = new ArrayList<String>();
        for (int sampleIndex = 0; sampleIndex < this.NUM_SAMPLES; ++sampleIndex) {
            if (this.clusters[sampleIndex] != clusterIndex) continue;
            clusterMembers.add(this.SAMPLE_IDS[sampleIndex]);
        }
        return clusterMembers;
    }

    public HashMap<String, ArrayList<Double>> getClusterMembersData(int clusterIndex) {
        HashMap<String, ArrayList<Double>> clusterMembers = new HashMap<String, ArrayList<Double>>();
        for (int sampleIndex = 0; sampleIndex < this.NUM_SAMPLES; ++sampleIndex) {
            if (this.clusters[sampleIndex] != clusterIndex) continue;
            ArrayList<Double> values = new ArrayList<Double>();
            for (int valueNumber = 0; valueNumber < this.NUM_VALUES; ++valueNumber) {
                values.add(this.SAMPLES[sampleIndex][valueNumber]);
            }
            clusterMembers.put(this.SAMPLE_IDS[sampleIndex], values);
        }
        return clusterMembers;
    }

    private SampleData readDataFromFile(File dataFile) {
        SampleData sampleData = null;
        try {
            int i;
            FileReader f = new FileReader(dataFile);
            BufferedReader br = new BufferedReader(f);
            String line = br.readLine();
            ArrayList<String> sampleIds = new ArrayList<String>();
            ArrayList sampleDataAsArray = new ArrayList();
            int numSamples = 0;
            int numValues = 0;
            while (line != null) {
                String[] values = line.split("\\t");
                sampleIds.add(values[0]);
                ArrayList<Double> tempData = new ArrayList<Double>();
                for (i = 1; i < values.length; ++i) {
                    tempData.add(Double.parseDouble(values[i]));
                }
                sampleDataAsArray.add(tempData);
                if (numValues == 0) {
                    numValues = values.length - 1;
                }
                ++numSamples;
                line = br.readLine();
            }
            String[] sampleNames = new String[numSamples];
            for (int i2 = 0; i2 < numSamples; ++i2) {
                sampleNames[i2] = (String)sampleIds.get(i2);
            }
            double[][] samples = new double[numSamples][numValues];
            for (i = 0; i < numSamples; ++i) {
                for (int j = 0; j < numValues; ++j) {
                    samples[i][j] = (Double)((ArrayList)sampleDataAsArray.get(i)).get(j);
                }
            }
            sampleData = new SampleData(samples, sampleNames);
            br.close();
            f.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sampleData;
    }

    public int getNumberOfClusters() {
        return this.NUM_CLUSTERS;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    private class SampleData {
        private double[][] samples;
        private String[] sampleIds;

        public SampleData(double[][] samples, String[] sampleIds) {
            this.samples = samples;
            this.sampleIds = sampleIds;
        }

        public double[][] getSamples() {
            return this.samples;
        }

        public String[] getSampleIds() {
            return this.sampleIds;
        }
    }
}

