/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.variants.AaSubstitutionMatrix;
import java.io.Serializable;

public class PeptideVariantsPreferences
implements Serializable {
    static final long serialVersionUID = -236026128063733907L;
    private Boolean useSpecificCount = false;
    private Integer nVariants = 0;
    private Integer nAaDeletions = 0;
    private Integer nAaInsertions = 0;
    private Integer nAaSubstitutions = 0;
    private Integer nAaSwap = 0;
    private AaSubstitutionMatrix aaSubstitutionMatrix = AaSubstitutionMatrix.noSubstitution;

    public Integer getnAaDeletions() {
        return this.nAaDeletions;
    }

    public void setnAaDeletions(Integer nAaDeletions) {
        this.nAaDeletions = nAaDeletions;
    }

    public Integer getnAaInsertions() {
        return this.nAaInsertions;
    }

    public void setnAaInsertions(Integer nAaInsertions) {
        this.nAaInsertions = nAaInsertions;
    }

    public Integer getnAaSubstitutions() {
        return this.nAaSubstitutions;
    }

    public void setnAaSubstitutions(Integer nAaSubstitutions) {
        this.nAaSubstitutions = nAaSubstitutions;
    }

    public Integer getnAaSwap() {
        return this.nAaSwap;
    }

    public void setnAaSwap(Integer nAaSwap) {
        this.nAaSwap = nAaSwap;
    }

    public AaSubstitutionMatrix getAaSubstitutionMatrix() {
        return this.aaSubstitutionMatrix;
    }

    public void setAaSubstitutionMatrix(AaSubstitutionMatrix aaSubstitutionMatrix) {
        this.aaSubstitutionMatrix = aaSubstitutionMatrix;
    }

    public Boolean getUseSpecificCount() {
        return this.useSpecificCount;
    }

    public void setUseSpecificCount(Boolean useSpecificCount) {
        this.useSpecificCount = useSpecificCount;
    }

    public Integer getnVariants() {
        return this.nVariants;
    }

    public void setnVariants(Integer nVariants) {
        this.nVariants = nVariants;
    }

    public boolean isSameAs(PeptideVariantsPreferences peptideVariantsPreferences) {
        if (!this.nAaDeletions.equals(peptideVariantsPreferences.getnAaDeletions())) {
            return false;
        }
        if (!this.nAaInsertions.equals(peptideVariantsPreferences.getnAaInsertions())) {
            return false;
        }
        if (!this.nAaSubstitutions.equals(peptideVariantsPreferences.getnAaSubstitutions())) {
            return false;
        }
        if (!this.nAaSwap.equals(peptideVariantsPreferences.getnAaSwap())) {
            return false;
        }
        if (!this.useSpecificCount.equals(peptideVariantsPreferences.getUseSpecificCount())) {
            return false;
        }
        if (!this.nVariants.equals(peptideVariantsPreferences.getnVariants())) {
            return false;
        }
        return this.aaSubstitutionMatrix.isSameAs(peptideVariantsPreferences.getAaSubstitutionMatrix());
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("#Variants: ").append(this.nVariants).append(".").append(newLine);
        if (this.useSpecificCount.booleanValue()) {
            output.append("AA Deletions: ").append(this.nAaDeletions).append(".").append(newLine);
            output.append("AA Insertions: ").append(this.nAaInsertions).append(".").append(newLine);
            output.append("AA Substitutions: ").append(this.nAaSubstitutions).append(".").append(newLine);
            output.append("AA Swap: ").append(this.nAaSwap).append(".").append(newLine);
            output.append("Substitution Matrix: ").append(this.aaSubstitutionMatrix.toString()).append(".").append(newLine);
        }
        return output.toString();
    }

    public static PeptideVariantsPreferences getNoVariantPreferences() {
        PeptideVariantsPreferences peptideVariantsPreferences = new PeptideVariantsPreferences();
        peptideVariantsPreferences.setnVariants(0);
        peptideVariantsPreferences.setUseSpecificCount(false);
        peptideVariantsPreferences.setAaSubstitutionMatrix(AaSubstitutionMatrix.noSubstitution);
        return peptideVariantsPreferences;
    }
}

