/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein_sequences_manager;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.protein_sequences_manager.enums.SequenceInputType;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ProteinSequencesManager {
    public static final String TEMP_FOLDER = ".temp";
    public static final String UNIPROT_FOLDER = "uniprot";
    public static final String USER_FOLDER = "user";
    public static final String DNA_FOLDER = "dna";
    private ArrayList<String> databaseNames;
    private HashMap<String, SequenceInputType> databaseInputTypes;
    private HashMap<String, HashMap<String, FastaIndex>> databaseIndexes;
    private File workingFolder;

    public ProteinSequencesManager() {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        this.workingFolder = utilitiesUserPreferences.getProteinSequencesManagerFolder();
        if (this.workingFolder == null || !this.workingFolder.exists()) {
            throw new IllegalArgumentException("Working folder not set.");
        }
        this.parseWorkingFolder();
    }

    private void parseWorkingFolder() {
        this.databaseNames = new ArrayList();
        this.databaseInputTypes = new HashMap();
        this.databaseIndexes = new HashMap();
        this.parseSubFolder(this.getUniprotFolder(), SequenceInputType.uniprot);
        this.parseSubFolder(this.getUserFolder(), SequenceInputType.user);
        this.parseSubFolder(this.getDnaFolder(), SequenceInputType.dna);
    }

    private void parseSubFolder(File folder, SequenceInputType sequenceInputType) {
        if (!folder.exists()) {
            folder.mkdirs();
            if (!folder.exists()) {
                throw new IllegalArgumentException("Impossible to write into the working folder.");
            }
            return;
        }
        for (File fastaFolder : folder.listFiles()) {
            if (!fastaFolder.isDirectory()) continue;
            String name = fastaFolder.getName();
            boolean dbFound = false;
            for (File versionFolder : fastaFolder.listFiles()) {
                if (!versionFolder.isDirectory()) continue;
                String version = versionFolder.getName();
                FastaIndex fastaIndex = null;
                for (File subFile : versionFolder.listFiles()) {
                    if (!subFile.getName().endsWith(".cui")) continue;
                    try {
                        File fastaFile;
                        FastaIndex tempIndex = (FastaIndex)SerializationUtils.readObject(subFile);
                        String correctedName = ProteinSequencesManager.correctFastaName(tempIndex.getName());
                        if (!correctedName.equals(name) || !(fastaFile = new File(versionFolder, tempIndex.getFileName())).exists()) continue;
                        fastaIndex = tempIndex;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fastaIndex != null) {
                    dbFound = true;
                    this.databaseNames.add(fastaIndex.getName());
                    this.databaseInputTypes.put(name, sequenceInputType);
                    HashMap<String, FastaIndex> fastaMap = this.databaseIndexes.get(name);
                    if (fastaMap == null) {
                        fastaMap = new HashMap(1);
                        this.databaseIndexes.put(name, fastaMap);
                    }
                    fastaMap.put(version, fastaIndex);
                    continue;
                }
                Util.deleteDir(versionFolder);
            }
            if (dbFound) continue;
            Util.deleteDir(fastaFolder);
        }
    }

    public File getUniprotFolder() {
        return new File(this.workingFolder, UNIPROT_FOLDER);
    }

    public File getUserFolder() {
        return new File(this.workingFolder, USER_FOLDER);
    }

    public File getDnaFolder() {
        return new File(this.workingFolder, DNA_FOLDER);
    }

    public void addFastaFile(File fastaFile, SequenceInputType sequenceInputType, WaitingHandler waitingHandler) throws IOException {
        FastaIndex tempIndex = SequenceFactory.getFastaIndex(fastaFile, false, waitingHandler);
        if (!waitingHandler.isRunCanceled()) {
            HashMap<String, FastaIndex> databaseMap;
            String fastaName = tempIndex.getName();
            File folder = this.getFolder(sequenceInputType);
            folder = new File(folder, fastaName);
            String version = tempIndex.getVersion();
            folder = new File(folder, version);
            folder.mkdirs();
            if (!folder.exists()) {
                throw new IllegalArgumentException("Impossible to write into the working folder.");
            }
            String fileName = fastaFile.getName();
            fileName = ProteinSequencesManager.correctFastaName(fileName);
            File importedFile = new File(folder, fileName);
            Util.copyFile(fastaFile, importedFile);
            FastaIndex newIndex = SequenceFactory.getFastaIndex(fastaFile, true, waitingHandler);
            newIndex.setName(tempIndex.getName());
            newIndex.setAccessionParsingRule(tempIndex.getAccessionParsingRule());
            newIndex.setDecoyTag(tempIndex.getDecoyTag());
            newIndex.setDescription(tempIndex.getDescription());
            newIndex.setMainDatabaseType(tempIndex.getMainDatabaseType());
            newIndex.setVersion(tempIndex.getVersion());
            SequenceFactory.writeIndex(newIndex, folder);
            if (!this.databaseNames.contains(fastaName)) {
                this.databaseNames.add(fastaName);
                this.databaseInputTypes.put(fastaName, sequenceInputType);
            }
            if ((databaseMap = this.databaseIndexes.get(fastaName)) == null) {
                databaseMap = new HashMap(1);
                this.databaseIndexes.put(fastaName, databaseMap);
            }
            databaseMap.put(version, newIndex);
        }
    }

    public static String correctFastaName(String fastaName) {
        return fastaName.replaceAll(" ", "_");
    }

    public File getFolder(SequenceInputType sequenceInputType) {
        switch (sequenceInputType) {
            case uniprot: {
                return new File(this.workingFolder, UNIPROT_FOLDER);
            }
            case user: {
                return new File(this.workingFolder, USER_FOLDER);
            }
            case dna: {
                return new File(this.workingFolder, DNA_FOLDER);
            }
        }
        throw new UnsupportedOperationException("Folder not implemented for input type " + (Object)((Object)sequenceInputType) + ".");
    }

    public File getTempFolder() {
        return new File(this.workingFolder, TEMP_FOLDER);
    }

    public ArrayList<String> getDatabaseNames() {
        return this.databaseNames;
    }

    public ArrayList<String> getVersionsForDb(String databaseName) {
        ArrayList<String> result = new ArrayList<String>(this.databaseIndexes.get(databaseName).keySet());
        Collections.sort(result);
        return result;
    }

    public FastaIndex getFastaIndex(String databaseName, String version) {
        HashMap<String, FastaIndex> databaseMap = this.databaseIndexes.get(databaseName);
        if (databaseMap == null) {
            return null;
        }
        return databaseMap.get(version);
    }

    public SequenceInputType getInputType(String databaseName) {
        return this.databaseInputTypes.get(databaseName);
    }
}

