/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein_sequences_manager.gui.sequences_import;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.LastSelectedFolder;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class ImportSequencesFromFilesDialog
extends JDialog {
    private static ProgressDialogX progressDialog;
    private UtilitiesUserPreferences utilitiesUserPreferences = null;
    private LastSelectedFolder lastSelectedFolder = null;
    private File selectedFile = null;
    private FastaIndex selectedFileIndex = null;
    private boolean canceled = false;
    private Frame parentFrame;
    private Image waitingImage;
    private Image normalImange;
    private JButton browseButton;
    private JButton cancelButton;
    private JButton clearButton;
    private JLabel descriptionLbl;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTxt;
    private JLabel fastaFileLabel;
    private JTextField fastaFilesTxt;
    private JPanel fileSelectionPanel;
    private JPanel importSequencesFromFilesPanel;
    private JPanel inputPanel;
    private JLabel nameLbl;
    private JTextField nameTxt;
    private JButton okButton;
    private JLabel parsingRuleLbl;
    private JTextField parsingRuleTxt;
    private JComboBox typeCmb;
    private JLabel typeLbl;
    private JLabel versionLbl;
    private JTextField versionTxt;

    public ImportSequencesFromFilesDialog(Frame parent, Image normalImange, Image waitingImage) {
        super(parent, true);
        this.parentFrame = parent;
        this.normalImange = normalImange;
        this.waitingImage = waitingImage;
        this.initComponents();
        this.loadUserPreferences();
        this.clearDatabaseSelection();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.importSequencesFromFilesPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.inputPanel = new JPanel();
        this.typeLbl = new JLabel();
        this.typeCmb = new JComboBox();
        this.nameLbl = new JLabel();
        this.versionLbl = new JLabel();
        this.nameTxt = new JTextField();
        this.versionTxt = new JTextField();
        this.descriptionLbl = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTxt = new JTextArea();
        this.parsingRuleTxt = new JTextField();
        this.parsingRuleLbl = new JLabel();
        this.fileSelectionPanel = new JPanel();
        this.fastaFileLabel = new JLabel();
        this.browseButton = new JButton();
        this.clearButton = new JButton();
        this.fastaFilesTxt = new JTextField();
        this.setDefaultCloseOperation(2);
        this.importSequencesFromFilesPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromFilesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromFilesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.inputPanel.setBorder(BorderFactory.createTitledBorder("Database Information"));
        this.inputPanel.setOpaque(false);
        this.typeLbl.setText("Type");
        this.typeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.nameLbl.setText("Name");
        this.versionLbl.setText("Version");
        this.descriptionLbl.setText("Description");
        this.descriptionTxt.setColumns(20);
        this.descriptionTxt.setRows(5);
        this.descriptionScrollPane.setViewportView(this.descriptionTxt);
        this.parsingRuleTxt.setEditable(false);
        this.parsingRuleTxt.setEnabled(false);
        this.parsingRuleLbl.setText("Parsing Rule");
        GroupLayout inputPanelLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(inputPanelLayout);
        inputPanelLayout.setHorizontalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLbl).addComponent(this.typeLbl)).addGap(18, 18, 18).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeCmb, 0, 200, Short.MAX_VALUE).addComponent(this.nameTxt, -1, 200, Short.MAX_VALUE)).addGap(134, 134, 134).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.parsingRuleLbl).addGap(18, 18, 18).addComponent(this.parsingRuleTxt, -1, 200, Short.MAX_VALUE)).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.versionLbl).addGap(42, 42, 42).addComponent(this.versionTxt, -1, 200, Short.MAX_VALUE)))).addComponent(this.descriptionScrollPane)).addContainerGap()).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.descriptionLbl).addGap(0, 0, Short.MAX_VALUE)))));
        inputPanelLayout.setVerticalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLbl).addComponent(this.typeCmb, -2, -1, -2).addComponent(this.parsingRuleLbl).addComponent(this.parsingRuleTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLbl).addComponent(this.versionLbl).addComponent(this.nameTxt, -2, -1, -2).addComponent(this.versionTxt, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.descriptionLbl).addGap(4, 4, 4).addComponent(this.descriptionScrollPane, -1, 193, Short.MAX_VALUE).addContainerGap()));
        this.fileSelectionPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        this.fileSelectionPanel.setOpaque(false);
        this.fastaFileLabel.setText("FASTA File");
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromFilesDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromFilesDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.fastaFilesTxt.setEditable(false);
        GroupLayout fileSelectionPanelLayout = new GroupLayout(this.fileSelectionPanel);
        this.fileSelectionPanel.setLayout(fileSelectionPanelLayout);
        fileSelectionPanelLayout.setHorizontalGroup(fileSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fileSelectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fastaFileLabel).addGap(18, 18, 18).addComponent(this.fastaFilesTxt, -1, 433, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton, -2, 67, -2).addGap(14, 14, 14)));
        fileSelectionPanelLayout.setVerticalGroup(fileSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileSelectionPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearButton).addComponent(this.browseButton)).addGroup(fileSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fastaFileLabel).addComponent(this.fastaFilesTxt, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout importSequencesFromFilesPanelLayout = new GroupLayout(this.importSequencesFromFilesPanel);
        this.importSequencesFromFilesPanel.setLayout(importSequencesFromFilesPanelLayout);
        importSequencesFromFilesPanelLayout.setHorizontalGroup(importSequencesFromFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, importSequencesFromFilesPanelLayout.createSequentialGroup().addContainerGap().addGroup(importSequencesFromFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fileSelectionPanel, -1, -1, Short.MAX_VALUE).addGroup(importSequencesFromFilesPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.inputPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        importSequencesFromFilesPanelLayout.setVerticalGroup(importSequencesFromFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, importSequencesFromFilesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileSelectionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(importSequencesFromFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.importSequencesFromFilesPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.importSequencesFromFilesPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.selectDB();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clearDatabaseSelection();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void loadUserPreferences() {
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (this.utilitiesUserPreferences.getProteinSequencesManagerFolder() == null || !this.utilitiesUserPreferences.getProteinSequencesManagerFolder().exists()) {
            throw new IllegalArgumentException("Database folder not set.");
        }
        this.lastSelectedFolder = this.utilitiesUserPreferences.getLastSelectedFolder();
    }

    public String getLastSelectedFolder() {
        if (this.lastSelectedFolder == null) {
            return null;
        }
        String folder = this.lastSelectedFolder.getLastSelectedFolder("fastaFile");
        if (folder == null) {
            folder = this.lastSelectedFolder.getLastSelectedFolder();
        }
        return folder;
    }

    public void clearDatabaseSelection() {
        this.selectedFile = null;
        this.fastaFilesTxt.setText("Please select a Fasta File");
        this.typeCmb.setSelectedIndex(0);
        this.typeCmb.setEnabled(false);
        this.parsingRuleTxt.setText("");
        this.parsingRuleTxt.setEnabled(false);
        this.nameTxt.setText("");
        this.nameTxt.setEnabled(false);
        this.versionTxt.setText("");
        this.versionTxt.setEnabled(false);
        this.descriptionTxt.setText("");
        this.descriptionTxt.setEnabled(false);
        this.clearButton.setEnabled(false);
    }

    public void importDatabase() throws IOException {
        final File finalFile = this.selectedFile;
        progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Loading Database. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("importThread"){

            @Override
            public void run() {
                try {
                    progressDialog.setTitle("Importing Database. Please Wait...");
                    progressDialog.setPrimaryProgressCounterIndeterminate(false);
                    ImportSequencesFromFilesDialog.this.selectedFileIndex = SequenceFactory.getFastaIndex(ImportSequencesFromFilesDialog.this.selectedFile, false, progressDialog);
                }
                catch (IOException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(ImportSequencesFromFilesDialog.this, new String[]{"FASTA Import Error.", "File " + finalFile.getAbsolutePath() + " not found."}, "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (StringIndexOutOfBoundsException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(ImportSequencesFromFilesDialog.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                catch (IllegalArgumentException e) {
                    progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(ImportSequencesFromFilesDialog.this, e.getMessage(), "FASTA Import Error", 2);
                    e.printStackTrace();
                    return;
                }
                if (!progressDialog.isRunCanceled()) {
                    ImportSequencesFromFilesDialog.this.typeCmb.setSelectedItem((Object)ImportSequencesFromFilesDialog.this.selectedFileIndex.getMainDatabaseType());
                    ImportSequencesFromFilesDialog.this.nameTxt.setText(ImportSequencesFromFilesDialog.this.selectedFileIndex.getName());
                    ImportSequencesFromFilesDialog.this.versionTxt.setText(ImportSequencesFromFilesDialog.this.selectedFileIndex.getVersion());
                    ImportSequencesFromFilesDialog.this.descriptionTxt.setText(ImportSequencesFromFilesDialog.this.selectedFileIndex.getDescription());
                    ImportSequencesFromFilesDialog.this.typeCmb.setEnabled(true);
                    ImportSequencesFromFilesDialog.this.nameTxt.setEnabled(true);
                    ImportSequencesFromFilesDialog.this.versionTxt.setEnabled(true);
                    ImportSequencesFromFilesDialog.this.descriptionTxt.setEnabled(true);
                } else {
                    ImportSequencesFromFilesDialog.this.clearDatabaseSelection();
                }
                progressDialog.setRunFinished();
            }
        }.start();
    }

    public void selectDB() {
        File startLocation = null;
        if (this.utilitiesUserPreferences.getDbFolder() != null && this.utilitiesUserPreferences.getDbFolder().exists()) {
            startLocation = this.utilitiesUserPreferences.getDbFolder();
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.getName().toLowerCase().endsWith("fas") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "FASTA (.fasta or .fas)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File userSelectedFile = fc.getSelectedFile();
            this.lastSelectedFolder.setLastSelectedFolder("fastaFile", userSelectedFile.getParent());
            try {
                String fileName = userSelectedFile.getName();
                fileName = fileName.replaceAll(" ", "_");
                File managerFolder = this.utilitiesUserPreferences.getProteinSequencesManagerFolder();
                File tempFolder = new File(managerFolder, ".temp");
                tempFolder.mkdirs();
                this.selectedFile = new File(tempFolder, fileName);
                Util.copyFile(userSelectedFile, this.selectedFile);
                this.importDatabase();
                this.fastaFilesTxt.setText(this.selectedFile.getAbsolutePath());
                this.clearButton.setEnabled(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occurred while importing " + this.selectedFile.getName() + ".", "Error", 0);
                this.clearDatabaseSelection();
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }
}

