/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein_sequences_manager.gui.sequences_import;

import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.LastSelectedFolder;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.protein_sequences_manager.DownloadingUtil;
import com.compomics.util.protein_sequences_manager.UniProtQuery;
import com.compomics.util.protein_sequences_manager.enums.ModelOrganism;
import com.compomics.util.protein_sequences_manager.enums.SequenceContentType;
import com.compomics.util.protein_sequences_manager.gui.sequences_import.taxonomy.TaxonomyTreeDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ImportSequencesFromUniprotDialog
extends JDialog {
    private static ProgressDialogX progressDialog;
    private UtilitiesUserPreferences utilitiesUserPreferences = null;
    private LastSelectedFolder lastSelectedFolder = null;
    private File downloadFile = null;
    private FastaIndex selectedFileIndex = null;
    private boolean canceled = false;
    private Frame parentFrame;
    private Image waitingImage;
    private Image normalImange;
    private JButton btnTaxonomyTree;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JComboBox cbModelOrganism;
    private JComboBox cbSequenceDatabaseType;
    private JLabel descriptionLbl;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTxt;
    private JButton downloadButton;
    private JPanel inputPanel;
    private JLabel lbSequenceContentType;
    private JLabel modelOrganismLabel;
    private JLabel nameLbl;
    private JTextField nameTxt;
    private JButton okButton;
    private JLabel parsingRuleLbl;
    private JTextField parsingRuleTxt;
    private JLabel taxIdLabel;
    private JPanel taxonomyPanel;
    private JTextField tfTaxonomyID;
    private JLabel typeLabel;
    private JLabel typeLbl;
    private JLabel versionLbl;
    private JTextField versionTxt;

    public ImportSequencesFromUniprotDialog(Frame parent) {
        super(parent, true);
        this.init();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void init() {
        this.initComponents();
        this.loadUserPreferences();
        this.cbSequenceDatabaseType.removeAllItems();
        for (SequenceContentType sequenceContentType : SequenceContentType.values()) {
            this.cbSequenceDatabaseType.addItem(sequenceContentType);
        }
        this.cbModelOrganism.removeAllItems();
        for (Enum enum_ : ModelOrganism.values()) {
            this.cbModelOrganism.addItem(enum_);
        }
        this.cbModelOrganism.addItem("other");
        this.cbModelOrganism.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = ImportSequencesFromUniprotDialog.this.cbModelOrganism.getSelectedItem();
                if (selectedItem.toString().equals("other")) {
                    ImportSequencesFromUniprotDialog.this.tfTaxonomyID.setText("-");
                } else {
                    ModelOrganism organism = (ModelOrganism)((Object)selectedItem);
                    ImportSequencesFromUniprotDialog.this.tfTaxonomyID.setText(String.valueOf(organism.getTaxonomyID()));
                }
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.taxonomyPanel = new JPanel();
        this.taxIdLabel = new JLabel();
        this.tfTaxonomyID = new JTextField();
        this.downloadButton = new JButton();
        this.cbSequenceDatabaseType = new JComboBox();
        this.typeLabel = new JLabel();
        this.modelOrganismLabel = new JLabel();
        this.cbModelOrganism = new JComboBox();
        this.btnTaxonomyTree = new JButton();
        this.inputPanel = new JPanel();
        this.typeLbl = new JLabel();
        this.nameLbl = new JLabel();
        this.versionLbl = new JLabel();
        this.nameTxt = new JTextField();
        this.versionTxt = new JTextField();
        this.descriptionLbl = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTxt = new JTextArea();
        this.parsingRuleTxt = new JTextField();
        this.parsingRuleLbl = new JLabel();
        this.lbSequenceContentType = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.taxonomyPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        this.taxIdLabel.setText("Taxonomy ID");
        this.tfTaxonomyID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromUniprotDialog.this.tfTaxonomyIDActionPerformed(evt);
            }
        });
        this.downloadButton.setText("Download");
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromUniprotDialog.this.downloadButtonActionPerformed(evt);
            }
        });
        this.cbSequenceDatabaseType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbSequenceDatabaseType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromUniprotDialog.this.cbSequenceDatabaseTypeActionPerformed(evt);
            }
        });
        this.typeLabel.setText("Type");
        this.modelOrganismLabel.setText("Model Organism");
        this.cbModelOrganism.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbModelOrganism.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromUniprotDialog.this.cbModelOrganismActionPerformed(evt);
            }
        });
        this.btnTaxonomyTree.setText("...");
        this.btnTaxonomyTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromUniprotDialog.this.btnTaxonomyTreeActionPerformed(evt);
            }
        });
        GroupLayout taxonomyPanelLayout = new GroupLayout(this.taxonomyPanel);
        this.taxonomyPanel.setLayout(taxonomyPanelLayout);
        taxonomyPanelLayout.setHorizontalGroup(taxonomyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(taxonomyPanelLayout.createSequentialGroup().addContainerGap().addGroup(taxonomyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modelOrganismLabel).addComponent(this.typeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(taxonomyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbModelOrganism, 0, 106, Short.MAX_VALUE).addComponent(this.cbSequenceDatabaseType, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(taxonomyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(taxonomyPanelLayout.createSequentialGroup().addComponent(this.taxIdLabel, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfTaxonomyID, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnTaxonomyTree, -2, 22, -2)).addGroup(GroupLayout.Alignment.TRAILING, taxonomyPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.downloadButton))).addContainerGap()));
        taxonomyPanelLayout.setVerticalGroup(taxonomyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, taxonomyPanelLayout.createSequentialGroup().addContainerGap().addGroup(taxonomyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modelOrganismLabel).addComponent(this.cbModelOrganism, -2, -1, -2).addComponent(this.taxIdLabel).addComponent(this.tfTaxonomyID, -2, -1, -2).addComponent(this.btnTaxonomyTree)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(taxonomyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.cbSequenceDatabaseType, -2, -1, -2).addComponent(this.downloadButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.inputPanel.setBorder(BorderFactory.createTitledBorder("Database Information"));
        this.inputPanel.setOpaque(false);
        this.typeLbl.setText("Type");
        this.nameLbl.setText("Name");
        this.versionLbl.setText("Version");
        this.descriptionLbl.setText("Description");
        this.descriptionTxt.setColumns(20);
        this.descriptionTxt.setRows(5);
        this.descriptionScrollPane.setViewportView(this.descriptionTxt);
        this.parsingRuleTxt.setEditable(false);
        this.parsingRuleTxt.setEnabled(false);
        this.parsingRuleLbl.setText("Parsing Rule");
        this.lbSequenceContentType.setText("-");
        GroupLayout inputPanelLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(inputPanelLayout);
        inputPanelLayout.setHorizontalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLbl).addComponent(this.typeLbl)).addGap(18, 18, 18).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTxt).addComponent(this.lbSequenceContentType, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parsingRuleLbl).addComponent(this.versionLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionTxt).addComponent(this.parsingRuleTxt))).addComponent(this.descriptionScrollPane)).addContainerGap()).addGroup(inputPanelLayout.createSequentialGroup().addComponent(this.descriptionLbl).addGap(0, 0, Short.MAX_VALUE)))));
        inputPanelLayout.setVerticalGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLbl).addComponent(this.parsingRuleLbl).addComponent(this.parsingRuleTxt, -2, -1, -2).addComponent(this.lbSequenceContentType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLbl).addComponent(this.versionLbl).addComponent(this.nameTxt, -2, -1, -2).addComponent(this.versionTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLbl).addGap(4, 4, 4).addComponent(this.descriptionScrollPane, -1, 171, Short.MAX_VALUE).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromUniprotDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSequencesFromUniprotDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addGap(8, 8, 8).addComponent(this.cancelButton)).addComponent(this.taxonomyPanel, -1, -1, Short.MAX_VALUE).addComponent(this.inputPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.taxonomyPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inputPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        this.downloadDatabase();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void cbSequenceDatabaseTypeActionPerformed(ActionEvent evt) {
    }

    private void tfTaxonomyIDActionPerformed(ActionEvent evt) {
    }

    private void cbModelOrganismActionPerformed(ActionEvent evt) {
    }

    private void btnTaxonomyTreeActionPerformed(ActionEvent evt) {
        Iterator<String> iterator;
        TaxonomyTreeDialog treeDialog = new TaxonomyTreeDialog(null, true);
        treeDialog.setTitle("Taxonomy Browser");
        treeDialog.setLocationRelativeTo(null);
        treeDialog.setVisible(true);
        HashMap<String, String> taxonomyResult = treeDialog.getTaxonomyResult();
        if (taxonomyResult != null && (iterator = taxonomyResult.keySet().iterator()).hasNext()) {
            this.tfTaxonomyID.setText(iterator.next());
        }
        treeDialog.dispose();
        this.downloadButtonActionPerformed(evt);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public File getSelectedFile() {
        return this.downloadFile;
    }

    public void downloadDatabase() {
        try {
            String fileName = this.tfTaxonomyID.getText() + "_" + String.valueOf(this.cbSequenceDatabaseType.getSelectedItem()) + ".FASTA";
            File managerFolder = this.utilitiesUserPreferences.getProteinSequencesManagerFolder();
            File tempFolder = new File(managerFolder, ".temp");
            tempFolder.mkdirs();
            this.downloadFile = new File(tempFolder, fileName);
            progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalImange, this.waitingImage, true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Loading Database. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("importThread"){
                private FastaIndex selectedFileIndex;

                @Override
                public void run() {
                    try {
                        int taxID = Integer.parseInt(ImportSequencesFromUniprotDialog.this.tfTaxonomyID.getText());
                        UniProtQuery query = new UniProtQuery(taxID, (SequenceContentType)((Object)ImportSequencesFromUniprotDialog.this.cbSequenceDatabaseType.getSelectedItem()));
                        progressDialog.setTitle("Downloading Database. Please Wait...");
                        progressDialog.setPrimaryProgressCounterIndeterminate(false);
                        if (DownloadingUtil.downloadFileFromURL(ImportSequencesFromUniprotDialog.this, query.getQueryURL(), ImportSequencesFromUniprotDialog.this.downloadFile, progressDialog)) {
                            progressDialog.setTitle("Indexing Database. Please Wait...");
                            this.selectedFileIndex = SequenceFactory.getFastaIndex(ImportSequencesFromUniprotDialog.this.downloadFile, false, progressDialog);
                        }
                    }
                    catch (NumberFormatException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(ImportSequencesFromUniprotDialog.this, e.getMessage(), "FASTA Import Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    catch (MalformedURLException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(ImportSequencesFromUniprotDialog.this, e.getMessage(), "FASTA Import Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    catch (IOException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(ImportSequencesFromUniprotDialog.this, new String[]{"FASTA Import Error.", "File " + ImportSequencesFromUniprotDialog.this.downloadFile.getAbsolutePath() + " not found."}, "FASTA Import Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(ImportSequencesFromUniprotDialog.this, e.getMessage(), "FASTA Import Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(ImportSequencesFromUniprotDialog.this, e.getMessage(), "FASTA Import Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    if (!progressDialog.isRunCanceled()) {
                        ImportSequencesFromUniprotDialog.this.lbSequenceContentType.setText(ImportSequencesFromUniprotDialog.this.cbSequenceDatabaseType.getSelectedItem().toString().toLowerCase());
                        ImportSequencesFromUniprotDialog.this.cbSequenceDatabaseType.setSelectedItem((Object)this.selectedFileIndex.getMainDatabaseType());
                        ImportSequencesFromUniprotDialog.this.nameTxt.setText(this.selectedFileIndex.getName());
                        ImportSequencesFromUniprotDialog.this.versionTxt.setText(this.selectedFileIndex.getVersion());
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        Date date = new Date();
                        ImportSequencesFromUniprotDialog.this.descriptionTxt.setText("Taxonomy ID : " + ImportSequencesFromUniprotDialog.this.tfTaxonomyID.getText() + " " + ImportSequencesFromUniprotDialog.this.cbSequenceDatabaseType.getSelectedItem().toString().toLowerCase() + " downloaded at " + dateFormat.format(date));
                        ImportSequencesFromUniprotDialog.this.cbSequenceDatabaseType.setEnabled(true);
                        ImportSequencesFromUniprotDialog.this.nameTxt.setEnabled(true);
                        ImportSequencesFromUniprotDialog.this.versionTxt.setEnabled(true);
                        ImportSequencesFromUniprotDialog.this.descriptionTxt.setEnabled(true);
                    } else {
                        ImportSequencesFromUniprotDialog.this.clearDatabaseSelection();
                    }
                    progressDialog.setRunFinished();
                }
            }.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "An error occurred while importing " + this.downloadFile.getName() + ".", "Error", 0);
            this.clearDatabaseSelection();
        }
    }

    public void clearDatabaseSelection() {
        this.downloadFile = null;
        this.parsingRuleTxt.setText("");
        this.parsingRuleTxt.setEnabled(false);
        this.nameTxt.setText("");
        this.nameTxt.setEnabled(false);
        this.versionTxt.setText("");
        this.versionTxt.setEnabled(false);
        this.descriptionTxt.setText("");
        this.descriptionTxt.setEnabled(false);
    }

    public void loadUserPreferences() {
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (this.utilitiesUserPreferences.getProteinSequencesManagerFolder() == null || !this.utilitiesUserPreferences.getProteinSequencesManagerFolder().exists()) {
            throw new IllegalArgumentException("Database folder not set.");
        }
        this.lastSelectedFolder = this.utilitiesUserPreferences.getLastSelectedFolder();
    }
}

