/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope;

import fr.profi.mzscope.InvalidMGFFormatException;
import fr.profi.mzscope.MGFConstants;
import fr.profi.mzscope.MSMSSpectrum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGFReader {
    private static final Logger logger = LoggerFactory.getLogger(MGFReader.class);
    private int currentLine = 0;
    private List<MSMSSpectrum> spectrumList;

    public List<MSMSSpectrum> read(File f) throws InvalidMGFFormatException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new InvalidMGFFormatException(e.getMessage());
        }
        InputStreamReader reader = new InputStreamReader(fis);
        return this.read(reader);
    }

    public List<MSMSSpectrum> read(InputStreamReader reader) throws InvalidMGFFormatException {
        this.spectrumList = new ArrayList<MSMSSpectrum>();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String nextLine = this.nextLine(bufferedReader);
            while (nextLine != null) {
                if (nextLine.startsWith(MGFConstants.START_QUERY)) {
                    MSMSSpectrum spectrum = this.readSpectrum(bufferedReader);
                    this.endSpectrum(this, spectrum);
                } else if (nextLine.startsWith(MGFConstants.START_COMMENT)) {
                    this.comment(this, nextLine.substring(1));
                }
                nextLine = this.nextLine(bufferedReader);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMGFFormatException(ioe.getMessage());
        }
        return this.spectrumList;
    }

    private String nextLine(BufferedReader reader) throws IOException {
        String nextLine = reader.readLine();
        if (nextLine != null) {
            nextLine = nextLine.trim();
            ++this.currentLine;
            if (nextLine.length() == 0) {
                return this.nextLine(reader);
            }
        }
        return nextLine;
    }

    private MSMSSpectrum readSpectrum(BufferedReader reader) throws InvalidMGFFormatException, IOException {
        String msg;
        Object[] args;
        double parentMass = -1.0;
        double parentIntensity = 0.0;
        int parentCharge = 0;
        double parentRetTime = 0.0;
        String title = null;
        String scans = null;
        String rawScans = null;
        String charges = null;
        ArrayList<double[]> allPeaks = new ArrayList<double[]>();
        String nextLine = reader.readLine();
        ++this.currentLine;
        boolean exitWithNoEnd = false;
        while (nextLine != null && !nextLine.startsWith(MGFConstants.END_QUERY)) {
            String value = null;
            String tag = nextLine;
            int separatorIndex = nextLine.indexOf(MGFConstants.VALUE_SEPARATOR);
            if (separatorIndex > 1) {
                tag = nextLine.substring(0, separatorIndex);
                value = nextLine.substring(separatorIndex + 1);
            }
            if (tag == null) {
                nextLine = this.nextLine(reader);
                if (nextLine != null) continue;
                exitWithNoEnd = true;
                break;
            }
            List<String> l = Arrays.asList(MGFConstants.MSMS_QUERY_TAGS);
            if (l.contains(tag)) {
                if (MGFConstants.PARENT_MASS_I.equals(tag)) {
                    double[] values = this.getMassAndIntensity(value);
                    parentMass = values[0];
                    parentIntensity = values[1];
                }
                if (MGFConstants.PARENT_CHARGE.equals(tag) && value != null) {
                    parentCharge = this.getCharge(value);
                    charges = value;
                }
                if (MGFConstants.TITLE.equals(tag) && value != null) {
                    title = value;
                }
                if (MGFConstants.RETENTION_TIME.equals(tag)) {
                    parentRetTime = this.getRetentionTime(value);
                }
                if (MGFConstants.SCANS.equals(tag) && value != null) {
                    scans = value;
                }
                if (MGFConstants.RAWSCANS.equals(tag) && value != null) {
                    rawScans = value;
                }
            } else {
                double[] peak = this.getPeakValue(nextLine);
                allPeaks.add(peak);
            }
            if ((nextLine = this.nextLine(reader)) != null) continue;
            exitWithNoEnd = true;
            break;
        }
        if (exitWithNoEnd) {
            args = new Object[]{this.currentLine};
            msg = MessageFormat.format("No END ION found for query [line:{0}]", args);
            throw new InvalidMGFFormatException(msg);
        }
        if (parentMass == -1.0) {
            args = new Object[]{this.currentLine};
            msg = MessageFormat.format("No mass specified for query [line:{0}]", args);
            throw new InvalidMGFFormatException(msg);
        }
        MSMSSpectrum spectra = new MSMSSpectrum(parentMass, parentIntensity, parentCharge, parentRetTime);
        if (title != null) {
            spectra.setAnnotation(MGFConstants.TITLE, title);
        }
        if (scans != null) {
            spectra.setAnnotation(MGFConstants.SCANS, scans);
        }
        if (rawScans != null) {
            spectra.setAnnotation(MGFConstants.RAWSCANS, rawScans);
        }
        if (charges != null) {
            spectra.setAnnotation(MGFConstants.ANNOTATION_CHARGE_STATES, charges);
        }
        for (int nbrPeaks = 0; nbrPeaks < allPeaks.size(); ++nbrPeaks) {
            double[] aPeak = (double[])allPeaks.get(nbrPeaks);
            spectra.addPeak(aPeak[0], aPeak[1]);
        }
        return spectra;
    }

    private double[] getPeakValue(String nextLine) throws InvalidMGFFormatException {
        double[] values = new double[2];
        StringTokenizer tokenizer = new StringTokenizer(nextLine);
        if (tokenizer.countTokens() != 2) {
            Object[] args = new Object[]{this.currentLine};
            String msg = MessageFormat.format("Mass and intensity values must be specified for each peak or end of spectrum not detected [line:{0}]", args);
            throw new InvalidMGFFormatException(msg);
        }
        try {
            values[0] = Double.parseDouble(tokenizer.nextToken());
            values[1] = Double.parseDouble(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            Object[] args = new Object[]{this.currentLine};
            String msg = MessageFormat.format("Mass and intensity values must be specified for each peak or end of spectrum not detected [line:{0}]", args);
            throw new InvalidMGFFormatException(msg);
        }
        return values;
    }

    private double getRetentionTime(String value) {
        double retTime = 0.0;
        if (value != null) {
            try {
                retTime = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                ArrayList<String> values = new ArrayList<String>();
                ArrayList<Double> result = new ArrayList<Double>();
                int commaIndex = value.indexOf(",");
                if (commaIndex != -1) {
                    values.add(value.substring(0, commaIndex));
                    values.add(value.substring(commaIndex + 1, value.length()));
                } else {
                    values.add(value);
                }
                for (int i = 0; i < values.size(); ++i) {
                    String nextValue = (String)values.get(i);
                    int dashIndex = nextValue.indexOf("-");
                    if (dashIndex != -1) {
                        try {
                            String firstDbl = nextValue.substring(0, dashIndex);
                            double first = Double.parseDouble(firstDbl);
                            String secDbl = nextValue.substring(dashIndex + 1, nextValue.length());
                            double sec = Double.parseDouble(secDbl);
                            double avg = (first + sec) / 2.0;
                            result.add(avg);
                        }
                        catch (NumberFormatException firstDbl) {}
                        continue;
                    }
                    try {
                        double dbl = Double.parseDouble(nextValue);
                        result.add(dbl);
                        continue;
                    }
                    catch (NumberFormatException dbl) {
                        // empty catch block
                    }
                }
                if (!result.isEmpty()) {
                    int nbrDbl;
                    for (nbrDbl = 0; nbrDbl < result.size(); ++nbrDbl) {
                        retTime += ((Double)result.get(nbrDbl)).doubleValue();
                    }
                    MessageFormat numberFormat = new MessageFormat("{0,number,0.0000} ", Locale.ENGLISH);
                    Object[] args = new Object[]{retTime /= (double)nbrDbl};
                    String retTimeStr = numberFormat.format(args);
                    retTime = Double.parseDouble(retTimeStr);
                }
                Object[] args = new Object[]{"retention time", this.currentLine};
                String msg = MessageFormat.format("Invalid {0} specified for query [line:{1}]", args);
                logger.warn(msg);
            }
        }
        return retTime;
    }

    private double[] getMassAndIntensity(String value) throws InvalidMGFFormatException {
        double[] ret = new double[2];
        if (value == null) {
            Object[] args = new Object[]{this.currentLine};
            String msg = MessageFormat.format("No mass specified for query [line:{0}]", args);
            throw new InvalidMGFFormatException(msg);
        }
        StringTokenizer tokenizer = new StringTokenizer(value);
        String firstVal = null;
        if (tokenizer.hasMoreTokens()) {
            firstVal = tokenizer.nextToken();
        }
        try {
            ret[0] = Double.parseDouble(firstVal);
        }
        catch (NumberFormatException nfe) {
            Object[] args = new Object[]{"mass", this.currentLine};
            String msg = MessageFormat.format("Invalid {0} specified for query [line:{1}]", args);
            throw new InvalidMGFFormatException(msg);
        }
        if (tokenizer.hasMoreTokens()) {
            String iVal = tokenizer.nextToken();
            try {
                ret[1] = Double.parseDouble(iVal);
            }
            catch (NumberFormatException nfe) {
                Object[] args = new Object[]{"intensity", this.currentLine};
                String msg = MessageFormat.format("Invalid {0} specified for query [line:{1}]", args);
                logger.warn(msg);
            }
        }
        return ret;
    }

    private int getCharge(String value) {
        int charge = 0;
        if (value == null) {
            return charge;
        }
        if (value.indexOf("+") != -1) {
            value = value.substring(0, value.indexOf("+"));
        }
        try {
            charge = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            Object[] args = new Object[]{"charge", this.currentLine};
            String msg = MessageFormat.format("Invalid {0} specified for query [line:{1}]", args);
            logger.warn(msg);
        }
        return charge;
    }

    public void endSpectrum(Object source, MSMSSpectrum spectrum) {
        if (this.spectrumList != null) {
            this.spectrumList.add(spectrum);
        }
    }

    public void comment(Object source, String text) {
    }
}

