/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ui;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.table.AbstractNonLazyTableModel;
import fr.proline.studio.table.Column;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;

public class IsotopicTableModel
extends AbstractNonLazyTableModel
implements GlobalTableModelInterface {
    private static TableCellRenderer FLOAT_2DIGITS = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 2);
    public static final Column COLTYPE_FEATURE_INDEX = new Column("index", "index", Integer.class, 0);
    public static final Column COLTYPE_FEATURE_MZCOL = new Column("m/z", "m/z", Double.class, 1, Column.DOUBLE_5DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_INTENSITY_COL = new Column("Int.", "Intensity", Float.class, 2, FLOAT_2DIGITS);
    private TheoreticalIsotopePattern m_isotopicPattern = null;

    public int[] getKeysColumn() {
        int[] keys = new int[]{COLTYPE_FEATURE_INDEX.getIndex(), COLTYPE_FEATURE_MZCOL.getIndex(), COLTYPE_FEATURE_INTENSITY_COL.getIndex()};
        return keys;
    }

    public int getInfoColumn() {
        return COLTYPE_FEATURE_INDEX.getIndex();
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public int getRowCount() {
        return this.m_isotopicPattern == null ? 0 : this.m_isotopicPattern.isotopeCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == COLTYPE_FEATURE_INDEX.getIndex()) {
            return rowIndex;
        }
        if (columnIndex == COLTYPE_FEATURE_INTENSITY_COL.getIndex()) {
            return Float.valueOf(this.m_isotopicPattern.abundances()[rowIndex]);
        }
        if (columnIndex == COLTYPE_FEATURE_MZCOL.getIndex()) {
            return this.m_isotopicPattern.mzAbundancePairs()[rowIndex]._1;
        }
        return null;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return 0;
    }

    public void setPattern(TheoreticalIsotopePattern pattern) {
        this.m_isotopicPattern = pattern;
        this.fireTableStructureChanged();
    }

    public TheoreticalIsotopePattern getIsotopicPattern() {
        return this.m_isotopicPattern;
    }

    public double[] getMasses() {
        if (this.m_isotopicPattern != null) {
            double[] masses = new double[this.m_isotopicPattern.isotopeCount()];
            for (int k = 0; k < masses.length; ++k) {
                masses[k] = (Double)this.m_isotopicPattern.mzAbundancePairs()[k]._1;
            }
            return masses;
        }
        return new double[0];
    }

    public float[] getAbundances() {
        if (this.m_isotopicPattern != null) {
            float[] abundances = new float[this.m_isotopicPattern.isotopeCount()];
            for (int k = 0; k < abundances.length; ++k) {
                abundances[k] = ((Float)this.m_isotopicPattern.mzAbundancePairs()[k]._2).floatValue();
            }
            return abundances;
        }
        return new float[0];
    }
}

