/*
 * Decompiled with CFR 0.152.
 */
package DatParser;

import DatParser.SpectrumAnnotationContainer;
import com.compomics.mascotdatfile.util.interfaces.FragmentIon;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.PeptideHitAnnotation;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.QueryToPeptideMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class MascotDatparser {
    public ArrayList<SpectrumAnnotationContainer> fragAnnotation(String dat) {
        MascotDatfile mdf = new MascotDatfile(dat);
        QueryToPeptideMap lQuery2P = mdf.getQueryToPeptideMap();
        ArrayList<SpectrumAnnotationContainer> psms = new ArrayList<SpectrumAnnotationContainer>();
        for (int j = 1; j <= lQuery2P.getNumberOfQueries(); ++j) {
            Query lQuery = mdf.getQuery(j);
            PeptideHit ph = lQuery2P.getPeptideHitOfOneQuery(j, 1);
            if (ph == null) continue;
            PeptideHitAnnotation lPha = new PeptideHitAnnotation(ph.getSequence(), ph.getModifications(), mdf.getMasses(), mdf.getParametersSection(), ph.getIonSeriesFound());
            Vector lMascotMatchedIons = lPha.getMatchedIonsByMascot(lQuery.getPeakList(), ph.getPeaksUsedFromIons1());
            HashMap<Double, String> fragannotation = new HashMap<Double, String>();
            for (int k = 0; k < lMascotMatchedIons.size(); ++k) {
                FragmentIon fm = (FragmentIon)lMascotMatchedIons.get(k);
                String fraglabel = fm.getType() + fm.getNumber();
                double fragmz = fm.getMZ() + fm.getTheoreticalExperimantalMassError();
                fragannotation.put(fragmz, fraglabel);
            }
            SpectrumAnnotationContainer psm = new SpectrumAnnotationContainer(lQuery.getFilename(), fragannotation);
            psms.add(psm);
        }
        return psms;
    }
}

