/*
 * Decompiled with CFR 0.152.
 */
package MZIDparser;

import MZIDparser.JPSM;
import Preprocessing.JPeak;
import Preprocessing.JSpectrum;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.math.MathException;

public class PeakMatch {
    public boolean bUseDynamicRange = true;
    public boolean bUseLowestMass = true;
    public boolean bUseMaxPeaks = true;
    public boolean bUseMinMass = true;
    public boolean bUseMinSize = true;
    public boolean bUseNeutralLoss = true;
    public int iMaxPeaks = 50;
    public double dDynamicRange = 100.0;
    public double dLowestMass = 150.0;
    public int iMinSize = 5;
    public static double ms2tol = 0.5;
    public double intensityLimit = 0.02;
    public double ticCutoffPercentage = 0.98;
    public MSnSpectrum spectrum;
    public ArrayList<IonMatch> matches = new ArrayList();
    public JSpectrum jSpectrum = new JSpectrum();
    public JPSM jpsm = new JPSM();
    public String fragmentMethod = "cid";
    public int maxFragmentChargeState = 3;
    private boolean lossWaterNH3 = false;

    public PeakMatch() {
    }

    public PeakMatch(MSnSpectrum spectrum, JSpectrum jSpectrum, JPSM jpsm) {
        this.spectrum = spectrum;
        this.jSpectrum = jSpectrum;
        this.jpsm = jpsm;
    }

    public void initialize(boolean lossWaterNH3, int maxFragCharge) throws IllegalArgumentException, FileNotFoundException, ClassNotFoundException, IOException, InterruptedException, SQLException, MathException {
        this.setLossWaterNH3(lossWaterNH3);
        this.setMaxFragmentChargeState(maxFragCharge);
        this.getSpectrumAnnotation();
    }

    public int removeLowMasses() {
        int rpn = 0;
        Iterator<JPeak> pListIterator = this.jSpectrum.getPeaks().iterator();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (!(jPeak.getMz() <= this.dLowestMass)) continue;
            ++rpn;
            pListIterator.remove();
        }
        return rpn;
    }

    public boolean filterByPeakCount() {
        boolean isRemove = false;
        int peaksNumber = this.jSpectrum.getPeaks().size();
        if (peaksNumber > this.iMaxPeaks) {
            this.jSpectrum.sortPeaksByIntensity();
            this.jSpectrum.getPeaks().subList(0, peaksNumber - this.iMaxPeaks).clear();
            isRemove = true;
        }
        return isRemove;
    }

    public boolean filterByPeakCount(int maxPeakCount) {
        boolean isRemove = false;
        int peaksNumber = this.jSpectrum.getPeaks().size();
        if (peaksNumber > maxPeakCount) {
            this.jSpectrum.sortPeaksByIntensity();
            this.jSpectrum.getPeaks().subList(0, peaksNumber - maxPeakCount).clear();
            isRemove = true;
        }
        return isRemove;
    }

    public int removeLowIntensityPeak() {
        int rpn = 0;
        double maxIntensity = this.jSpectrum.getMaxIntensityFragmentIonPeak().getIntensity();
        double limitIntensity = 1.0 * this.intensityLimit * maxIntensity;
        Iterator<JPeak> pListIterator = this.jSpectrum.getPeaks().iterator();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (!(jPeak.getIntensity() < limitIntensity)) continue;
            ++rpn;
            pListIterator.remove();
        }
        return rpn;
    }

    public int removeLowIntensityPeak(double interLimit) {
        int rpn = 0;
        double maxIntensity = this.jSpectrum.getMaxIntensityFragmentIonPeak().getIntensity();
        double limitIntensity = 1.0 * interLimit * maxIntensity;
        Iterator<JPeak> pListIterator = this.jSpectrum.getPeaks().iterator();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (!(jPeak.getIntensity() < limitIntensity)) continue;
            ++rpn;
            pListIterator.remove();
        }
        return rpn;
    }

    public int removeIsotopes() {
        int rpn = 0;
        if (this.jSpectrum.getPeaks().size() > 2) {
            this.getJSpectrum().sortPeaksByMZ();
            JPeak jPeak1 = this.getJSpectrum().getPeaks().get(0);
            JPeak jPeak2 = this.getJSpectrum().getPeaks().get(1);
            ArrayList<JPeak> tmpJPeaks = new ArrayList<JPeak>();
            double mz1 = jPeak1.getMz();
            for (int i = 1; i < this.getJSpectrum().getPeaks().size(); ++i) {
                jPeak2 = this.getJSpectrum().getPeaks().get(i);
                if (jPeak2.getMz() - mz1 >= 0.95 || jPeak2.getMz() < 200.0) {
                    tmpJPeaks.add(jPeak1);
                    jPeak1 = jPeak2;
                    mz1 = jPeak1.getMz();
                    continue;
                }
                if (!(jPeak2.getIntensity() > jPeak1.getIntensity())) continue;
                jPeak1 = jPeak2;
                mz1 = jPeak1.getMz();
            }
            rpn = this.jSpectrum.getPeaks().size() - tmpJPeaks.size();
            tmpJPeaks.add(jPeak1);
            this.jSpectrum.setPeaks(tmpJPeaks);
        }
        return rpn;
    }

    public int cleanIsotopes() {
        int rpn = 0;
        if (this.jSpectrum.getPeaks().size() > 2) {
            this.getJSpectrum().sortPeaksByMZ();
            JPeak jPeak1 = this.getJSpectrum().getPeaks().get(0);
            JPeak jPeak2 = this.getJSpectrum().getPeaks().get(1);
            ArrayList<JPeak> tmpJPeaks = new ArrayList<JPeak>();
            double mz1 = jPeak1.getMz();
            for (int i = 1; i < this.getJSpectrum().getPeaks().size(); ++i) {
                jPeak2 = this.getJSpectrum().getPeaks().get(i);
                if (jPeak2.getMz() - mz1 >= 1.5 || jPeak2.getMz() < 200.0) {
                    tmpJPeaks.add(jPeak1);
                    jPeak1 = jPeak2;
                    mz1 = jPeak1.getMz();
                    continue;
                }
                if (!(jPeak2.getIntensity() > jPeak1.getIntensity())) continue;
                jPeak1 = jPeak2;
                mz1 = jPeak1.getMz();
            }
            rpn = this.jSpectrum.getPeaks().size() - tmpJPeaks.size();
            tmpJPeaks.add(jPeak1);
            this.jSpectrum.setPeaks(tmpJPeaks);
        }
        return rpn;
    }

    public void normalizePeaks(double maxPeakAfterNornalize) {
        double maxIntensity = this.jSpectrum.getMaxIntensityFragmentIonPeak().getIntensity();
        for (int i = 0; i < this.jSpectrum.getPeaks().size(); ++i) {
            double norIntensity = 1.0 * maxPeakAfterNornalize * this.jSpectrum.getPeaks().get(i).getIntensity() / maxIntensity;
            this.jSpectrum.getPeaks().get(i).setIntensity(norIntensity);
        }
    }

    public MSnSpectrum getMSnSpectrum() {
        return this.spectrum;
    }

    public void setMSnSpectrum(MSnSpectrum spectrum) {
        this.spectrum = spectrum;
    }

    public ArrayList<IonMatch> getIonMatches() {
        return this.matches;
    }

    public void setIonMatches(ArrayList<IonMatch> matches) {
        this.matches = matches;
    }

    public JSpectrum getJSpectrum() {
        return this.jSpectrum;
    }

    public void setJSpectrum(JSpectrum jSpectrum) {
        this.jSpectrum = jSpectrum;
    }

    public ArrayList<IonMatch> getCopyOfIonMatches() {
        ArrayList<IonMatch> newIonMatches = new ArrayList<IonMatch>();
        for (IonMatch ionMatch : this.getIonMatches()) {
            newIonMatches.add(ionMatch);
        }
        return newIonMatches;
    }

    public String getFragmentMethod() {
        return this.fragmentMethod;
    }

    public void setFragmentMethod(String fragmentMethod) {
        this.fragmentMethod = fragmentMethod;
    }

    public JPSM getPSM() {
        return this.jpsm;
    }

    public void setPSM(JPSM j) {
        this.jpsm = j;
    }

    public int filterByTIC() {
        int rpn = 0;
        if (this.jSpectrum.getPeaks().size() > 7) {
            double totalIonCurrent = this.jSpectrum.getTotalIonCurrent();
            double relativeIntensity = 0.0;
            this.jSpectrum.sortPeaksByIntensity();
            ArrayList<JPeak> tmpJPeaks = new ArrayList<JPeak>();
            for (int i = this.jSpectrum.getPeaks().size() - 1; i >= 0; --i) {
                if ((relativeIntensity += this.jSpectrum.getPeaks().get(i).getIntensity() / totalIonCurrent) <= this.ticCutoffPercentage) {
                    tmpJPeaks.add(this.jSpectrum.getPeaks().get(i));
                    continue;
                }
                ++rpn;
            }
            this.jSpectrum.setPeaks(tmpJPeaks);
        }
        return rpn;
    }

    public int getMaxFragmentChargeState() {
        return this.maxFragmentChargeState;
    }

    public void setMaxFragmentChargeState(int maxFragmentChargeState) {
        this.maxFragmentChargeState = maxFragmentChargeState;
    }

    public int filterPeakByRange(double lowBoundmz, double upBoundmz) {
        int rpn = 0;
        Iterator<JPeak> pListIterator = this.jSpectrum.getPeaks().iterator();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (!(jPeak.getMz() < lowBoundmz) && !(jPeak.getMz() > upBoundmz)) continue;
            ++rpn;
            pListIterator.remove();
        }
        return rpn;
    }

    public int keepTopNPeaksInRegions(int n, double regionMass) throws InterruptedException {
        int rpn = 0;
        HashMap<Double, Integer> mz2region = new HashMap<Double, Integer>();
        HashMap<Integer, Integer> regionP = new HashMap<Integer, Integer>();
        for (JPeak jPeak : this.jSpectrum.getPeaks()) {
            int rg = (int)Math.floor(1.0 * jPeak.getMz() / regionMass) - 1;
            if (rg < 0) continue;
            mz2region.put(jPeak.getMz(), rg);
            regionP.put(rg, 0);
        }
        this.jSpectrum.sortPeaksByIntensity();
        Collections.reverse(this.jSpectrum.getPeaks());
        Iterator<JPeak> pListIterator = this.jSpectrum.getPeaks().iterator();
        while (pListIterator.hasNext()) {
            JPeak jPeak;
            jPeak = pListIterator.next();
            double ionMz = jPeak.getMz();
            if (!mz2region.containsKey(ionMz)) {
                pListIterator.remove();
                ++rpn;
                continue;
            }
            int rg = (Integer)mz2region.get(ionMz);
            if ((Integer)regionP.get(rg) >= n) {
                pListIterator.remove();
                ++rpn;
                continue;
            }
            regionP.put(rg, (Integer)regionP.get(rg) + 1);
        }
        return rpn;
    }

    public int removePeakGreaterBy(double cutoff) {
        int rpn = 0;
        Iterator<JPeak> pListIterator = this.jSpectrum.getPeaks().iterator();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (!(jPeak.getMz() > cutoff)) continue;
            ++rpn;
            pListIterator.remove();
        }
        return rpn;
    }

    public int removePeakAroundParent(double cutoff) {
        int rpn = 0;
        Iterator<JPeak> pListIterator = this.jSpectrum.getPeaks().iterator();
        double precursor_mz = this.jSpectrum.getParentMassToCharge();
        while (pListIterator.hasNext()) {
            JPeak jPeak = pListIterator.next();
            if (!(jPeak.getMz() > precursor_mz - cutoff) || !(jPeak.getMz() < precursor_mz + cutoff)) continue;
            ++rpn;
            pListIterator.remove();
        }
        return rpn;
    }

    public void getSpectrumAnnotation() throws IllegalArgumentException, ClassNotFoundException, IOException, InterruptedException, SQLException, MathException {
        ArrayList matches;
        this.jSpectrum.resetPeaks();
        this.jSpectrum.sortPeaksByMZ();
        Peptide objPeptide = new Peptide(this.jpsm.getPepSeq(), this.jpsm.getModificationMatch());
        ArrayList mm = objPeptide.getModificationMatches();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        String spectrumKey = this.spectrum.getSpectrumKey();
        Charge objCharge = new Charge(1, this.jpsm.getCharge());
        PeptideAssumption peptideAssumption = new PeptideAssumption(objPeptide, 1, 1, objCharge, 1.0);
        SpecificAnnotationSettings specificAnnotationPreferences = new SpecificAnnotationSettings(spectrumKey, (SpectrumIdentificationAssumption)peptideAssumption);
        ArrayList<Integer> charges = new ArrayList<Integer>(4);
        int precursorCharge = peptideAssumption.getIdentificationCharge().value;
        if (precursorCharge == 1) {
            charges.add(precursorCharge);
        } else {
            for (int c = 1; c < precursorCharge; ++c) {
                charges.add(c);
            }
        }
        specificAnnotationPreferences.setSelectedCharges(charges);
        specificAnnotationPreferences.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 1);
        specificAnnotationPreferences.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 4);
        specificAnnotationPreferences.setFragmentIonAccuracy(ms2tol);
        specificAnnotationPreferences.setFragmentIonPpm(false);
        specificAnnotationPreferences.setNeutralLossesAuto(false);
        specificAnnotationPreferences.clearNeutralLosses();
        specificAnnotationPreferences.addNeutralLoss(NeutralLoss.H2O);
        specificAnnotationPreferences.addNeutralLoss(NeutralLoss.NH3);
        AnnotationSettings annotationSettings = new AnnotationSettings();
        annotationSettings.setHighResolutionAnnotation(false);
        annotationSettings.setFragmentIonAccuracy(ms2tol);
        annotationSettings.setFragmentIonPpm(false);
        annotationSettings.setIntensityLimit(this.intensityLimit);
        this.matches = matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationSettings, specificAnnotationPreferences, this.spectrum, objPeptide);
    }

    public boolean isLossWaterNH3() {
        return this.lossWaterNH3;
    }

    public void setLossWaterNH3(boolean lossWaterNH3) {
        this.lossWaterNH3 = lossWaterNH3;
    }

    public static double getMs2tol() {
        return ms2tol;
    }

    public static void setMs2tol(double va) {
        ms2tol = va;
    }
}

