/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.exporter;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteStatement;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SQLiteIsolationWindowStorer$
implements LazyLogging {
    public static SQLiteIsolationWindowStorer$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SQLiteIsolationWindowStorer$();
    }

    private Logger logger$lzycompute() {
        SQLiteIsolationWindowStorer$ sQLiteIsolationWindowStorer$ = this;
        synchronized (sQLiteIsolationWindowStorer$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void storeIsolationWindows(MzDbReader mzDbReader, File dbLocation) {
        SQLiteConnection connection = new SQLiteConnection(dbLocation);
        connection.open(true);
        connection.exec("PRAGMA temp_store=2;");
        connection.exec("PRAGMA cache_size=8000;");
        connection.exec("CREATE TABLE isolation_window ( spectrum_id INTEGER,\n time REAL,\n precursor_mz REAL,\n spectrum BLOB\n)");
        connection.exec("BEGIN TRANSACTION");
        SQLiteStatement stmt = connection.prepare("INSERT INTO isolation_window VALUES (?, ?, ?, ?)", true);
        mzDbReader.enablePrecursorListLoading();
        Map ms1ShByCycle = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mzDbReader.getMs1SpectrumHeaders())).map((Function1 & Serializable & scala.Serializable)sh -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)sh.getCycle())), sh), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        SpectrumHeader[] ms2SpectrumHeaders = (SpectrumHeader[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mzDbReader.getMs2SpectrumHeaders())).take(1000);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ms2SpectrumHeaders)).foreach((Function1 & Serializable & scala.Serializable)sh -> {
            BoxedUnit boxedUnit;
            SpectrumHeader ms1Sh = (SpectrumHeader)ms1ShByCycle.apply((Object)BoxesRunTime.boxToInteger((int)sh.getCycle()));
            double precMz = sh.getPrecursor().parseFirstSelectedIonMz();
            SpectrumSlice[] spectrumSlices = mzDbReader.getMsSpectrumSlices(precMz - (double)2, precMz + (double)2, ms1Sh.getTime() - 0.2f, ms1Sh.getTime() + 0.2f);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).isEmpty()) {
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("no spectrum data loaded");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                Predef$.MODULE$.require(spectrumSlices.length == 1, (Function0 & Serializable & scala.Serializable)() -> "weird");
                SpectrumData filteredData = ((Spectrum)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).head()).getData().mzRangeFilter(precMz - 1.0, precMz + 1.0);
                if (filteredData != null) {
                    Tuple2[] dataPoints = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredData.toPeaks((ILcContext)sh))).map((Function1 & Serializable & scala.Serializable)peak -> (Tuple2[])((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)(peak.getMz() - 1.0E-5))), (Object)BoxesRunTime.boxToFloat((float)0.0f)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)peak.getMz())), (Object)BoxesRunTime.boxToFloat((float)peak.getIntensity())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)(peak.getMz() + 1.0E-5))), (Object)BoxesRunTime.boxToFloat((float)0.0f))}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)))))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Tuple2.class));
                    byte[] chartBytes = MODULE$.createSpectrumChart(dataPoints);
                    int j = 0;
                    stmt.bind(++j, sh.getId());
                    stmt.bind(++j, (double)sh.getTime());
                    stmt.bind(++j, precMz);
                    stmt.bind(++j, chartBytes);
                    stmt.step();
                    boxedUnit = stmt.reset();
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
        connection.exec("COMMIT TRANSACTION");
        connection.dispose();
    }

    public byte[] createSpectrumChart(Tuple2<Object, Object>[] dataPoints) {
        XYSeries series = new XYSeries((Comparable)((Object)"SPECTRUM"));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataPoints)).foreach((Function1 & Serializable & scala.Serializable)dataPoint -> {
            series.add(dataPoint._1$mcD$sp(), (double)BoxesRunTime.unboxToFloat((Object)dataPoint._2()));
            return BoxedUnit.UNIT;
        });
        XYSeriesCollection xyDataset = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"SPECTRUM", (String)"m/z", (String)"Intensity", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        BufferedImage bi = this.chartToImage(chart, 800, 600);
        return ChartUtils.encodeAsPNG((BufferedImage)bi);
    }

    public BufferedImage chartToImage(JFreeChart chart, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = img.createGraphics();
        chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.dispose();
        return img;
    }

    private SQLiteIsolationWindowStorer$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

