/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.model;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class Signal {
    private static final Logger logger = LoggerFactory.getLogger(Signal.class);
    private int m_signalType = 0;
    public static final int PROFILE = 0;
    public static final int CENTROID = 1;
    private double[] m_xSeries;
    private double[] m_ySeries;

    public Signal(double[] xSeries, double[] ySeries) {
        this.m_xSeries = xSeries;
        this.m_ySeries = ySeries;
    }

    public Signal(double[] xSeries, float[] ySeries) {
        this.m_xSeries = xSeries;
        this.m_ySeries = Signal.convertToDoubleArray(ySeries);
    }

    public void setSignalType(int signalType) {
        if (signalType == 0 || signalType == 1) {
            this.m_signalType = signalType;
        }
    }

    public int getSignalType() {
        return this.m_signalType;
    }

    public double[] getXSeries() {
        return this.m_xSeries;
    }

    public double[] getYSeries() {
        return this.m_ySeries;
    }

    private static double[] convertToDoubleArray(float[] source) {
        double[] dest = new double[source.length];
        for (int i = 0; i < source.length; ++i) {
            dest[i] = source[i];
        }
        return dest;
    }

    public List<Tuple2> toScalaArrayTuple(boolean includeNullIntensity) {
        ArrayList<Tuple2> xyPairs = new ArrayList<Tuple2>();
        for (int k = 0; k < this.m_xSeries.length; ++k) {
            if (!includeNullIntensity && this.m_ySeries[k] <= 0.0) continue;
            xyPairs.add(new Tuple2((Object)this.m_xSeries[k], (Object)this.m_ySeries[k]));
        }
        return xyPairs;
    }
}

