/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzml;

import fr.proline.mzscope.model.Chromatogram;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.mzml.Scan;
import fr.proline.mzscope.utils.BinarySearch;
import java.text.DecimalFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XICExtractor {
    static Logger logger = LoggerFactory.getLogger(XICExtractor.class);
    private static final DecimalFormat massFormatter = new DecimalFormat("0.0000");

    static void search(Scan s, float v) {
        BinarySearch bs = new BinarySearch();
        float[] values = s.getMasses();
        int index = bs.searchIndex(values, v, 0, values.length);
        logger.debug("value " + v + " found at " + index);
        logger.debug("average iterations " + bs.getIterations());
    }

    static IChromatogram extract(List<Scan> scans, float vmin, float vmax) {
        BinarySearch bs = new BinarySearch();
        long start = System.currentTimeMillis();
        double[] XIintensities = new double[scans.size()];
        double[] XItime = new double[scans.size()];
        float[] masses = scans.get(0).getMasses();
        float[] intensities = scans.get(0).getIntensities();
        int index = bs.searchIndex(masses, vmin, 0, masses.length);
        XIintensities[0] = XICExtractor.summary(masses, intensities, index, vmax);
        XItime[0] = scans.get(0).getRetentionTime();
        for (int k = 1; k < scans.size(); ++k) {
            masses = scans.get(k).getMasses();
            intensities = scans.get(k).getIntensities();
            index = bs.searchIndex(masses, vmin, 0, masses.length);
            XIintensities[k] = XICExtractor.summary(masses, intensities, index, vmax);
            XItime[k] = scans.get(k).getRetentionTime();
        }
        logger.info("search in :: " + (System.currentTimeMillis() - start) + " ms");
        logger.info("average iterations :: " + (float)bs.getIterations() / (float)scans.size());
        logger.info("nb of failed prediction :: " + bs.getFails());
        Chromatogram chromatogram = new Chromatogram(null, null, XItime, XIintensities);
        chromatogram.setMinMz(vmin);
        chromatogram.setMaxMz(vmax);
        StringBuilder builder = new StringBuilder("Mass range: ");
        builder.append(massFormatter.format(chromatogram.getMinMz())).append("-").append(massFormatter.format(chromatogram.getMaxMz()));
        return chromatogram;
    }

    static double summary(float[] masses, float[] intensities, int index, float vmax) {
        int index2;
        double result = 0.0;
        int n = index2 = index <= 0 ? 1 : index;
        while (index2 < masses.length - 1 && masses[index2] < vmax) {
            if (intensities[index2] > intensities[index2 - 1] && intensities[index2] >= intensities[index2 + 1]) {
                result += (double)intensities[index2++];
            }
            ++index2;
        }
        return result;
    }
}

