/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import com.almworks.sqlite4java.SQLiteException;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Point;
import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.PeakelsPatternPredictor;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.IsotopicPatternUtils;
import fr.proline.mzscope.processing.SpectrumUtils;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class PeakelsHelper {
    public static final String VALID_FEATURES = "valid features";
    public static final String DUBIOUS_FEATURES = "dubious features";
    private static final Logger logger = LoggerFactory.getLogger(PeakelsHelper.class);
    public static int HALF_MZ_WINDOW = 5;
    private static float RT_TOLERANCE = 40.0f;
    private static float INTENSITY_PERCENTILE = 0.99f;
    private List<Peakel> peakels;
    private RTree<Peakel, Point> rTree;

    public PeakelsHelper(Peakel[] peakels) {
        this(Arrays.asList(peakels));
    }

    public PeakelsHelper(List<Peakel> peakels) {
        logger.info("creates PeakelsHelper with {} peakels", (Object)peakels.size());
        this.peakels = peakels;
        this.rTree = RTree.create();
        for (Peakel p : peakels) {
            this.rTree = this.rTree.add((Object)p, (Geometry)Geometries.point((double)p.getMz(), (double)p.getElutionTime()));
        }
        logger.info("built RTree contains {} peakels", (Object)this.rTree.size());
    }

    public List<Peakel> findCoelutingPeakels(double minMz, double maxMz, float minRt, float maxRt) {
        ArrayList<Peakel> coelutingPeakels = new ArrayList<Peakel>(1000);
        Iterator peakelIterator = this.rTree.search(Geometries.rectangle((double)minMz, (double)minRt, (double)maxMz, (double)maxRt)).toBlocking().toIterable().iterator();
        while (peakelIterator.hasNext()) {
            coelutingPeakels.add((Peakel)((Entry)peakelIterator.next()).value());
        }
        return coelutingPeakels;
    }

    public List<Peakel> findCoelutingPeakels(double minMz, double maxMz, float minRt, float maxRt, Map<Integer, Peakel> assigned) {
        ArrayList<Peakel> coelutingPeakels = new ArrayList<Peakel>(1000);
        Iterator peakelIterator = this.rTree.search(Geometries.rectangle((double)minMz, (double)minRt, (double)maxMz, (double)maxRt)).toBlocking().toIterable().iterator();
        while (peakelIterator.hasNext()) {
            Peakel p = (Peakel)((Entry)peakelIterator.next()).value();
            if (assigned.containsKey(p.getId())) continue;
            coelutingPeakels.add(p);
        }
        return coelutingPeakels;
    }

    public Map<String, List<Feature>> deisotopePeakels(float mzTolPPM, float rtTolerance) throws StreamCorruptedException, SQLiteException {
        long start = System.currentTimeMillis();
        DescriptiveStatistics[] stats = new DescriptiveStatistics[]{new DescriptiveStatistics(), new DescriptiveStatistics(), new DescriptiveStatistics()};
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Feature> monoPeakelFeatures = new ArrayList<Feature>();
        HashMap<Integer, Peakel> assigned = new HashMap<Integer, Peakel>();
        this.peakels.sort((o1, o2) -> Double.compare(o2.getApexIntensity(), o1.getApexIntensity()));
        for (int k = 0; k < this.peakels.size(); ++k) {
            Peakel peakel;
            if (k % 10000 == 0) {
                logger.info("processing peakel " + k);
            }
            if (assigned.containsKey((peakel = this.peakels.get(k)).getId())) continue;
            SpectrumData data = this.buildSpectrumFromPeakels(k, assigned, rtTolerance);
            TheoreticalIsotopePattern pattern = (TheoreticalIsotopePattern)IsotopicPatternUtils.predictIsotopicPattern((SpectrumData)data, (double)peakel.getMz(), (double)((double)mzTolPPM))._2;
            ArrayList<Peakel> l = new ArrayList<Peakel>(pattern.isotopeCount() + 1);
            int gapRank = 0;
            int indexOfMatching = 0;
            for (Tuple2 tuple2 : pattern.mzAbundancePairs()) {
                if (1000000.0 * (Math.abs(peakel.getMz() - (Double)tuple2._1) / peakel.getMz()) < (double)mzTolPPM) break;
                ++indexOfMatching;
            }
            if (Math.abs(peakel.getMz() - 762.70542) < 1.0E-4 && Math.abs((double)peakel.getApexElutionTime() - 7639.8) < 10.0) {
                logger.info("this one");
            }
            double scaling = peakel.getApexIntensity() / ((Float)pattern.mzAbundancePairs()[indexOfMatching]._2).floatValue();
            int rank = 0;
            for (Tuple2 t : pattern.mzAbundancePairs()) {
                double patternMz = (Double)t._1;
                float patternNormAbundance = ((Float)t._2).floatValue();
                float minRt = peakel.getFirstElutionTime();
                float maxRt = peakel.getLastElutionTime();
                List<Peakel> isotopes = this.findCoelutingPeakels(patternMz - patternMz * (double)mzTolPPM / 1000000.0, patternMz + patternMz * (double)mzTolPPM / 1000000.0, minRt, maxRt);
                Peakel bestMatching = null;
                double maxCorr = Double.MIN_VALUE;
                for (Peakel p : isotopes) {
                    double corr = SpectrumUtils.correlation(peakel, p);
                    if (!(corr > 0.5) || !(corr > maxCorr) || !((double)p.getApexIntensity() < (double)(4.0f * patternNormAbundance) * scaling)) continue;
                    maxCorr = corr;
                    bestMatching = p;
                }
                if (bestMatching != null) {
                    if (!assigned.containsKey(bestMatching.getId())) {
                        gapRank = 0;
                        assigned.put(bestMatching.getId(), bestMatching);
                        l.add(bestMatching);
                    }
                } else {
                    ++gapRank;
                }
                if (gapRank >= 3) break;
                ++rank;
            }
            if (l.isEmpty()) {
                logger.info("Strange situation: peakel {}, {} not found from pattern at mono {}, {}+ (indexOfMatching: {})", new Object[]{peakel.getMz(), (double)peakel.getElutionTime() / 60.0, pattern.monoMz(), pattern.charge(), indexOfMatching});
                l.add(peakel);
            }
            Feature feature = new Feature(((Peakel)l.get(0)).getMz(), pattern.charge(), (Buffer)JavaConverters.asScalaBufferConverter(l).asScala(), true);
            if (l.size() > 1) {
                features.add(feature);
                stats[0].addValue((double)feature.getBasePeakel().getApexIntensity());
                stats[1].addValue((double)feature.calcDuration());
                stats[2].addValue((double)feature.getMs1Count());
                continue;
            }
            monoPeakelFeatures.add(feature);
        }
        double minIntensity = stats[0].getPercentile(10.0);
        double maxDuration = stats[1].getMax();
        double minMs1Count = stats[2].getPercentile(10.0);
        logger.info("Filter dubious features: Thresholds are minIntensity={}, maxDuration={}, minMs1Count{}", new Object[]{minIntensity, maxDuration, minMs1Count});
        HashMap<String, List<Feature>> map = new HashMap<String, List<Feature>>();
        map.put(VALID_FEATURES, features);
        map.put(DUBIOUS_FEATURES, new ArrayList());
        for (Feature f : monoPeakelFeatures) {
            if (f.getCharge() > 1) {
                ((List)map.get(VALID_FEATURES)).add(f);
                continue;
            }
            ((List)map.get(DUBIOUS_FEATURES)).add(f);
        }
        logger.info("Features detected : {} in {} ms", (Object)((List)map.get(VALID_FEATURES)).size(), (Object)(System.currentTimeMillis() - start));
        return map;
    }

    public List<Feature> deisotopePeakelsFromMzdb(MzDbReader reader, float mzTolPPM) throws StreamCorruptedException, SQLiteException {
        long start = System.currentTimeMillis();
        ArrayList<Feature> result = new ArrayList<Feature>();
        HashMap<Integer, Peakel> assigned = new HashMap<Integer, Peakel>();
        this.peakels.sort(new Comparator<Peakel>(){

            @Override
            public int compare(Peakel o1, Peakel o2) {
                return Double.compare(o2.getApexIntensity(), o1.getApexIntensity());
            }
        });
        for (int k = 0; k < this.peakels.size(); ++k) {
            if (k % 10000 == 0) {
                logger.info("processing peakel " + k);
            }
            if (assigned.containsKey(this.peakels.get(k).getId())) continue;
            SpectrumData data = reader.getSpectrumData(this.peakels.get(k).getApexSpectrumId());
            TheoreticalIsotopePattern bestPattern = (TheoreticalIsotopePattern)IsotopicPatternUtils.predictIsotopicPattern((SpectrumData)data, (double)this.peakels.get((int)k).getMz(), (double)((double)mzTolPPM))._2;
            ArrayList<Peakel> l = new ArrayList<Peakel>(bestPattern.isotopeCount() + 1);
            for (Tuple2 t : bestPattern.mzAbundancePairs()) {
                double mz = (Double)t._1;
                List<Peakel> isotopes = this.findCoelutingPeakels(mz - mz * (double)mzTolPPM / 1000000.0, mz + mz * (double)mzTolPPM / 1000000.0, this.peakels.get(k).getFirstElutionTime(), this.peakels.get(k).getLastElutionTime());
                Peakel bestMatching = null;
                double maxCorr = Double.MIN_VALUE;
                for (Peakel p : isotopes) {
                    double corr = SpectrumUtils.correlation(this.peakels.get(k), p);
                    if (!(corr > 0.5) || !(corr > maxCorr)) continue;
                    maxCorr = corr;
                    bestMatching = p;
                }
                if (bestMatching == null || assigned.containsKey(bestMatching.getId())) continue;
                assigned.put(bestMatching.getId(), bestMatching);
                l.add(bestMatching);
            }
            if (l.isEmpty()) {
                logger.trace("Strange situation : peakel not found within isotopic pattern .... " + this.peakels.get(k).getMz());
                l.add(this.peakels.get(k));
            }
            Feature feature = new Feature(((Peakel)l.get(0)).getMz(), bestPattern.charge(), (Buffer)JavaConverters.asScalaBufferConverter(l).asScala(), true);
            result.add(feature);
        }
        logger.info("Features detected : {} in {} ms", (Object)result.size(), (Object)(System.currentTimeMillis() - start));
        return result;
    }

    private SpectrumData buildSpectrumFromPeakels(int k, Map<Integer, Peakel> assigned, float rtTolerance) {
        Peakel peakel = this.peakels.get(k);
        List<Peakel> coelutingPeakels = this.findCoelutingPeakels(peakel.getApexMz() - (double)HALF_MZ_WINDOW, peakel.getApexMz() + (double)HALF_MZ_WINDOW, peakel.getElutionTime() - rtTolerance, peakel.getElutionTime() + rtTolerance);
        return this.buildSpectrumFromPeakels(coelutingPeakels, peakel);
    }

    public SpectrumData buildSpectrumFromPeakels(List<Peakel> coelutingPeakels, Peakel peakel) {
        SpectrumData data = PeakelsPatternPredictor.buildSpectrumFromPeakels((Seq)((Seq)JavaConverters.asScalaBufferConverter(coelutingPeakels).asScala()), (Peakel)peakel);
        return data;
    }

    private Tuple4<double[], float[], float[], float[]> slicePeakels(List<Peakel> coelutingPeakels, Long matchingSpectrumId) {
        ArrayList mzList = new ArrayList(coelutingPeakels.size());
        ArrayList intensityList = new ArrayList(coelutingPeakels.size());
        ArrayList lfwhmList = new ArrayList(coelutingPeakels.size());
        ArrayList rfwhmList = new ArrayList(coelutingPeakels.size());
        coelutingPeakels.sort(new Comparator<Peakel>(){

            @Override
            public int compare(Peakel o1, Peakel o2) {
                return Double.compare(o1.getApexMz(), o2.getApexMz());
            }
        });
        boolean SPAN = true;
        coelutingPeakels.stream().forEach(peakel -> {
            int index = Arrays.binarySearch(peakel.getSpectrumIds(), matchingSpectrumId);
            Boolean foundPeak = index >= 0 && index < peakel.peaksCount();
            if (!foundPeak.booleanValue()) {
                foundPeak = (index ^= 0xFFFFFFFF) > 0 && index < peakel.peaksCount();
            }
            float sum = 0.0f;
            int count = 0;
            if (foundPeak.booleanValue()) {
                int minBound = Math.max(0, index - 1);
                int maxBound = Math.min(index + 1, peakel.getPeaksCount() - 1);
                for (int i = minBound; i <= maxBound; ++i) {
                    sum += peakel.intensityValues()[i];
                    ++count;
                }
                mzList.add(peakel.mzValues()[index]);
                intensityList.add(Float.valueOf(sum / (float)count));
                lfwhmList.add(Float.valueOf(peakel.getLeftHwhmMean()));
                rfwhmList.add(Float.valueOf(peakel.getRightHwhmMean()));
            }
        });
        double[] mz = new double[mzList.size()];
        float[] intensities = new float[intensityList.size()];
        float[] lfwhm = new float[lfwhmList.size()];
        float[] rfwhm = new float[rfwhmList.size()];
        for (int idx = 0; idx < mzList.size(); ++idx) {
            mz[idx] = (Double)mzList.get(idx);
            intensities[idx] = ((Float)intensityList.get(idx)).floatValue();
            lfwhm[idx] = ((Float)lfwhmList.get(idx)).floatValue();
            rfwhm[idx] = ((Float)rfwhmList.get(idx)).floatValue();
        }
        return new Tuple4((Object)mz, (Object)intensities, (Object)lfwhm, (Object)rfwhm);
    }

    public List<Peakel> findFeatureIsotopes(Peakel peakel, int charge, double mzTolPPM) {
        double peakelMz = peakel.getMz();
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator.getTheoreticalPattern((double)peakelMz, (int)charge);
        float intensityScalingFactor = peakel.getApexIntensity() / ((Float)pattern.mzAbundancePairs()[0]._2).floatValue();
        int gapRank = 0;
        ArrayList<Peakel> isotopes = new ArrayList<Peakel>(pattern.isotopeCount());
        for (Tuple2 t : pattern.mzAbundancePairs()) {
            double patternMz = (Double)t._1;
            float patternNormAbundance = ((Float)t._2).floatValue();
            float minRt = peakel.getFirstElutionTime();
            float maxRt = peakel.getLastElutionTime();
            List<Peakel> putativeIsotopes = this.findCoelutingPeakels(patternMz - patternMz * mzTolPPM / 1000000.0, patternMz + patternMz * mzTolPPM / 1000000.0, minRt, maxRt);
            Peakel bestMatching = null;
            double maxCorr = Double.MIN_VALUE;
            for (Peakel p : putativeIsotopes) {
                double corr = SpectrumUtils.correlation(peakel, p);
                if (!(corr > 0.5) || !(corr > maxCorr) || !(p.getApexIntensity() < 4.0f * patternNormAbundance * intensityScalingFactor)) continue;
                maxCorr = corr;
                bestMatching = p;
            }
            if (bestMatching != null) {
                gapRank = 0;
                isotopes.add(bestMatching);
            } else {
                ++gapRank;
            }
            if (gapRank >= 3) break;
        }
        return isotopes;
    }
}

