/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.IsotopicPatternUtils;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.dialog.IsotopicPredictionParamDialog;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.ui.model.ScanTableModel;
import fr.proline.studio.WindowManager;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotPanelListener;
import fr.proline.studio.graphics.PlotStick;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.IntervalMarker;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import fr.proline.studio.graphics.marker.PointMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import fr.proline.studio.graphics.marker.coordinates.DataCoordinates;
import fr.proline.studio.graphics.measurement.AbstractMeasurement;
import fr.proline.studio.graphics.measurement.IntegralMeasurement;
import fr.proline.studio.graphics.measurement.WidthMeasurement;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public abstract class AbstractSpectrumPanel
extends JPanel
implements PlotPanelListener,
PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSpectrumPanel.class);
    private static final DecimalFormat SCORE_FORMATTER = new DecimalFormat("#.###");
    protected final IRawFileViewer rawFileViewer;
    protected BasePlotPanel spectrumPlotPanel;
    protected JSplitPane splitPane;
    protected PlotXYAbstract scanPlot;
    protected LineMarker positionMarker;
    protected Spectrum currentScan;
    protected ReferenceSpectrum referenceSpectrum;
    protected boolean autoZoom = false;
    protected List<AbstractMarker> ipMarkers = new ArrayList<AbstractMarker>();

    public AbstractSpectrumPanel(IRawFileViewer rawFileViewer) {
        this.rawFileViewer = rawFileViewer;
        this.rawFileViewer.addPropertyChangeListener("lastExtractionRequest", this);
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        PlotPanel plotPanel = new PlotPanel();
        this.spectrumPlotPanel = plotPanel.getBasePlotPanel();
        this.spectrumPlotPanel.setDrawCursor(true);
        this.spectrumPlotPanel.addListener((PlotPanelListener)this);
        this.positionMarker = new LineMarker(this.spectrumPlotPanel, 0.0, 1, Color.BLUE, false);
        this.spectrumPlotPanel.repaint();
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent((Component)plotPanel);
        this.splitPane.setDividerLocation(1.0);
        this.splitPane.setDividerSize(0);
        this.add((Component)this.splitPane, "Center");
        this.add((Component)this.getSpectrumToolbar(), "North");
    }

    protected abstract JToolBar getSpectrumToolbar();

    public void displayIsotopicPrediction(double mozToPredict) {
        Spectrum spectrum = this.currentScan;
        if (this.referenceSpectrum != null) {
            IsotopicPredictionParamDialog dialog = new IsotopicPredictionParamDialog((Window)WindowManager.getDefault().getMainWindow());
            dialog.pack();
            dialog.setVisible(true);
            if (dialog.getButtonClicked() == 0) {
                spectrum = dialog.getSpectrum() == "Current Spectrum" ? this.currentScan : this.referenceSpectrum.spectrum;
            }
        }
        this.ipMarkers.stream().forEach(m -> this.scanPlot.removeMarker(m));
        this.ipMarkers = new ArrayList<AbstractMarker>();
        float ppmTol = MzScopePreferences.getInstance().getMzPPMTolerance();
        Tuple2<Object, TheoreticalIsotopePattern> prediction = IsotopicPatternUtils.predictIsotopicPattern(spectrum.getSpectrumData(), mozToPredict, ppmTol);
        this.displayIsotopes(spectrum, mozToPredict, prediction, ppmTol, 5);
        this.spectrumPlotPanel.repaintUpdateDoubleBuffer();
    }

    private void displayIsotopes(Spectrum spectrum, double mozToPredict, Tuple2<Object, TheoreticalIsotopePattern> scoredPattern, float ppmTol, int colorIndex) {
        int referenceMzIdx = 0;
        TheoreticalIsotopePattern pattern = (TheoreticalIsotopePattern)scoredPattern._2;
        int idx = SpectrumUtils.getNearestPeakIndex(spectrum.getSpectrumData().getMzList(), mozToPredict);
        for (Tuple2 t : pattern.mzAbundancePairs()) {
            if (1000000.0 * (Math.abs(spectrum.getSpectrumData().getMzList()[idx] - (Double)t._1) / spectrum.getSpectrumData().getMzList()[idx]) < (double)ppmTol) break;
            ++referenceMzIdx;
        }
        if (referenceMzIdx < pattern.isotopeCount()) {
            float abundance = spectrum.getSpectrumData().getIntensityList()[idx];
            float normAbundance = ((Float)pattern.mzAbundancePairs()[referenceMzIdx]._2).floatValue();
            for (Tuple2 t : pattern.mzAbundancePairs()) {
                Double mz = (Double)t._1;
                Float ab = (Float)t._2;
                PointMarker m = new PointMarker(this.spectrumPlotPanel, (AbstractCoordinates)new DataCoordinates(mz.doubleValue(), (double)(ab.floatValue() * abundance / normAbundance)), CyclicColorPalette.getColor((int)0));
                this.ipMarkers.add((AbstractMarker)m);
                this.scanPlot.addMarker((AbstractMarker)m);
                int peakIdx = SpectrumUtils.getPeakIndex(spectrum.getSpectrumData().getMzList(), mz, ppmTol);
                if (peakIdx == -1) continue;
                logger.info("Peak found mz= " + mz + " expected= " + ab.floatValue() * abundance / normAbundance + " observed= " + spectrum.getSpectrumData().getIntensityList()[peakIdx]);
                PointMarker pm = new PointMarker(this.spectrumPlotPanel, (AbstractCoordinates)new DataCoordinates(spectrum.getSpectrumData().getMzList()[peakIdx], (double)spectrum.getSpectrumData().getIntensityList()[peakIdx]), CyclicColorPalette.getColor((int)colorIndex));
                this.ipMarkers.add((AbstractMarker)pm);
                this.scanPlot.addMarker((AbstractMarker)pm);
            }
            Double mz = 0.1 + ((Double)pattern.mzAbundancePairs()[0]._1 + (Double)pattern.mzAbundancePairs()[1]._1) / 2.0;
            Float ab = Float.valueOf(((Float)pattern.mzAbundancePairs()[0]._2).floatValue() * 0.75f);
            StringBuilder labelTxt = new StringBuilder("charge ");
            labelTxt.append(pattern.charge()).append("+").append("(").append(SCORE_FORMATTER.format(scoredPattern._1)).append(")");
            LabelMarker label = new LabelMarker(this.spectrumPlotPanel, (AbstractCoordinates)new DataCoordinates(mz.doubleValue(), (double)(ab.floatValue() * abundance / normAbundance)), labelTxt.toString(), 2, 2, CyclicColorPalette.getColor((int)0));
            this.ipMarkers.add((AbstractMarker)label);
            this.scanPlot.addMarker((AbstractMarker)label);
        }
    }

    public void addMarkerRange(double minMz, double maxMz) {
        this.scanPlot.addMarker((AbstractMarker)new IntervalMarker(this.spectrumPlotPanel, Color.orange, Color.RED, minMz, maxMz));
    }

    public void displayScan(Spectrum scan) {
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        if (this.currentScan != null && this.currentScan.getMasses().length > 0) {
            xMin = this.spectrumPlotPanel.getXAxis().getMinValue();
            xMax = this.spectrumPlotPanel.getXAxis().getMaxValue();
            yMin = this.spectrumPlotPanel.getYAxis().getMinValue();
            yMax = this.spectrumPlotPanel.getYAxis().getMaxValue();
        }
        if (scan != null && scan.getMasses().length > 0) {
            Color plotColor = this.rawFileViewer.getPlotColor(this.rawFileViewer.getCurrentRawfile() == null ? null : this.rawFileViewer.getCurrentRawfile().getName());
            ScanTableModel scanModel = new ScanTableModel(scan);
            scanModel.setColor(plotColor);
            this.scanPlot = this.buildPlot(scan, plotColor, 1.0f);
            this.spectrumPlotPanel.setPlot((PlotBaseAbstract)this.scanPlot);
            this.spectrumPlotPanel.lockMinXValue();
            this.spectrumPlotPanel.lockMinYValue();
            if (this.currentScan != null && this.currentScan.getMasses().length > 0 && this.currentScan.getMsLevel() == scan.getMsLevel()) {
                if (!this.autoZoom) {
                    this.spectrumPlotPanel.getXAxis().setRange(xMin, xMax);
                    this.spectrumPlotPanel.getYAxis().setRange(yMin, yMax);
                } else {
                    this.spectrumPlotPanel.getXAxis().setRange(xMin, xMax);
                }
            }
            if (this.currentScan != null && this.currentScan.getMsLevel() != scan.getMsLevel()) {
                this.positionMarker.setVisible(false);
            }
            this.scanPlot.addMarker((AbstractMarker)this.positionMarker);
            this._displayReferenceSpectrum();
            this.spectrumPlotPanel.repaint();
            this.currentScan = scan;
        } else if (scan != null) {
            logger.info("display scan id = {},contains no data ", (Object)scan.getIndex());
            this.currentScan = scan;
            this.spectrumPlotPanel.clearPlotsWithRepaint();
        } else {
            this.spectrumPlotPanel.clearPlotsWithRepaint();
        }
    }

    protected void _displayReferenceSpectrum() {
        if (this.referenceSpectrum != null) {
            double xMin = 0.0;
            double xMax = 0.0;
            double yMin = 0.0;
            double yMax = 0.0;
            if (this.currentScan != null) {
                xMin = this.spectrumPlotPanel.getXAxis().getMinValue();
                xMax = this.spectrumPlotPanel.getXAxis().getMaxValue();
                yMin = this.spectrumPlotPanel.getYAxis().getMinValue();
                yMax = this.spectrumPlotPanel.getYAxis().getMaxValue();
            }
            PlotXYAbstract plot = this.buildPlot(this.referenceSpectrum.spectrum, CyclicColorPalette.getColor((int)5), this.referenceSpectrum.scaleFactor.floatValue());
            this.spectrumPlotPanel.addPlot(plot, true);
            this.spectrumPlotPanel.lockMinYValue();
            if (this.currentScan != null) {
                double[] minMaxY = this.spectrumPlotPanel.getMinMaxPlots((Axis)this.spectrumPlotPanel.getYAxis());
                this.spectrumPlotPanel.getXAxis().setRange(xMin, xMax);
                this.spectrumPlotPanel.getYAxis().setRange(Math.min(yMin, minMaxY[0]), yMax);
            }
            this.spectrumPlotPanel.repaint();
        }
    }

    protected PlotXYAbstract buildPlot(Spectrum scan, Color plotColor, float scaleFactor) {
        ScanTableModel scanModel = new ScanTableModel(scan, scaleFactor);
        PlotStick plot = null;
        scanModel.setColor(plotColor);
        if (scan.getDataType() == Spectrum.ScanType.CENTROID) {
            plot = new PlotStick(this.spectrumPlotPanel, (ExtendedTableModelInterface)scanModel, null, 0, 1);
            plot.setStrokeFixed(true);
            plot.setPlotInformation(scanModel.getPlotInformation());
        } else {
            plot = new PlotLinear(this.spectrumPlotPanel, (ExtendedTableModelInterface)scanModel, null, 0, 1);
            plot.addMeasurement((AbstractMeasurement)new IntegralMeasurement((PlotBaseAbstract)plot));
            plot.addMeasurement((AbstractMeasurement)new WidthMeasurement((PlotBaseAbstract)plot));
            ((PlotLinear)plot).setStrokeFixed(true);
            ((PlotLinear)plot).setPlotInformation(scanModel.getPlotInformation());
        }
        plot.setIsPaintMarker(true);
        return plot;
    }

    public void clearReferenceSpectrumData() {
        if (this.referenceSpectrum != null) {
            this.referenceSpectrum = null;
            this.displayScan(this.currentScan);
        }
    }

    public void setReferenceSpectrum(Spectrum spectrum, Float scaleFactor) {
        this.referenceSpectrum = new ReferenceSpectrum(spectrum, scaleFactor);
        this.displayScan(this.currentScan);
    }

    public void updateAxisRange(double[] oldX, double[] newX, double[] oldY, double[] newY) {
    }

    private class ReferenceSpectrum {
        public final Spectrum spectrum;
        public final Float scaleFactor;

        protected ReferenceSpectrum(Spectrum spectrum, Float scaleFactor) {
            this.spectrum = spectrum;
            this.scaleFactor = scaleFactor;
        }
    }
}

