/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.mzdb.ThreadedMzdbRawFile;
import fr.proline.mzscope.mzml.MzMLRawFile;
import fr.proline.mzscope.timstof.TimstofRawFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFileManager {
    private static final Logger logger = LoggerFactory.getLogger(RawFileManager.class);
    private Map<String, IRawFile> files = new HashMap<String, IRawFile>();
    private IRawFile currentFile;
    private static RawFileManager instance;

    public static RawFileManager getInstance() {
        if (instance == null) {
            instance = new RawFileManager();
        }
        return instance;
    }

    private RawFileManager() {
    }

    public IRawFile addRawFile(IRawFile rawFile) {
        this.currentFile = rawFile;
        this.files.put(rawFile.getFile().getAbsolutePath(), this.currentFile);
        logger.info("Rawfile {} added to RawFileManager", (Object)rawFile.getFile().getAbsolutePath());
        return rawFile;
    }

    public IRawFile addRawFile(File file) {
        String absolutePath = file.getAbsolutePath();
        if (absolutePath.toLowerCase().endsWith(".mzdb")) {
            this.currentFile = new ThreadedMzdbRawFile(file);
            this.files.put(absolutePath, this.currentFile);
            logger.info("mzDB Rawfile {} added to RawFileManager", (Object)absolutePath);
        } else if (absolutePath.toLowerCase().endsWith(".mzml")) {
            this.currentFile = new MzMLRawFile(file);
            this.files.put(absolutePath, this.currentFile);
            logger.info("mzML Rawfile {} added to RawFileManager", (Object)absolutePath);
        } else if (absolutePath.toLowerCase().endsWith(".d")) {
            Object[] options = new String[]{"Single Spectra", "Spectra Per Scan"};
            int reply = JOptionPane.showOptionDialog(null, "MS1 Spectra display", "MS1 Format", 0, 3, null, options, "Single Spectra");
            this.currentFile = reply == 0 ? new TimstofRawFile(file) : new TimstofRawFile(file, "Spectra Per Scan");
            this.files.put(absolutePath, this.currentFile);
            logger.info("TimsTof Rawfile {} added to RawFileManager", (Object)absolutePath);
        }
        return this.currentFile;
    }

    public IRawFile getLastFile() {
        return this.currentFile;
    }

    public IRawFile getFile(String absoluteFilePath) {
        if (this.files.containsKey(absoluteFilePath)) {
            logger.info("RawFileManager will give access to {}", (Object)absoluteFilePath);
            return this.files.get(absoluteFilePath);
        }
        logger.warn("RawFile {} not found", (Object)absoluteFilePath);
        return null;
    }

    public List<IRawFile> getAllFiles() {
        return new ArrayList<IRawFile>(this.files.values());
    }

    public void removeFile(IRawFile rawFile) {
        if (this.files.containsValue(rawFile)) {
            for (Map.Entry<String, IRawFile> e : this.files.entrySet()) {
                if (!e.getValue().equals(rawFile)) continue;
                rawFile.closeIRawFile();
                this.files.remove(e.getKey());
                break;
            }
        }
    }

    public void removeAllFiles() {
        for (IRawFile rFile : this.files.values()) {
            rFile.closeIRawFile();
        }
        this.files = new HashMap<String, IRawFile>();
    }

    public boolean removeRawFile(IRawFile rawFile) {
        IRawFile removedFile = this.files.remove(rawFile.getFile().getAbsolutePath());
        return removedFile != null;
    }
}

