/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.PairedPeakel;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.table.AbstractNonLazyTableModel;
import fr.proline.studio.table.Column;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.BigFloatOrDoubleRenderer;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;

public class PeakelsCompareTableModel
extends AbstractNonLazyTableModel
implements GlobalTableModelInterface {
    private static TableCellRenderer BIG_FLOAT = new BigFloatOrDoubleRenderer((TableCellRenderer)new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 0);
    public static final Column COLTYPE_STATUS = new Column("Status", "Pairing Status", String.class, 0, Column.STRING_LEFT);
    public static final Column COLTYPE_FEATURE_MZCOL = new Column("m/z", "m/z", Double.class, 1, Column.DOUBLE_5DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_ET_COL = new Column("Elution", "Elution Time in minutes", Float.class, 2, Column.DOUBLE_2DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_DURATION_COL = new Column("Duration", "Duration in minutes", Float.class, 3, Column.DOUBLE_2DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_APEX_INT_COL = new Column("Apex Int.", "Apex intensity", Float.class, 4, BIG_FLOAT);
    public static final Column COLTYPE_FEATURE_AREA_COL = new Column("Area", "Area", Double.class, 5, BIG_FLOAT);
    public static final Column COLTYPE_FEATURE_SCAN_COUNT_COL = new Column("MS Count", "MS Count", Integer.class, 6);
    public static final Column COLTYPE_FEATURE_RAWFILE = new Column("Raw file", "Raw File Name", String.class, 7, Column.STRING_LEFT);
    public static final Column COLTYPE_FEATURE_MZCOL2 = new Column("m/z 2", "m/z", Double.class, 8, Column.DOUBLE_5DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_ET_COL2 = new Column("Elution 2", "Elution Time in minutes", Float.class, 9, Column.DOUBLE_2DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_DURATION_COL2 = new Column("Duration 2", "Duration in minutes", Float.class, 10, Column.DOUBLE_2DIGITS_RIGHT);
    public static final Column COLTYPE_FEATURE_APEX_INT_COL2 = new Column("Apex Int. 2", "Apex intensity", Float.class, 11, BIG_FLOAT);
    public static final Column COLTYPE_FEATURE_AREA_COL2 = new Column("Area 2", "Area", Double.class, 12, BIG_FLOAT);
    public static final Column COLTYPE_FEATURE_SCAN_COUNT_COL2 = new Column("MS Count 2", "MS Count", Integer.class, 13);
    public static final Column COLTYPE_FEATURE_RAWFILE2 = new Column("Raw file 2", "Raw File Name", String.class, 14, Column.STRING_LEFT);
    protected ArrayList<PairedPeakel> m_pairedPeakelArrayList = new ArrayList();

    public int[] getKeysColumn() {
        int[] keys = new int[]{COLTYPE_FEATURE_MZCOL.getIndex(), COLTYPE_FEATURE_ET_COL.getIndex(), COLTYPE_FEATURE_RAWFILE.getIndex()};
        return keys;
    }

    public int getInfoColumn() {
        return COLTYPE_FEATURE_MZCOL.getIndex();
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public int getRowCount() {
        return this.m_pairedPeakelArrayList.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        PairedPeakel pairedPeakel = this.m_pairedPeakelArrayList.get(rowIndex);
        if (columnIndex == COLTYPE_STATUS.getIndex()) {
            return pairedPeakel.getStatus().toString();
        }
        if (columnIndex < COLTYPE_FEATURE_MZCOL2.getIndex()) {
            IPeakel p = pairedPeakel.getPeakel1();
            if (p == null) {
                return null;
            }
            if (columnIndex == COLTYPE_FEATURE_MZCOL.getIndex()) {
                return p.getMz();
            }
            if (columnIndex == COLTYPE_FEATURE_ET_COL.getIndex()) {
                return (double)p.getElutionTime() / 60.0;
            }
            if (columnIndex == COLTYPE_FEATURE_DURATION_COL.getIndex()) {
                return (double)p.getDuration() / 60.0;
            }
            if (columnIndex == COLTYPE_FEATURE_APEX_INT_COL.getIndex()) {
                return Float.valueOf(p.getApexIntensity());
            }
            if (columnIndex == COLTYPE_FEATURE_AREA_COL.getIndex()) {
                return (double)p.getArea() / 60.0;
            }
            if (columnIndex == COLTYPE_FEATURE_SCAN_COUNT_COL.getIndex()) {
                return p.getScanCount();
            }
            if (columnIndex == COLTYPE_FEATURE_RAWFILE.getIndex()) {
                return p.getRawFile().getName();
            }
        } else {
            IPeakel p = pairedPeakel.getPeakel2();
            if (p == null) {
                return null;
            }
            if (columnIndex == COLTYPE_FEATURE_MZCOL2.getIndex()) {
                return p.getMz();
            }
            if (columnIndex == COLTYPE_FEATURE_ET_COL2.getIndex()) {
                return (double)p.getElutionTime() / 60.0;
            }
            if (columnIndex == COLTYPE_FEATURE_DURATION_COL2.getIndex()) {
                return (double)p.getDuration() / 60.0;
            }
            if (columnIndex == COLTYPE_FEATURE_APEX_INT_COL2.getIndex()) {
                return Float.valueOf(p.getApexIntensity());
            }
            if (columnIndex == COLTYPE_FEATURE_AREA_COL2.getIndex()) {
                return (double)p.getArea() / 60.0;
            }
            if (columnIndex == COLTYPE_FEATURE_SCAN_COUNT_COL2.getIndex()) {
                return p.getScanCount();
            }
            if (columnIndex == COLTYPE_FEATURE_RAWFILE2.getIndex()) {
                return p.getRawFile().getName();
            }
        }
        return null;
    }

    public Object getValue(Class c) {
        return this.getSingleValue(c);
    }

    public Object getRowValue(Class c, int row) {
        if (IPeakel.class.isAssignableFrom(c)) {
            PairedPeakel pairedPeakel = this.m_pairedPeakelArrayList.get(row);
            return pairedPeakel.getPeakel1();
        }
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void setPeakels(ArrayList<PairedPeakel> pairedPeakelArrayList) {
        this.m_pairedPeakelArrayList = pairedPeakelArrayList;
        this.fireTableDataChanged();
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return 0;
    }
}

