/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.BasicArray;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.VoidFunction;

public abstract class OperationVoid
implements ArrayOperation {
    public static int THRESHOLD = 256;

    public static <N extends Comparable<N>> void invoke(BasicArray<N> data, int first, int limit, int step, VoidFunction<N> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data.doubleValue(i));
        }
    }

    public static <N extends Comparable<N>> void invoke(BasicArray<N> data, long first, long limit, long step, VoidFunction<N> visitor) {
        switch (data.getMathType()) {
            case R064: {
                for (long i = first; i < limit; i += step) {
                    visitor.invoke(data.doubleValue(i));
                }
                break;
            }
            case R032: {
                for (long i = first; i < limit; i += step) {
                    visitor.invoke(data.floatValue(i));
                }
                break;
            }
            case Z064: {
                for (long i = first; i < limit; i += step) {
                    visitor.invoke(data.longValue(i));
                }
                break;
            }
            case Z032: 
            case Z016: 
            case Z008: {
                for (long i = first; i < limit; i += step) {
                    visitor.invoke(data.intValue(i));
                }
                break;
            }
            default: {
                for (long i = first; i < limit; i += step) {
                    visitor.invoke(data.get(i));
                }
            }
        }
    }

    public static void invoke(byte[] data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data[i]);
        }
    }

    public static void invoke(double[] data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data[i]);
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data[i]);
        }
    }

    public static void invoke(int[] data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data[i]);
        }
    }

    public static void invoke(long[] data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data[i]);
        }
    }

    public static <N extends Comparable<N>> void invoke(N[] data, int first, int limit, int step, VoidFunction<N> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data[i]);
        }
    }

    public static void invoke(short[] data, int first, int limit, int step, VoidFunction<Double> visitor) {
        for (int i = first; i < limit; i += step) {
            visitor.invoke(data[i]);
        }
    }
}

