/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.util.List;
import org.ojalgo.data.domain.finance.FinanceUtils;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public class PortfolioContext
implements FinancePortfolio.Context {
    private final MatrixR064 myAssetReturns;
    private MatrixR064 myAssetVolatilities = null;
    private MatrixR064 myCorrelations = null;
    private MatrixR064 myCovariances = null;

    public PortfolioContext(Access1D<?> assetReturns, Access1D<?> assetVolatilities, Access2D<?> correlations) {
        this.myAssetReturns = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new Access1D[]{assetReturns});
        this.myAssetVolatilities = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new Access1D[]{assetVolatilities});
        this.myCorrelations = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.copy((Access2D)correlations);
    }

    public PortfolioContext(Access1D<?> assetReturns, Access2D<?> covariances) {
        this.myAssetReturns = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new Access1D[]{assetReturns});
        this.myCovariances = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.copy((Access2D)covariances);
    }

    private PortfolioContext() {
        this.myAssetReturns = null;
    }

    @Override
    public double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        return ((MatrixR064)((MatrixR064)FinancePortfolio.MATRIX_FACTORY.rows(new List[]{weightsPortfolio.getWeights()})).multiply(this.getAssetReturns())).doubleValue(0L);
    }

    @Override
    public double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        MatrixR064 tmpWeights = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{weightsPortfolio.getWeights()});
        return ((MatrixR064)((MatrixR064)tmpWeights.transpose()).multiply((MatrixR064)this.getCovariances().multiply(tmpWeights))).doubleValue(0L);
    }

    @Override
    public MatrixR064 getAssetReturns() {
        return this.myAssetReturns;
    }

    @Override
    public MatrixR064 getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            this.myAssetVolatilities = FinanceUtils.toVolatilities(this.myCovariances);
        }
        return this.myAssetVolatilities;
    }

    @Override
    public MatrixR064 getCorrelations() {
        if (this.myCorrelations == null) {
            this.myCorrelations = FinanceUtils.toCorrelations(this.myCovariances, false);
        }
        return this.myCorrelations;
    }

    @Override
    public MatrixR064 getCovariances() {
        if (this.myCovariances == null) {
            this.myCovariances = FinanceUtils.toCovariances(this.myAssetVolatilities, this.myCorrelations);
        }
        return this.myCovariances;
    }

    @Override
    public int size() {
        return (int)this.myAssetReturns.count();
    }
}

