/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.equation;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.NumberDefinition;

public final class Equation
implements Comparable<Equation>,
Access1D<Double>,
Mutate1D.Modifiable<Double> {
    public final int index;
    private final BasicArray<Double> myBody;
    private double myPivot = PrimitiveMath.ZERO;
    private double myRHS;

    public static Equation dense(int pivot, int cols) {
        return Equation.dense(pivot, cols, ArrayR064.FACTORY);
    }

    public static Equation dense(int pivot, int cols, DenseArray.Factory<Double> factory) {
        return new Equation((BasicArray)factory.make(cols), pivot, PrimitiveMath.ZERO);
    }

    public static List<Equation> denseSystem(int rows, int cols) {
        return Equation.denseSystem(rows, cols, ArrayR064.FACTORY);
    }

    public static List<Equation> denseSystem(int rows, int cols, DenseArray.Factory<Double> factory) {
        ArrayList<Equation> system = new ArrayList<Equation>(rows);
        for (int i = 0; i < rows; ++i) {
            system.add(new Equation((BasicArray)factory.make(cols), i, PrimitiveMath.ZERO));
        }
        return system;
    }

    public static Equation of(double rhs, int pivot, double ... body) {
        return new Equation(ArrayR064.wrap(body), pivot, rhs);
    }

    public static Equation sparse(int pivot, int cols) {
        return Equation.sparse(pivot, cols, ArrayR064.FACTORY);
    }

    public static Equation sparse(int pivot, int cols, DenseArray.Factory<Double> factory) {
        return new Equation(((SparseArray.SparseFactory)SparseArray.factory(factory).limit(cols)).make(), pivot, PrimitiveMath.ZERO);
    }

    public static Equation sparse(int pivot, int cols, DenseArray.Factory<Double> factory, int numberOfNonzeros) {
        return new Equation(((SparseArray.SparseFactory)((SparseArray.SparseFactory)SparseArray.factory(factory).limit(cols)).initial(numberOfNonzeros)).make(), pivot, PrimitiveMath.ZERO);
    }

    public static Equation sparse(int pivot, int cols, int numberOfNonzeros) {
        return Equation.sparse(pivot, cols, ArrayR064.FACTORY, numberOfNonzeros);
    }

    public static List<Equation> sparseSystem(int rows, int cols) {
        return Equation.sparseSystem(rows, cols, ArrayR064.FACTORY);
    }

    public static List<Equation> sparseSystem(int rows, int cols, DenseArray.Factory<Double> factory) {
        ArrayList<Equation> system = new ArrayList<Equation>(rows);
        for (int i = 0; i < rows; ++i) {
            system.add(new Equation(((SparseArray.SparseFactory)SparseArray.factory(factory).limit(cols)).make(), i, PrimitiveMath.ZERO));
        }
        return system;
    }

    public static List<Equation> sparseSystem(int rows, int cols, DenseArray.Factory<Double> factory, int numberOfNonzeros) {
        ArrayList<Equation> system = new ArrayList<Equation>(rows);
        for (int i = 0; i < rows; ++i) {
            system.add(new Equation(((SparseArray.SparseFactory)((SparseArray.SparseFactory)SparseArray.factory(factory).limit(cols)).initial(numberOfNonzeros)).make(), i, PrimitiveMath.ZERO));
        }
        return system;
    }

    public static List<Equation> sparseSystem(int rows, int cols, int numberOfNonzeros) {
        return Equation.sparseSystem(rows, cols, ArrayR064.FACTORY, numberOfNonzeros);
    }

    public static Equation wrap(BasicArray<Double> body, int pivot, double rhs) {
        return new Equation(body, pivot, rhs);
    }

    @Deprecated
    public Equation(int row, long numberOfColumns, double rhs) {
        this(((SparseArray.SparseFactory)SparseArray.factory(ArrayR064.FACTORY).limit(numberOfColumns)).make(), row, rhs);
    }

    Equation(BasicArray<Double> body, int pivot, double rhs) {
        this.myBody = body;
        this.myRHS = rhs;
        this.index = pivot;
        this.myPivot = PrimitiveMath.ZERO;
    }

    @Override
    public void add(long ind, Comparable<?> addend) {
        this.add(ind, NumberDefinition.doubleValue(addend));
    }

    @Override
    public void add(long ind, double addend) {
        this.myBody.add(ind, addend);
        if (ind == (long)this.index) {
            this.myPivot = this.myBody.doubleValue(ind);
        }
    }

    public <T extends Access1D<Double> & Mutate1D.Modifiable<Double>> double adjust(T x, double relaxation) {
        return this.calculate(x, this.myRHS, relaxation);
    }

    @Override
    public int compareTo(Equation other) {
        return Integer.compare(this.index, other.index);
    }

    @Override
    public long count() {
        return this.myBody.count();
    }

    @Override
    public double dot(Access1D<?> vector) {
        return this.myBody.dot(vector);
    }

    @Override
    public double doubleValue(long ind) {
        return this.myBody.doubleValue(ind);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Equation)) {
            return false;
        }
        Equation other = (Equation)obj;
        return this.index == other.index;
    }

    @Override
    public Double get(long ind) {
        return (Double)this.myBody.get(ind);
    }

    public BasicArray<Double> getBody() {
        return this.myBody;
    }

    public double getPivot() {
        return this.myPivot;
    }

    public double getRHS() {
        return this.myRHS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + this.index;
    }

    public <T extends Access1D<Double> & Mutate1D.Modifiable<Double>> void initialise(T x) {
        this.calculate(x, PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    @Override
    public void modifyOne(long ind, UnaryFunction<Double> modifier) {
        this.myBody.modifyOne(ind, modifier);
        if (ind == (long)this.index) {
            this.myPivot = this.myBody.doubleValue(ind);
        }
    }

    public void set(long ind, Comparable<?> value) {
        this.set(ind, NumberDefinition.doubleValue(value));
    }

    public void set(long ind, double value) {
        this.myBody.set(ind, value);
        if (ind == (long)this.index) {
            this.myPivot = value;
        }
    }

    public void setRHS(double rhs) {
        this.myRHS = rhs;
    }

    public String toString() {
        return this.index + ": " + this.myBody.toString() + " = " + this.myRHS;
    }

    private <T extends Access1D<Double> & Mutate1D.Modifiable<Double>> double calculate(T x, double rhs, double relaxation) {
        double increment = rhs;
        double error = increment -= this.myBody.dot(x);
        increment *= relaxation;
        ((Mutate1D.Modifiable<Double>)x).add((long)this.index, increment /= this.myPivot);
        return error;
    }
}

