/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.AffineFunction;
import org.ojalgo.function.multiary.ApproximateFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access1D;

public final class FirstOrderApproximation<N extends Comparable<N>>
extends ApproximateFunction<N> {
    private final AffineFunction<N> myDelegate;

    public FirstOrderApproximation(MultiaryFunction.TwiceDifferentiable<N> function, Access1D<N> point) {
        super(function, point);
        MatrixStore<N> linear = function.getGradient(point);
        N constant = function.invoke(point);
        this.myDelegate = new AffineFunction<N>(linear);
        this.myDelegate.setConstant((Comparable<?>)constant);
    }

    @Override
    public int arity() {
        return this.myDelegate.arity();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FirstOrderApproximation)) {
            return false;
        }
        FirstOrderApproximation other = (FirstOrderApproximation)obj;
        return !(this.myDelegate == null ? other.myDelegate != null : !this.myDelegate.equals(other.myDelegate));
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.myDelegate.getGradient(null);
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myDelegate.getHessian(null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.myDelegate == null ? 0 : this.myDelegate.hashCode());
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return this.myDelegate.invoke(this.shift(arg));
    }

    public String toString() {
        return this.myDelegate.toString();
    }

    @Override
    PhysicalStore.Factory<N, ?> factory() {
        return this.myDelegate.factory();
    }
}

