/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.PureQuadraticFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public final class QuadraticFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Quadratic<N> {
    private final LinearFunction<N> myLinear;
    private final PureQuadraticFunction<N> myPureQuadratic;

    public static <N extends Comparable<N>> Factory<N> factory(PhysicalStore.Factory<N, ?> factory) {
        return new Factory<N>(factory);
    }

    @Deprecated
    public static QuadraticFunction<ComplexNumber> makeComplex(Access2D<?> quadratic, Access1D<?> linear) {
        return QuadraticFunction.factory(GenericStore.C128).quadratic(quadratic).linear(linear).make(linear.size());
    }

    @Deprecated
    public static QuadraticFunction<ComplexNumber> makeComplex(int arity) {
        return QuadraticFunction.factory(GenericStore.C128).make(arity);
    }

    @Deprecated
    public static QuadraticFunction<Double> makePrimitive(Access2D<?> quadratic, Access1D<?> linear) {
        return QuadraticFunction.factory(Primitive64Store.FACTORY).quadratic(quadratic).linear(linear).make(linear.size());
    }

    @Deprecated
    public static QuadraticFunction<Double> makePrimitive(int arity) {
        return QuadraticFunction.factory(Primitive64Store.FACTORY).make(arity);
    }

    @Deprecated
    public static QuadraticFunction<RationalNumber> makeRational(Access2D<?> quadratic, Access1D<?> linear) {
        return QuadraticFunction.factory(GenericStore.Q128).quadratic(quadratic).linear(linear).make(linear.size());
    }

    @Deprecated
    public static QuadraticFunction<RationalNumber> makeRational(int arity) {
        return QuadraticFunction.factory(GenericStore.Q128).make(arity);
    }

    public static <N extends Comparable<N>> QuadraticFunction<N> wrap(PhysicalStore<N> quadratic, PhysicalStore<N> linear) {
        return new QuadraticFunction<N>(quadratic, linear);
    }

    QuadraticFunction(MatrixStore<N> quadratic, MatrixStore<N> linear) {
        this(new PureQuadraticFunction<N>(quadratic), new LinearFunction<N>(linear));
    }

    QuadraticFunction(PureQuadraticFunction<N> pureQuadratic, LinearFunction<N> linear) {
        this.myPureQuadratic = pureQuadratic;
        this.myLinear = linear;
        if (this.myPureQuadratic.arity() != this.myLinear.arity()) {
            throw new IllegalArgumentException("Must have the same arity!");
        }
    }

    @Override
    public int arity() {
        return this.myLinear.arity();
    }

    @Override
    public N getConstant() {
        return this.myPureQuadratic.getConstant();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        MatrixStore<MatrixStore<N>> pureQuadraticPart = this.myPureQuadratic.getGradient(point);
        MatrixStore<N> linearPart = this.myLinear.getGradient(point);
        return pureQuadraticPart.add(linearPart);
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myPureQuadratic.getHessian(point);
    }

    @Override
    public MatrixStore<N> getLinearFactors(boolean negated) {
        return this.myLinear.getLinearFactors(negated);
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return (N)((Comparable)this.getScalarValue(arg).get());
    }

    @Override
    public PhysicalStore<N> linear() {
        return this.myLinear.linear();
    }

    @Override
    public PhysicalStore<N> quadratic() {
        return this.myPureQuadratic.quadratic();
    }

    @Override
    public void setConstant(Comparable<?> constant) {
        this.myPureQuadratic.setConstant(constant);
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myLinear.factory();
    }

    Scalar<N> getScalarValue(Access1D<N> arg) {
        Scalar<N> retVal = this.myPureQuadratic.getScalarValue(arg);
        N linearPart = this.myLinear.invoke(arg);
        return (Scalar)retVal.add(linearPart);
    }

    public static final class Factory<N extends Comparable<N>> {
        private final LinearFunction.Factory<N> myLinear;
        private final PureQuadraticFunction.Factory<N> myPureQuadratic;

        Factory(PhysicalStore.Factory<N, ?> factory) {
            this.myPureQuadratic = new PureQuadraticFunction.Factory<N>(factory);
            this.myLinear = new LinearFunction.Factory<N>(factory);
        }

        public Factory<N> linear(Access1D<?> coefficients) {
            this.myLinear.coefficients(coefficients);
            return this;
        }

        public QuadraticFunction<N> make(int arity) {
            return new QuadraticFunction<N>(this.myPureQuadratic.make(arity), this.myLinear.make(arity));
        }

        public Factory<N> quadratic(Access2D<?> coefficients) {
            this.myPureQuadratic.coefficients(coefficients);
            return this;
        }
    }
}

