/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.special;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.GammaFunction;
import org.ojalgo.scalar.ComplexNumber;

public abstract class BetaFunction {
    public static ComplexNumber beta(ComplexNumber a, ComplexNumber b) {
        return GammaFunction.gamma(a).multiply(GammaFunction.gamma(b)).divide(GammaFunction.gamma(a.add(b)));
    }

    public static double beta(double a, double b) {
        return GammaFunction.gamma(a) * GammaFunction.gamma(b) / GammaFunction.gamma(a + b);
    }

    public static double beta(int a, int b) {
        return GammaFunction.gamma(a) * GammaFunction.gamma(b) / GammaFunction.gamma(a + b);
    }

    public static abstract class Regularized
    extends BetaFunction {
        public static ComplexNumber beta(double limit, ComplexNumber a, ComplexNumber b) {
            return Incomplete.beta(limit, a, b).divide(BetaFunction.beta(a, b));
        }

        public static double beta(double limit, double a, double b) {
            return Incomplete.beta(limit, a, b) / BetaFunction.beta(a, b);
        }

        public static double beta(double limit, int a, int b) {
            return Incomplete.beta(limit, a, b) / BetaFunction.beta(a, b);
        }
    }

    public static abstract class Incomplete
    extends BetaFunction {
        public static ComplexNumber beta(double limit, ComplexNumber a, ComplexNumber b) {
            return ComplexNumber.NaN;
        }

        public static double beta(double limit, double a, double b) {
            double tmp = PrimitiveMath.ONE;
            double sum = tmp / a;
            for (int n = 1; n < 100; ++n) {
                sum += (tmp *= ((double)n - b) / (double)n * limit) / (a + (double)n);
            }
            return Math.exp(a * Math.log(limit) + Math.log(sum));
        }

        public static double beta(double limit, int a, int b) {
            return Incomplete.beta(limit, (double)a, (double)b);
        }
    }
}

