/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawSingularValue;
import org.ojalgo.matrix.decomposition.SingularValueDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public interface SingularValue<N extends Comparable<N>>
extends MatrixDecomposition<N>,
MatrixDecomposition.Solver<N>,
MatrixDecomposition.EconomySize<N>,
MatrixDecomposition.RankRevealing<N>,
MatrixDecomposition.Values<N>,
Provider2D.Condition {
    public static final Factory<ComplexNumber> C128 = (typical, fullSize) -> new SingularValueDecomposition.C128(fullSize);
    public static final Factory<Double> R064 = (typical, fullSize) -> {
        if (fullSize || 1024L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new SingularValueDecomposition.R064(fullSize);
        }
        return new RawSingularValue();
    };
    public static final Factory<Quadruple> R128 = (typical, fullSize) -> new SingularValueDecomposition.R128(fullSize);
    public static final Factory<Quaternion> H256 = (typical, fullSize) -> new SingularValueDecomposition.H256(fullSize);
    public static final Factory<RationalNumber> Q128 = (typical, fullSize) -> new SingularValueDecomposition.Q128(fullSize);
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    @Deprecated
    public static final Factory<Double> PRIMITIVE = R064;
    @Deprecated
    public static final Factory<Quadruple> QUADRUPLE = R128;
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, SingularValue<N> decomposition, NumberContext context) {
        MatrixStore<Object> tmpThat;
        MatrixStore<MatrixStore<Object>> tmpThis;
        boolean retVal;
        int nbRows = matrix.getRowDim();
        int nbCols = matrix.getColDim();
        MatrixStore<MatrixStore<N>> tmpU = decomposition.getU();
        MatrixStore<N> tmpD = decomposition.getD();
        MatrixStore<Object> tmpV = decomposition.getV();
        boolean bl = retVal = (long)nbRows == tmpU.countRows() && tmpV.countRows() == (long)nbCols;
        if (retVal) {
            tmpThis = matrix.multiply(tmpV);
            tmpThat = tmpU.multiply(tmpD);
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal && tmpU.countRows() == tmpU.countColumns()) {
            tmpThis = tmpU.physical().makeEye(nbRows, nbRows);
            tmpThat = tmpU.conjugate().multiply(tmpU);
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal && tmpV.countRows() == tmpV.countColumns()) {
            tmpThis = tmpV.physical().makeEye(nbCols, nbCols);
            tmpThat = tmpV.multiply(tmpV.conjugate());
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal) {
            MatrixStore<MatrixStore<MatrixStore<Object>>> inverse = decomposition.getInverse();
            MatrixStore<MatrixStore<MatrixStore<N>>> multiplied = matrix.multiply((MatrixStore<Object>)inverse.multiply(matrix));
            retVal &= matrix.equals(multiplied, context);
        }
        if (retVal) {
            Array1D<Double> tmpSV = decomposition.getSingularValues();
            for (int i = 1; retVal && i < tmpSV.size(); retVal &= tmpSV.doubleValue(i - 1) >= tmpSV.doubleValue(i), ++i) {
            }
            if (retVal && decomposition.isOrdered()) {
                int ij = 1;
                while (retVal && (long)ij < tmpD.countRows()) {
                    retVal &= tmpD.doubleValue(ij - 1, ij - 1) >= tmpD.doubleValue(ij, ij);
                    ++ij;
                }
            }
        }
        return retVal;
    }

    @Override
    public double getCondition();

    public MatrixStore<N> getCovariance();

    public MatrixStore<N> getD();

    public double getFrobeniusNorm();

    public double getKyFanNorm(int var1);

    public double getOperatorNorm();

    public Array1D<Double> getSingularValues();

    default public void getSingularValues(double[] values) {
        ProgrammingError.throwIfNull((Object)values);
        Array1D<Double> singulars = this.getSingularValues();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            values[i] = singulars.doubleValue(i);
        }
    }

    public double getTraceNorm();

    public MatrixStore<N> getU();

    public MatrixStore<N> getV();

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxQ1 = this.getU();
        MatrixStore<N> mtrxD = this.getD();
        MatrixStore<N> mtrxQ2 = this.getV();
        return mtrxQ1.multiply(mtrxD).multiply((MatrixStore<Object>)mtrxQ2.conjugate());
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<SingularValue<N>> {
        default public SingularValue<N> make(boolean fullSize) {
            return this.make(MatrixDecomposition.TYPICAL, fullSize);
        }

        @Override
        default public SingularValue<N> make(Structure2D typical) {
            return this.make(typical, false);
        }

        public SingularValue<N> make(Structure2D var1, boolean var2);
    }
}

