/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class ColumnsStore<N extends Comparable<N>>
extends SelectingStore<N> {
    private final int[] myColumns;

    ColumnsStore(MatrixStore<N> base, int[] columns) {
        super(base, (int)base.countRows(), columns.length);
        this.myColumns = columns;
    }

    @Override
    public double doubleValue(long row, long col) {
        int colIndex = this.toBaseIndex(col);
        if (colIndex >= 0) {
            return this.base().doubleValue(row, colIndex);
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        int colIndex = this.toBaseIndex(col);
        if (colIndex >= 0) {
            return this.base().firstInColumn(colIndex);
        }
        return this.getRowDim();
    }

    @Override
    public N get(long row, long col) {
        int colIndex = this.toBaseIndex(col);
        if (colIndex >= 0) {
            return this.base().get(row, colIndex);
        }
        return (N)((Comparable)this.zero().get());
    }

    @Override
    public int limitOfColumn(int col) {
        int colIndex = this.toBaseIndex(col);
        if (colIndex >= 0) {
            return this.base().limitOfColumn(colIndex);
        }
        return 0;
    }

    @Override
    public void supplyTo(TransformableRegion<N> consumer) {
        MatrixStore base = this.base();
        for (int j = 0; j < this.myColumns.length; ++j) {
            int colIndex = this.toBaseIndex(j);
            if (colIndex >= 0) {
                consumer.fillColumn((long)j, base.sliceColumn(colIndex));
                continue;
            }
            consumer.fillColumn((long)j, (Access1D<Comparable>)((Object)((Comparable)this.zero().get())));
        }
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        int colIndex = this.toBaseIndex(col);
        if (colIndex >= 0) {
            return this.base().toScalar(row, colIndex);
        }
        return this.zero();
    }

    private int toBaseIndex(int col) {
        return this.myColumns[col];
    }

    private int toBaseIndex(long col) {
        return this.myColumns[Math.toIntExact(col)];
    }
}

