/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.Mutate2D;

public final class ColumnsSupplier<N extends Comparable<N>>
implements MatrixStore<N>,
Mutate2D {
    private final SparseArray.SparseFactory<N> myColumnFactory;
    private final List<SparseArray<N>> myColumns = new ArrayList<SparseArray<N>>();
    private final PhysicalStore.Factory<N, ?> myPhysicalStoreFactory;
    private final int myRowsCount;

    ColumnsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfRows) {
        this.myRowsCount = numberOfRows;
        this.myPhysicalStoreFactory = factory;
        this.myColumnFactory = (SparseArray.SparseFactory)SparseArray.factory(factory.array()).limit(this.myRowsCount);
    }

    public SparseArray<N> addColumn() {
        return this.addColumn(this.myColumnFactory.make());
    }

    public void addColumns(int numberToAdd) {
        for (int j = 0; j < numberToAdd; ++j) {
            this.myColumns.add(this.myColumnFactory.make());
        }
    }

    @Override
    public SingleView<N> columns() {
        return new SingleView(this);
    }

    @Override
    public MatrixStore<N> columns(final int ... columns) {
        return new MatrixStore<N>(){

            @Override
            public long countColumns() {
                return columns.length;
            }

            @Override
            public long countRows() {
                return ColumnsSupplier.this.countRows();
            }

            @Override
            public double doubleValue(long row, long col) {
                return ColumnsSupplier.this.doubleValue(row, columns[(int)col]);
            }

            @Override
            public N get(long row, long col) {
                return ColumnsSupplier.this.get(row, columns[(int)col]);
            }

            @Override
            public PhysicalStore.Factory<N, ?> physical() {
                return ColumnsSupplier.this.physical();
            }

            @Override
            public void supplyTo(TransformableRegion<N> receiver) {
                receiver.reset();
                for (int j = 0; j < columns.length; ++j) {
                    SparseArray column = ColumnsSupplier.this.getColumn(columns[j]);
                    for (SparseArray.NonzeroView nz : column.nonzeros()) {
                        receiver.set(nz.index(), (long)j, (Comparable<?>)nz.get());
                    }
                }
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    @Override
    public long countColumns() {
        return this.myColumns.size();
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myColumns.get((int)col).doubleValue(row);
    }

    @Override
    public PhysicalStore<N> get() {
        return (PhysicalStore)this.collect(this.myPhysicalStoreFactory);
    }

    @Override
    public N get(long row, long col) {
        return this.myColumns.get((int)col).get(row);
    }

    public SparseArray<N> getColumn(int index) {
        return this.myColumns.get(index);
    }

    @Override
    public PhysicalStore.Factory<N, ?> physical() {
        return this.myPhysicalStoreFactory;
    }

    public Access1D<N> removeColumn(int index) {
        return this.myColumns.remove(index);
    }

    public ColumnsSupplier<N> selectColumns(int[] indices) {
        ColumnsSupplier<N> retVal = new ColumnsSupplier<N>(this.myPhysicalStoreFactory, this.myRowsCount);
        for (int i = 0; i < indices.length; ++i) {
            retVal.addColumn(this.getColumn(indices[i]));
        }
        return retVal;
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.myColumns.get((int)col).set(row, value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myColumns.get((int)col).set(row, value);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.reset();
        int limit = this.myColumns.size();
        for (int j = 0; j < limit; ++j) {
            this.myColumns.get(j).supplyNonZerosTo(receiver.regionByColumns(j));
        }
    }

    public String toString() {
        return Access2D.toString(this);
    }

    SparseArray<N> addColumn(SparseArray<N> columnToAdd) {
        if (this.myColumns.add(columnToAdd)) {
            return columnToAdd;
        }
        return null;
    }

    public static final class SingleView<N extends Comparable<N>>
    extends Access2D.ColumnView<N>
    implements Access2D.Collectable<N, PhysicalStore<N>> {
        private final ColumnsSupplier<N> myBase;

        SingleView(ColumnsSupplier<N> base) {
            super(base);
            this.myBase = base;
        }

        @Override
        public long countColumns() {
            return 1L;
        }

        @Override
        public long countRows() {
            return this.myBase.countRows();
        }

        @Override
        public ElementView1D<N, ?> elements() {
            return this.getCurrent().elements();
        }

        @Override
        public ElementView1D<N, ?> nonzeros() {
            return this.getCurrent().nonzeros();
        }

        @Override
        public void supplyTo(PhysicalStore<N> receiver) {
            receiver.reset();
            for (ElementView1D element : this.nonzeros()) {
                receiver.set(element.index(), element.doubleValue());
            }
        }

        private SparseArray<N> getCurrent() {
            return this.myBase.getColumn(Math.toIntExact(this.column()));
        }
    }
}

