/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.QuadrupleMath;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.BasePrimitiveSolver;
import org.ojalgo.optimisation.convex.ConvexData;
import org.ojalgo.optimisation.convex.ConvexObjectiveFunction;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.structure.Access2D;

final class IterativeRefinementSolver
extends ConvexSolver {
    private final ConvexData<Quadruple> myData;

    private static Optimisation.Result doIteration(MatrixStore<Quadruple> H, MatrixStore<Quadruple> g, MatrixStore<Quadruple> AE, MatrixStore<Quadruple> BE, MatrixStore<Quadruple> AI, MatrixStore<Quadruple> BI, Optimisation.Options options, Optimisation.Result startValue) {
        double tmpVal;
        int j;
        int i;
        int nbVars = g.size();
        int nbEqus = BE.getRowDim();
        int nbIneq = BI.getRowDim();
        ConvexData<Double> data = new ConvexData<Double>(Primitive64Store.FACTORY, nbVars, nbEqus, nbIneq);
        ((ConvexObjectiveFunction)data.getObjective()).quadratic().fillMatching(H);
        ((ConvexObjectiveFunction)data.getObjective()).linear().fillMatching(g);
        for (i = 0; i < nbEqus; ++i) {
            for (j = 0; j < nbVars; ++j) {
                tmpVal = AE.doubleValue(i, j);
                if (tmpVal == 0.0) continue;
                data.setAE(i, j, tmpVal);
            }
            data.setBE(i, BE.doubleValue(i));
        }
        for (i = 0; i < nbIneq; ++i) {
            for (j = 0; j < nbVars; ++j) {
                tmpVal = AI.doubleValue(i, j);
                if (tmpVal == 0.0) continue;
                data.setAI(i, j, tmpVal);
            }
            data.setBI(i, BI.doubleValue(i));
        }
        return BasePrimitiveSolver.newSolver(data, options).solve(startValue);
    }

    static Optimisation.Result doSolve(MatrixStore<Quadruple> Q_in, MatrixStore<Quadruple> C_in, MatrixStore<Quadruple> ae_in, MatrixStore<Quadruple> be_in, MatrixStore<Quadruple> ai_in, MatrixStore<Quadruple> bi_in, Optimisation.Options options) {
        double epsPrimal = 1.0E-15;
        double epsDual = 1.0E-15;
        double epsSlack = 1.0E-15;
        double maxZoomFactor = 1.0E12;
        int maxRefinementIterations = 5;
        int maxTriesOnFailure = 3;
        double smallestNoneZeroHessian = 1.0E-10;
        double be_Size = be_in.aggregateAll(Aggregator.LARGEST).doubleValue();
        be_Size = be_Size > 1.0E-15 ? be_Size : 1.0;
        double C_Size = C_in.aggregateAll(Aggregator.LARGEST).doubleValue();
        C_Size = C_Size > 1.0 ? C_Size : 1.0;
        double Q_Size = Q_in.aggregateAll(Aggregator.LARGEST).doubleValue();
        MatrixStore<Quadruple> Q0 = Q_in;
        MatrixStore<Quadruple> C0 = C_in;
        MatrixStore<Quadruple> ae0 = ae_in;
        MatrixStore<Quadruple> be0 = be_in;
        MatrixStore<Quadruple> ai0 = ai_in;
        MatrixStore<Quadruple> bi0 = bi_in;
        Optimisation.Result startValue = Optimisation.Result.of(Optimisation.State.APPROXIMATE, new double[Q_in.getColDim()]);
        Optimisation.Result x_y_double = IterativeRefinementSolver.doIteration(Q_in, C_in, ae_in, be_in, ai_in, bi_in, options, startValue);
        if (x_y_double.getState() == Optimisation.State.INFEASIBLE) {
            return x_y_double;
        }
        if (!x_y_double.getState().isOptimal()) {
            x_y_double = IterativeRefinementSolver.doIteration(Q_in, C_in, ae_in, be_in, ai_in, bi_in, options, startValue);
        }
        MatrixStore<Object> x0 = (MatrixStore<Object>)GenericStore.R128.columns(x_y_double);
        MatrixStore<Object> y0 = (MatrixStore<Object>)GenericStore.R128.columns(x_y_double.getMultipliers().get());
        double initialSolutionValue = x_y_double.getValue();
        double scaleP0 = 1.0;
        double scaleD0 = 1.0;
        int iteration = 0;
        while (x_y_double.getState().isFeasible()) {
            ++iteration;
            MatrixStore<MatrixStore<Quadruple>> be1 = be0.subtract((Quadruple)((Object)ae0.multiply((Quadruple)((Object)x0))));
            double maxEqualityResidual = ((Quadruple)((Object)be1.aggregateAll(Aggregator.LARGEST))).doubleValue();
            MatrixStore<MatrixStore<Quadruple>> bi1 = bi0.subtract((Quadruple)((Object)ai0.multiply((Quadruple)((Object)x0))));
            double maxInequalityResidual = ((Quadruple)bi1.negate().aggregateAll(Aggregator.MAXIMUM)).doubleValue();
            double maxPrimalResidual = Math.max(maxEqualityResidual, maxInequalityResidual);
            double scaleP1 = Math.min(1.0 / maxPrimalResidual, maxZoomFactor * scaleP0);
            scaleP1 = Math.max(1.0, scaleP1);
            MatrixStore<MatrixStore<MatrixStore>> C1 = C0.subtract((Quadruple)((Object)Q0.multiply((Quadruple)((Object)x0)))).subtract((MatrixStore<Quadruple>)ae0.below((Access2D<Quadruple>)ai0).transpose().multiply(y0));
            double maxGradientResidual = ((Quadruple)C1.negate().aggregateAll(Aggregator.LARGEST)).norm();
            double relativeComplementarySlackness1 = ((Quadruple)((GenericStore)C1.onMatching((BinaryFunction)QuadrupleMath.MULTIPLY, x0).collect(GenericStore.R128)).aggregateAll(Aggregator.LARGEST)).doubleValue() / C_Size;
            double relativeComplementarySlackness2 = ((Quadruple)((GenericStore)y0.onMatching((BinaryFunction)QuadrupleMath.MULTIPLY, be1.below((Access2D<MatrixStore<Quadruple>>)bi1)).collect(GenericStore.R128)).aggregateAll(Aggregator.LARGEST)).doubleValue() / be_Size;
            double relativeComplementarySlackness = Math.max(relativeComplementarySlackness1, relativeComplementarySlackness2 * relativeComplementarySlackness2);
            double scaleD1 = Math.min(1.0 / maxGradientResidual, maxZoomFactor * scaleD0);
            scaleD1 = Math.max(1.0, scaleD1);
            double relativeGradientResidual = maxGradientResidual / C_Size;
            if (maxPrimalResidual < epsPrimal && relativeGradientResidual < epsDual && relativeComplementarySlackness < epsSlack) break;
            double scaledHessianNorm = Q_Size * scaleD1 / scaleP1;
            if (scaledHessianNorm < smallestNoneZeroHessian) {
                scaleP1 = Q_Size * scaleD1 / scaledHessianNorm;
            }
            if (iteration > maxRefinementIterations) {
                if (!(maxPrimalResidual < Math.sqrt(epsPrimal)) || !(relativeGradientResidual < Math.sqrt(epsDual)) || !(relativeComplementarySlackness < Math.sqrt(epsSlack))) break;
                break;
            }
            int noTries = 0;
            do {
                Object bi1_;
                MatrixStore<Quadruple> ai1_;
                Object be1_;
                MatrixStore<Quadruple> ae1_;
                Object C1_;
                ++noTries;
                Object Q1_ = Q0.multiply(scaleD1 / scaleP1);
                x_y_double = IterativeRefinementSolver.doIteration((MatrixStore<Quadruple>)Q1_, (MatrixStore<Quadruple>)(C1_ = C1.multiply(scaleD1)), ae1_ = ae0, (MatrixStore<Quadruple>)(be1_ = be1.multiply(scaleP1)), ai1_ = ai0, (MatrixStore<Quadruple>)(bi1_ = bi1.multiply(scaleP1)), options, startValue);
                if (x_y_double.getState().isOptimal()) continue;
                double increaseP = scaleP1 / scaleP0;
                double newIncreaseP = Math.sqrt(increaseP);
                scaleP1 = scaleP0 * newIncreaseP;
                double increaseD = scaleD1 / scaleD0;
                double newIncreaseD = Math.sqrt(increaseD);
                scaleD1 = scaleD0 * newIncreaseD;
            } while (!x_y_double.getState().isOptimal() && noTries < maxTriesOnFailure);
            if (noTries == maxTriesOnFailure) break;
            MatrixStore x1 = (MatrixStore)GenericStore.R128.columns(x_y_double);
            MatrixStore y1 = (MatrixStore)GenericStore.R128.columns(x_y_double.getMultipliers().get());
            if (((Quadruple)x1.aggregateAll(Aggregator.LARGEST)).compareTo(Quadruple.ZERO) == 0 && ((Quadruple)y1.aggregateAll(Aggregator.LARGEST)).compareTo(Quadruple.ZERO) == 0) break;
            x0 = x0.add(x1.divide(scaleP1));
            y0 = y0.add(y1.divide(scaleD1));
            scaleP0 = scaleP1;
            scaleD0 = scaleD1;
        }
        Optimisation.Result result = IterativeRefinementSolver.buildResult(Q0, C0, (MatrixStore<Quadruple>)x0, (MatrixStore<Quadruple>)y0, Optimisation.State.OPTIMAL);
        double improvement = (initialSolutionValue - result.getValue()) / initialSolutionValue;
        return result;
    }

    private static Optimisation.Result buildResult(MatrixStore<Quadruple> Q0, MatrixStore<Quadruple> C0, MatrixStore<Quadruple> x0, MatrixStore<Quadruple> y0, Optimisation.State state) {
        Quadruple objectiveValue = ((Quadruple)Q0.multiplyBoth(x0).divide(2.0f)).subtract((Quadruple)x0.transpose().multiply(C0).get(0L));
        Optimisation.Result result = new Optimisation.Result(state, objectiveValue.doubleValue(), x0);
        result.multipliers(y0);
        return result;
    }

    static ConvexData<Quadruple> newInstance(int nbVars, int nbEqus, int nbIneq) {
        return new ConvexData<Quadruple>(GenericStore.R128, nbVars, nbEqus, nbIneq);
    }

    IterativeRefinementSolver(Optimisation.Options solverOptions, ConvexData<Quadruple> data) {
        super(solverOptions);
        this.myData = data;
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        MultiaryFunction.TwiceDifferentiable objective = this.myData.getObjective();
        PhysicalStore<Quadruple> mtrxQ = ((ConvexObjectiveFunction)objective).quadratic();
        PhysicalStore<Quadruple> mtrxC = ((ConvexObjectiveFunction)objective).linear();
        MatrixStore mtrxAE = this.myData.getAE();
        MatrixStore<Quadruple> mtrxBE = this.myData.getBE();
        MatrixStore mtrxAI = this.myData.getAI();
        MatrixStore<Quadruple> mtrxBI = this.myData.getBI();
        return IterativeRefinementSolver.doSolve(mtrxQ, mtrxC, mtrxAE, mtrxBE, mtrxAI, mtrxBI, this.options);
    }
}

