/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.integer.IntegerStrategy;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.context.NumberContext;

public abstract class ModelStrategy
implements IntegerStrategy {
    private final int[] myIndices;
    private final Optimisation.Sense myOptimisationSense;
    private final IntegerStrategy myStrategy;
    private final List<Comparator<NodeKey>> myWorkerPriorities;
    protected boolean cutting = true;

    protected ModelStrategy(ExpressionsBasedModel model, IntegerStrategy strategy) {
        this.myOptimisationSense = model.getOptimisationSense() != Optimisation.Sense.MAX ? Optimisation.Sense.MIN : Optimisation.Sense.MAX;
        this.myStrategy = strategy;
        List<Variable> integerVariables = model.getIntegerVariables();
        int nbIntegers = integerVariables.size();
        this.myIndices = new int[nbIntegers];
        for (int i = 0; i < nbIntegers; ++i) {
            int globalIndex;
            this.myIndices[i] = globalIndex = model.indexOf(integerVariables.get(i));
        }
        this.myWorkerPriorities = strategy.getWorkerPriorities();
    }

    @Override
    public NumberContext getGapTolerance() {
        return this.myStrategy.getGapTolerance();
    }

    @Override
    public IntegerStrategy.GMICutConfiguration getGMICutConfiguration() {
        return this.myStrategy.getGMICutConfiguration();
    }

    @Override
    public NumberContext getIntegralityTolerance() {
        return this.myStrategy.getIntegralityTolerance();
    }

    @Override
    public List<Comparator<NodeKey>> getWorkerPriorities() {
        return this.myWorkerPriorities;
    }

    @Override
    public ModelStrategy newModelStrategy(ExpressionsBasedModel model) {
        return this.myStrategy.newModelStrategy(model);
    }

    public final String toString() {
        return Arrays.toString(this.myIndices);
    }

    protected int countIntegerVariables() {
        return this.myIndices.length;
    }

    protected int getIndex(int idx) {
        return this.myIndices[idx];
    }

    protected abstract ModelStrategy initialise(MultiaryFunction.TwiceDifferentiable<Double> var1, Access1D<?> var2);

    protected abstract boolean isCutRatherThanBranch(double var1, boolean var3);

    protected abstract boolean isDirect(NodeKey var1, boolean var2);

    protected boolean isGoodEnough(Optimisation.Result bestResultSoFar, double relaxedNodeValue) {
        if (bestResultSoFar == null) {
            return true;
        }
        if (!Double.isFinite(relaxedNodeValue)) {
            return false;
        }
        double bestIntegerValue = bestResultSoFar.getValue();
        if (!this.myStrategy.getGapTolerance().isDifferent(bestIntegerValue, relaxedNodeValue)) {
            return false;
        }
        return this.myOptimisationSense == Optimisation.Sense.MIN && relaxedNodeValue < bestIntegerValue || this.myOptimisationSense == Optimisation.Sense.MAX && relaxedNodeValue > bestIntegerValue;
    }

    protected abstract void markInfeasible(NodeKey var1, boolean var2);

    protected abstract void markInteger(NodeKey var1, Optimisation.Result var2);

    protected abstract double toComparable(int var1, double var2, boolean var4);

    static final class DefaultStrategy
    extends ModelStrategy {
        private static final NumberContext ROUGHLY = NumberContext.of(2);
        private Access1D<?> myIterationPoint = null;
        private final double[] mySignificances;

        DefaultStrategy(ExpressionsBasedModel model, IntegerStrategy strategy) {
            super(model, strategy);
            List<Variable> integerVariables = model.getIntegerVariables();
            int nbIntegers = integerVariables.size();
            this.mySignificances = new double[nbIntegers];
        }

        private void addSignificance(int idx, double significance) {
            this.mySignificances[idx] = MissingMath.hypot(this.mySignificances[idx], significance);
        }

        @Override
        protected ModelStrategy initialise(MultiaryFunction.TwiceDifferentiable<Double> function, Access1D<?> point) {
            Arrays.fill(this.mySignificances, PrimitiveMath.ONE);
            int nbIntegers = this.countIntegerVariables();
            Access1D<Double> iterationPoint = Access1D.asPrimitive1D(point);
            MatrixStore<Double> gradient = function.getGradient(iterationPoint);
            double largest = gradient.aggregateAll(Aggregator.LARGEST);
            if (!ROUGHLY.isZero(largest)) {
                for (int i = 0; i < nbIntegers; ++i) {
                    int globalIndex = this.getIndex(i);
                    double partial = gradient.doubleValue(globalIndex);
                    if (ROUGHLY.isZero(partial)) continue;
                    this.addSignificance(i, partial / largest);
                }
            }
            this.myIterationPoint = iterationPoint;
            return this;
        }

        @Override
        protected boolean isCutRatherThanBranch(double displacement, boolean found) {
            if (this.cutting && found) {
                return displacement > 0.49;
            }
            return false;
        }

        @Override
        protected boolean isDirect(NodeKey node, boolean found) {
            return found ? node.displacement < PrimitiveMath.THIRD : node.displacement < PrimitiveMath.HALF;
        }

        @Override
        protected void markInfeasible(NodeKey key, boolean found) {
            int index = key.index;
            if (index >= 0) {
                this.addSignificance(index, found ? 0.2 : 0.1);
            }
        }

        @Override
        protected void markInteger(NodeKey key, Optimisation.Result result) {
            if (this.myIterationPoint != null) {
                int limit = this.countIntegerVariables();
                for (int i = 0; i < limit; ++i) {
                    int globalIndex = this.getIndex(i);
                    double diff = result.doubleValue(globalIndex) - this.myIterationPoint.doubleValue(globalIndex);
                    if (ROUGHLY.isZero(diff)) continue;
                    this.addSignificance(i, PrimitiveMath.ONE / diff);
                }
            }
            this.myIterationPoint = result;
        }

        @Override
        protected double toComparable(int idx, double displacement, boolean found) {
            return found ? displacement * this.mySignificances[idx] : PrimitiveMath.ONE - displacement;
        }
    }

    public static abstract class AbstractStrategy
    extends ModelStrategy {
        protected final ModelStrategy delegate;

        protected AbstractStrategy(ExpressionsBasedModel model, IntegerStrategy strategy) {
            super(model, strategy);
            this.delegate = new DefaultStrategy(model, strategy);
        }
    }
}

